// https://www.youtube.com/watch?v=yScO_v7NUYQ 
// LEITURA DE BOTÕES

#include "mbed.h"
#include "TextLCD.h"


//FRDM-K64F
//TextLCD lcd(PTA0,PTC4,PTB23,PTA2,PTC2,PTC3); // rs, e, d4-d7
TextLCD lcd(D8, D9, D4, D5, D6, D7); // rs, e, d4-d7

DigitalIn digi1 (D1);
DigitalIn digi2 (D2);
DigitalIn digi3 (D3);

enum States {calib1, calib2, homing, emgcontrol, demo}; //calib1=0, calib2=1, ..., demo=4
int state;
Ticker      main_loop;

float looptime = 0.001f;

//Timer       time;


                
AnalogIn Sensor(PTB2); //ESPECIFICA O PINO DE LEITURA ANALOGICA PARA FRDM-K64F 
void loopfunction(){
    switch (state){
            case calib1:
                lcd.printf(" * Calibrating... /n motor 1 * "); //while in calib 1 print
                lcd.cls();
            break;
        
            case calib2:
                lcd.printf(" * Calibrating... /n motor 2 * "); //while in calib 2 print
                lcd.cls();
            break;
        
            case homing:
                lcd.printf(" * Homing... * "); //while in homing print
                lcd.cls();
            break;
        
            case emgcontrol:
                lcd.printf(" * Calibrating EMG... * "); //while calibrating EMG print
                lcd.cls();
            break;
        
            case demo:
                lcd.printf(" * demo... * "); //while in demo print
                lcd.cls();
            break;
        }
}




int main() {
    
    lcd.printf(" Calibration \n FRDM-K64F");
    wait(3);   
    lcd.cls();   
     main_loop.attach(&loopfunction, looptime); //1000 Hz main loop
     while(1){                                                  // Clean the display
if(Sensor.read_u16()>12000 && Sensor.read_u16()< 15000){
               state = calib1;                
                } 
                
            if(Sensor.read_u16()>46000 && Sensor.read_u16()< 48000){
                state = calib2;               
                } 
                
            if(Sensor.read_u16()>30000 && Sensor.read_u16()< 32000){
                state = homing;                 
                } 
                
            if(Sensor.read_u16()>0 && Sensor.read_u16()< 10000){
                lcd.printf("right", Sensor.read_u16());
            wait(1);        
            lcd.cls();                    
                }  
                
            else {
                lcd.printf("Press to start", Sensor.read_u16());
            wait(1);        
            lcd.cls();
            }
}
/*
            if(Sensor.read_u16()>12000 && Sensor.read_u16()< 15000){
               lcd.printf("Procedure \n will start");
               tick.attach(&ticker, 2.0);                
                } 
                
            if(Sensor.read_u16()>46000 && Sensor.read_u16()< 48000){
               lcd.printf(" * left * ");
               wait(1);
               lcd.cls();                
                } 
                
            if(Sensor.read_u16()>30000 && Sensor.read_u16()< 32000){
               lcd.printf("  * down * ");
               wait(1);
               lcd.cls();                
                } 
                
            if(Sensor.read_u16()>0 && Sensor.read_u16()< 10000){
               lcd.printf("  * right * ");
               wait(1);
               lcd.cls();                       
                }  
                
            else {
                lcd.printf("Press to start", Sensor.read_u16());
            wait(1);        
            lcd.cls();
            }*/
                   
                                        
        }



