/* Demo for mbed Library for FTDI FT800  Enbedded Video Engine "EVE"
 * by Peter Drescher, DC2PD 2014
 * Released under the MIT License: http://mbed.org/license/mit */

#include "mbed.h"
#include "FT_Platform.h"
#include "FT_color.h"
#include "stdio.h"
#include "float.h"
#include "DS1820.h"

//#include "SDFileSystem.h"


#define SAMAPP_DELAY_BTW_APIS (1000)
#define SAMAPP_ENABLE_DELAY() Ft_Gpu_Hal_Sleep(SAMAPP_DELAY_BTW_APIS)
#define SAMAPP_ENABLE_DELAY_VALUE(x) Ft_Gpu_Hal_Sleep(x)
#define DATA_PIN A1
FT800 TFT(D11,D12,D13,D9,D8,D14);





// global Vars
unsigned int r,b,g;
char buffer[50];
Ticker tick;
unsigned int color = 0,bright = 0;



Serial usart(D1, D0); 
DS1820 probe(DATA_PIN);

// function to convert hue , saturation and  value to RGB
// see http://en.wikipedia.org/wiki/HSL_and_HSV

void hsv2rgb(double H,double S, double V)
{
    double f,h,p,q,t;
    int i;
    if( S == 0.0) {
        r = V * 255;  
        g = V * 255;
        b = V * 255;
        return;
    }
    if(H > 480.0) H = 0.0;   // check values
    if(S > 1.0) S = 1.0; 
    if(S < 0.0) S = 0.0;
    if(V > 1.0) V = 1.0;
    if(V < 0.0) V = 0.0;
    
    h = H / 60.0;
    i = (int) h;
    f = h - i;
    p = V * (1.0 - S);
    q = V * (1.0 - (S * f));
    t = V * (1.0 - (S * (1.0 - f)));
 
    switch(i) {
        case 0:
            r = V * 255;  
            g = t * 255;
            b = p * 255;
            break;
        case 1:
            r = q * 255;
            g = V * 255;
            b = p * 255;
            break;
        case 2:
            r = p * 255;
            g = V * 255;
            b = t * 255;
            break;
        case 3:
            r = p * 255;
            g = q * 255;
            b = V * 255;
            break;
        case 4:
            r = t * 255;
            g = p * 255;
            b = V * 255;
            break;
        case 5:
        default:
            r = V * 255;
            g = p * 255;
            b = q * 255;
            break;
    }  
}


/***************************************************************************/
// Rysowanie ekranu demonstracyjnego 
/***************************************************************************/

ft_void_t Trip_Comp(ft_char8_t *str, ft_float_t temp)
{
    //const char* str2 = "FT81x  EVE2 FRDM-K64F";
    TFT.DLstart();                             // przygotowanie na nową listę nkomend 
    TFT.DL(CLEAR_COLOR_RGB(255,255,255));      // kolor tła (biały)
    TFT.DL(CLEAR(1,1,1));                      // czyszczenie buforów --> color, stencil, tag
    
    
    
    TFT.Button(580, 440, 67, 27, 27, OPT_FLAT, "MENU");
    TFT.Button(650, 440, 67, 27, 27, OPT_FLAT | OPT_CENTER, "INFO");
    TFT.Button(720, 440, 67, 27, 27, OPT_FLAT, "GUIDE");

    //--------------opisy ekranu
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(400, 180, 28, OPT_CENTER, "KM/H");
    TFT.Text(120, 119, 28, OPT_CENTER, "RPM /1000");
    TFT.Text(680, 330, 28, OPT_CENTER, "Temp");
    
    //TFT.Text(378, 154, 27, OPT_CENTER, "KM:");
    TFT.Text(680, 119, 28, OPT_CENTER, "Fuel");
    TFT.Text(400, 30, 30, OPT_CENTER, str);
    
    TFT.DL(COLOR_RGB(255, 0, 0));
    TFT.Text(400, 440, 27, OPT_CENTER, "ENGINE OFF");
    TFT.DL(COLOR_RGB(0, 255, 0));
    TFT.Text(400, 420, 27, OPT_CENTER, "LIGHT: ON");
    
    //GAUGE_0 = OPT_NOBACK | OPT_NOPOINTER;
    //GAUGE_1 = OPT_NOBACK | OPT_NOTICKS;
    
    //--------------prędkosciomierz 
    TFT.DL(COLOR_RGB(0, 0, 255));
    TFT.Gauge((TFT.DispWidth/2), TFT.DispHeight/2, 208, OPT_NOBACK | OPT_NOPOINTER, 10, 10, 0, 250);
    TFT.DL(COLOR_RGB(255, 0, 0));
    TFT.Gauge((TFT.DispWidth/2), TFT.DispHeight/2, 208, OPT_NOBACK | OPT_NOTICKS, 10, 10, 0 , 250);
    TFT.Number(400, 370, 31, OPT_CENTER, 0);
    
    //--------------zegarek
    TFT.DL(COLOR_RGB(0, 0, 255));
    TFT.Clock(130, 350, 100, OPT_NOBACK | OPT_NOPOINTER |  OPT_NOSECS, 19, 51, 17, 0);
    TFT.DL(COLOR_RGB(255, 0, 0));
    TFT.Clock(130, 350, 100, OPT_NOBACK | OPT_NOTICKS, 19, 51, 17, 0);
    
     
    //-------------- RPM
    TFT.DL(COLOR_RGB(0, 0, 255));
    TFT.Gauge(120, 150, 130, OPT_NOBACK | OPT_NOPOINTER, 8, 5, 0, 100);
    TFT.DL(COLOR_RGB(255, 0, 0));
    TFT.Gauge(120, 150, 130, OPT_NOBACK | OPT_NOTICKS, 8, 5, 0, 100);
    TFT.DL(COLOR_RGB(0, 255, 0));
    TFT.Number(120, 220, 31, OPT_CENTER, 0);
    
    //-------------- FUELL  
    TFT.DL(COLOR_RGB(0, 0, 255)); 
    TFT.Gauge(680, 150, 130, OPT_NOBACK | OPT_NOPOINTER, 4, 5, 40, 100);
    TFT.DL(COLOR_RGB(255, 0, 0));
    TFT.Gauge(680, 150, 130, OPT_NOBACK | OPT_NOTICKS, 4, 5, 35, 100);
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    //TFT.Text(15, 257, 16, 0, str);
    
    
    
    //------------- TEmperatura 
    TFT.DL(COLOR_RGB(0, 0, 255)); 
    TFT.Gauge(680, 350, 100, OPT_NOBACK | OPT_NOPOINTER, 4, 5, 40, 125);
    TFT.DL(COLOR_RGB(255, 0, 0));
    TFT.Gauge(680, 350, 100, OPT_NOBACK | OPT_NOTICKS, 4, 5, temp, 125);
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Number(680, 400, 31, OPT_CENTER, temp);

    
    
    TFT.DL(DISPLAY());                         // Wyswietlamy przygotowany screen 
    TFT.Swap();                                
    TFT.Flush_Co_Buffer();                     // pobieramy komendy z FiFo

    TFT.WaitCmdfifo_empty();                   // czekanie na zakończenie operacji
    TFT.Sleep(5000);                          // koniec wyswietlania (15000 = 15sec)
}




int main()
{
    
    
    usart.baud(38400);  
    TFT.Flush_Co_Buffer();                         
    TFT.WaitCmdfifo_empty();                       
                         
     
                            
    while(1) 
    {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        usart.printf("Temperatura to %3.3f Celsiusza\r\n", probe.temperature());
        Trip_Comp("SunTRIP Computer", probe.temperature());
        
        //Demo_Screen2("Temperatura", probe.temperature());
        //  wait(1);
    }

    
}



