#include "mbed.h"
#include "Touch.h"
/* ********************************************************************** */
#define TOUCH_X_MIN 30
#define TOUCH_X_MAX 230
#define TOUCH_Y_MIN 15
#define TOUCH_Y_MAX 240
/* ********************************************************************** */
DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
/* ********************************************************************** */
TOUCH_DATA Coordenadas;
volatile bool kbhit_irq=0;
volatile bool kbhit_tratament=0;

TouchScreenADS7843 MyTouch(p9,p10,p11,p12,p8); // ADS7843-> SDO,SDI,SCK,CS,IRQ
/* ********************************************************************** */
void vISRTouchIRQ(void){
    UINT_COORDxy Temp;
   
    MyTouch.vTestTouchPanel(&Coordenadas);
    // Coordenadas dentro del rango de pantalla LCD:
    if((Coordenadas.x>TOUCH_X_MIN && Coordenadas.x<TOUCH_X_MAX) && (Coordenadas.y>TOUCH_Y_MIN && Coordenadas.y<TOUCH_Y_MAX)){
	    // Cambio de coordenada y escala:
	    Temp=Coordenadas.y;
	    Coordenadas.y=((float)((255-TOUCH_X_MIN)-Coordenadas.x)*(320.0/(TOUCH_X_MAX-TOUCH_X_MIN)));
	    Coordenadas.x=((float)(Temp-TOUCH_Y_MIN)*(240.0/(TOUCH_Y_MAX-TOUCH_Y_MIN)));
	    kbhit_irq=1;
    }
}


int main(){
	

	MyTouch.vInitADS7843(USE_8BITS,&vISRTouchIRQ);
	
	Led1=0;
	Led2=0;

	while(1){
		Led2=!Led2;
		if(kbhit_irq==1){
			kbhit_irq=0;
			if((Coordenadas.x<235 && Coordenadas.x>135) && (Coordenadas.y<320 && Coordenadas.y>250)){
				Led1=!Led1;
			}
		}
		wait_ms(300);
	}
}
