#include "mbed.h"
#include "TMP175.h"
DigitalOut myled(LED1);
TMP175 mySensor(p9,p10);
LocalFileSystem local("mbedMemory"); 

int main(){
    char Fmt[100];
    float Temp;
    mySensor.vSetConfigurationTMP175(SHUTDOWN_MODE_OFF|COMPARATOR_MODE|POLARITY_0|FAULT_QUEUE_6|RESOLUTION_12,0x48); // Address -> A0,A1,A2=0
    mySensor.vSetTemperatureLowTMP175(25.0);
    mySensor.vSetTemperatureHighTMP175(35.0);
    
    FILE *fp = fopen("/mbedMemory/TMP175Debug.txt", "w"); 
    fprintf(fp, "TMP175/75 mbed NXP:\r\n"); 
    for(int k=0;k<100;k++){
        Temp=mySensor;
        sprintf(&Fmt[0],"Temperature: %f C\r\n",Temp);
        fprintf(fp,&Fmt[0]); 
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
    fclose(fp);
    while(1);
}
