/*
   \file main.cpp
   \version: 1.0
   
   \brief Este fichero contiene ejemplo para sincronizacion de fecha y hora
          mediante TCPClient 
  
   \web www.micros-designs.com.ar
   \date 19/01/11
  
*- Version Log --------------------------------------------------------------*
*   Fecha       Autor                Comentarios                             *
*----------------------------------------------------------------------------*
* 19/01/11      Suky        Original                                         *
*----------------------------------------------------------------------------* 
*/
#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
// **********************************************************************
#define TIME_NIST_GOV       IpAddr(192,43,244,18)   // time.nist.gov
#define TIME_A_NIST_GOV     IpAddr(129,6,15,28)     // time-a.nist.gov
#define TIME_B_NIST_GOV     IpAddr(129,6,15,29)     // time-b.nist.gov
#define TIME_NW_NIST_GOV    IpAddr(131,107,13,100)  // time-nw.nist.gov
// **********************************************************************
DigitalIn button(p8);
// **********************************************************************
EthernetNetIf eth;
TCPSocket tcp;
Host server(TIME_NIST_GOV,13,"time.nist.gov");
// **********************************************************************
struct{
    int connected;
    int writeable;
    int readable;
}flags;
// **********************************************************************
void onTCPSocketEvent(TCPSocketEvent e){
    
    printf("New TCPSocketEvent: %d",e);

    switch(e){
        case TCPSOCKET_CONNECTED:   flags.connected = 1;break;
        case TCPSOCKET_WRITEABLE:   flags.writeable = 1;break;
        case TCPSOCKET_READABLE:    flags.readable = 1;break;
        case TCPSOCKET_CONTIMEOUT:
        case TCPSOCKET_CONRST:
        case TCPSOCKET_CONABRT:
        case TCPSOCKET_ERROR:
        case TCPSOCKET_DISCONNECTED:
            tcp.close();
            flags.connected = 0;
        break;
    }
}
// **********************************************************************
int main(){    
    button.mode(PullUp);    
    
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr){
        printf("Ethernet Error %d\n", ethErr);
        return -1;
    }else{
        printf("mbed is online...\n");
    }
    
    flags.connected=0;
    flags.writeable=0;  
    flags.readable=0;  
    tcp.setOnEvent(&onTCPSocketEvent);
    
    printf("Conecting host...\n");
    TCPSocketErr err = tcp.connect(server);
    if(err){
        printf("Error connecting\n");
    }
    
    while(true){
        Net::poll();
        
        if(!button){
            printf("Conecting host...\n");
            TCPSocketErr err = tcp.connect(server);
            if(err){
                printf("Error connecting\n");
            }
        }
        
        if(flags.readable==1){
            flags.readable=0;
            
            printf("received host...\n");
            char Buffer[100]={0};
            char Fmt[150]={0};
         
            tcp.recv(&Buffer[0],100);
            sprintf(&Fmt[0],"%s",Buffer);
            
            // 6...23 useful string :  
            Fmt[24]=NULL;         
            printf("%s",&Fmt[6]);
            tcp.close();
        }// en if
    }// end while(true)
}// end main
// **********************************************************************
