/*
  @file LCD_Serial.h
  @version: 1.0
  
  @web www.micros-designs.com.ar
  @date 05/02/11
  
*- Version Log --------------------------------------------------------------*
*   Fecha       Autor                Comentarios                             *
*----------------------------------------------------------------------------*
* 05/02/11      Suky        Original                                         *
*----------------------------------------------------------------------------*/ 
///////////////////////////////////////////////////////////////////////////
////                                                                   ////
////                                                                   ////
////        (C) Copyright 2011 www.micros-designs.com.ar               ////
//// Este codigo puede ser usado, modificado y distribuido libremente  ////
//// sin eliminar esta cabecera y  sin garantia de ningun tipo.        ////
////                                                                   ////
////                                                                   ////
/////////////////////////////////////////////////////////////////////////// 
#include "mbed.h"
#include "DataCGRAM.h"

class LCDSerial:public Stream {
    public: 
        #define LCDClr             0x01   // Borra pantalla, cursor a Inicio
        #define LCDHome            0x02   // Cursor a Inicio, DDRAM sin cambios
        #define LCDIncCursor       0x06   // Modo incrementa cursor
        #define LCDDecCursor       0x04   // Modo decrementa cursor
        #define LCDOn              0x0C   // Pantalla On
        #define LCDOff             0x08   // Pantalla Off
        #define LCDCursorOn        0x0E   // Pantalla On, cursor On
        #define LCDCursorOff       0x0C   // Pantalla On, cursor Off
        #define LCDCursorBlink     0x0F   // Pantalla On, Cursor parpadeante
        #define LCDCursorLeft      0x10   // Mueve cursor a la izquierda
        #define LCDCursorRight     0x14   // Mueve cursor a la derecha
        #define LCDDisplayLeft     0x18   // Mueve Display   a la izquierda
        #define LCDDisplayRight    0x1C   // Mueve   Display a la Derecha 
         /** Crea LCD interface
         *
         * @param DATA    
         * @param CLK   
         * @param E
         */
        LCDSerial(PinName DATA,PinName CLK,PinName E,PinName BACK=NC);
        void vGotoxy(char x,char y);
        void vSetBacklight(bool Value);
        void vPutc(char Data);
        void vCommand(char Data);
        #if DOXYGEN_ONLY
            /** Escribe un caracter en LCD
             *
             * @param c El caracter a escribir en LCD
             */
            int putc(int c);
        
            /** Escribe un string formateado en LCD
             *
             * @param format A printf-style format string, followed by the
             *               variables to use in formating the string.
             */
            int printf(const char* format, ...);
        #endif       
    private:    
        #define LcdType 2                       // 0=5x7, 1=5x10, 2=varias lineas
        #define LCD_LINE_1_ADDRESS  0x00
        #define LCD_LINE_2_ADDRESS  0x40
        #define LCD_LINE_3_ADDRESS  0x14
        #define LCD_LINE_4_ADDRESS  0x54
        #define LCD_COMMAND         0
        #define LCD_DATA            1
        DigitalOut _DATA,_CLK,_E,_BACK;
        char NLinea;
        // Stream implementation functions
        virtual int _putc(int value);
        virtual int _getc();
        virtual void vWriteLCD(char Data,char Type);
        virtual void vSetCGRAM(const char *Data);
};


LCDSerial::LCDSerial(PinName DATA,PinName CLK,PinName E,PinName BACK)
    :_DATA(DATA),_CLK(CLK),_E(E),_BACK(BACK){
    char Temp;
    
    NLinea=1;
    wait_ms(15);
    _DATA=0;
    _CLK=0;
    _E=0;
    _BACK=0;

    for(int k=0;k<8;k++){
        _CLK=1;
        wait_us(1);
        _CLK=0;
        wait_us(1);
    } 
    
    Temp=0x03;
    for(int k=0;k<8;k++){
        _DATA=!!(Temp&0x80);
        Temp<<=1;
        _CLK=1;
        wait_us(1);
        _CLK=0;
    }  
    for(int k=0;k<3;k++){
        _E=1;
        wait_ms(2);
        _E=0;
        wait_ms(2);
    }
    Temp=0x02;
    for(int k=0;k<8;k++){
        _DATA=!!(Temp&0x80);
        Temp<<=1;
        _CLK=1;
        wait_us(1);
        _CLK=0;
    }  
    _E=1;
    wait_us(1);
    _E=0;
    
    vWriteLCD(0x20 | (LcdType<<2),LCD_COMMAND);  // Tipo display.-  
    wait_ms(2);    
    vWriteLCD(0x01,LCD_COMMAND);    // Borramos display.-   
    wait_ms(2);          
    vWriteLCD(0x06,LCD_COMMAND);    // Incrementa cursor.-
    vWriteLCD(0x0C,LCD_COMMAND);    // Encendemos display.-
    vSetCGRAM(CGRAM_DATA);          // Guardamos data en CGRAM.-
}

void LCDSerial::vWriteLCD(char Data,char Type){
    char data_temp;


    wait_us(100);

    data_temp=(Data>>4);  // Rs es bit 4
    if(Type){
        data_temp|=0x10;
    }
    for(int i=0;i<8;i++){
        _DATA=!!(data_temp & 0x80);
        data_temp<<=1;
        _CLK=1;
        wait_us(1);
        _CLK=0;
    }
   
    _E = 1;
    wait_us(1);
    _E = 0;
    data_temp=(Data&0x0F);  // Rs es bit 4
    if(Type){
        data_temp|=0x10;
    }
    for(int i=0;i<8;i++){
        _DATA=!!(data_temp & 0x80);
        data_temp<<=1;
        _CLK=1;
        wait_us(1);
        _CLK=0;
    }
    _E = 1;
    wait_us(1);
    _E = 0;
   
} 

void LCDSerial::vGotoxy(char x,char y){
    char Direccion;

    switch(y){
        case 1:Direccion = LCD_LINE_1_ADDRESS;NLinea=1;break;
        case 2:Direccion = LCD_LINE_2_ADDRESS;NLinea=2;break;
        case 3:Direccion = LCD_LINE_3_ADDRESS;NLinea=3;break;
        case 4:Direccion = LCD_LINE_4_ADDRESS;NLinea=4;break;
        default:Direccion = LCD_LINE_1_ADDRESS;NLinea=1;break;
    }

    Direccion+=x-1;
    vWriteLCD(0x80|Direccion,LCD_COMMAND);
}

int LCDSerial::_getc(){
    return(-1);
}

int LCDSerial::_putc(int value){
   
   switch(value){
      case '\f':
         vWriteLCD(0x01,LCD_COMMAND);
         NLinea=1;
         wait_ms(2);
      break;
      case '\n':
         vGotoxy(1,++NLinea);         
      break;
      default:
         vWriteLCD(value,LCD_DATA);
   }
   
   return(value);
}

void LCDSerial::vSetBacklight(bool Value){
    _BACK=Value;
}

void LCDSerial::vSetCGRAM(const char *Data){

    vWriteLCD(0x40,LCD_COMMAND);
    for(int k=0;k<64;k++){
        vWriteLCD(*Data++,LCD_DATA);
    }
}

void LCDSerial::vPutc(char Data){
    _putc(Data);
}

void LCDSerial::vCommand(char Data){
    vWriteLCD(Data,LCD_COMMAND);
}
