// Nothing special, an example for using the library of FFT, Audio Spectrum Analyzer with LCD
#include "mbed.h"
#include "FFT.h"
#include "LCD_Serial.h"
// **********************************************************************************************
#define N 32
float Data[N*2];  
unsigned char PowerInt[N/2];
volatile int kbhit;
float Average;

AnalogIn    ChannelR(p16);
AnalogIn    ChannelL(p17);
AnalogIn    ChannelC(p18);
LCDSerial myLcd(p21,p22,p23,p24); // Data, Clock, Enable, Back
// **********************************************************************************************
void vUpdateDataAnalogs(float Analogs[]);
void vGraphicDisplay(unsigned char *Data);
// **********************************************************************************************
int main() {
    myLcd.vSetBacklight(1);
    myLcd.printf("\f FFT with mbed!!!");
    wait(2.0);
    myLcd.printf("\f");
    
    Average=0;
    for(int k=0;k<64;k++){
        Average+=ChannelC.read_u16();
        wait_us(100);
    }
    Average/=64;
   
    while(1){
        vUpdateDataAnalogs(Data);
        vFFT(Data-1,N);
        vCalPowerInt(Data,PowerInt,N/2);
        vGraphicDisplay(PowerInt);
        wait_ms(30);
    }
}
// **********************************************************************************************
void vUpdate(void){
    kbhit=1;
}
void vUpdateDataAnalogs(float Analogs[]){
    unsigned short TempReadR[32],TempReadL[32];
    Ticker Period;
    
    kbhit=0;
    Period.attach_us(&vUpdate,25); // 25 us, 40.000 Hz
    for(int k=0;k<32;k++){
        while(kbhit==0);
        kbhit=0;
        TempReadR[k]=ChannelR.read_u16();
    }
    for(int k=0;k<32;k++){
        while(kbhit==0);
        kbhit=0;
        TempReadL[k]=ChannelL.read_u16();
    }
    Period.detach();
    for(int k=0,j=0;k<32;k++,j++){
        Analogs[j]=(TempReadR[k]+TempReadL[k])/2;   // Promedio (x1[n]+x2[n]=X1[k]+X2[k])
        Analogs[j]=((float)(Analogs[j]-Average)/10);   // Desplazo y aplico escala.-
        Analogs[++j]=0;
    }
    return;
}
// **********************************************************************************************
void vGraphicDisplay(unsigned char *Data){
     unsigned char k;
 
     myLcd.vGotoxy(3,1);
     for(k=0;k<16;k++,Data++){
         if(*Data>192){myLcd.vPutc((*Data-193)/8);}else{myLcd.vPutc(' ');}
     }
     myLcd.vGotoxy(3,2);
     Data-=16;
    for(k=0;k<16;k++,Data++){
         if((*Data>128)&&(*Data<193)){myLcd.vPutc((*Data-129)/8);}else if(*Data>192){myLcd.vPutc(0x07);}else{myLcd.vPutc(' ');}
     }
     myLcd.vGotoxy(3,3);
     Data-=16;
     for(k=0;k<16;k++,Data++){
         if((*Data>64)&&(*Data<129)){myLcd.vPutc((*Data-65)/8);}else if(*Data>128){myLcd.vPutc(0x07);}else{myLcd.vPutc(' ');}
     }
     myLcd.vGotoxy(3,4);
     Data-=16;
     for(k=0;k<16;k++,Data++){
         if((*Data>0)&&(*Data<65)){myLcd.vPutc((*Data-1)/8);}else if(*Data>64){myLcd.vPutc(0x07);}else{myLcd.vPutc(' ');}
     }
 
 }