#include "mbed.h"
#include "Menus.h"

float VariableAModificar=153.125;

void vAbout(void);
void vEventosAbout(unsigned char Evento);

void vModificarVariable(void);
void vEventosModificarVariable(unsigned char Evento, float Data);


void vFuncion(void){
    
}

extern const MENU MenuSubMenu1[];
extern const MENU MenuSubMenu2[];
extern const MENU MenuSubMenu3[];

const MENU MenuPrincipal[]={
    {MENU_MAIN,"Menu Principal",(UINT8 *)&MenuSubMenu1,NULL,NULL},
    {MENU_FIN,"",NULL,NULL,NULL}
};

const MENU MenuSubMenu1[]={
    {SUBMENU_ANTERIOR,"Sub Menu 1",(UINT8 *)&MenuPrincipal,NULL,NULL},
    {MENU_SUBMENU,"Sub Menu 2",(UINT8 *)&MenuSubMenu2,NULL,&Icono1[0]},
    {MENU_SUBMENU,"Juegos",(UINT8 *)&MenuSubMenu3,NULL,&Icono4[0]},
    {MENU_COMANDO,"About",NULL,vAbout,&Icono6[0]},
    {MENU_FIN,"",NULL,NULL,NULL}    
};
const MENU MenuSubMenu2[]={
    {SUBMENU_ANTERIOR,"Sub Menu 2",(UINT8 *)&MenuSubMenu1,NULL,NULL},
    {MENU_COMANDO,"Modificar Variable",NULL,vModificarVariable,&Icono7[0]},
    {MENU_FIN,"",NULL,NULL,NULL}    
};
const MENU MenuSubMenu3[]={
    {SUBMENU_ANTERIOR,"Juegos",(UINT8 *)&MenuSubMenu1,NULL,NULL},
    {MENU_COMANDO,"Simons Says",NULL,vFuncion,&Icono5[0]},
    {MENU_FIN,"",NULL,NULL,NULL}    
};

int main(){
       
    vInitLCDTFTAndTouch();

    vSeleccionMenu(MenuPrincipal,1);
    while(1){
        vEjecutaEventosMenu();
    }
}

void vAbout(void){
    vMensajePantalla("Libreria para creacion de Menues\nen TFT 320x240 Touch Screen\npor Suky\n\n\n\n\n(C) Copyright 2011\n\nwww.micros-designs.com.ar",100,MENSAJE_ATRAS,vEventosAbout);
}

void vEventosAbout(unsigned char Evento){
    vSeleccionarMenuAnterior();
}

void vModificarVariable(void){

    vModificadorVariables("Variable Prueba",VariableAModificar,vEventosModificarVariable);
    
}


void vEventosModificarVariable(unsigned char Evento, float Data){

    switch(Evento){
        case MODIFICADOR_ACEPTAR:
            vSeleccionarMenuAnterior();    
            VariableAModificar=Data;    
        break;
        case MODIFICADOR_CANCELAR:
            vSeleccionarMenuAnterior();
        break;    
    }
}
