#include "mbed.h"
#include "MPU9250.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX); // Huyperterminal default config: 9600 bauds
Serial mobile(D8,D2);
//mobile.baud(38400);

MPU9250 mpu9250;
Timer t;
//DigitalOut myled(LED1);

I2C i2c_lcd(D14,D15); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4); // I2C bus, PCF8574 Slaveaddress, LCD Type

char pack[14]={0};

int Ay[2]={0};
float sum=0;
uint32_t sumCount = 0;
char buffer[14];
uint8_t dato_leido[2];
uint8_t whoami;
int GetAcceloroY();

DigitalOut pinled0(PC_8);  DigitalOut pinled1(PC_6);  DigitalOut pinled2(PC_5);
DigitalOut pinled3(PA_12);  DigitalOut pinled4(PA_11); DigitalOut pinled5(PB_12);
DigitalOut pinled6(PB_2); DigitalOut pinled7(PB_15);  DigitalOut pinled8(PB_14);
DigitalOut pinled9(PB_13); DigitalOut pinbuzz(D3);
void resetled();
void getdistance2led(char step);

InterruptIn switch1(D11);//TR
InterruptIn switch2(D10);//TL
InterruptIn switch3(D7);//BR
void switch_1();
void switch_2();
void switch_3();
int matrix_state=0;

int main() {
  
  
  //___ Set up I2C: use fast (400 kHz) I2C ___
  i2c.frequency(400000);  
  // Read the WHO_AM_I register, this is a good test of communication
  whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);
  pc.printf("I AM 0x%x\n\r", whoami); pc.printf("I SHOULD BE 0x71\n\r");
  if (I2Cstate != 0) // error on I2C
    pc.printf("I2C failure while reading WHO_AM_I register");
  
  if (whoami == 0x71) // WHO_AM_I should always be 0x71
  {  
        pc.printf("MPU9250 is online...\n\r");
        sprintf(buffer, "0x%x", whoami);
        wait(1);
        mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
        mpu9250.MPU9250SelfTest(SelfTest); // Start by performing self test and reporting values (accelerometer and gyroscope self test)
        mpu9250.calibrateMPU9250(gyroBias, accelBias); // Calibrate gyro and accelerometer, load biases in bias registers  
        wait(2);
        //Initialize device for active mode read of acclerometer, gyroscope, and temperature
        mpu9250.initMPU9250();
        pc.printf("MPU9250 initialized for active data mode....\n\r");
        //Initialize device for active mode read of magnetometer, 16 bit resolution, 100Hz.
        mpu9250.initAK8963(magCalibration);
        wait(1);
   }
   
   else // Connection failure
   {
    pc.printf("Could not connect to MPU9250: \n\r");
    pc.printf("%#x \n",  whoami);    
    sprintf(buffer, "WHO_AM_I 0x%x", whoami);
    //while(1) ; // Loop forever if communication doesn't happen
    }
  
    mpu9250.getAres(); 
    
    lcd.locate(0,0);
    lcd.printf("FRA221 DigitalElec.");
    lcd.locate(0,1);
    lcd.printf("Bike_Light");
    resetled();
    t.start();
    
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////         
    while(1) 
    {  
    
      if(t.read_ms()<=50)
      {
          //Read data
          /*if(mobile.readable())
          {
                //pack[0] = mobile.getc();
                for(int i=0;i<13;i++)
                    pack[i] = mobile.getc();
                  
                  //Debug_Serial   
                  for(int i=0;i<12;i++) 
                      pc.printf("%c",pack[i]); 
                  pc.printf("\n"); 
                  //lcd.locate(0,2); 
                  //for(int i=0;i<14;i++) lcd.printf("%c",pack[i]); 
                  
                  if(pack[0] == '#')
                  {
                    
                    if(pack[1] == 'D' && pack[4] == 'S' && pack[7] == 'K')
                    {
                         getdistance2led(pack[3]);
                         lcd.locate(0,2);  
                         lcd.printf("SPEED : %c%c km/hr",pack[5],pack[6]);
                         lcd.locate(0,3);  
                         lcd.printf("Distance: %c.%c%c km.",pack[8],pack[9],pack[10]);
                         //pc.printf("read\n");
                    }  
                  }
            }*/ 
               
          Ay[0]=GetAcceloroY(); //pc.printf("1: %d\n",Ay[0]);
          Ay[1]=GetAcceloroY(); //pc.printf("2: %d\n",Ay[1]);
          if( Ay[1]+Ay[0]< -150 ) {matrix_state=3; pc.printf("#BR$\n\n\n"); }
          switch1.rise(&switch_1);
          switch2.rise(&switch_2);
          switch3.rise(&switch_3);
          if(matrix_state == 0){mobile.printf("#MED$"); pc.printf("#MED$");}
          else if(matrix_state == 1){mobile.printf("#TR$");  pc.printf("#TR$\n");}
          else if(matrix_state == 2){mobile.printf("#TL$");  pc.printf("#TL$\n");}
          else if(matrix_state == 3){mobile.printf("#BR$");  pc.printf("#BR$\n");}
          if(switch1 == 0 && switch2 == 0 && switch3 == 0) matrix_state = 0;
          //if(switch1 == 0 && switch2 == 0 && switch3 == 0 && matrix_state == 0) {matrix_state = 1; mobile.printf("#MED$"); pc.printf("#MED$");}
          t.reset();
      }                 
    }
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
}

void switch_1() 
{ 
    matrix_state=1; 
    //matrix_state = 0;
    //mobile.printf("#TR$");
}
void switch_2() 
{
    matrix_state=2;
    //matrix_state = 0;
    //mobile.printf("#TL$");
}
void switch_3() 
{ 
    matrix_state=3;
    //matrix_state = 0;
    //mobile.printf("#BR$");
}

void getdistance2led(char step)
{
         resetled();
         if(step == '0'){
            pinled0=1; pinled1=0; pinled2=0; pinled3=0; pinled4=0; pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '1'){
            pinled0=1; pinled1=1; pinled2=0; pinled3=0; pinled4=0; pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '2'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=0; pinled4=0; pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '3'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=0; pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '4'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=1; pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '5'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=1; pinled5=1; pinled6=0; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '6'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=1; pinled5=1; pinled6=1; pinled7=0; pinled8=0; pinled9=0;}
         else if(step == '7'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=1; pinled5=1; pinled6=1; pinled7=1; pinled8=0; pinled9=0;}
         else if(step == '8'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=1; pinled5=1; pinled6=1; pinled7=1; pinled8=1; pinled9=0;}
         else if(step == '9'){
            pinled0=1; pinled1=1; pinled2=1; pinled3=1; pinled4=1; pinled5=1; pinled6=1; pinled7=1; pinled8=1; pinled9=1; pinbuzz=1;}
         else { pinled0=0; pinled1=0; pinled2=0; pinled3=0; pinled4=0; pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0; pinbuzz=0; }
}
void resetled()
{
         //reset
         pinled0=0; pinled1=0; pinled2=0; pinled3=0; pinled4=0;
         pinled5=0; pinled6=0; pinled7=0; pinled8=0; pinled9=0;
         pinbuzz=0;
}
//Function 4 SenAcceloroY
int GetAcceloroY()
{
         // If intPin goes high, all data registers have new data
        if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) {  // On interrupt, check if data ready interrupt   
            mpu9250.readAccelData(accelCount);  // Read the x/y/z adc values   
                I2Cstate = 1;
                ay = (float)accelCount[1]*aRes - accelBias[1];
            }   
       
        mpu9250.MahonyQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f, my, mx, mz);
        mpu9250.MadgwickQuaternionUpdate(ax,ay,az,gx,gy,gz,mx,my,mz);  
            //pc.printf(" ay = %.2f\n", 1000*ay);
        
        return ay*1000;
}