#include "mbed.h"
#include "rtos.h"
#include "IMU_RPY.h"
#include "GameCode.h"
#include "HumanPosition.h"
#include "HumanControl.h"

int main()
{
    pc.printf("\n\rStartup...\r\n");

    //Reset xbee
    pc.printf("Resetting XBee...\r\n");
    rst1 = 0;
    wait_us(1);
    rst1 = 1;
    wait_us(1);

    //Initialize IMU and filter
    pc.printf("Initializing IMU...\r\n");
    imuFilter.reset();
    rpy_init();

    // wait for AI car to get away from user
    pc.printf("Waiting for AI car...\n\r");
    wait(10);

    // start positioning system
    pc.printf("Starting Positioning System...\n\r");
    Thread position(PositionSystemMain, NULL, osPriorityRealtime, 256 * 4);
    wait(3); // wait for the mouse sensor to boot up

    // give control to radio driver while game is running
    pc.printf("Running!\n");
    Timer sendTimer;
    sendTimer.start();
    while(!gameOver) {
        radioDrive();
        if(sendTimer.read_ms() % 250)
            sendPosition(NULL);
    }
}
