#ifndef ULCD_GAUGES_H
#define ULCD_GAUGES_H
 
#include "uLCD_4DGL.h"
#include "mbed.h"

/** 
*   Header file for uLCD gauges library
*/
class uLCD_gauges {
public:
    /**
    * Constructor for the uLCD_gauges class. Sets up the value mapping assuming the default gauge is used.
    * @param screen The uLCD instance that is going to be used for the gauge
    * @param min The minimum value the gauge wil be updated with. Used for mapping.
    * @param max The maximum value the gauge wil be updated with. Used for mapping.
    */
    uLCD_gauges(uLCD_4DGL& screen, float min, float max);
    /**
    * Constructor for the uLCD_gauges class. Sets up the value mapping for custom gauges.
    * @param screen The uLCD instance that is going to be used for the gauge
    * @param min The minimum value the gauge wil be updated with. Used for mapping.
    * @param max The maximum value the gauge wil be updated with. Used for mapping.
    * @param memoryAddressHigh The ending memory address of the animation that will be displayed as a gauge.
    * @param memoryAddressLow The starting memory address of the animation that will be displayed as a gauge.
    */
    uLCD_gauges(uLCD_4DGL& screen, float min, float max, int lowF, int highF, long memoryAddressHigh, long memoryAddressLow);
    /**
    * This method repares the uLCD for displaying the gauge. Must be called once after object instancing
    */
    void start();
    /**
    * This method updates the gauge based on the new input value
    * @param value The value to be mapped onto the display
    */
    void update(float value);
  
private:  
    uLCD_4DGL *uLCD;
    float minVal;
    float maxVal;
    float mapOffset;
    float mapSlope;
    float highFrame;
    long memHigh;
    long memLow;
};
 
#endif
