#include "uLCD_gauges.h"
#include "mbed.h"

/**
* @file uLCD_gauges.cpp
* @brief This cpp file defines all the functions for uLCD_gauges.h
* @author Matthew Arceri and Harsha Nori
* @date 3/13/2015
*/

uLCD_gauges::uLCD_gauges(uLCD_4DGL& screen, float min, float max){
    uLCD = &screen;
    minVal = min;
    maxVal = max;
    mapOffset = 1;
    highFrame = 90;
    mapSlope = (highFrame - mapOffset) / (maxVal - minVal);
    memHigh = 0;
    memLow = 0;
}

uLCD_gauges::uLCD_gauges(uLCD_4DGL& screen, float min, float max, int lowF, int highF, long memoryAddressHigh, long memoryAddressLow){
    uLCD = &screen;
    minVal = min;
    maxVal = max;
    highFrame = highF;
    mapOffset = lowF;
    mapSlope = (highFrame - mapOffset) / (maxVal - minVal);
    memHigh = memoryAddressHigh;
    memLow = memoryAddressLow;
}

void uLCD_gauges::start() {
    uLCD->baudrate(3000000);
    uLCD->cls();
    uLCD->media_init();
    uLCD->set_sector_address(0,0);
}

void uLCD_gauges::update(float value){
    //Map value in range minVal to maxVal onto 1 to 99
    int mappedValue = int(mapOffset + mapSlope*(value - minVal));
    uLCD->display_frame(0,0, mappedValue);
}