#include "mbed.h"
#include "gps.h"

GPS::GPS(void){
    
    latitude = 0.0f;
    longitude = 0.0f;
    speed = 0.0f;
    mph = 0.0f;
    angle = 0.0f;    
    hour = 0;
    minute = 0;
    seconds = 0;
    year = 0;
    month = 0;
    day = 0;
    milliseconds = 0;
    fix = false;
    lineidx = 0;
    newSentence = false;
    firstfix = false;
    for (int i = 0; i<3; i++){
        positions[i].x = 0;
        positions[i].y = 0;
        }
    }
    
void GPS::parse(char *nmea) {
    uint16_t sum;
// do checksum check
// first look if we even have one
  if (nmea[strlen(nmea)-4] == '*') {
    sum = parseHex(nmea[strlen(nmea)-3]) * 16;
    sum += parseHex(nmea[strlen(nmea)-2]);
// check checksum 
    for (uint8_t i=1; i < (strlen(nmea)-4); i++) {
      sum ^= nmea[i];
    }
    if (sum != 0) {
// bad checksum :(
    newSentence = false;
    return;
    }
  }
// bad string
  float minutes;
  char degreebuff[10];
// look for RMC sentence only
  if (strstr(nmea, "$GPRMC")) {
     newSentence = true;
     char *p = nmea;
// get time
    p = strchr(p, ',')+1;
    timef = atof(p)*(float)10;
    uint32_t time = timef;
    hour = time / 100000;
    minute = (time % 100000) / 1000;
    seconds = (time % 1000)/10;
    milliseconds = time % 10;
//Check for valid fix
    p = strchr(p, ',')+1;
    if (p[0] == 'A') 
        fix = true;
    else{
        fix = false;
        return;
        }
    firstfix = true;
// parse out latitude
    p = strchr(p, ',')+1;
    if (',' != *p){
      strncpy(degreebuff, p, 2);
      p += 2;
      degreebuff[2] = '\0';
      latitude = atof(degreebuff);
      strncpy(degreebuff, p, 7); // float minutes
      degreebuff[7] = '\0';
      minutes = atof(degreebuff)/60;
      latitude += minutes;
        }
    p = strchr(p, ',')+1;
    if (',' != *p)
    {
      if (p[0] == 'S') longitude *= -1.0;
    }
// parse out longitude
    p = strchr(p, ',')+1;
    if (',' != *p)
//Not empty value due to no fix
    {
      strncpy(degreebuff, p, 2);
      p += 2;
      degreebuff[2] = '\0';
      longitude = atof(degreebuff);
      strncpy(degreebuff, p, 7); // float minutes
      degreebuff[7] = '\0';
      minutes = atof(degreebuff)/60;
      longitude += minutes;
    }
    p = strchr(p, ',')+1;
    if (',' != *p)
    {
      if (p[0] == 'W') longitude *= -1.0;
    }
    // speed
    p = strchr(p, ',')+1;
    if (',' != *p)
    {
      speed = atof(p)*knots_to_ms;
      mph = speed / 0.44704f;
    }
    
    // angle
    p = strchr(p, ',')+1;
    if (',' != *p)
    {
      angle = atof(p);
    }
    
    p = strchr(p, ',')+1;
    if (',' != *p)
    {
      uint32_t fulldate = atof(p);
      day = fulldate / 10000;
      month = (fulldate % 10000) / 100;
      year = (fulldate % 100);
    }
    positions[0] = positions[1];
    positions[1] = positions[2];
    positions[2] = Cartesian(latitude,longitude);
    if (mph > 10) radius = CalcRadius(positions[0], positions[1], positions[2]);
    else radius = 300.0f;
    if (radius > 300.0f) radius = 300.0f;
    return;
  }
  newSentence = false;
}