/*********************************
**Read DS1631 Temperature Sensor**
******Made by Stijn Sontrop*******
**********22 Dec 2010*************
**********************************/

#include "mbed.h"
#include <TextLCD.h> //Include the TextLCD lib (add this one to your project)

///DS1631 Address:
//Formation: 1001 A2 A1 A0 R/W'
//Write: Make R/W' 0
#define DS1631WRITEADDRESS 0x90
//Read: Make R/W' 1
#define DS1631READADDRESS 0x91

TextLCD lcd(p15, p16, p17, p18, p19, p20); //LCD config rs, e, d4-d7

I2C i2c(p9, p10); //SDA & SCL from I2C
typedef struct { //Struct to contain read values
    char msb;
    char lsb;
} temperature;

temperature readds1631(void) {
    temperature readval;
    i2c.start();
    i2c.write(DS1631WRITEADDRESS);
    i2c.write(0xAA); //Read the temperature
    i2c.stop();
    wait_ms(1);
    i2c.start();
    i2c.write(DS1631READADDRESS);
    readval.msb = i2c.read(1); //Read the MSB (and do an ACK)
    readval.lsb = i2c.read(0); //Read the LSB (and don't do an ACK)
    i2c.stop();
    readval.msb = readval.msb - 2; //Apparently you need to do -2 to get the right value
    return readval; //Return the value
}

int main() {
    temperature readval;
    i2c.start();
    i2c.write(DS1631WRITEADDRESS); //address
    i2c.write(0xAC); //config reg
    i2c.write(0x02); //config
    i2c.stop();
    
    //Start conversion:
    i2c.start();
    i2c.write(DS1631WRITEADDRESS);
    i2c.write(0x51); //start conversion
    i2c.stop();
    while(1) {
        readval = readds1631(); //Call the readds1631 function
        lcd.cls(); //Clear the LCD
        lcd.printf("Temp: %d\nLSB:%d", readval.msb, readval.lsb);
        wait(0.3); 
    }
}
