/*********************************
**Read DS1624 Temperature Sensor**
******Made by Stijn Sontrop*******
**********22 Dec 2010*************
**********************************/

#include "mbed.h"
#include <TextLCD.h> //Include the TextLCD lib (add this one to your project)


//Address of DS1642: 1001 A2 A1 A0 R/W'
//Example: 0x92 = Sensor with address 1
//Make R/W' 0
#define DS1642WRITEADDR 0x92
//Make R/W' 1
#define DS1642READADDR 0x93

TextLCD lcd(p15, p16, p17, p18, p19, p20); //LCD Config rs, e, d4-d7

I2C i2c(p9, p10); //SDA & SCL from I2C
typedef struct { //Struct that contains the MSB en LSB value
    char msb;
    char lsb;
} temperature;

//Function that reads the temperature
temperature readDS1624(void) {
    temperature readval;
    i2c.start();
    i2c.write(DS1642WRITEADDR); //address
    i2c.write(0xEE); //start conv T
    i2c.stop();
    wait_ms(2);
    
    i2c.start();
    i2c.write(DS1642WRITEADDR); //Address
    i2c.write(0xAA); //read temp command
    i2c.stop();
    wait_ms(1);
    
    i2c.start();
    i2c.write(DS1642READADDR); //Write Address
    readval.msb = i2c.read(1); //Read MSB + ACK
    readval.lsb = i2c.read(0); //Read LSB + No ACK
    i2c.stop();
    readval.msb = readval.msb - 2; //Apparently you need to do -2 to get the right value
    return readval; //Return value
}

int main() {
    temperature readval;
    i2c.start();
    i2c.write(DS1642WRITEADDR); //b1001 A2 A1 A0 R/W'
    i2c.write(0xAC); //access config
    i2c.write(0x00); //continuous conversion
    i2c.stop();
    
    while (1) {
        readval = readDS1624(); //Call the readDS162 function
        lcd.cls(); //Clear LCD
        lcd.printf("Temp: %d\n%d", readval.msb, readval.lsb); //Print values to LCD
        wait(0.3);
    }
}
