#include "Step_Motor.h"
#include "mbed.h"
#include "General.h"
 
 
 Serial pc1(USBTX,USBRX);
 
    
stepmotor::stepmotor(PinName in1, PinName in2, PinName in3, PinName in4,PinName in5, PinName in6, PinName in7, PinName in8) : motor_out(in1,in2,in3,in4,in5,in6,in7,in8) { 
 
 
    motor_out=0x0;
    nstep=0;
    motorSpeed=1200;
    nstep2=7;
}
 
 
void stepmotor::move() { 
   
   switch(nstep2)
        { 
            case 0: ms2 = 0x1;  break;  // 0001 XXXX
            case 1: ms2 = 0x3; break;  // 0011
            case 2: ms2 = 0x2;  break;  // 0010   
            case 3: ms2 = 0x6;  break;  // 0110
            case 4: ms2 = 0x4;  break;  // 0100
            case 5: ms2 = 0xC;  break;  // 1100
            case 6: ms2 = 0x8;  break;  // 1000
            case 7: ms2 = 0x9;  break;  // 1001
            
            default: ms2 = 0x0; break; // 0000
        }
   
   switch(nstep)
        { 
            case 0: motor_out = 0x10 + ms2;  break;  // 0001 XXXX
            case 1: motor_out = 0x30 + ms2; break;  // 0011
            case 2: motor_out = 0x20 + ms2;  break;  // 0010   
            case 3: motor_out = 0x60 + ms2;  break;  // 0110
            case 4: motor_out = 0x40 + ms2;  break;  // 0100
            case 5: motor_out = 0xC0 + ms2;  break;  // 1100
            case 6: motor_out = 0x80 + ms2;  break;  // 1000
            case 7: motor_out = 0x90 + ms2;  break;  // 1001
            
            default: motor_out = 0x00 + ms2; break; // 0000
        }
        wait_us(motorSpeed);
        
}
 
void stepmotor::set_speed(int speed){
    motorSpeed=speed; //set motor speed us 
}
uint32_t stepmotor::get_speed(){
    return motorSpeed; // 
}
 
void stepmotor::step(uint32_t num_steps, uint8_t cw) {
// funcion para mover el motor N pasos CW o CCW   
// num_steps  número de paso que da el motor 
// cw =True  para dirección en sentido del reloj 
// cw =False para dirección contraria de las manecillas del reloj         
    pc1.baud(9600);              //programar los baudios
    pc1.format(8,SerialBase::None,1); 
    
    uint32_t count=num_steps ;
    while(count){
        if (cw==DER)   nstep++; nstep2++;    
        if (cw==IZQ)  nstep--; nstep2--;
        if (cw==UP)   nstep++; nstep2--;    
        if (cw==DOWN)  nstep--; nstep2++;  
        if (nstep>7) nstep=0;
        if (nstep<0) nstep=7;
        if (nstep2>7) nstep=0;
        if (nstep2<0) nstep=7;
        move();
        count--;
 
    }
    if(cw==UP) pc1.printf("Avance \n");
    else if (cw==DOWN) pc1.printf("Retrocedi \n");
    else if (cw==IZQ) pc1.printf("Gire Izq \n");
    else if (cw==DER) pc1.printf("Gire Der \n");
}