#include "mbed.h"
#include "Servo_X.h"
#include "Step_Motor.h"
#include "General.h"
 
DigitalOut myled(LED1);
 
Serial pc(USBTX,USBRX);      //pines de transmision y recepcion asignados a puerto USB tipo B y aqui
 
 #define MEM_SIZE 10000
#define MEM_TYPE uint32_t
 
stepmotor smotor1(PA_9,PC_7,PB_6,PA_7,PC_0,PC_1,PB_0,PA_4);

uint32_t mem_head = 0;
uint32_t mem_tail = 0;
uint32_t full = 0;
 
MEM_TYPE buffer[MEM_SIZE];
 
void mem_free()
{
    mem_head=0;
    full=0;
    mem_tail=0;   
}
 
uint32_t mem_put(MEM_TYPE data)
{
    if(full){
        return 1;
    }
    buffer [mem_head] = data;
    mem_head +=1;
    if(mem_head == MEM_SIZE)
    full=1;
    return 0;
}
 
uint32_t mem_get(MEM_TYPE* data)
{
    if(mem_head == 0)
        return 1;
    if (mem_head == mem_tail)
        return 1;
        
    *data=buffer[mem_tail];
    mem_tail +=1;
    
    return 0;
}

void program_serial();
void ejecutar();
int guardar();
void matriz(uint8_t,uint8_t);
int sentido(int);
int paridad(uint8_t);
 
int main() 
{
    program_serial();
    uint8_t letra,subletra;
    Servo Servos;
    Servos.SetServo(0,0);        //calibración coordenadas (0,0)
    Servos.SetZ(NODRAW);
    myled = 1;
    wait(2);
    while(1) {
        pc.printf("ingrese comando \n");
        pc.printf("FE - para guardado, FF - para ejercutar \n");
        letra=pc.getc();                //recibir caracter
        subletra=pc.getc();
        if(subletra==CM_STOP)
        {
        switch(letra)
        {
            case CM_EJECUTAR:
                if(mem_head!=mem_tail)
                { 
                    ejecutar();
                }
                else{
                    pc.printf("La memoria se encuentra vacia \n");
                } 
            break;
            case CM_GUARDAR: 
                if(guardar()==0)
                {
                    pc.printf("el programa se guardo correctamente \n");
                }
                else
                {
                    pc.printf("el programa no se pudo guardar... vuelva a intentar \n");
                }
                break;
            case CM_MATRIZ:
                letra=pc.getc();                //recibir caracter
                subletra=pc.getc();
                pc.printf("Y el f0? \n");
                pc.getc();
                matriz(letra,subletra);
            break;
            default: pc.printf("error de comando \n");break ;
        }
        }
        else
        {
            pc.printf("el comando End no fue definido... vuelva a intentar \n");
        }
    }
}
void program_serial()
{
    pc.baud(9600);              //programar los baudios
    pc.format(8,SerialBase::None,1);        //el numero de datos en bits, el bit de paridad, el bit de stop
}
void ejecutar()
{
    program_serial();
    Servo Servos;
    pc.printf("el programa se esta ejecutando \n");
    uint8_t a=0,b=0,c=0;
    uint32_t letra1,letra2,letra3;
    MEM_TYPE val;
    
    mem_get(&val);
    letra1=(val&0xff00)>>8;
    letra2=(val&0xff0000)>>16;
    letra3=(val&0xff000000)>>24;
    while(c!=CM_END)
    {
        a=letra3;
        b=letra2;
        c=letra1;
        if(a==CM_SERVO)
        {
            Servos.SetServo(b,c);
        }
        
        else if(c==CM_SDRAW)
        {
            Servos.SetZ(DRAW);
        }
        else if(c==CM_SN0DRAW)
        {
            Servos.SetZ(NODRAW);
        }
        else if(a==CM_STEPMOTOR)
        {
            uint8_t NCA=b;
            uint32_t cuadrante=(NUME_PASOS/RADIO_R);
            cuadrante=cuadrante*NCA;
            c=c&0x1;
            smotor1.step(cuadrante,c);
            pc.printf("ya lo movi \n");
        }
        mem_get(&val);
        letra1=(val&0xff00)>>8;
        letra2=(val&0xff0000)>>16;
        letra3=(val&0xff000000)>>24;
        wait(1);
    }
    pc.printf("el programa se termino de ejecutar \n");
    mem_tail=0;
}
int guardar()
{
    mem_free();
    uint32_t letra=0;
    uint8_t subletra;             
    program_serial();
    pc.printf("el programa se esta guardando \n");
    subletra=pc.getc();
    pc.putc(subletra);
    while(subletra!=CM_END)
    {
        switch(subletra)
        {
            case CM_SERVO:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                letra=letra+subletra;
                pc.putc(letra);
                letra=letra<<8;
                subletra=pc.getc();
                letra=letra+subletra;
                pc.putc(letra);
                letra=letra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                pc.putc(letra);
                mem_put(letra);
            break;
            case CM_SDRAW:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                mem_put(letra);
            break;
            case CM_SN0DRAW:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                mem_put(letra);
            break; 
            case CM_STEPMOTOR:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                letra=letra+subletra;
                pc.putc(letra);
                letra=letra<<8;
                subletra=pc.getc();
                letra=letra+subletra;
                pc.putc(letra);
                letra=letra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                pc.putc(letra);
                mem_put(letra);
            break;
        }
        letra=0;
        subletra=pc.getc();   
    }
    subletra=pc.getc();
    pc.printf("el programa termino de guardar \n");
    mem_put(0xfaf0);
    return 0;
}

void matriz(uint8_t columnas,uint8_t filas)
{
    uint32_t cuacolum,cuafila;
    uint32_t cuadrante=(NUME_PASOS/RADIO_R);
    cuacolum=cuadrante*columnas;
    cuafila=cuadrante*filas;
    for(int i=0;i<2;i++){
    smotor1.step(cuacolum,UP);
    smotor1.step(TURN,IZQ);
    smotor1.step(cuafila,UP);
    smotor1.step(TURN,IZQ);}
    smotor1.step(cuadrante,UP);
    smotor1.step(TURN,IZQ);
    
    for(int i=1;i<=paridad(columnas);i++){            //1 der 2 izq y otro para el columnas y filas
        smotor1.step(cuafila,UP);
        smotor1.step(TURN,sentido(i));
        smotor1.step(cuadrante,UP);
        smotor1.step(TURN,sentido(i));
    }
    smotor1.step(cuadrante,UP);
    smotor1.step(TURN,sentido((columnas-1)%2));
        
    for(int i=0;i<paridad(filas);i++)            //1 der 2 izq            
    {
         smotor1.step(cuafila,UP);       
         smotor1.step(TURN,sentido(i));
         smotor1.step(cuadrante,UP);
         smotor1.step(TURN,sentido(i));
    }     
}
int sentido(int sent)
{
    if(sent%2==0)
        return IZQ;
    else
        return DER;
}
int paridad(uint8_t part)
{
    if(part%2==0)
        return part;
    else
        return part-1;
}           