#include "mbed.h"
#include "Servo_X.h"
#include "Step_Motor.h"

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);      //pines de transmision y recepcion asignados a puerto USB tipo B

#define MEM_SIZE 10000
#define MEM_TYPE uint32_t
uint32_t mem_head = 0;
uint32_t mem_tail = 0;
uint32_t full = 0;

MEM_TYPE buffer[MEM_SIZE];

void mem_free()
{
    mem_head=0;
    full=0;
    mem_tail=0;   
}

uint32_t mem_put(MEM_TYPE data)
{
    if(full){
        return 1;
    }
    buffer [mem_head] = data;
    mem_head +=1;
    if(mem_head == MEM_SIZE)
    full=1;
    return 0;
}

uint32_t mem_get(MEM_TYPE* data)
{
    if(mem_head == 0)
        return 1;
    if (mem_head == mem_tail)
        return 1;
        
    *data=buffer[mem_tail];
    mem_tail +=1;
    
    return 0;
}

void S_EMPIEZA();
void program_serial();
void ejecutar();
int guardar();

int main() 
{
    program_serial();
    uint8_t letra,subletra;
    Servo Servos;
    Servos.SetServo(0,0);        //calibración coordenadas (0,0)
    Servos.SetZ(NODRAW);
    myled = 1;
    wait(2);
    while(1) {
        pc.printf("ingrese comando \n");
        letra=pc.getc();                //recibir caracter
        subletra=pc.getc();
        if(subletra==CM_STOP)
        {
        switch(letra)
        {
            case CM_EJECUTAR:
                if(mem_head!=mem_tail)
                { 
                    ejecutar();
                }
                else{
                    pc.printf("La memoria se encuentra vacia \n");
                } 
            break;
            case CM_GUARDAR: 
                if(guardar()==0)
                {
                    pc.printf("el programa se guardo correctamente \n");
                }
                else
                {
                    pc.printf("el programa no se pudo guardar... vuelva a intentar \n");
                }
                break;
            default: pc.printf("error de comando \n");break ;
        }
        }
        else
        {
            pc.printf("el comando End no fue definido... vuelva a intentar \n");
        }
    }
}
void program_serial()
{
    pc.baud(9600);              //programar los baudios
    pc.format(8,SerialBase::None,1);        //el numero de datos en bits, el bit de paridad, el bit de stop
}
void S_EMPIEZA()
{
    
}
void ejecutar()
{
    program_serial();
    Servo Servos;
    pc.printf("el programa se esta ejecutando \n");
    uint8_t a=0,b=0,c=0,d=0;
    uint32_t letra,letra1,letra2,letra3;
    MEM_TYPE val;
    
    mem_get(&val);
    letra1=(val&0xff00)>>8;
    letra2=(val&0xff0000)>>16;
    letra3=(val&0xff000000)>>24;
    letra=val&0xff;
    while(c!=CM_END)
    {
        a=letra3;
        pc.putc(a);
        b=letra2;
        pc.putc(b);
        c=letra1;
        pc.putc(c);
        d=letra;
        pc.putc(d);
        if(a==CM_SERVO)
        {
            Servos.SetServo(b,c);
        }
        else if(c==CM_SDRAW)
        {
            Servos.SetZ(DRAW);
        }
        else if(c==CM_SN0DRAW)
        {
            Servos.SetZ(NODRAW);
        }
        mem_get(&val);
        letra1=(val&0xff00)>>8;
        letra2=(val&0xff0000)>>16;
        letra3=(val&0xff000000)>>24;
        letra=val&0xff;
        wait(1);
    }
    pc.printf("el programa se termino de ejecutar \n");
    mem_tail=0;
}
int guardar()
{
    mem_free();
    uint32_t letra=0;
    uint8_t subletra;
    Servo Servos;
    program_serial();
    pc.printf("el programa se esta guardando \n");
    subletra=pc.getc();
    pc.putc(subletra);
    //mem_put(letra);
    while(subletra!=CM_END)
    {
        switch(subletra)
        {
            case CM_SERVO:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                letra=letra+subletra;
                pc.putc(letra);
                letra=letra<<8;
                subletra=pc.getc();
                letra=letra+subletra;
                pc.putc(letra);
                letra=letra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                pc.putc(letra);
                mem_put(letra);
            break;
            case CM_SDRAW:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                mem_put(letra);
            break;
            case CM_SN0DRAW:
                letra=letra+subletra<<8;
                subletra=pc.getc();
                if(subletra!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                letra=letra+subletra;
                mem_put(letra);
            break; 
        }
        letra=0;
        subletra=pc.getc();   
    }
    subletra=pc.getc();
    pc.printf("el programa termino de guardar \n");
    mem_put(0xfaf0);
    return 0;
}