#include "mbed.h"
#include "Memoria.h"

uint32_t mem_head = 0;
uint32_t mem_tail = 0;
uint32_t full = 0;
MEM_TYPE buffer[MEM_SIZE];

uint32_t get_mem_head()
{
    return mem_head;
}
uint32_t get_mem_tail()
{
    return mem_tail;
}
uint32_t reset_tail()
{
    mem_tail=0;
}
void mem_free()
{
    mem_head=0;
    full=0;
    mem_tail=0;   
}

uint32_t mem_put(MEM_TYPE data)
{
    if(full){
        return 1;
    }
    buffer [mem_head] = data;
    mem_head +=1;
    if(mem_head == MEM_SIZE)
    full=1;
    return 0;
}

uint32_t mem_get(MEM_TYPE* data)
{
    if(mem_head == 0)
        return 1;
    if (mem_head == mem_tail)
        return 1;
        
    *data=buffer[mem_tail];
    mem_tail +=1;
    
    return 0;
}