#include "mbed.h"
#include "pt.h"

#define numsamples 1
#define sizeofpattern 30    // max size of string length


//  function declartion
int touchSense(int Num_Charger);
void displayString(int* String);
void displayMessage(int NumMes);

//  I/O declarations
DigitalOut myled(LED1);
AnalogIn input1(p20), input0(p17);
DigitalIn charger1(p19), charger0(p16);
DigitalOut ground(p18);
Serial pc(USBTX, USBRX); // tx, rx


//  variable definitions
int hostString[sizeofpattern];
//int currentState = S_idle;
//int nextState = S_idle;

int i, j, token;
int NewTokenFlag, StateFlag;   //  NewTokenFlag is 1 when a token is received, otherwise 0
//  StateFlag is 1 when a state transition decision is made, it is sets to 2 when the system should be reset

//  threads declarations
static struct pt pt_1, pt_2;


//  FSM_transition executes FSM transition
static int FSM_transition(struct pt *pt) {

    PT_BEGIN(pt);

    StateFlag = 1;  // let IO_handler run first

    while (1) {
        PT_WAIT_UNTIL(pt, (NewTokenFlag==1));
        if (token == 'S') {
            NewTokenFlag = 0;
            break;
        } else { // handle the case when the input is not S
            displayMessage(1);
            NewTokenFlag = 0;
            StateFlag = 1;
        }
    }

    //
    //printf("S_HostInput \n");
    //

    //  currentState = S_HostInput
    i = 0;
    while (1) {
        StateFlag = 1;
        PT_WAIT_UNTIL(pt, NewTokenFlag);
        NewTokenFlag = 0;
        if (token=='E')  break;
        else if ((token=='0'||token=='1')&& i<sizeofpattern) {
            hostString[i] = token;
            i++;
        }

        else {
            displayMessage(1);  // currentState = S_HostError
            i = 0;
            StateFlag =2;   //  indicate the system should be reset
            break;
        }
    }

    if (StateFlag!=2) {     // skip S_UserInput if the sysetem should be reset
        //    currentState = S_UserInput
        //
        //printf("S_UserInput ------- \n");
        //
        j =0;
        while (1) {
            StateFlag = 1;
            PT_WAIT_UNTIL(pt, NewTokenFlag);
            NewTokenFlag = 0;

            if (hostString[j]==token) {
                j++;
                if (j==i) {
                    displayMessage(2);  //  currentState = S_Match
                    break;
                }
            } else {
                displayMessage(0);  //  currentState = S_UserError
                j = 0;
                continue;           //   returns S_UserInput
            }

            StateFlag = 2;  //  indicates the system should be reset
        }   //  end of while
    }   // end of skip

    PT_END(pt);
}


//  IO_handler polls the I/O ports
static int IO_Handler(struct pt *pt) {
    PT_BEGIN(pt);
    while (1) {
        if (StateFlag == 2) break;  //  reacts when the system is rest

        PT_WAIT_UNTIL(pt, StateFlag==1);
        //
        //printf("CP 2 ------- \n");
        //
        if (pc.readable()) {
            token = pc.getc();
            pc.putc(token);
            NewTokenFlag = 1;
            StateFlag = 0;
        } else if (touchSense(0)) {
            myled=1;
            token = '0';
            pc.putc('0');
            NewTokenFlag = 1;
            StateFlag = 0;
        } else if (touchSense(1)) {
            myled=1;
            token = '1';
            pc.putc('1');
            NewTokenFlag = 1;
            StateFlag = 0;
        } else myled =0;
        wait(0.1);
        //
        //printf("CP 3 ------- \n");
        //
    }

    PT_END(pt);
}



int main() {
    PT_INIT(&pt_1);
    PT_INIT(&pt_2);
    StateFlag =0;
    NewTokenFlag =0;

    while (1) {

        FSM_transition(&pt_1);
        IO_Handler(&pt_2);
    }
    return 0;
}   //  end of main


int touchSense(int Num_Charger) {
    float sample1, sample2;
    ground = 0;
    if (Num_Charger ==1) {
        charger1.mode(PullUp);
        charger1.mode(PullNone);
        sample1=input1.read();  // take two samples to avoid the random jump on voltage on touch sensor
        wait(0.1);
        sample2=input1.read();
    } else {
        charger0.mode(PullUp);
        charger0.mode(PullNone);
        sample1=input0.read();  // take two samples to ignore temp jump
        wait(0.1);
        sample2=input0.read();
    }

    if (sample1 < 0.3 && sample2 < 0.3) {
        return 1;
    } else {
        return 0;
    }
}



void displayString(int* String) {
    for (int j=0; j<sizeofpattern; j++)
        pc.putc(String[j]);

    pc.putc('\n');

}

void displayMessage(int NumMes) {
    if (NumMes == 1)
        printf("HOST ERROR : Host must send string in the form of Sxxxx...E X=0 or 1 \n");
    else if (NumMes == 0)  printf("TOUCH ERROR: Please enter the string that matched host string exactly through touchsensor\n");
    else   printf("MATCH: Host will send another string\n");

}

