#include "mbed.h"

#define numsamples 1
#define sizeofpattern 30
#define S_idle 0
#define S_HostInput 1
#define S_UserInput 2
#define S_HostError 3
#define S_UserError 4
#define S_Match 5

//  function declartion
int touchSense(int Num_Charger);
void displayString(int* String);
void displayMessage(int NumMes);

//  I/O declarations
DigitalOut myled(LED1);
AnalogIn input1(p20), input0(p17);
DigitalIn charger1(p19), charger0(p16);
DigitalOut ground(p18);
Serial pc(USBTX, USBRX); // tx, rx


//  variable definitions
int hostString[sizeofpattern];
int currentState = S_idle;
int nextState = S_idle;
int token;

//  interrrupt handler
void ReadHost() {
    if (pc.readable()){
       token = pc.getc(); //  getc returns int representation of letters and digits
       pc.putc(token);
    }
}


int main() {
    int i=0, j=0;
    

    pc.attach(&ReadHost);   //  retrives the input letter or digit when a serial pc generates an interrupt
    while (1) {
        token = 'n';    // n = no input

//  accept input token from touch sensors
        if (touchSense(0)) {
            myled = 1;
            token = '0';
            pc.putc('0');
        } else if (touchSense(1))  {
            myled =1;
            token = '1';
            pc.putc('1');
        } else myled = 0;


//  debug output
        if (token=='m')   {
            printf("current token is %d \n", token);
            printf("current j and jth element are %d %d \n", j, hostString[j]);
            printf("The string received from host is");
            displayString(hostString);
            printf("current state and next state are %d %d \n", currentState, nextState);
        }


        if (token == 'n' )  continue; // if no input, skip this cycle


//  deciding what next state is and generates output
        if (currentState == S_idle)  {
            if (token == 'S' )   nextState = S_HostInput;
             else {
                nextState = currentState;
                displayMessage(1);
            }
        }


        else if (currentState == S_HostInput) {
            if ((token == '0' || token == '1') && i < sizeofpattern) {
                hostString[i] = token;
                i++;
                nextState = currentState;   //  remain in the same state
            }
            //
            else if (token == 'm')   nextState = currentState;
            //
            else if (token == 'E')   nextState = S_UserInput;
            else {                      //  S_HostError
                displayMessage(1);
                nextState = S_idle;
                i = 0;
            }
        }

        else if (currentState == S_UserInput) {

            if (hostString[j] == token) {
                nextState = currentState;
                j++;
                if (j==i)  {
                        displayMessage(3);      // S_Match
                    nextState = S_idle;
                    j =0;
                    i=0;
                }
            }

            //
            else if (token == 'm')   nextState = currentState;
            //
            else {                              // S_UserError
                displayMessage(0);
                nextState = S_UserInput;
                j = 0;
            }
        }

        
        /*        else if (currentState == S_Match) {
                    displayMessage(3);
                    nextState = S_idle;
                    j =0;
                    i=0;
                }


                else if (currentState == S_HostError) {
                    displayMessage(1);
                    nextState = S_idle;
                    i = 0;
                }


                else if (currentState == S_UserError) {
                    displayMessage(0);
                    nextState = S_UserInput;
                    j = 0;
                }   */




    
//  state transition
        currentState = nextState;

    }// end of while

}   //  end of main


int touchSense(int Num_Charger) {
    float sample1, sample2;
    ground = 0;
    if (Num_Charger ==1) {
        charger1.mode(PullUp);
        charger1.mode(PullNone);
        sample1=input1.read();  // take two samples to ignore temp jump
        wait(0.2);
        sample2=input1.read();
    } else {
        charger0.mode(PullUp);
        charger0.mode(PullNone);
        sample1=input0.read();  // take two samples to ignore temp jump
        wait(0.2);
        sample2=input0.read();
    }

    if (sample1 < 0.3 && sample2 < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

//  debugging output
void displayString(int* String) {
    for (int j=0; j<sizeofpattern; j++)
        pc.putc(String[j]);

    pc.putc('\n');

}

void displayMessage(int NumMes) {
    if (NumMes == 1)
        printf("HOST ERROR : Host must send string in the form of Sxxxx...E X=0 or 1 \n");
    else if (NumMes == 0)  printf("TOUCH ERROR: Please enter the string that matched host string exactly through touchsensor\n");
    else   printf("MATCH: Host will send another string\n");

}
