/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_CAU_REGISTERS_H__
#define __HW_CAU_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 CAU
 *
 * Memory Mapped Cryptographic Acceleration Unit (MMCAU)
 *
 * Registers defined in this header file:
 * - HW_CAU_DIRECT0 - Direct access register 0
 * - HW_CAU_DIRECT1 - Direct access register 1
 * - HW_CAU_DIRECT2 - Direct access register 2
 * - HW_CAU_DIRECT3 - Direct access register 3
 * - HW_CAU_DIRECT4 - Direct access register 4
 * - HW_CAU_DIRECT5 - Direct access register 5
 * - HW_CAU_DIRECT6 - Direct access register 6
 * - HW_CAU_DIRECT7 - Direct access register 7
 * - HW_CAU_DIRECT8 - Direct access register 8
 * - HW_CAU_DIRECT9 - Direct access register 9
 * - HW_CAU_DIRECT10 - Direct access register 10
 * - HW_CAU_DIRECT11 - Direct access register 11
 * - HW_CAU_DIRECT12 - Direct access register 12
 * - HW_CAU_DIRECT13 - Direct access register 13
 * - HW_CAU_DIRECT14 - Direct access register 14
 * - HW_CAU_DIRECT15 - Direct access register 15
 * - HW_CAU_LDR_CASR - Status register  - Load Register command
 * - HW_CAU_LDR_CAA - Accumulator register - Load Register command
 * - HW_CAU_LDR_CA0 - General Purpose Register 0 - Load Register command
 * - HW_CAU_LDR_CA1 - General Purpose Register 1 - Load Register command
 * - HW_CAU_LDR_CA2 - General Purpose Register 2 - Load Register command
 * - HW_CAU_LDR_CA3 - General Purpose Register 3 - Load Register command
 * - HW_CAU_LDR_CA4 - General Purpose Register 4 - Load Register command
 * - HW_CAU_LDR_CA5 - General Purpose Register 5 - Load Register command
 * - HW_CAU_LDR_CA6 - General Purpose Register 6 - Load Register command
 * - HW_CAU_LDR_CA7 - General Purpose Register 7 - Load Register command
 * - HW_CAU_LDR_CA8 - General Purpose Register 8 - Load Register command
 * - HW_CAU_STR_CASR - Status register  - Store Register command
 * - HW_CAU_STR_CAA - Accumulator register - Store Register command
 * - HW_CAU_STR_CA0 - General Purpose Register 0 - Store Register command
 * - HW_CAU_STR_CA1 - General Purpose Register 1 - Store Register command
 * - HW_CAU_STR_CA2 - General Purpose Register 2 - Store Register command
 * - HW_CAU_STR_CA3 - General Purpose Register 3 - Store Register command
 * - HW_CAU_STR_CA4 - General Purpose Register 4 - Store Register command
 * - HW_CAU_STR_CA5 - General Purpose Register 5 - Store Register command
 * - HW_CAU_STR_CA6 - General Purpose Register 6 - Store Register command
 * - HW_CAU_STR_CA7 - General Purpose Register 7 - Store Register command
 * - HW_CAU_STR_CA8 - General Purpose Register 8 - Store Register command
 * - HW_CAU_ADR_CASR - Status register  - Add Register command
 * - HW_CAU_ADR_CAA - Accumulator register - Add to register command
 * - HW_CAU_ADR_CA0 - General Purpose Register 0 - Add to register command
 * - HW_CAU_ADR_CA1 - General Purpose Register 1 - Add to register command
 * - HW_CAU_ADR_CA2 - General Purpose Register 2 - Add to register command
 * - HW_CAU_ADR_CA3 - General Purpose Register 3 - Add to register command
 * - HW_CAU_ADR_CA4 - General Purpose Register 4 - Add to register command
 * - HW_CAU_ADR_CA5 - General Purpose Register 5 - Add to register command
 * - HW_CAU_ADR_CA6 - General Purpose Register 6 - Add to register command
 * - HW_CAU_ADR_CA7 - General Purpose Register 7 - Add to register command
 * - HW_CAU_ADR_CA8 - General Purpose Register 8 - Add to register command
 * - HW_CAU_RADR_CASR - Status register  - Reverse and Add to Register command
 * - HW_CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command
 * - HW_CAU_RADR_CA0 - General Purpose Register 0 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA1 - General Purpose Register 1 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA2 - General Purpose Register 2 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA3 - General Purpose Register 3 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA4 - General Purpose Register 4 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA5 - General Purpose Register 5 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA6 - General Purpose Register 6 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA7 - General Purpose Register 7 - Reverse and Add to Register command
 * - HW_CAU_RADR_CA8 - General Purpose Register 8 - Reverse and Add to Register command
 * - HW_CAU_XOR_CASR - Status register  - Exclusive Or command
 * - HW_CAU_XOR_CAA - Accumulator register - Exclusive Or command
 * - HW_CAU_XOR_CA0 - General Purpose Register 0 - Exclusive Or command
 * - HW_CAU_XOR_CA1 - General Purpose Register 1 - Exclusive Or command
 * - HW_CAU_XOR_CA2 - General Purpose Register 2 - Exclusive Or command
 * - HW_CAU_XOR_CA3 - General Purpose Register 3 - Exclusive Or command
 * - HW_CAU_XOR_CA4 - General Purpose Register 4 - Exclusive Or command
 * - HW_CAU_XOR_CA5 - General Purpose Register 5 - Exclusive Or command
 * - HW_CAU_XOR_CA6 - General Purpose Register 6 - Exclusive Or command
 * - HW_CAU_XOR_CA7 - General Purpose Register 7 - Exclusive Or command
 * - HW_CAU_XOR_CA8 - General Purpose Register 8 - Exclusive Or command
 * - HW_CAU_ROTL_CASR - Status register  - Rotate Left command
 * - HW_CAU_ROTL_CAA - Accumulator register - Rotate Left command
 * - HW_CAU_ROTL_CA0 - General Purpose Register 0 - Rotate Left command
 * - HW_CAU_ROTL_CA1 - General Purpose Register 1 - Rotate Left command
 * - HW_CAU_ROTL_CA2 - General Purpose Register 2 - Rotate Left command
 * - HW_CAU_ROTL_CA3 - General Purpose Register 3 - Rotate Left command
 * - HW_CAU_ROTL_CA4 - General Purpose Register 4 - Rotate Left command
 * - HW_CAU_ROTL_CA5 - General Purpose Register 5 - Rotate Left command
 * - HW_CAU_ROTL_CA6 - General Purpose Register 6 - Rotate Left command
 * - HW_CAU_ROTL_CA7 - General Purpose Register 7 - Rotate Left command
 * - HW_CAU_ROTL_CA8 - General Purpose Register 8 - Rotate Left command
 * - HW_CAU_AESC_CASR - Status register  - AES Column Operation command
 * - HW_CAU_AESC_CAA - Accumulator register - AES Column Operation command
 * - HW_CAU_AESC_CA0 - General Purpose Register 0 - AES Column Operation command
 * - HW_CAU_AESC_CA1 - General Purpose Register 1 - AES Column Operation command
 * - HW_CAU_AESC_CA2 - General Purpose Register 2 - AES Column Operation command
 * - HW_CAU_AESC_CA3 - General Purpose Register 3 - AES Column Operation command
 * - HW_CAU_AESC_CA4 - General Purpose Register 4 - AES Column Operation command
 * - HW_CAU_AESC_CA5 - General Purpose Register 5 - AES Column Operation command
 * - HW_CAU_AESC_CA6 - General Purpose Register 6 - AES Column Operation command
 * - HW_CAU_AESC_CA7 - General Purpose Register 7 - AES Column Operation command
 * - HW_CAU_AESC_CA8 - General Purpose Register 8 - AES Column Operation command
 * - HW_CAU_AESIC_CASR - Status register  - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA0 - General Purpose Register 0 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA1 - General Purpose Register 1 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA2 - General Purpose Register 2 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA3 - General Purpose Register 3 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA4 - General Purpose Register 4 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA5 - General Purpose Register 5 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA6 - General Purpose Register 6 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA7 - General Purpose Register 7 - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA8 - General Purpose Register 8 - AES Inverse Column Operation command
 *
 * - hw_cau_t - Struct containing all module registers.
 */

#define HW_CAU_INSTANCE_COUNT (1U) /*!< Number of instances of the CAU module. */

/*******************************************************************************
 * HW_CAU_DIRECT0 - Direct access register 0
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT0 - Direct access register 0 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct0
{
    uint32_t U;
    struct _hw_cau_direct0_bitfields
    {
        uint32_t CAU_DIRECT0b : 32;    /*!< [31:0] Direct register 0 */
    } B;
} hw_cau_direct0_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT0 register
 */
/*@{*/
#define HW_CAU_DIRECT0_ADDR(x)   ((x) + 0x0U)

#define HW_CAU_DIRECT0(x)        (*(__O hw_cau_direct0_t *) HW_CAU_DIRECT0_ADDR(x))
#define HW_CAU_DIRECT0_WR(x, v)  (HW_CAU_DIRECT0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT0 bitfields
 */

/*!
 * @name Register CAU_DIRECT0, field CAU_DIRECT0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT0_CAU_DIRECT0 (0U)    /*!< Bit position for CAU_DIRECT0_CAU_DIRECT0. */
#define BM_CAU_DIRECT0_CAU_DIRECT0 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT0_CAU_DIRECT0. */
#define BS_CAU_DIRECT0_CAU_DIRECT0 (32U)   /*!< Bit field size in bits for CAU_DIRECT0_CAU_DIRECT0. */

/*! @brief Format value for bitfield CAU_DIRECT0_CAU_DIRECT0. */
#define BF_CAU_DIRECT0_CAU_DIRECT0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT0_CAU_DIRECT0) & BM_CAU_DIRECT0_CAU_DIRECT0)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT1 - Direct access register 1
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT1 - Direct access register 1 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct1
{
    uint32_t U;
    struct _hw_cau_direct1_bitfields
    {
        uint32_t CAU_DIRECT1b : 32;    /*!< [31:0] Direct register 1 */
    } B;
} hw_cau_direct1_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT1 register
 */
/*@{*/
#define HW_CAU_DIRECT1_ADDR(x)   ((x) + 0x4U)

#define HW_CAU_DIRECT1(x)        (*(__O hw_cau_direct1_t *) HW_CAU_DIRECT1_ADDR(x))
#define HW_CAU_DIRECT1_WR(x, v)  (HW_CAU_DIRECT1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT1 bitfields
 */

/*!
 * @name Register CAU_DIRECT1, field CAU_DIRECT1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT1_CAU_DIRECT1 (0U)    /*!< Bit position for CAU_DIRECT1_CAU_DIRECT1. */
#define BM_CAU_DIRECT1_CAU_DIRECT1 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT1_CAU_DIRECT1. */
#define BS_CAU_DIRECT1_CAU_DIRECT1 (32U)   /*!< Bit field size in bits for CAU_DIRECT1_CAU_DIRECT1. */

/*! @brief Format value for bitfield CAU_DIRECT1_CAU_DIRECT1. */
#define BF_CAU_DIRECT1_CAU_DIRECT1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT1_CAU_DIRECT1) & BM_CAU_DIRECT1_CAU_DIRECT1)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT2 - Direct access register 2
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT2 - Direct access register 2 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct2
{
    uint32_t U;
    struct _hw_cau_direct2_bitfields
    {
        uint32_t CAU_DIRECT2b : 32;    /*!< [31:0] Direct register 2 */
    } B;
} hw_cau_direct2_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT2 register
 */
/*@{*/
#define HW_CAU_DIRECT2_ADDR(x)   ((x) + 0x8U)

#define HW_CAU_DIRECT2(x)        (*(__O hw_cau_direct2_t *) HW_CAU_DIRECT2_ADDR(x))
#define HW_CAU_DIRECT2_WR(x, v)  (HW_CAU_DIRECT2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT2 bitfields
 */

/*!
 * @name Register CAU_DIRECT2, field CAU_DIRECT2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT2_CAU_DIRECT2 (0U)    /*!< Bit position for CAU_DIRECT2_CAU_DIRECT2. */
#define BM_CAU_DIRECT2_CAU_DIRECT2 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT2_CAU_DIRECT2. */
#define BS_CAU_DIRECT2_CAU_DIRECT2 (32U)   /*!< Bit field size in bits for CAU_DIRECT2_CAU_DIRECT2. */

/*! @brief Format value for bitfield CAU_DIRECT2_CAU_DIRECT2. */
#define BF_CAU_DIRECT2_CAU_DIRECT2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT2_CAU_DIRECT2) & BM_CAU_DIRECT2_CAU_DIRECT2)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT3 - Direct access register 3
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT3 - Direct access register 3 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct3
{
    uint32_t U;
    struct _hw_cau_direct3_bitfields
    {
        uint32_t CAU_DIRECT3b : 32;    /*!< [31:0] Direct register 3 */
    } B;
} hw_cau_direct3_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT3 register
 */
/*@{*/
#define HW_CAU_DIRECT3_ADDR(x)   ((x) + 0xCU)

#define HW_CAU_DIRECT3(x)        (*(__O hw_cau_direct3_t *) HW_CAU_DIRECT3_ADDR(x))
#define HW_CAU_DIRECT3_WR(x, v)  (HW_CAU_DIRECT3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT3 bitfields
 */

/*!
 * @name Register CAU_DIRECT3, field CAU_DIRECT3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT3_CAU_DIRECT3 (0U)    /*!< Bit position for CAU_DIRECT3_CAU_DIRECT3. */
#define BM_CAU_DIRECT3_CAU_DIRECT3 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT3_CAU_DIRECT3. */
#define BS_CAU_DIRECT3_CAU_DIRECT3 (32U)   /*!< Bit field size in bits for CAU_DIRECT3_CAU_DIRECT3. */

/*! @brief Format value for bitfield CAU_DIRECT3_CAU_DIRECT3. */
#define BF_CAU_DIRECT3_CAU_DIRECT3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT3_CAU_DIRECT3) & BM_CAU_DIRECT3_CAU_DIRECT3)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT4 - Direct access register 4
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT4 - Direct access register 4 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct4
{
    uint32_t U;
    struct _hw_cau_direct4_bitfields
    {
        uint32_t CAU_DIRECT4b : 32;    /*!< [31:0] Direct register 4 */
    } B;
} hw_cau_direct4_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT4 register
 */
/*@{*/
#define HW_CAU_DIRECT4_ADDR(x)   ((x) + 0x10U)

#define HW_CAU_DIRECT4(x)        (*(__O hw_cau_direct4_t *) HW_CAU_DIRECT4_ADDR(x))
#define HW_CAU_DIRECT4_WR(x, v)  (HW_CAU_DIRECT4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT4 bitfields
 */

/*!
 * @name Register CAU_DIRECT4, field CAU_DIRECT4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT4_CAU_DIRECT4 (0U)    /*!< Bit position for CAU_DIRECT4_CAU_DIRECT4. */
#define BM_CAU_DIRECT4_CAU_DIRECT4 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT4_CAU_DIRECT4. */
#define BS_CAU_DIRECT4_CAU_DIRECT4 (32U)   /*!< Bit field size in bits for CAU_DIRECT4_CAU_DIRECT4. */

/*! @brief Format value for bitfield CAU_DIRECT4_CAU_DIRECT4. */
#define BF_CAU_DIRECT4_CAU_DIRECT4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT4_CAU_DIRECT4) & BM_CAU_DIRECT4_CAU_DIRECT4)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT5 - Direct access register 5
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT5 - Direct access register 5 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct5
{
    uint32_t U;
    struct _hw_cau_direct5_bitfields
    {
        uint32_t CAU_DIRECT5b : 32;    /*!< [31:0] Direct register 5 */
    } B;
} hw_cau_direct5_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT5 register
 */
/*@{*/
#define HW_CAU_DIRECT5_ADDR(x)   ((x) + 0x14U)

#define HW_CAU_DIRECT5(x)        (*(__O hw_cau_direct5_t *) HW_CAU_DIRECT5_ADDR(x))
#define HW_CAU_DIRECT5_WR(x, v)  (HW_CAU_DIRECT5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT5 bitfields
 */

/*!
 * @name Register CAU_DIRECT5, field CAU_DIRECT5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT5_CAU_DIRECT5 (0U)    /*!< Bit position for CAU_DIRECT5_CAU_DIRECT5. */
#define BM_CAU_DIRECT5_CAU_DIRECT5 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT5_CAU_DIRECT5. */
#define BS_CAU_DIRECT5_CAU_DIRECT5 (32U)   /*!< Bit field size in bits for CAU_DIRECT5_CAU_DIRECT5. */

/*! @brief Format value for bitfield CAU_DIRECT5_CAU_DIRECT5. */
#define BF_CAU_DIRECT5_CAU_DIRECT5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT5_CAU_DIRECT5) & BM_CAU_DIRECT5_CAU_DIRECT5)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT6 - Direct access register 6
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT6 - Direct access register 6 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct6
{
    uint32_t U;
    struct _hw_cau_direct6_bitfields
    {
        uint32_t CAU_DIRECT6b : 32;    /*!< [31:0] Direct register 6 */
    } B;
} hw_cau_direct6_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT6 register
 */
/*@{*/
#define HW_CAU_DIRECT6_ADDR(x)   ((x) + 0x18U)

#define HW_CAU_DIRECT6(x)        (*(__O hw_cau_direct6_t *) HW_CAU_DIRECT6_ADDR(x))
#define HW_CAU_DIRECT6_WR(x, v)  (HW_CAU_DIRECT6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT6 bitfields
 */

/*!
 * @name Register CAU_DIRECT6, field CAU_DIRECT6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT6_CAU_DIRECT6 (0U)    /*!< Bit position for CAU_DIRECT6_CAU_DIRECT6. */
#define BM_CAU_DIRECT6_CAU_DIRECT6 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT6_CAU_DIRECT6. */
#define BS_CAU_DIRECT6_CAU_DIRECT6 (32U)   /*!< Bit field size in bits for CAU_DIRECT6_CAU_DIRECT6. */

/*! @brief Format value for bitfield CAU_DIRECT6_CAU_DIRECT6. */
#define BF_CAU_DIRECT6_CAU_DIRECT6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT6_CAU_DIRECT6) & BM_CAU_DIRECT6_CAU_DIRECT6)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT7 - Direct access register 7
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT7 - Direct access register 7 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct7
{
    uint32_t U;
    struct _hw_cau_direct7_bitfields
    {
        uint32_t CAU_DIRECT7b : 32;    /*!< [31:0] Direct register 7 */
    } B;
} hw_cau_direct7_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT7 register
 */
/*@{*/
#define HW_CAU_DIRECT7_ADDR(x)   ((x) + 0x1CU)

#define HW_CAU_DIRECT7(x)        (*(__O hw_cau_direct7_t *) HW_CAU_DIRECT7_ADDR(x))
#define HW_CAU_DIRECT7_WR(x, v)  (HW_CAU_DIRECT7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT7 bitfields
 */

/*!
 * @name Register CAU_DIRECT7, field CAU_DIRECT7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT7_CAU_DIRECT7 (0U)    /*!< Bit position for CAU_DIRECT7_CAU_DIRECT7. */
#define BM_CAU_DIRECT7_CAU_DIRECT7 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT7_CAU_DIRECT7. */
#define BS_CAU_DIRECT7_CAU_DIRECT7 (32U)   /*!< Bit field size in bits for CAU_DIRECT7_CAU_DIRECT7. */

/*! @brief Format value for bitfield CAU_DIRECT7_CAU_DIRECT7. */
#define BF_CAU_DIRECT7_CAU_DIRECT7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT7_CAU_DIRECT7) & BM_CAU_DIRECT7_CAU_DIRECT7)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT8 - Direct access register 8
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT8 - Direct access register 8 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct8
{
    uint32_t U;
    struct _hw_cau_direct8_bitfields
    {
        uint32_t CAU_DIRECT8b : 32;    /*!< [31:0] Direct register 8 */
    } B;
} hw_cau_direct8_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT8 register
 */
/*@{*/
#define HW_CAU_DIRECT8_ADDR(x)   ((x) + 0x20U)

#define HW_CAU_DIRECT8(x)        (*(__O hw_cau_direct8_t *) HW_CAU_DIRECT8_ADDR(x))
#define HW_CAU_DIRECT8_WR(x, v)  (HW_CAU_DIRECT8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT8 bitfields
 */

/*!
 * @name Register CAU_DIRECT8, field CAU_DIRECT8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT8_CAU_DIRECT8 (0U)    /*!< Bit position for CAU_DIRECT8_CAU_DIRECT8. */
#define BM_CAU_DIRECT8_CAU_DIRECT8 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT8_CAU_DIRECT8. */
#define BS_CAU_DIRECT8_CAU_DIRECT8 (32U)   /*!< Bit field size in bits for CAU_DIRECT8_CAU_DIRECT8. */

/*! @brief Format value for bitfield CAU_DIRECT8_CAU_DIRECT8. */
#define BF_CAU_DIRECT8_CAU_DIRECT8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT8_CAU_DIRECT8) & BM_CAU_DIRECT8_CAU_DIRECT8)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT9 - Direct access register 9
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT9 - Direct access register 9 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct9
{
    uint32_t U;
    struct _hw_cau_direct9_bitfields
    {
        uint32_t CAU_DIRECT9b : 32;    /*!< [31:0] Direct register 9 */
    } B;
} hw_cau_direct9_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT9 register
 */
/*@{*/
#define HW_CAU_DIRECT9_ADDR(x)   ((x) + 0x24U)

#define HW_CAU_DIRECT9(x)        (*(__O hw_cau_direct9_t *) HW_CAU_DIRECT9_ADDR(x))
#define HW_CAU_DIRECT9_WR(x, v)  (HW_CAU_DIRECT9(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT9 bitfields
 */

/*!
 * @name Register CAU_DIRECT9, field CAU_DIRECT9[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT9_CAU_DIRECT9 (0U)    /*!< Bit position for CAU_DIRECT9_CAU_DIRECT9. */
#define BM_CAU_DIRECT9_CAU_DIRECT9 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT9_CAU_DIRECT9. */
#define BS_CAU_DIRECT9_CAU_DIRECT9 (32U)   /*!< Bit field size in bits for CAU_DIRECT9_CAU_DIRECT9. */

/*! @brief Format value for bitfield CAU_DIRECT9_CAU_DIRECT9. */
#define BF_CAU_DIRECT9_CAU_DIRECT9(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT9_CAU_DIRECT9) & BM_CAU_DIRECT9_CAU_DIRECT9)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT10 - Direct access register 10
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT10 - Direct access register 10 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct10
{
    uint32_t U;
    struct _hw_cau_direct10_bitfields
    {
        uint32_t CAU_DIRECT10b : 32;   /*!< [31:0] Direct register 10 */
    } B;
} hw_cau_direct10_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT10 register
 */
/*@{*/
#define HW_CAU_DIRECT10_ADDR(x)  ((x) + 0x28U)

#define HW_CAU_DIRECT10(x)       (*(__O hw_cau_direct10_t *) HW_CAU_DIRECT10_ADDR(x))
#define HW_CAU_DIRECT10_WR(x, v) (HW_CAU_DIRECT10(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT10 bitfields
 */

/*!
 * @name Register CAU_DIRECT10, field CAU_DIRECT10[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT10_CAU_DIRECT10 (0U)  /*!< Bit position for CAU_DIRECT10_CAU_DIRECT10. */
#define BM_CAU_DIRECT10_CAU_DIRECT10 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT10_CAU_DIRECT10. */
#define BS_CAU_DIRECT10_CAU_DIRECT10 (32U) /*!< Bit field size in bits for CAU_DIRECT10_CAU_DIRECT10. */

/*! @brief Format value for bitfield CAU_DIRECT10_CAU_DIRECT10. */
#define BF_CAU_DIRECT10_CAU_DIRECT10(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT10_CAU_DIRECT10) & BM_CAU_DIRECT10_CAU_DIRECT10)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT11 - Direct access register 11
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT11 - Direct access register 11 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct11
{
    uint32_t U;
    struct _hw_cau_direct11_bitfields
    {
        uint32_t CAU_DIRECT11b : 32;   /*!< [31:0] Direct register 11 */
    } B;
} hw_cau_direct11_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT11 register
 */
/*@{*/
#define HW_CAU_DIRECT11_ADDR(x)  ((x) + 0x2CU)

#define HW_CAU_DIRECT11(x)       (*(__O hw_cau_direct11_t *) HW_CAU_DIRECT11_ADDR(x))
#define HW_CAU_DIRECT11_WR(x, v) (HW_CAU_DIRECT11(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT11 bitfields
 */

/*!
 * @name Register CAU_DIRECT11, field CAU_DIRECT11[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT11_CAU_DIRECT11 (0U)  /*!< Bit position for CAU_DIRECT11_CAU_DIRECT11. */
#define BM_CAU_DIRECT11_CAU_DIRECT11 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT11_CAU_DIRECT11. */
#define BS_CAU_DIRECT11_CAU_DIRECT11 (32U) /*!< Bit field size in bits for CAU_DIRECT11_CAU_DIRECT11. */

/*! @brief Format value for bitfield CAU_DIRECT11_CAU_DIRECT11. */
#define BF_CAU_DIRECT11_CAU_DIRECT11(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT11_CAU_DIRECT11) & BM_CAU_DIRECT11_CAU_DIRECT11)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT12 - Direct access register 12
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT12 - Direct access register 12 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct12
{
    uint32_t U;
    struct _hw_cau_direct12_bitfields
    {
        uint32_t CAU_DIRECT12b : 32;   /*!< [31:0] Direct register 12 */
    } B;
} hw_cau_direct12_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT12 register
 */
/*@{*/
#define HW_CAU_DIRECT12_ADDR(x)  ((x) + 0x30U)

#define HW_CAU_DIRECT12(x)       (*(__O hw_cau_direct12_t *) HW_CAU_DIRECT12_ADDR(x))
#define HW_CAU_DIRECT12_WR(x, v) (HW_CAU_DIRECT12(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT12 bitfields
 */

/*!
 * @name Register CAU_DIRECT12, field CAU_DIRECT12[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT12_CAU_DIRECT12 (0U)  /*!< Bit position for CAU_DIRECT12_CAU_DIRECT12. */
#define BM_CAU_DIRECT12_CAU_DIRECT12 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT12_CAU_DIRECT12. */
#define BS_CAU_DIRECT12_CAU_DIRECT12 (32U) /*!< Bit field size in bits for CAU_DIRECT12_CAU_DIRECT12. */

/*! @brief Format value for bitfield CAU_DIRECT12_CAU_DIRECT12. */
#define BF_CAU_DIRECT12_CAU_DIRECT12(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT12_CAU_DIRECT12) & BM_CAU_DIRECT12_CAU_DIRECT12)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT13 - Direct access register 13
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT13 - Direct access register 13 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct13
{
    uint32_t U;
    struct _hw_cau_direct13_bitfields
    {
        uint32_t CAU_DIRECT13b : 32;   /*!< [31:0] Direct register 13 */
    } B;
} hw_cau_direct13_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT13 register
 */
/*@{*/
#define HW_CAU_DIRECT13_ADDR(x)  ((x) + 0x34U)

#define HW_CAU_DIRECT13(x)       (*(__O hw_cau_direct13_t *) HW_CAU_DIRECT13_ADDR(x))
#define HW_CAU_DIRECT13_WR(x, v) (HW_CAU_DIRECT13(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT13 bitfields
 */

/*!
 * @name Register CAU_DIRECT13, field CAU_DIRECT13[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT13_CAU_DIRECT13 (0U)  /*!< Bit position for CAU_DIRECT13_CAU_DIRECT13. */
#define BM_CAU_DIRECT13_CAU_DIRECT13 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT13_CAU_DIRECT13. */
#define BS_CAU_DIRECT13_CAU_DIRECT13 (32U) /*!< Bit field size in bits for CAU_DIRECT13_CAU_DIRECT13. */

/*! @brief Format value for bitfield CAU_DIRECT13_CAU_DIRECT13. */
#define BF_CAU_DIRECT13_CAU_DIRECT13(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT13_CAU_DIRECT13) & BM_CAU_DIRECT13_CAU_DIRECT13)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT14 - Direct access register 14
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT14 - Direct access register 14 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct14
{
    uint32_t U;
    struct _hw_cau_direct14_bitfields
    {
        uint32_t CAU_DIRECT14b : 32;   /*!< [31:0] Direct register 14 */
    } B;
} hw_cau_direct14_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT14 register
 */
/*@{*/
#define HW_CAU_DIRECT14_ADDR(x)  ((x) + 0x38U)

#define HW_CAU_DIRECT14(x)       (*(__O hw_cau_direct14_t *) HW_CAU_DIRECT14_ADDR(x))
#define HW_CAU_DIRECT14_WR(x, v) (HW_CAU_DIRECT14(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT14 bitfields
 */

/*!
 * @name Register CAU_DIRECT14, field CAU_DIRECT14[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT14_CAU_DIRECT14 (0U)  /*!< Bit position for CAU_DIRECT14_CAU_DIRECT14. */
#define BM_CAU_DIRECT14_CAU_DIRECT14 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT14_CAU_DIRECT14. */
#define BS_CAU_DIRECT14_CAU_DIRECT14 (32U) /*!< Bit field size in bits for CAU_DIRECT14_CAU_DIRECT14. */

/*! @brief Format value for bitfield CAU_DIRECT14_CAU_DIRECT14. */
#define BF_CAU_DIRECT14_CAU_DIRECT14(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT14_CAU_DIRECT14) & BM_CAU_DIRECT14_CAU_DIRECT14)
/*@}*/

/*******************************************************************************
 * HW_CAU_DIRECT15 - Direct access register 15
 ******************************************************************************/

/*!
 * @brief HW_CAU_DIRECT15 - Direct access register 15 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct15
{
    uint32_t U;
    struct _hw_cau_direct15_bitfields
    {
        uint32_t CAU_DIRECT15b : 32;   /*!< [31:0] Direct register 15 */
    } B;
} hw_cau_direct15_t;

/*!
 * @name Constants and macros for entire CAU_DIRECT15 register
 */
/*@{*/
#define HW_CAU_DIRECT15_ADDR(x)  ((x) + 0x3CU)

#define HW_CAU_DIRECT15(x)       (*(__O hw_cau_direct15_t *) HW_CAU_DIRECT15_ADDR(x))
#define HW_CAU_DIRECT15_WR(x, v) (HW_CAU_DIRECT15(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_DIRECT15 bitfields
 */

/*!
 * @name Register CAU_DIRECT15, field CAU_DIRECT15[31:0] (WO)
 */
/*@{*/
#define BP_CAU_DIRECT15_CAU_DIRECT15 (0U)  /*!< Bit position for CAU_DIRECT15_CAU_DIRECT15. */
#define BM_CAU_DIRECT15_CAU_DIRECT15 (0xFFFFFFFFU) /*!< Bit mask for CAU_DIRECT15_CAU_DIRECT15. */
#define BS_CAU_DIRECT15_CAU_DIRECT15 (32U) /*!< Bit field size in bits for CAU_DIRECT15_CAU_DIRECT15. */

/*! @brief Format value for bitfield CAU_DIRECT15_CAU_DIRECT15. */
#define BF_CAU_DIRECT15_CAU_DIRECT15(v) ((uint32_t)((uint32_t)(v) << BP_CAU_DIRECT15_CAU_DIRECT15) & BM_CAU_DIRECT15_CAU_DIRECT15)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CASR - Status register  - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CASR - Status register  - Load Register command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_ldr_casr
{
    uint32_t U;
    struct _hw_cau_ldr_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_ldr_casr_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CASR register
 */
/*@{*/
#define HW_CAU_LDR_CASR_ADDR(x)  ((x) + 0x840U)

#define HW_CAU_LDR_CASR(x)       (*(__O hw_cau_ldr_casr_t *) HW_CAU_LDR_CASR_ADDR(x))
#define HW_CAU_LDR_CASR_WR(x, v) (HW_CAU_LDR_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CASR bitfields
 */

/*!
 * @name Register CAU_LDR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_LDR_CASR_IC   (0U)          /*!< Bit position for CAU_LDR_CASR_IC. */
#define BM_CAU_LDR_CASR_IC   (0x00000001U) /*!< Bit mask for CAU_LDR_CASR_IC. */
#define BS_CAU_LDR_CASR_IC   (1U)          /*!< Bit field size in bits for CAU_LDR_CASR_IC. */

/*! @brief Format value for bitfield CAU_LDR_CASR_IC. */
#define BF_CAU_LDR_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CASR_IC) & BM_CAU_LDR_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_LDR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_LDR_CASR_DPE  (1U)          /*!< Bit position for CAU_LDR_CASR_DPE. */
#define BM_CAU_LDR_CASR_DPE  (0x00000002U) /*!< Bit mask for CAU_LDR_CASR_DPE. */
#define BS_CAU_LDR_CASR_DPE  (1U)          /*!< Bit field size in bits for CAU_LDR_CASR_DPE. */

/*! @brief Format value for bitfield CAU_LDR_CASR_DPE. */
#define BF_CAU_LDR_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CASR_DPE) & BM_CAU_LDR_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_LDR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_LDR_CASR_VER  (28U)         /*!< Bit position for CAU_LDR_CASR_VER. */
#define BM_CAU_LDR_CASR_VER  (0xF0000000U) /*!< Bit mask for CAU_LDR_CASR_VER. */
#define BS_CAU_LDR_CASR_VER  (4U)          /*!< Bit field size in bits for CAU_LDR_CASR_VER. */

/*! @brief Format value for bitfield CAU_LDR_CASR_VER. */
#define BF_CAU_LDR_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CASR_VER) & BM_CAU_LDR_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CAA - Accumulator register - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CAA - Accumulator register - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_caa
{
    uint32_t U;
    struct _hw_cau_ldr_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_ldr_caa_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CAA register
 */
/*@{*/
#define HW_CAU_LDR_CAA_ADDR(x)   ((x) + 0x844U)

#define HW_CAU_LDR_CAA(x)        (*(__O hw_cau_ldr_caa_t *) HW_CAU_LDR_CAA_ADDR(x))
#define HW_CAU_LDR_CAA_WR(x, v)  (HW_CAU_LDR_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CAA bitfields
 */

/*!
 * @name Register CAU_LDR_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CAA_ACC   (0U)          /*!< Bit position for CAU_LDR_CAA_ACC. */
#define BM_CAU_LDR_CAA_ACC   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CAA_ACC. */
#define BS_CAU_LDR_CAA_ACC   (32U)         /*!< Bit field size in bits for CAU_LDR_CAA_ACC. */

/*! @brief Format value for bitfield CAU_LDR_CAA_ACC. */
#define BF_CAU_LDR_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CAA_ACC) & BM_CAU_LDR_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA0 - General Purpose Register 0 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA0 - General Purpose Register 0 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca0
{
    uint32_t U;
    struct _hw_cau_ldr_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_ldr_ca0_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA0 register
 */
/*@{*/
#define HW_CAU_LDR_CA0_ADDR(x)   ((x) + 0x848U)

#define HW_CAU_LDR_CA0(x)        (*(__O hw_cau_ldr_ca0_t *) HW_CAU_LDR_CA0_ADDR(x))
#define HW_CAU_LDR_CA0_WR(x, v)  (HW_CAU_LDR_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA0 bitfields
 */

/*!
 * @name Register CAU_LDR_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA0_CA0   (0U)          /*!< Bit position for CAU_LDR_CA0_CA0. */
#define BM_CAU_LDR_CA0_CA0   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA0_CA0. */
#define BS_CAU_LDR_CA0_CA0   (32U)         /*!< Bit field size in bits for CAU_LDR_CA0_CA0. */

/*! @brief Format value for bitfield CAU_LDR_CA0_CA0. */
#define BF_CAU_LDR_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA0_CA0) & BM_CAU_LDR_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA1 - General Purpose Register 1 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA1 - General Purpose Register 1 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca1
{
    uint32_t U;
    struct _hw_cau_ldr_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_ldr_ca1_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA1 register
 */
/*@{*/
#define HW_CAU_LDR_CA1_ADDR(x)   ((x) + 0x84CU)

#define HW_CAU_LDR_CA1(x)        (*(__O hw_cau_ldr_ca1_t *) HW_CAU_LDR_CA1_ADDR(x))
#define HW_CAU_LDR_CA1_WR(x, v)  (HW_CAU_LDR_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA1 bitfields
 */

/*!
 * @name Register CAU_LDR_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA1_CA1   (0U)          /*!< Bit position for CAU_LDR_CA1_CA1. */
#define BM_CAU_LDR_CA1_CA1   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA1_CA1. */
#define BS_CAU_LDR_CA1_CA1   (32U)         /*!< Bit field size in bits for CAU_LDR_CA1_CA1. */

/*! @brief Format value for bitfield CAU_LDR_CA1_CA1. */
#define BF_CAU_LDR_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA1_CA1) & BM_CAU_LDR_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA2 - General Purpose Register 2 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA2 - General Purpose Register 2 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca2
{
    uint32_t U;
    struct _hw_cau_ldr_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_ldr_ca2_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA2 register
 */
/*@{*/
#define HW_CAU_LDR_CA2_ADDR(x)   ((x) + 0x850U)

#define HW_CAU_LDR_CA2(x)        (*(__O hw_cau_ldr_ca2_t *) HW_CAU_LDR_CA2_ADDR(x))
#define HW_CAU_LDR_CA2_WR(x, v)  (HW_CAU_LDR_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA2 bitfields
 */

/*!
 * @name Register CAU_LDR_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA2_CA2   (0U)          /*!< Bit position for CAU_LDR_CA2_CA2. */
#define BM_CAU_LDR_CA2_CA2   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA2_CA2. */
#define BS_CAU_LDR_CA2_CA2   (32U)         /*!< Bit field size in bits for CAU_LDR_CA2_CA2. */

/*! @brief Format value for bitfield CAU_LDR_CA2_CA2. */
#define BF_CAU_LDR_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA2_CA2) & BM_CAU_LDR_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA3 - General Purpose Register 3 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA3 - General Purpose Register 3 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca3
{
    uint32_t U;
    struct _hw_cau_ldr_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_ldr_ca3_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA3 register
 */
/*@{*/
#define HW_CAU_LDR_CA3_ADDR(x)   ((x) + 0x854U)

#define HW_CAU_LDR_CA3(x)        (*(__O hw_cau_ldr_ca3_t *) HW_CAU_LDR_CA3_ADDR(x))
#define HW_CAU_LDR_CA3_WR(x, v)  (HW_CAU_LDR_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA3 bitfields
 */

/*!
 * @name Register CAU_LDR_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA3_CA3   (0U)          /*!< Bit position for CAU_LDR_CA3_CA3. */
#define BM_CAU_LDR_CA3_CA3   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA3_CA3. */
#define BS_CAU_LDR_CA3_CA3   (32U)         /*!< Bit field size in bits for CAU_LDR_CA3_CA3. */

/*! @brief Format value for bitfield CAU_LDR_CA3_CA3. */
#define BF_CAU_LDR_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA3_CA3) & BM_CAU_LDR_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA4 - General Purpose Register 4 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA4 - General Purpose Register 4 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca4
{
    uint32_t U;
    struct _hw_cau_ldr_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_ldr_ca4_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA4 register
 */
/*@{*/
#define HW_CAU_LDR_CA4_ADDR(x)   ((x) + 0x858U)

#define HW_CAU_LDR_CA4(x)        (*(__O hw_cau_ldr_ca4_t *) HW_CAU_LDR_CA4_ADDR(x))
#define HW_CAU_LDR_CA4_WR(x, v)  (HW_CAU_LDR_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA4 bitfields
 */

/*!
 * @name Register CAU_LDR_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA4_CA4   (0U)          /*!< Bit position for CAU_LDR_CA4_CA4. */
#define BM_CAU_LDR_CA4_CA4   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA4_CA4. */
#define BS_CAU_LDR_CA4_CA4   (32U)         /*!< Bit field size in bits for CAU_LDR_CA4_CA4. */

/*! @brief Format value for bitfield CAU_LDR_CA4_CA4. */
#define BF_CAU_LDR_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA4_CA4) & BM_CAU_LDR_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA5 - General Purpose Register 5 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA5 - General Purpose Register 5 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca5
{
    uint32_t U;
    struct _hw_cau_ldr_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_ldr_ca5_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA5 register
 */
/*@{*/
#define HW_CAU_LDR_CA5_ADDR(x)   ((x) + 0x85CU)

#define HW_CAU_LDR_CA5(x)        (*(__O hw_cau_ldr_ca5_t *) HW_CAU_LDR_CA5_ADDR(x))
#define HW_CAU_LDR_CA5_WR(x, v)  (HW_CAU_LDR_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA5 bitfields
 */

/*!
 * @name Register CAU_LDR_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA5_CA5   (0U)          /*!< Bit position for CAU_LDR_CA5_CA5. */
#define BM_CAU_LDR_CA5_CA5   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA5_CA5. */
#define BS_CAU_LDR_CA5_CA5   (32U)         /*!< Bit field size in bits for CAU_LDR_CA5_CA5. */

/*! @brief Format value for bitfield CAU_LDR_CA5_CA5. */
#define BF_CAU_LDR_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA5_CA5) & BM_CAU_LDR_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA6 - General Purpose Register 6 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA6 - General Purpose Register 6 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca6
{
    uint32_t U;
    struct _hw_cau_ldr_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_ldr_ca6_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA6 register
 */
/*@{*/
#define HW_CAU_LDR_CA6_ADDR(x)   ((x) + 0x860U)

#define HW_CAU_LDR_CA6(x)        (*(__O hw_cau_ldr_ca6_t *) HW_CAU_LDR_CA6_ADDR(x))
#define HW_CAU_LDR_CA6_WR(x, v)  (HW_CAU_LDR_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA6 bitfields
 */

/*!
 * @name Register CAU_LDR_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA6_CA6   (0U)          /*!< Bit position for CAU_LDR_CA6_CA6. */
#define BM_CAU_LDR_CA6_CA6   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA6_CA6. */
#define BS_CAU_LDR_CA6_CA6   (32U)         /*!< Bit field size in bits for CAU_LDR_CA6_CA6. */

/*! @brief Format value for bitfield CAU_LDR_CA6_CA6. */
#define BF_CAU_LDR_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA6_CA6) & BM_CAU_LDR_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA7 - General Purpose Register 7 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA7 - General Purpose Register 7 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca7
{
    uint32_t U;
    struct _hw_cau_ldr_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_ldr_ca7_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA7 register
 */
/*@{*/
#define HW_CAU_LDR_CA7_ADDR(x)   ((x) + 0x864U)

#define HW_CAU_LDR_CA7(x)        (*(__O hw_cau_ldr_ca7_t *) HW_CAU_LDR_CA7_ADDR(x))
#define HW_CAU_LDR_CA7_WR(x, v)  (HW_CAU_LDR_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA7 bitfields
 */

/*!
 * @name Register CAU_LDR_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA7_CA7   (0U)          /*!< Bit position for CAU_LDR_CA7_CA7. */
#define BM_CAU_LDR_CA7_CA7   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA7_CA7. */
#define BS_CAU_LDR_CA7_CA7   (32U)         /*!< Bit field size in bits for CAU_LDR_CA7_CA7. */

/*! @brief Format value for bitfield CAU_LDR_CA7_CA7. */
#define BF_CAU_LDR_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA7_CA7) & BM_CAU_LDR_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_LDR_CA8 - General Purpose Register 8 - Load Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_LDR_CA8 - General Purpose Register 8 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca8
{
    uint32_t U;
    struct _hw_cau_ldr_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_ldr_ca8_t;

/*!
 * @name Constants and macros for entire CAU_LDR_CA8 register
 */
/*@{*/
#define HW_CAU_LDR_CA8_ADDR(x)   ((x) + 0x868U)

#define HW_CAU_LDR_CA8(x)        (*(__O hw_cau_ldr_ca8_t *) HW_CAU_LDR_CA8_ADDR(x))
#define HW_CAU_LDR_CA8_WR(x, v)  (HW_CAU_LDR_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CA8 bitfields
 */

/*!
 * @name Register CAU_LDR_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_LDR_CA8_CA8   (0U)          /*!< Bit position for CAU_LDR_CA8_CA8. */
#define BM_CAU_LDR_CA8_CA8   (0xFFFFFFFFU) /*!< Bit mask for CAU_LDR_CA8_CA8. */
#define BS_CAU_LDR_CA8_CA8   (32U)         /*!< Bit field size in bits for CAU_LDR_CA8_CA8. */

/*! @brief Format value for bitfield CAU_LDR_CA8_CA8. */
#define BF_CAU_LDR_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_LDR_CA8_CA8) & BM_CAU_LDR_CA8_CA8)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CASR - Status register  - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CASR - Status register  - Store Register command (RO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_str_casr
{
    uint32_t U;
    struct _hw_cau_str_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_str_casr_t;

/*!
 * @name Constants and macros for entire CAU_STR_CASR register
 */
/*@{*/
#define HW_CAU_STR_CASR_ADDR(x)  ((x) + 0x880U)

#define HW_CAU_STR_CASR(x)       (*(__I hw_cau_str_casr_t *) HW_CAU_STR_CASR_ADDR(x))
#define HW_CAU_STR_CASR_RD(x)    (HW_CAU_STR_CASR(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CASR bitfields
 */

/*!
 * @name Register CAU_STR_CASR, field IC[0] (RO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_STR_CASR_IC   (0U)          /*!< Bit position for CAU_STR_CASR_IC. */
#define BM_CAU_STR_CASR_IC   (0x00000001U) /*!< Bit mask for CAU_STR_CASR_IC. */
#define BS_CAU_STR_CASR_IC   (1U)          /*!< Bit field size in bits for CAU_STR_CASR_IC. */

/*! @brief Read current value of the CAU_STR_CASR_IC field. */
#define BR_CAU_STR_CASR_IC(x) (HW_CAU_STR_CASR(x).B.IC)
/*@}*/

/*!
 * @name Register CAU_STR_CASR, field DPE[1] (RO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_STR_CASR_DPE  (1U)          /*!< Bit position for CAU_STR_CASR_DPE. */
#define BM_CAU_STR_CASR_DPE  (0x00000002U) /*!< Bit mask for CAU_STR_CASR_DPE. */
#define BS_CAU_STR_CASR_DPE  (1U)          /*!< Bit field size in bits for CAU_STR_CASR_DPE. */

/*! @brief Read current value of the CAU_STR_CASR_DPE field. */
#define BR_CAU_STR_CASR_DPE(x) (HW_CAU_STR_CASR(x).B.DPE)
/*@}*/

/*!
 * @name Register CAU_STR_CASR, field VER[31:28] (RO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_STR_CASR_VER  (28U)         /*!< Bit position for CAU_STR_CASR_VER. */
#define BM_CAU_STR_CASR_VER  (0xF0000000U) /*!< Bit mask for CAU_STR_CASR_VER. */
#define BS_CAU_STR_CASR_VER  (4U)          /*!< Bit field size in bits for CAU_STR_CASR_VER. */

/*! @brief Read current value of the CAU_STR_CASR_VER field. */
#define BR_CAU_STR_CASR_VER(x) (HW_CAU_STR_CASR(x).B.VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CAA - Accumulator register - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CAA - Accumulator register - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_caa
{
    uint32_t U;
    struct _hw_cau_str_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_str_caa_t;

/*!
 * @name Constants and macros for entire CAU_STR_CAA register
 */
/*@{*/
#define HW_CAU_STR_CAA_ADDR(x)   ((x) + 0x884U)

#define HW_CAU_STR_CAA(x)        (*(__I hw_cau_str_caa_t *) HW_CAU_STR_CAA_ADDR(x))
#define HW_CAU_STR_CAA_RD(x)     (HW_CAU_STR_CAA(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CAA bitfields
 */

/*!
 * @name Register CAU_STR_CAA, field ACC[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CAA_ACC   (0U)          /*!< Bit position for CAU_STR_CAA_ACC. */
#define BM_CAU_STR_CAA_ACC   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CAA_ACC. */
#define BS_CAU_STR_CAA_ACC   (32U)         /*!< Bit field size in bits for CAU_STR_CAA_ACC. */

/*! @brief Read current value of the CAU_STR_CAA_ACC field. */
#define BR_CAU_STR_CAA_ACC(x) (HW_CAU_STR_CAA(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA0 - General Purpose Register 0 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA0 - General Purpose Register 0 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca0
{
    uint32_t U;
    struct _hw_cau_str_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_str_ca0_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA0 register
 */
/*@{*/
#define HW_CAU_STR_CA0_ADDR(x)   ((x) + 0x888U)

#define HW_CAU_STR_CA0(x)        (*(__I hw_cau_str_ca0_t *) HW_CAU_STR_CA0_ADDR(x))
#define HW_CAU_STR_CA0_RD(x)     (HW_CAU_STR_CA0(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA0 bitfields
 */

/*!
 * @name Register CAU_STR_CA0, field CA0[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA0_CA0   (0U)          /*!< Bit position for CAU_STR_CA0_CA0. */
#define BM_CAU_STR_CA0_CA0   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA0_CA0. */
#define BS_CAU_STR_CA0_CA0   (32U)         /*!< Bit field size in bits for CAU_STR_CA0_CA0. */

/*! @brief Read current value of the CAU_STR_CA0_CA0 field. */
#define BR_CAU_STR_CA0_CA0(x) (HW_CAU_STR_CA0(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA1 - General Purpose Register 1 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA1 - General Purpose Register 1 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca1
{
    uint32_t U;
    struct _hw_cau_str_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_str_ca1_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA1 register
 */
/*@{*/
#define HW_CAU_STR_CA1_ADDR(x)   ((x) + 0x88CU)

#define HW_CAU_STR_CA1(x)        (*(__I hw_cau_str_ca1_t *) HW_CAU_STR_CA1_ADDR(x))
#define HW_CAU_STR_CA1_RD(x)     (HW_CAU_STR_CA1(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA1 bitfields
 */

/*!
 * @name Register CAU_STR_CA1, field CA1[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA1_CA1   (0U)          /*!< Bit position for CAU_STR_CA1_CA1. */
#define BM_CAU_STR_CA1_CA1   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA1_CA1. */
#define BS_CAU_STR_CA1_CA1   (32U)         /*!< Bit field size in bits for CAU_STR_CA1_CA1. */

/*! @brief Read current value of the CAU_STR_CA1_CA1 field. */
#define BR_CAU_STR_CA1_CA1(x) (HW_CAU_STR_CA1(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA2 - General Purpose Register 2 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA2 - General Purpose Register 2 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca2
{
    uint32_t U;
    struct _hw_cau_str_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_str_ca2_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA2 register
 */
/*@{*/
#define HW_CAU_STR_CA2_ADDR(x)   ((x) + 0x890U)

#define HW_CAU_STR_CA2(x)        (*(__I hw_cau_str_ca2_t *) HW_CAU_STR_CA2_ADDR(x))
#define HW_CAU_STR_CA2_RD(x)     (HW_CAU_STR_CA2(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA2 bitfields
 */

/*!
 * @name Register CAU_STR_CA2, field CA2[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA2_CA2   (0U)          /*!< Bit position for CAU_STR_CA2_CA2. */
#define BM_CAU_STR_CA2_CA2   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA2_CA2. */
#define BS_CAU_STR_CA2_CA2   (32U)         /*!< Bit field size in bits for CAU_STR_CA2_CA2. */

/*! @brief Read current value of the CAU_STR_CA2_CA2 field. */
#define BR_CAU_STR_CA2_CA2(x) (HW_CAU_STR_CA2(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA3 - General Purpose Register 3 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA3 - General Purpose Register 3 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca3
{
    uint32_t U;
    struct _hw_cau_str_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_str_ca3_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA3 register
 */
/*@{*/
#define HW_CAU_STR_CA3_ADDR(x)   ((x) + 0x894U)

#define HW_CAU_STR_CA3(x)        (*(__I hw_cau_str_ca3_t *) HW_CAU_STR_CA3_ADDR(x))
#define HW_CAU_STR_CA3_RD(x)     (HW_CAU_STR_CA3(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA3 bitfields
 */

/*!
 * @name Register CAU_STR_CA3, field CA3[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA3_CA3   (0U)          /*!< Bit position for CAU_STR_CA3_CA3. */
#define BM_CAU_STR_CA3_CA3   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA3_CA3. */
#define BS_CAU_STR_CA3_CA3   (32U)         /*!< Bit field size in bits for CAU_STR_CA3_CA3. */

/*! @brief Read current value of the CAU_STR_CA3_CA3 field. */
#define BR_CAU_STR_CA3_CA3(x) (HW_CAU_STR_CA3(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA4 - General Purpose Register 4 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA4 - General Purpose Register 4 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca4
{
    uint32_t U;
    struct _hw_cau_str_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_str_ca4_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA4 register
 */
/*@{*/
#define HW_CAU_STR_CA4_ADDR(x)   ((x) + 0x898U)

#define HW_CAU_STR_CA4(x)        (*(__I hw_cau_str_ca4_t *) HW_CAU_STR_CA4_ADDR(x))
#define HW_CAU_STR_CA4_RD(x)     (HW_CAU_STR_CA4(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA4 bitfields
 */

/*!
 * @name Register CAU_STR_CA4, field CA4[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA4_CA4   (0U)          /*!< Bit position for CAU_STR_CA4_CA4. */
#define BM_CAU_STR_CA4_CA4   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA4_CA4. */
#define BS_CAU_STR_CA4_CA4   (32U)         /*!< Bit field size in bits for CAU_STR_CA4_CA4. */

/*! @brief Read current value of the CAU_STR_CA4_CA4 field. */
#define BR_CAU_STR_CA4_CA4(x) (HW_CAU_STR_CA4(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA5 - General Purpose Register 5 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA5 - General Purpose Register 5 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca5
{
    uint32_t U;
    struct _hw_cau_str_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_str_ca5_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA5 register
 */
/*@{*/
#define HW_CAU_STR_CA5_ADDR(x)   ((x) + 0x89CU)

#define HW_CAU_STR_CA5(x)        (*(__I hw_cau_str_ca5_t *) HW_CAU_STR_CA5_ADDR(x))
#define HW_CAU_STR_CA5_RD(x)     (HW_CAU_STR_CA5(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA5 bitfields
 */

/*!
 * @name Register CAU_STR_CA5, field CA5[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA5_CA5   (0U)          /*!< Bit position for CAU_STR_CA5_CA5. */
#define BM_CAU_STR_CA5_CA5   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA5_CA5. */
#define BS_CAU_STR_CA5_CA5   (32U)         /*!< Bit field size in bits for CAU_STR_CA5_CA5. */

/*! @brief Read current value of the CAU_STR_CA5_CA5 field. */
#define BR_CAU_STR_CA5_CA5(x) (HW_CAU_STR_CA5(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA6 - General Purpose Register 6 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA6 - General Purpose Register 6 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca6
{
    uint32_t U;
    struct _hw_cau_str_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_str_ca6_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA6 register
 */
/*@{*/
#define HW_CAU_STR_CA6_ADDR(x)   ((x) + 0x8A0U)

#define HW_CAU_STR_CA6(x)        (*(__I hw_cau_str_ca6_t *) HW_CAU_STR_CA6_ADDR(x))
#define HW_CAU_STR_CA6_RD(x)     (HW_CAU_STR_CA6(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA6 bitfields
 */

/*!
 * @name Register CAU_STR_CA6, field CA6[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA6_CA6   (0U)          /*!< Bit position for CAU_STR_CA6_CA6. */
#define BM_CAU_STR_CA6_CA6   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA6_CA6. */
#define BS_CAU_STR_CA6_CA6   (32U)         /*!< Bit field size in bits for CAU_STR_CA6_CA6. */

/*! @brief Read current value of the CAU_STR_CA6_CA6 field. */
#define BR_CAU_STR_CA6_CA6(x) (HW_CAU_STR_CA6(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA7 - General Purpose Register 7 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA7 - General Purpose Register 7 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca7
{
    uint32_t U;
    struct _hw_cau_str_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_str_ca7_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA7 register
 */
/*@{*/
#define HW_CAU_STR_CA7_ADDR(x)   ((x) + 0x8A4U)

#define HW_CAU_STR_CA7(x)        (*(__I hw_cau_str_ca7_t *) HW_CAU_STR_CA7_ADDR(x))
#define HW_CAU_STR_CA7_RD(x)     (HW_CAU_STR_CA7(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA7 bitfields
 */

/*!
 * @name Register CAU_STR_CA7, field CA7[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA7_CA7   (0U)          /*!< Bit position for CAU_STR_CA7_CA7. */
#define BM_CAU_STR_CA7_CA7   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA7_CA7. */
#define BS_CAU_STR_CA7_CA7   (32U)         /*!< Bit field size in bits for CAU_STR_CA7_CA7. */

/*! @brief Read current value of the CAU_STR_CA7_CA7 field. */
#define BR_CAU_STR_CA7_CA7(x) (HW_CAU_STR_CA7(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_STR_CA8 - General Purpose Register 8 - Store Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_STR_CA8 - General Purpose Register 8 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca8
{
    uint32_t U;
    struct _hw_cau_str_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_str_ca8_t;

/*!
 * @name Constants and macros for entire CAU_STR_CA8 register
 */
/*@{*/
#define HW_CAU_STR_CA8_ADDR(x)   ((x) + 0x8A8U)

#define HW_CAU_STR_CA8(x)        (*(__I hw_cau_str_ca8_t *) HW_CAU_STR_CA8_ADDR(x))
#define HW_CAU_STR_CA8_RD(x)     (HW_CAU_STR_CA8(x).U)
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CA8 bitfields
 */

/*!
 * @name Register CAU_STR_CA8, field CA8[31:0] (RO)
 */
/*@{*/
#define BP_CAU_STR_CA8_CA8   (0U)          /*!< Bit position for CAU_STR_CA8_CA8. */
#define BM_CAU_STR_CA8_CA8   (0xFFFFFFFFU) /*!< Bit mask for CAU_STR_CA8_CA8. */
#define BS_CAU_STR_CA8_CA8   (32U)         /*!< Bit field size in bits for CAU_STR_CA8_CA8. */

/*! @brief Read current value of the CAU_STR_CA8_CA8 field. */
#define BR_CAU_STR_CA8_CA8(x) (HW_CAU_STR_CA8(x).U)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CASR - Status register  - Add Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CASR - Status register  - Add Register command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_adr_casr
{
    uint32_t U;
    struct _hw_cau_adr_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_adr_casr_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CASR register
 */
/*@{*/
#define HW_CAU_ADR_CASR_ADDR(x)  ((x) + 0x8C0U)

#define HW_CAU_ADR_CASR(x)       (*(__O hw_cau_adr_casr_t *) HW_CAU_ADR_CASR_ADDR(x))
#define HW_CAU_ADR_CASR_WR(x, v) (HW_CAU_ADR_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CASR bitfields
 */

/*!
 * @name Register CAU_ADR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_ADR_CASR_IC   (0U)          /*!< Bit position for CAU_ADR_CASR_IC. */
#define BM_CAU_ADR_CASR_IC   (0x00000001U) /*!< Bit mask for CAU_ADR_CASR_IC. */
#define BS_CAU_ADR_CASR_IC   (1U)          /*!< Bit field size in bits for CAU_ADR_CASR_IC. */

/*! @brief Format value for bitfield CAU_ADR_CASR_IC. */
#define BF_CAU_ADR_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CASR_IC) & BM_CAU_ADR_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_ADR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_ADR_CASR_DPE  (1U)          /*!< Bit position for CAU_ADR_CASR_DPE. */
#define BM_CAU_ADR_CASR_DPE  (0x00000002U) /*!< Bit mask for CAU_ADR_CASR_DPE. */
#define BS_CAU_ADR_CASR_DPE  (1U)          /*!< Bit field size in bits for CAU_ADR_CASR_DPE. */

/*! @brief Format value for bitfield CAU_ADR_CASR_DPE. */
#define BF_CAU_ADR_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CASR_DPE) & BM_CAU_ADR_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_ADR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_ADR_CASR_VER  (28U)         /*!< Bit position for CAU_ADR_CASR_VER. */
#define BM_CAU_ADR_CASR_VER  (0xF0000000U) /*!< Bit mask for CAU_ADR_CASR_VER. */
#define BS_CAU_ADR_CASR_VER  (4U)          /*!< Bit field size in bits for CAU_ADR_CASR_VER. */

/*! @brief Format value for bitfield CAU_ADR_CASR_VER. */
#define BF_CAU_ADR_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CASR_VER) & BM_CAU_ADR_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CAA - Accumulator register - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CAA - Accumulator register - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_caa
{
    uint32_t U;
    struct _hw_cau_adr_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_adr_caa_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CAA register
 */
/*@{*/
#define HW_CAU_ADR_CAA_ADDR(x)   ((x) + 0x8C4U)

#define HW_CAU_ADR_CAA(x)        (*(__O hw_cau_adr_caa_t *) HW_CAU_ADR_CAA_ADDR(x))
#define HW_CAU_ADR_CAA_WR(x, v)  (HW_CAU_ADR_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CAA bitfields
 */

/*!
 * @name Register CAU_ADR_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CAA_ACC   (0U)          /*!< Bit position for CAU_ADR_CAA_ACC. */
#define BM_CAU_ADR_CAA_ACC   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CAA_ACC. */
#define BS_CAU_ADR_CAA_ACC   (32U)         /*!< Bit field size in bits for CAU_ADR_CAA_ACC. */

/*! @brief Format value for bitfield CAU_ADR_CAA_ACC. */
#define BF_CAU_ADR_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CAA_ACC) & BM_CAU_ADR_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA0 - General Purpose Register 0 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA0 - General Purpose Register 0 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca0
{
    uint32_t U;
    struct _hw_cau_adr_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_adr_ca0_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA0 register
 */
/*@{*/
#define HW_CAU_ADR_CA0_ADDR(x)   ((x) + 0x8C8U)

#define HW_CAU_ADR_CA0(x)        (*(__O hw_cau_adr_ca0_t *) HW_CAU_ADR_CA0_ADDR(x))
#define HW_CAU_ADR_CA0_WR(x, v)  (HW_CAU_ADR_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA0 bitfields
 */

/*!
 * @name Register CAU_ADR_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA0_CA0   (0U)          /*!< Bit position for CAU_ADR_CA0_CA0. */
#define BM_CAU_ADR_CA0_CA0   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA0_CA0. */
#define BS_CAU_ADR_CA0_CA0   (32U)         /*!< Bit field size in bits for CAU_ADR_CA0_CA0. */

/*! @brief Format value for bitfield CAU_ADR_CA0_CA0. */
#define BF_CAU_ADR_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA0_CA0) & BM_CAU_ADR_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA1 - General Purpose Register 1 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA1 - General Purpose Register 1 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca1
{
    uint32_t U;
    struct _hw_cau_adr_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_adr_ca1_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA1 register
 */
/*@{*/
#define HW_CAU_ADR_CA1_ADDR(x)   ((x) + 0x8CCU)

#define HW_CAU_ADR_CA1(x)        (*(__O hw_cau_adr_ca1_t *) HW_CAU_ADR_CA1_ADDR(x))
#define HW_CAU_ADR_CA1_WR(x, v)  (HW_CAU_ADR_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA1 bitfields
 */

/*!
 * @name Register CAU_ADR_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA1_CA1   (0U)          /*!< Bit position for CAU_ADR_CA1_CA1. */
#define BM_CAU_ADR_CA1_CA1   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA1_CA1. */
#define BS_CAU_ADR_CA1_CA1   (32U)         /*!< Bit field size in bits for CAU_ADR_CA1_CA1. */

/*! @brief Format value for bitfield CAU_ADR_CA1_CA1. */
#define BF_CAU_ADR_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA1_CA1) & BM_CAU_ADR_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA2 - General Purpose Register 2 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA2 - General Purpose Register 2 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca2
{
    uint32_t U;
    struct _hw_cau_adr_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_adr_ca2_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA2 register
 */
/*@{*/
#define HW_CAU_ADR_CA2_ADDR(x)   ((x) + 0x8D0U)

#define HW_CAU_ADR_CA2(x)        (*(__O hw_cau_adr_ca2_t *) HW_CAU_ADR_CA2_ADDR(x))
#define HW_CAU_ADR_CA2_WR(x, v)  (HW_CAU_ADR_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA2 bitfields
 */

/*!
 * @name Register CAU_ADR_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA2_CA2   (0U)          /*!< Bit position for CAU_ADR_CA2_CA2. */
#define BM_CAU_ADR_CA2_CA2   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA2_CA2. */
#define BS_CAU_ADR_CA2_CA2   (32U)         /*!< Bit field size in bits for CAU_ADR_CA2_CA2. */

/*! @brief Format value for bitfield CAU_ADR_CA2_CA2. */
#define BF_CAU_ADR_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA2_CA2) & BM_CAU_ADR_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA3 - General Purpose Register 3 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA3 - General Purpose Register 3 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca3
{
    uint32_t U;
    struct _hw_cau_adr_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_adr_ca3_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA3 register
 */
/*@{*/
#define HW_CAU_ADR_CA3_ADDR(x)   ((x) + 0x8D4U)

#define HW_CAU_ADR_CA3(x)        (*(__O hw_cau_adr_ca3_t *) HW_CAU_ADR_CA3_ADDR(x))
#define HW_CAU_ADR_CA3_WR(x, v)  (HW_CAU_ADR_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA3 bitfields
 */

/*!
 * @name Register CAU_ADR_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA3_CA3   (0U)          /*!< Bit position for CAU_ADR_CA3_CA3. */
#define BM_CAU_ADR_CA3_CA3   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA3_CA3. */
#define BS_CAU_ADR_CA3_CA3   (32U)         /*!< Bit field size in bits for CAU_ADR_CA3_CA3. */

/*! @brief Format value for bitfield CAU_ADR_CA3_CA3. */
#define BF_CAU_ADR_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA3_CA3) & BM_CAU_ADR_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA4 - General Purpose Register 4 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA4 - General Purpose Register 4 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca4
{
    uint32_t U;
    struct _hw_cau_adr_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_adr_ca4_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA4 register
 */
/*@{*/
#define HW_CAU_ADR_CA4_ADDR(x)   ((x) + 0x8D8U)

#define HW_CAU_ADR_CA4(x)        (*(__O hw_cau_adr_ca4_t *) HW_CAU_ADR_CA4_ADDR(x))
#define HW_CAU_ADR_CA4_WR(x, v)  (HW_CAU_ADR_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA4 bitfields
 */

/*!
 * @name Register CAU_ADR_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA4_CA4   (0U)          /*!< Bit position for CAU_ADR_CA4_CA4. */
#define BM_CAU_ADR_CA4_CA4   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA4_CA4. */
#define BS_CAU_ADR_CA4_CA4   (32U)         /*!< Bit field size in bits for CAU_ADR_CA4_CA4. */

/*! @brief Format value for bitfield CAU_ADR_CA4_CA4. */
#define BF_CAU_ADR_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA4_CA4) & BM_CAU_ADR_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA5 - General Purpose Register 5 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA5 - General Purpose Register 5 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca5
{
    uint32_t U;
    struct _hw_cau_adr_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_adr_ca5_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA5 register
 */
/*@{*/
#define HW_CAU_ADR_CA5_ADDR(x)   ((x) + 0x8DCU)

#define HW_CAU_ADR_CA5(x)        (*(__O hw_cau_adr_ca5_t *) HW_CAU_ADR_CA5_ADDR(x))
#define HW_CAU_ADR_CA5_WR(x, v)  (HW_CAU_ADR_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA5 bitfields
 */

/*!
 * @name Register CAU_ADR_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA5_CA5   (0U)          /*!< Bit position for CAU_ADR_CA5_CA5. */
#define BM_CAU_ADR_CA5_CA5   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA5_CA5. */
#define BS_CAU_ADR_CA5_CA5   (32U)         /*!< Bit field size in bits for CAU_ADR_CA5_CA5. */

/*! @brief Format value for bitfield CAU_ADR_CA5_CA5. */
#define BF_CAU_ADR_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA5_CA5) & BM_CAU_ADR_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA6 - General Purpose Register 6 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA6 - General Purpose Register 6 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca6
{
    uint32_t U;
    struct _hw_cau_adr_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_adr_ca6_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA6 register
 */
/*@{*/
#define HW_CAU_ADR_CA6_ADDR(x)   ((x) + 0x8E0U)

#define HW_CAU_ADR_CA6(x)        (*(__O hw_cau_adr_ca6_t *) HW_CAU_ADR_CA6_ADDR(x))
#define HW_CAU_ADR_CA6_WR(x, v)  (HW_CAU_ADR_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA6 bitfields
 */

/*!
 * @name Register CAU_ADR_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA6_CA6   (0U)          /*!< Bit position for CAU_ADR_CA6_CA6. */
#define BM_CAU_ADR_CA6_CA6   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA6_CA6. */
#define BS_CAU_ADR_CA6_CA6   (32U)         /*!< Bit field size in bits for CAU_ADR_CA6_CA6. */

/*! @brief Format value for bitfield CAU_ADR_CA6_CA6. */
#define BF_CAU_ADR_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA6_CA6) & BM_CAU_ADR_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA7 - General Purpose Register 7 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA7 - General Purpose Register 7 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca7
{
    uint32_t U;
    struct _hw_cau_adr_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_adr_ca7_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA7 register
 */
/*@{*/
#define HW_CAU_ADR_CA7_ADDR(x)   ((x) + 0x8E4U)

#define HW_CAU_ADR_CA7(x)        (*(__O hw_cau_adr_ca7_t *) HW_CAU_ADR_CA7_ADDR(x))
#define HW_CAU_ADR_CA7_WR(x, v)  (HW_CAU_ADR_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA7 bitfields
 */

/*!
 * @name Register CAU_ADR_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA7_CA7   (0U)          /*!< Bit position for CAU_ADR_CA7_CA7. */
#define BM_CAU_ADR_CA7_CA7   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA7_CA7. */
#define BS_CAU_ADR_CA7_CA7   (32U)         /*!< Bit field size in bits for CAU_ADR_CA7_CA7. */

/*! @brief Format value for bitfield CAU_ADR_CA7_CA7. */
#define BF_CAU_ADR_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA7_CA7) & BM_CAU_ADR_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_ADR_CA8 - General Purpose Register 8 - Add to register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ADR_CA8 - General Purpose Register 8 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca8
{
    uint32_t U;
    struct _hw_cau_adr_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_adr_ca8_t;

/*!
 * @name Constants and macros for entire CAU_ADR_CA8 register
 */
/*@{*/
#define HW_CAU_ADR_CA8_ADDR(x)   ((x) + 0x8E8U)

#define HW_CAU_ADR_CA8(x)        (*(__O hw_cau_adr_ca8_t *) HW_CAU_ADR_CA8_ADDR(x))
#define HW_CAU_ADR_CA8_WR(x, v)  (HW_CAU_ADR_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CA8 bitfields
 */

/*!
 * @name Register CAU_ADR_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ADR_CA8_CA8   (0U)          /*!< Bit position for CAU_ADR_CA8_CA8. */
#define BM_CAU_ADR_CA8_CA8   (0xFFFFFFFFU) /*!< Bit mask for CAU_ADR_CA8_CA8. */
#define BS_CAU_ADR_CA8_CA8   (32U)         /*!< Bit field size in bits for CAU_ADR_CA8_CA8. */

/*! @brief Format value for bitfield CAU_ADR_CA8_CA8. */
#define BF_CAU_ADR_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ADR_CA8_CA8) & BM_CAU_ADR_CA8_CA8)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CASR - Status register  - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CASR - Status register  - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_radr_casr
{
    uint32_t U;
    struct _hw_cau_radr_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_radr_casr_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CASR register
 */
/*@{*/
#define HW_CAU_RADR_CASR_ADDR(x) ((x) + 0x900U)

#define HW_CAU_RADR_CASR(x)      (*(__O hw_cau_radr_casr_t *) HW_CAU_RADR_CASR_ADDR(x))
#define HW_CAU_RADR_CASR_WR(x, v) (HW_CAU_RADR_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CASR bitfields
 */

/*!
 * @name Register CAU_RADR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_RADR_CASR_IC  (0U)          /*!< Bit position for CAU_RADR_CASR_IC. */
#define BM_CAU_RADR_CASR_IC  (0x00000001U) /*!< Bit mask for CAU_RADR_CASR_IC. */
#define BS_CAU_RADR_CASR_IC  (1U)          /*!< Bit field size in bits for CAU_RADR_CASR_IC. */

/*! @brief Format value for bitfield CAU_RADR_CASR_IC. */
#define BF_CAU_RADR_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CASR_IC) & BM_CAU_RADR_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_RADR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_RADR_CASR_DPE (1U)          /*!< Bit position for CAU_RADR_CASR_DPE. */
#define BM_CAU_RADR_CASR_DPE (0x00000002U) /*!< Bit mask for CAU_RADR_CASR_DPE. */
#define BS_CAU_RADR_CASR_DPE (1U)          /*!< Bit field size in bits for CAU_RADR_CASR_DPE. */

/*! @brief Format value for bitfield CAU_RADR_CASR_DPE. */
#define BF_CAU_RADR_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CASR_DPE) & BM_CAU_RADR_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_RADR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_RADR_CASR_VER (28U)         /*!< Bit position for CAU_RADR_CASR_VER. */
#define BM_CAU_RADR_CASR_VER (0xF0000000U) /*!< Bit mask for CAU_RADR_CASR_VER. */
#define BS_CAU_RADR_CASR_VER (4U)          /*!< Bit field size in bits for CAU_RADR_CASR_VER. */

/*! @brief Format value for bitfield CAU_RADR_CASR_VER. */
#define BF_CAU_RADR_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CASR_VER) & BM_CAU_RADR_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_caa
{
    uint32_t U;
    struct _hw_cau_radr_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_radr_caa_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CAA register
 */
/*@{*/
#define HW_CAU_RADR_CAA_ADDR(x)  ((x) + 0x904U)

#define HW_CAU_RADR_CAA(x)       (*(__O hw_cau_radr_caa_t *) HW_CAU_RADR_CAA_ADDR(x))
#define HW_CAU_RADR_CAA_WR(x, v) (HW_CAU_RADR_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CAA bitfields
 */

/*!
 * @name Register CAU_RADR_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CAA_ACC  (0U)          /*!< Bit position for CAU_RADR_CAA_ACC. */
#define BM_CAU_RADR_CAA_ACC  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CAA_ACC. */
#define BS_CAU_RADR_CAA_ACC  (32U)         /*!< Bit field size in bits for CAU_RADR_CAA_ACC. */

/*! @brief Format value for bitfield CAU_RADR_CAA_ACC. */
#define BF_CAU_RADR_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CAA_ACC) & BM_CAU_RADR_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA0 - General Purpose Register 0 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA0 - General Purpose Register 0 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca0
{
    uint32_t U;
    struct _hw_cau_radr_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_radr_ca0_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA0 register
 */
/*@{*/
#define HW_CAU_RADR_CA0_ADDR(x)  ((x) + 0x908U)

#define HW_CAU_RADR_CA0(x)       (*(__O hw_cau_radr_ca0_t *) HW_CAU_RADR_CA0_ADDR(x))
#define HW_CAU_RADR_CA0_WR(x, v) (HW_CAU_RADR_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA0 bitfields
 */

/*!
 * @name Register CAU_RADR_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA0_CA0  (0U)          /*!< Bit position for CAU_RADR_CA0_CA0. */
#define BM_CAU_RADR_CA0_CA0  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA0_CA0. */
#define BS_CAU_RADR_CA0_CA0  (32U)         /*!< Bit field size in bits for CAU_RADR_CA0_CA0. */

/*! @brief Format value for bitfield CAU_RADR_CA0_CA0. */
#define BF_CAU_RADR_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA0_CA0) & BM_CAU_RADR_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA1 - General Purpose Register 1 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA1 - General Purpose Register 1 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca1
{
    uint32_t U;
    struct _hw_cau_radr_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_radr_ca1_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA1 register
 */
/*@{*/
#define HW_CAU_RADR_CA1_ADDR(x)  ((x) + 0x90CU)

#define HW_CAU_RADR_CA1(x)       (*(__O hw_cau_radr_ca1_t *) HW_CAU_RADR_CA1_ADDR(x))
#define HW_CAU_RADR_CA1_WR(x, v) (HW_CAU_RADR_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA1 bitfields
 */

/*!
 * @name Register CAU_RADR_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA1_CA1  (0U)          /*!< Bit position for CAU_RADR_CA1_CA1. */
#define BM_CAU_RADR_CA1_CA1  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA1_CA1. */
#define BS_CAU_RADR_CA1_CA1  (32U)         /*!< Bit field size in bits for CAU_RADR_CA1_CA1. */

/*! @brief Format value for bitfield CAU_RADR_CA1_CA1. */
#define BF_CAU_RADR_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA1_CA1) & BM_CAU_RADR_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA2 - General Purpose Register 2 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA2 - General Purpose Register 2 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca2
{
    uint32_t U;
    struct _hw_cau_radr_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_radr_ca2_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA2 register
 */
/*@{*/
#define HW_CAU_RADR_CA2_ADDR(x)  ((x) + 0x910U)

#define HW_CAU_RADR_CA2(x)       (*(__O hw_cau_radr_ca2_t *) HW_CAU_RADR_CA2_ADDR(x))
#define HW_CAU_RADR_CA2_WR(x, v) (HW_CAU_RADR_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA2 bitfields
 */

/*!
 * @name Register CAU_RADR_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA2_CA2  (0U)          /*!< Bit position for CAU_RADR_CA2_CA2. */
#define BM_CAU_RADR_CA2_CA2  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA2_CA2. */
#define BS_CAU_RADR_CA2_CA2  (32U)         /*!< Bit field size in bits for CAU_RADR_CA2_CA2. */

/*! @brief Format value for bitfield CAU_RADR_CA2_CA2. */
#define BF_CAU_RADR_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA2_CA2) & BM_CAU_RADR_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA3 - General Purpose Register 3 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA3 - General Purpose Register 3 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca3
{
    uint32_t U;
    struct _hw_cau_radr_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_radr_ca3_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA3 register
 */
/*@{*/
#define HW_CAU_RADR_CA3_ADDR(x)  ((x) + 0x914U)

#define HW_CAU_RADR_CA3(x)       (*(__O hw_cau_radr_ca3_t *) HW_CAU_RADR_CA3_ADDR(x))
#define HW_CAU_RADR_CA3_WR(x, v) (HW_CAU_RADR_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA3 bitfields
 */

/*!
 * @name Register CAU_RADR_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA3_CA3  (0U)          /*!< Bit position for CAU_RADR_CA3_CA3. */
#define BM_CAU_RADR_CA3_CA3  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA3_CA3. */
#define BS_CAU_RADR_CA3_CA3  (32U)         /*!< Bit field size in bits for CAU_RADR_CA3_CA3. */

/*! @brief Format value for bitfield CAU_RADR_CA3_CA3. */
#define BF_CAU_RADR_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA3_CA3) & BM_CAU_RADR_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA4 - General Purpose Register 4 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA4 - General Purpose Register 4 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca4
{
    uint32_t U;
    struct _hw_cau_radr_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_radr_ca4_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA4 register
 */
/*@{*/
#define HW_CAU_RADR_CA4_ADDR(x)  ((x) + 0x918U)

#define HW_CAU_RADR_CA4(x)       (*(__O hw_cau_radr_ca4_t *) HW_CAU_RADR_CA4_ADDR(x))
#define HW_CAU_RADR_CA4_WR(x, v) (HW_CAU_RADR_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA4 bitfields
 */

/*!
 * @name Register CAU_RADR_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA4_CA4  (0U)          /*!< Bit position for CAU_RADR_CA4_CA4. */
#define BM_CAU_RADR_CA4_CA4  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA4_CA4. */
#define BS_CAU_RADR_CA4_CA4  (32U)         /*!< Bit field size in bits for CAU_RADR_CA4_CA4. */

/*! @brief Format value for bitfield CAU_RADR_CA4_CA4. */
#define BF_CAU_RADR_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA4_CA4) & BM_CAU_RADR_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA5 - General Purpose Register 5 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA5 - General Purpose Register 5 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca5
{
    uint32_t U;
    struct _hw_cau_radr_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_radr_ca5_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA5 register
 */
/*@{*/
#define HW_CAU_RADR_CA5_ADDR(x)  ((x) + 0x91CU)

#define HW_CAU_RADR_CA5(x)       (*(__O hw_cau_radr_ca5_t *) HW_CAU_RADR_CA5_ADDR(x))
#define HW_CAU_RADR_CA5_WR(x, v) (HW_CAU_RADR_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA5 bitfields
 */

/*!
 * @name Register CAU_RADR_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA5_CA5  (0U)          /*!< Bit position for CAU_RADR_CA5_CA5. */
#define BM_CAU_RADR_CA5_CA5  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA5_CA5. */
#define BS_CAU_RADR_CA5_CA5  (32U)         /*!< Bit field size in bits for CAU_RADR_CA5_CA5. */

/*! @brief Format value for bitfield CAU_RADR_CA5_CA5. */
#define BF_CAU_RADR_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA5_CA5) & BM_CAU_RADR_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA6 - General Purpose Register 6 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA6 - General Purpose Register 6 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca6
{
    uint32_t U;
    struct _hw_cau_radr_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_radr_ca6_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA6 register
 */
/*@{*/
#define HW_CAU_RADR_CA6_ADDR(x)  ((x) + 0x920U)

#define HW_CAU_RADR_CA6(x)       (*(__O hw_cau_radr_ca6_t *) HW_CAU_RADR_CA6_ADDR(x))
#define HW_CAU_RADR_CA6_WR(x, v) (HW_CAU_RADR_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA6 bitfields
 */

/*!
 * @name Register CAU_RADR_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA6_CA6  (0U)          /*!< Bit position for CAU_RADR_CA6_CA6. */
#define BM_CAU_RADR_CA6_CA6  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA6_CA6. */
#define BS_CAU_RADR_CA6_CA6  (32U)         /*!< Bit field size in bits for CAU_RADR_CA6_CA6. */

/*! @brief Format value for bitfield CAU_RADR_CA6_CA6. */
#define BF_CAU_RADR_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA6_CA6) & BM_CAU_RADR_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA7 - General Purpose Register 7 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA7 - General Purpose Register 7 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca7
{
    uint32_t U;
    struct _hw_cau_radr_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_radr_ca7_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA7 register
 */
/*@{*/
#define HW_CAU_RADR_CA7_ADDR(x)  ((x) + 0x924U)

#define HW_CAU_RADR_CA7(x)       (*(__O hw_cau_radr_ca7_t *) HW_CAU_RADR_CA7_ADDR(x))
#define HW_CAU_RADR_CA7_WR(x, v) (HW_CAU_RADR_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA7 bitfields
 */

/*!
 * @name Register CAU_RADR_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA7_CA7  (0U)          /*!< Bit position for CAU_RADR_CA7_CA7. */
#define BM_CAU_RADR_CA7_CA7  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA7_CA7. */
#define BS_CAU_RADR_CA7_CA7  (32U)         /*!< Bit field size in bits for CAU_RADR_CA7_CA7. */

/*! @brief Format value for bitfield CAU_RADR_CA7_CA7. */
#define BF_CAU_RADR_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA7_CA7) & BM_CAU_RADR_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_RADR_CA8 - General Purpose Register 8 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief HW_CAU_RADR_CA8 - General Purpose Register 8 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca8
{
    uint32_t U;
    struct _hw_cau_radr_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_radr_ca8_t;

/*!
 * @name Constants and macros for entire CAU_RADR_CA8 register
 */
/*@{*/
#define HW_CAU_RADR_CA8_ADDR(x)  ((x) + 0x928U)

#define HW_CAU_RADR_CA8(x)       (*(__O hw_cau_radr_ca8_t *) HW_CAU_RADR_CA8_ADDR(x))
#define HW_CAU_RADR_CA8_WR(x, v) (HW_CAU_RADR_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CA8 bitfields
 */

/*!
 * @name Register CAU_RADR_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_RADR_CA8_CA8  (0U)          /*!< Bit position for CAU_RADR_CA8_CA8. */
#define BM_CAU_RADR_CA8_CA8  (0xFFFFFFFFU) /*!< Bit mask for CAU_RADR_CA8_CA8. */
#define BS_CAU_RADR_CA8_CA8  (32U)         /*!< Bit field size in bits for CAU_RADR_CA8_CA8. */

/*! @brief Format value for bitfield CAU_RADR_CA8_CA8. */
#define BF_CAU_RADR_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_RADR_CA8_CA8) & BM_CAU_RADR_CA8_CA8)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CASR - Status register  - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CASR - Status register  - Exclusive Or command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_xor_casr
{
    uint32_t U;
    struct _hw_cau_xor_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_xor_casr_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CASR register
 */
/*@{*/
#define HW_CAU_XOR_CASR_ADDR(x)  ((x) + 0x980U)

#define HW_CAU_XOR_CASR(x)       (*(__O hw_cau_xor_casr_t *) HW_CAU_XOR_CASR_ADDR(x))
#define HW_CAU_XOR_CASR_WR(x, v) (HW_CAU_XOR_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CASR bitfields
 */

/*!
 * @name Register CAU_XOR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_XOR_CASR_IC   (0U)          /*!< Bit position for CAU_XOR_CASR_IC. */
#define BM_CAU_XOR_CASR_IC   (0x00000001U) /*!< Bit mask for CAU_XOR_CASR_IC. */
#define BS_CAU_XOR_CASR_IC   (1U)          /*!< Bit field size in bits for CAU_XOR_CASR_IC. */

/*! @brief Format value for bitfield CAU_XOR_CASR_IC. */
#define BF_CAU_XOR_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CASR_IC) & BM_CAU_XOR_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_XOR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_XOR_CASR_DPE  (1U)          /*!< Bit position for CAU_XOR_CASR_DPE. */
#define BM_CAU_XOR_CASR_DPE  (0x00000002U) /*!< Bit mask for CAU_XOR_CASR_DPE. */
#define BS_CAU_XOR_CASR_DPE  (1U)          /*!< Bit field size in bits for CAU_XOR_CASR_DPE. */

/*! @brief Format value for bitfield CAU_XOR_CASR_DPE. */
#define BF_CAU_XOR_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CASR_DPE) & BM_CAU_XOR_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_XOR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_XOR_CASR_VER  (28U)         /*!< Bit position for CAU_XOR_CASR_VER. */
#define BM_CAU_XOR_CASR_VER  (0xF0000000U) /*!< Bit mask for CAU_XOR_CASR_VER. */
#define BS_CAU_XOR_CASR_VER  (4U)          /*!< Bit field size in bits for CAU_XOR_CASR_VER. */

/*! @brief Format value for bitfield CAU_XOR_CASR_VER. */
#define BF_CAU_XOR_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CASR_VER) & BM_CAU_XOR_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CAA - Accumulator register - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CAA - Accumulator register - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_caa
{
    uint32_t U;
    struct _hw_cau_xor_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_xor_caa_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CAA register
 */
/*@{*/
#define HW_CAU_XOR_CAA_ADDR(x)   ((x) + 0x984U)

#define HW_CAU_XOR_CAA(x)        (*(__O hw_cau_xor_caa_t *) HW_CAU_XOR_CAA_ADDR(x))
#define HW_CAU_XOR_CAA_WR(x, v)  (HW_CAU_XOR_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CAA bitfields
 */

/*!
 * @name Register CAU_XOR_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CAA_ACC   (0U)          /*!< Bit position for CAU_XOR_CAA_ACC. */
#define BM_CAU_XOR_CAA_ACC   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CAA_ACC. */
#define BS_CAU_XOR_CAA_ACC   (32U)         /*!< Bit field size in bits for CAU_XOR_CAA_ACC. */

/*! @brief Format value for bitfield CAU_XOR_CAA_ACC. */
#define BF_CAU_XOR_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CAA_ACC) & BM_CAU_XOR_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA0 - General Purpose Register 0 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA0 - General Purpose Register 0 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca0
{
    uint32_t U;
    struct _hw_cau_xor_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_xor_ca0_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA0 register
 */
/*@{*/
#define HW_CAU_XOR_CA0_ADDR(x)   ((x) + 0x988U)

#define HW_CAU_XOR_CA0(x)        (*(__O hw_cau_xor_ca0_t *) HW_CAU_XOR_CA0_ADDR(x))
#define HW_CAU_XOR_CA0_WR(x, v)  (HW_CAU_XOR_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA0 bitfields
 */

/*!
 * @name Register CAU_XOR_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA0_CA0   (0U)          /*!< Bit position for CAU_XOR_CA0_CA0. */
#define BM_CAU_XOR_CA0_CA0   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA0_CA0. */
#define BS_CAU_XOR_CA0_CA0   (32U)         /*!< Bit field size in bits for CAU_XOR_CA0_CA0. */

/*! @brief Format value for bitfield CAU_XOR_CA0_CA0. */
#define BF_CAU_XOR_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA0_CA0) & BM_CAU_XOR_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA1 - General Purpose Register 1 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA1 - General Purpose Register 1 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca1
{
    uint32_t U;
    struct _hw_cau_xor_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_xor_ca1_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA1 register
 */
/*@{*/
#define HW_CAU_XOR_CA1_ADDR(x)   ((x) + 0x98CU)

#define HW_CAU_XOR_CA1(x)        (*(__O hw_cau_xor_ca1_t *) HW_CAU_XOR_CA1_ADDR(x))
#define HW_CAU_XOR_CA1_WR(x, v)  (HW_CAU_XOR_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA1 bitfields
 */

/*!
 * @name Register CAU_XOR_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA1_CA1   (0U)          /*!< Bit position for CAU_XOR_CA1_CA1. */
#define BM_CAU_XOR_CA1_CA1   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA1_CA1. */
#define BS_CAU_XOR_CA1_CA1   (32U)         /*!< Bit field size in bits for CAU_XOR_CA1_CA1. */

/*! @brief Format value for bitfield CAU_XOR_CA1_CA1. */
#define BF_CAU_XOR_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA1_CA1) & BM_CAU_XOR_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA2 - General Purpose Register 2 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA2 - General Purpose Register 2 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca2
{
    uint32_t U;
    struct _hw_cau_xor_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_xor_ca2_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA2 register
 */
/*@{*/
#define HW_CAU_XOR_CA2_ADDR(x)   ((x) + 0x990U)

#define HW_CAU_XOR_CA2(x)        (*(__O hw_cau_xor_ca2_t *) HW_CAU_XOR_CA2_ADDR(x))
#define HW_CAU_XOR_CA2_WR(x, v)  (HW_CAU_XOR_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA2 bitfields
 */

/*!
 * @name Register CAU_XOR_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA2_CA2   (0U)          /*!< Bit position for CAU_XOR_CA2_CA2. */
#define BM_CAU_XOR_CA2_CA2   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA2_CA2. */
#define BS_CAU_XOR_CA2_CA2   (32U)         /*!< Bit field size in bits for CAU_XOR_CA2_CA2. */

/*! @brief Format value for bitfield CAU_XOR_CA2_CA2. */
#define BF_CAU_XOR_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA2_CA2) & BM_CAU_XOR_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA3 - General Purpose Register 3 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA3 - General Purpose Register 3 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca3
{
    uint32_t U;
    struct _hw_cau_xor_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_xor_ca3_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA3 register
 */
/*@{*/
#define HW_CAU_XOR_CA3_ADDR(x)   ((x) + 0x994U)

#define HW_CAU_XOR_CA3(x)        (*(__O hw_cau_xor_ca3_t *) HW_CAU_XOR_CA3_ADDR(x))
#define HW_CAU_XOR_CA3_WR(x, v)  (HW_CAU_XOR_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA3 bitfields
 */

/*!
 * @name Register CAU_XOR_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA3_CA3   (0U)          /*!< Bit position for CAU_XOR_CA3_CA3. */
#define BM_CAU_XOR_CA3_CA3   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA3_CA3. */
#define BS_CAU_XOR_CA3_CA3   (32U)         /*!< Bit field size in bits for CAU_XOR_CA3_CA3. */

/*! @brief Format value for bitfield CAU_XOR_CA3_CA3. */
#define BF_CAU_XOR_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA3_CA3) & BM_CAU_XOR_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA4 - General Purpose Register 4 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA4 - General Purpose Register 4 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca4
{
    uint32_t U;
    struct _hw_cau_xor_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_xor_ca4_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA4 register
 */
/*@{*/
#define HW_CAU_XOR_CA4_ADDR(x)   ((x) + 0x998U)

#define HW_CAU_XOR_CA4(x)        (*(__O hw_cau_xor_ca4_t *) HW_CAU_XOR_CA4_ADDR(x))
#define HW_CAU_XOR_CA4_WR(x, v)  (HW_CAU_XOR_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA4 bitfields
 */

/*!
 * @name Register CAU_XOR_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA4_CA4   (0U)          /*!< Bit position for CAU_XOR_CA4_CA4. */
#define BM_CAU_XOR_CA4_CA4   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA4_CA4. */
#define BS_CAU_XOR_CA4_CA4   (32U)         /*!< Bit field size in bits for CAU_XOR_CA4_CA4. */

/*! @brief Format value for bitfield CAU_XOR_CA4_CA4. */
#define BF_CAU_XOR_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA4_CA4) & BM_CAU_XOR_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA5 - General Purpose Register 5 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA5 - General Purpose Register 5 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca5
{
    uint32_t U;
    struct _hw_cau_xor_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_xor_ca5_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA5 register
 */
/*@{*/
#define HW_CAU_XOR_CA5_ADDR(x)   ((x) + 0x99CU)

#define HW_CAU_XOR_CA5(x)        (*(__O hw_cau_xor_ca5_t *) HW_CAU_XOR_CA5_ADDR(x))
#define HW_CAU_XOR_CA5_WR(x, v)  (HW_CAU_XOR_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA5 bitfields
 */

/*!
 * @name Register CAU_XOR_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA5_CA5   (0U)          /*!< Bit position for CAU_XOR_CA5_CA5. */
#define BM_CAU_XOR_CA5_CA5   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA5_CA5. */
#define BS_CAU_XOR_CA5_CA5   (32U)         /*!< Bit field size in bits for CAU_XOR_CA5_CA5. */

/*! @brief Format value for bitfield CAU_XOR_CA5_CA5. */
#define BF_CAU_XOR_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA5_CA5) & BM_CAU_XOR_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA6 - General Purpose Register 6 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA6 - General Purpose Register 6 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca6
{
    uint32_t U;
    struct _hw_cau_xor_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_xor_ca6_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA6 register
 */
/*@{*/
#define HW_CAU_XOR_CA6_ADDR(x)   ((x) + 0x9A0U)

#define HW_CAU_XOR_CA6(x)        (*(__O hw_cau_xor_ca6_t *) HW_CAU_XOR_CA6_ADDR(x))
#define HW_CAU_XOR_CA6_WR(x, v)  (HW_CAU_XOR_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA6 bitfields
 */

/*!
 * @name Register CAU_XOR_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA6_CA6   (0U)          /*!< Bit position for CAU_XOR_CA6_CA6. */
#define BM_CAU_XOR_CA6_CA6   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA6_CA6. */
#define BS_CAU_XOR_CA6_CA6   (32U)         /*!< Bit field size in bits for CAU_XOR_CA6_CA6. */

/*! @brief Format value for bitfield CAU_XOR_CA6_CA6. */
#define BF_CAU_XOR_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA6_CA6) & BM_CAU_XOR_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA7 - General Purpose Register 7 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA7 - General Purpose Register 7 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca7
{
    uint32_t U;
    struct _hw_cau_xor_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_xor_ca7_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA7 register
 */
/*@{*/
#define HW_CAU_XOR_CA7_ADDR(x)   ((x) + 0x9A4U)

#define HW_CAU_XOR_CA7(x)        (*(__O hw_cau_xor_ca7_t *) HW_CAU_XOR_CA7_ADDR(x))
#define HW_CAU_XOR_CA7_WR(x, v)  (HW_CAU_XOR_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA7 bitfields
 */

/*!
 * @name Register CAU_XOR_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA7_CA7   (0U)          /*!< Bit position for CAU_XOR_CA7_CA7. */
#define BM_CAU_XOR_CA7_CA7   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA7_CA7. */
#define BS_CAU_XOR_CA7_CA7   (32U)         /*!< Bit field size in bits for CAU_XOR_CA7_CA7. */

/*! @brief Format value for bitfield CAU_XOR_CA7_CA7. */
#define BF_CAU_XOR_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA7_CA7) & BM_CAU_XOR_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_XOR_CA8 - General Purpose Register 8 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief HW_CAU_XOR_CA8 - General Purpose Register 8 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca8
{
    uint32_t U;
    struct _hw_cau_xor_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_xor_ca8_t;

/*!
 * @name Constants and macros for entire CAU_XOR_CA8 register
 */
/*@{*/
#define HW_CAU_XOR_CA8_ADDR(x)   ((x) + 0x9A8U)

#define HW_CAU_XOR_CA8(x)        (*(__O hw_cau_xor_ca8_t *) HW_CAU_XOR_CA8_ADDR(x))
#define HW_CAU_XOR_CA8_WR(x, v)  (HW_CAU_XOR_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CA8 bitfields
 */

/*!
 * @name Register CAU_XOR_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_XOR_CA8_CA8   (0U)          /*!< Bit position for CAU_XOR_CA8_CA8. */
#define BM_CAU_XOR_CA8_CA8   (0xFFFFFFFFU) /*!< Bit mask for CAU_XOR_CA8_CA8. */
#define BS_CAU_XOR_CA8_CA8   (32U)         /*!< Bit field size in bits for CAU_XOR_CA8_CA8. */

/*! @brief Format value for bitfield CAU_XOR_CA8_CA8. */
#define BF_CAU_XOR_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_XOR_CA8_CA8) & BM_CAU_XOR_CA8_CA8)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CASR - Status register  - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CASR - Status register  - Rotate Left command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_rotl_casr
{
    uint32_t U;
    struct _hw_cau_rotl_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_rotl_casr_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CASR register
 */
/*@{*/
#define HW_CAU_ROTL_CASR_ADDR(x) ((x) + 0x9C0U)

#define HW_CAU_ROTL_CASR(x)      (*(__O hw_cau_rotl_casr_t *) HW_CAU_ROTL_CASR_ADDR(x))
#define HW_CAU_ROTL_CASR_WR(x, v) (HW_CAU_ROTL_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CASR bitfields
 */

/*!
 * @name Register CAU_ROTL_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_ROTL_CASR_IC  (0U)          /*!< Bit position for CAU_ROTL_CASR_IC. */
#define BM_CAU_ROTL_CASR_IC  (0x00000001U) /*!< Bit mask for CAU_ROTL_CASR_IC. */
#define BS_CAU_ROTL_CASR_IC  (1U)          /*!< Bit field size in bits for CAU_ROTL_CASR_IC. */

/*! @brief Format value for bitfield CAU_ROTL_CASR_IC. */
#define BF_CAU_ROTL_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CASR_IC) & BM_CAU_ROTL_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_ROTL_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_ROTL_CASR_DPE (1U)          /*!< Bit position for CAU_ROTL_CASR_DPE. */
#define BM_CAU_ROTL_CASR_DPE (0x00000002U) /*!< Bit mask for CAU_ROTL_CASR_DPE. */
#define BS_CAU_ROTL_CASR_DPE (1U)          /*!< Bit field size in bits for CAU_ROTL_CASR_DPE. */

/*! @brief Format value for bitfield CAU_ROTL_CASR_DPE. */
#define BF_CAU_ROTL_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CASR_DPE) & BM_CAU_ROTL_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_ROTL_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_ROTL_CASR_VER (28U)         /*!< Bit position for CAU_ROTL_CASR_VER. */
#define BM_CAU_ROTL_CASR_VER (0xF0000000U) /*!< Bit mask for CAU_ROTL_CASR_VER. */
#define BS_CAU_ROTL_CASR_VER (4U)          /*!< Bit field size in bits for CAU_ROTL_CASR_VER. */

/*! @brief Format value for bitfield CAU_ROTL_CASR_VER. */
#define BF_CAU_ROTL_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CASR_VER) & BM_CAU_ROTL_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CAA - Accumulator register - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CAA - Accumulator register - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_caa
{
    uint32_t U;
    struct _hw_cau_rotl_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_rotl_caa_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CAA register
 */
/*@{*/
#define HW_CAU_ROTL_CAA_ADDR(x)  ((x) + 0x9C4U)

#define HW_CAU_ROTL_CAA(x)       (*(__O hw_cau_rotl_caa_t *) HW_CAU_ROTL_CAA_ADDR(x))
#define HW_CAU_ROTL_CAA_WR(x, v) (HW_CAU_ROTL_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CAA bitfields
 */

/*!
 * @name Register CAU_ROTL_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CAA_ACC  (0U)          /*!< Bit position for CAU_ROTL_CAA_ACC. */
#define BM_CAU_ROTL_CAA_ACC  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CAA_ACC. */
#define BS_CAU_ROTL_CAA_ACC  (32U)         /*!< Bit field size in bits for CAU_ROTL_CAA_ACC. */

/*! @brief Format value for bitfield CAU_ROTL_CAA_ACC. */
#define BF_CAU_ROTL_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CAA_ACC) & BM_CAU_ROTL_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA0 - General Purpose Register 0 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA0 - General Purpose Register 0 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca0
{
    uint32_t U;
    struct _hw_cau_rotl_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_rotl_ca0_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA0 register
 */
/*@{*/
#define HW_CAU_ROTL_CA0_ADDR(x)  ((x) + 0x9C8U)

#define HW_CAU_ROTL_CA0(x)       (*(__O hw_cau_rotl_ca0_t *) HW_CAU_ROTL_CA0_ADDR(x))
#define HW_CAU_ROTL_CA0_WR(x, v) (HW_CAU_ROTL_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA0 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA0_CA0  (0U)          /*!< Bit position for CAU_ROTL_CA0_CA0. */
#define BM_CAU_ROTL_CA0_CA0  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA0_CA0. */
#define BS_CAU_ROTL_CA0_CA0  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA0_CA0. */

/*! @brief Format value for bitfield CAU_ROTL_CA0_CA0. */
#define BF_CAU_ROTL_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA0_CA0) & BM_CAU_ROTL_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA1 - General Purpose Register 1 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA1 - General Purpose Register 1 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca1
{
    uint32_t U;
    struct _hw_cau_rotl_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_rotl_ca1_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA1 register
 */
/*@{*/
#define HW_CAU_ROTL_CA1_ADDR(x)  ((x) + 0x9CCU)

#define HW_CAU_ROTL_CA1(x)       (*(__O hw_cau_rotl_ca1_t *) HW_CAU_ROTL_CA1_ADDR(x))
#define HW_CAU_ROTL_CA1_WR(x, v) (HW_CAU_ROTL_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA1 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA1_CA1  (0U)          /*!< Bit position for CAU_ROTL_CA1_CA1. */
#define BM_CAU_ROTL_CA1_CA1  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA1_CA1. */
#define BS_CAU_ROTL_CA1_CA1  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA1_CA1. */

/*! @brief Format value for bitfield CAU_ROTL_CA1_CA1. */
#define BF_CAU_ROTL_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA1_CA1) & BM_CAU_ROTL_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA2 - General Purpose Register 2 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA2 - General Purpose Register 2 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca2
{
    uint32_t U;
    struct _hw_cau_rotl_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_rotl_ca2_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA2 register
 */
/*@{*/
#define HW_CAU_ROTL_CA2_ADDR(x)  ((x) + 0x9D0U)

#define HW_CAU_ROTL_CA2(x)       (*(__O hw_cau_rotl_ca2_t *) HW_CAU_ROTL_CA2_ADDR(x))
#define HW_CAU_ROTL_CA2_WR(x, v) (HW_CAU_ROTL_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA2 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA2_CA2  (0U)          /*!< Bit position for CAU_ROTL_CA2_CA2. */
#define BM_CAU_ROTL_CA2_CA2  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA2_CA2. */
#define BS_CAU_ROTL_CA2_CA2  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA2_CA2. */

/*! @brief Format value for bitfield CAU_ROTL_CA2_CA2. */
#define BF_CAU_ROTL_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA2_CA2) & BM_CAU_ROTL_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA3 - General Purpose Register 3 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA3 - General Purpose Register 3 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca3
{
    uint32_t U;
    struct _hw_cau_rotl_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_rotl_ca3_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA3 register
 */
/*@{*/
#define HW_CAU_ROTL_CA3_ADDR(x)  ((x) + 0x9D4U)

#define HW_CAU_ROTL_CA3(x)       (*(__O hw_cau_rotl_ca3_t *) HW_CAU_ROTL_CA3_ADDR(x))
#define HW_CAU_ROTL_CA3_WR(x, v) (HW_CAU_ROTL_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA3 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA3_CA3  (0U)          /*!< Bit position for CAU_ROTL_CA3_CA3. */
#define BM_CAU_ROTL_CA3_CA3  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA3_CA3. */
#define BS_CAU_ROTL_CA3_CA3  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA3_CA3. */

/*! @brief Format value for bitfield CAU_ROTL_CA3_CA3. */
#define BF_CAU_ROTL_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA3_CA3) & BM_CAU_ROTL_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA4 - General Purpose Register 4 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA4 - General Purpose Register 4 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca4
{
    uint32_t U;
    struct _hw_cau_rotl_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_rotl_ca4_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA4 register
 */
/*@{*/
#define HW_CAU_ROTL_CA4_ADDR(x)  ((x) + 0x9D8U)

#define HW_CAU_ROTL_CA4(x)       (*(__O hw_cau_rotl_ca4_t *) HW_CAU_ROTL_CA4_ADDR(x))
#define HW_CAU_ROTL_CA4_WR(x, v) (HW_CAU_ROTL_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA4 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA4_CA4  (0U)          /*!< Bit position for CAU_ROTL_CA4_CA4. */
#define BM_CAU_ROTL_CA4_CA4  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA4_CA4. */
#define BS_CAU_ROTL_CA4_CA4  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA4_CA4. */

/*! @brief Format value for bitfield CAU_ROTL_CA4_CA4. */
#define BF_CAU_ROTL_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA4_CA4) & BM_CAU_ROTL_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA5 - General Purpose Register 5 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA5 - General Purpose Register 5 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca5
{
    uint32_t U;
    struct _hw_cau_rotl_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_rotl_ca5_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA5 register
 */
/*@{*/
#define HW_CAU_ROTL_CA5_ADDR(x)  ((x) + 0x9DCU)

#define HW_CAU_ROTL_CA5(x)       (*(__O hw_cau_rotl_ca5_t *) HW_CAU_ROTL_CA5_ADDR(x))
#define HW_CAU_ROTL_CA5_WR(x, v) (HW_CAU_ROTL_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA5 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA5_CA5  (0U)          /*!< Bit position for CAU_ROTL_CA5_CA5. */
#define BM_CAU_ROTL_CA5_CA5  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA5_CA5. */
#define BS_CAU_ROTL_CA5_CA5  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA5_CA5. */

/*! @brief Format value for bitfield CAU_ROTL_CA5_CA5. */
#define BF_CAU_ROTL_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA5_CA5) & BM_CAU_ROTL_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA6 - General Purpose Register 6 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA6 - General Purpose Register 6 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca6
{
    uint32_t U;
    struct _hw_cau_rotl_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_rotl_ca6_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA6 register
 */
/*@{*/
#define HW_CAU_ROTL_CA6_ADDR(x)  ((x) + 0x9E0U)

#define HW_CAU_ROTL_CA6(x)       (*(__O hw_cau_rotl_ca6_t *) HW_CAU_ROTL_CA6_ADDR(x))
#define HW_CAU_ROTL_CA6_WR(x, v) (HW_CAU_ROTL_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA6 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA6_CA6  (0U)          /*!< Bit position for CAU_ROTL_CA6_CA6. */
#define BM_CAU_ROTL_CA6_CA6  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA6_CA6. */
#define BS_CAU_ROTL_CA6_CA6  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA6_CA6. */

/*! @brief Format value for bitfield CAU_ROTL_CA6_CA6. */
#define BF_CAU_ROTL_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA6_CA6) & BM_CAU_ROTL_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA7 - General Purpose Register 7 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA7 - General Purpose Register 7 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca7
{
    uint32_t U;
    struct _hw_cau_rotl_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_rotl_ca7_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA7 register
 */
/*@{*/
#define HW_CAU_ROTL_CA7_ADDR(x)  ((x) + 0x9E4U)

#define HW_CAU_ROTL_CA7(x)       (*(__O hw_cau_rotl_ca7_t *) HW_CAU_ROTL_CA7_ADDR(x))
#define HW_CAU_ROTL_CA7_WR(x, v) (HW_CAU_ROTL_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA7 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA7_CA7  (0U)          /*!< Bit position for CAU_ROTL_CA7_CA7. */
#define BM_CAU_ROTL_CA7_CA7  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA7_CA7. */
#define BS_CAU_ROTL_CA7_CA7  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA7_CA7. */

/*! @brief Format value for bitfield CAU_ROTL_CA7_CA7. */
#define BF_CAU_ROTL_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA7_CA7) & BM_CAU_ROTL_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_ROTL_CA8 - General Purpose Register 8 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief HW_CAU_ROTL_CA8 - General Purpose Register 8 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca8
{
    uint32_t U;
    struct _hw_cau_rotl_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_rotl_ca8_t;

/*!
 * @name Constants and macros for entire CAU_ROTL_CA8 register
 */
/*@{*/
#define HW_CAU_ROTL_CA8_ADDR(x)  ((x) + 0x9E8U)

#define HW_CAU_ROTL_CA8(x)       (*(__O hw_cau_rotl_ca8_t *) HW_CAU_ROTL_CA8_ADDR(x))
#define HW_CAU_ROTL_CA8_WR(x, v) (HW_CAU_ROTL_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CA8 bitfields
 */

/*!
 * @name Register CAU_ROTL_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_ROTL_CA8_CA8  (0U)          /*!< Bit position for CAU_ROTL_CA8_CA8. */
#define BM_CAU_ROTL_CA8_CA8  (0xFFFFFFFFU) /*!< Bit mask for CAU_ROTL_CA8_CA8. */
#define BS_CAU_ROTL_CA8_CA8  (32U)         /*!< Bit field size in bits for CAU_ROTL_CA8_CA8. */

/*! @brief Format value for bitfield CAU_ROTL_CA8_CA8. */
#define BF_CAU_ROTL_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_ROTL_CA8_CA8) & BM_CAU_ROTL_CA8_CA8)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CASR - Status register  - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CASR - Status register  - AES Column Operation command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_aesc_casr
{
    uint32_t U;
    struct _hw_cau_aesc_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_aesc_casr_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CASR register
 */
/*@{*/
#define HW_CAU_AESC_CASR_ADDR(x) ((x) + 0xB00U)

#define HW_CAU_AESC_CASR(x)      (*(__O hw_cau_aesc_casr_t *) HW_CAU_AESC_CASR_ADDR(x))
#define HW_CAU_AESC_CASR_WR(x, v) (HW_CAU_AESC_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CASR bitfields
 */

/*!
 * @name Register CAU_AESC_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_AESC_CASR_IC  (0U)          /*!< Bit position for CAU_AESC_CASR_IC. */
#define BM_CAU_AESC_CASR_IC  (0x00000001U) /*!< Bit mask for CAU_AESC_CASR_IC. */
#define BS_CAU_AESC_CASR_IC  (1U)          /*!< Bit field size in bits for CAU_AESC_CASR_IC. */

/*! @brief Format value for bitfield CAU_AESC_CASR_IC. */
#define BF_CAU_AESC_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CASR_IC) & BM_CAU_AESC_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_AESC_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_AESC_CASR_DPE (1U)          /*!< Bit position for CAU_AESC_CASR_DPE. */
#define BM_CAU_AESC_CASR_DPE (0x00000002U) /*!< Bit mask for CAU_AESC_CASR_DPE. */
#define BS_CAU_AESC_CASR_DPE (1U)          /*!< Bit field size in bits for CAU_AESC_CASR_DPE. */

/*! @brief Format value for bitfield CAU_AESC_CASR_DPE. */
#define BF_CAU_AESC_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CASR_DPE) & BM_CAU_AESC_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_AESC_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_AESC_CASR_VER (28U)         /*!< Bit position for CAU_AESC_CASR_VER. */
#define BM_CAU_AESC_CASR_VER (0xF0000000U) /*!< Bit mask for CAU_AESC_CASR_VER. */
#define BS_CAU_AESC_CASR_VER (4U)          /*!< Bit field size in bits for CAU_AESC_CASR_VER. */

/*! @brief Format value for bitfield CAU_AESC_CASR_VER. */
#define BF_CAU_AESC_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CASR_VER) & BM_CAU_AESC_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CAA - Accumulator register - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CAA - Accumulator register - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_caa
{
    uint32_t U;
    struct _hw_cau_aesc_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_aesc_caa_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CAA register
 */
/*@{*/
#define HW_CAU_AESC_CAA_ADDR(x)  ((x) + 0xB04U)

#define HW_CAU_AESC_CAA(x)       (*(__O hw_cau_aesc_caa_t *) HW_CAU_AESC_CAA_ADDR(x))
#define HW_CAU_AESC_CAA_WR(x, v) (HW_CAU_AESC_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CAA bitfields
 */

/*!
 * @name Register CAU_AESC_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CAA_ACC  (0U)          /*!< Bit position for CAU_AESC_CAA_ACC. */
#define BM_CAU_AESC_CAA_ACC  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CAA_ACC. */
#define BS_CAU_AESC_CAA_ACC  (32U)         /*!< Bit field size in bits for CAU_AESC_CAA_ACC. */

/*! @brief Format value for bitfield CAU_AESC_CAA_ACC. */
#define BF_CAU_AESC_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CAA_ACC) & BM_CAU_AESC_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA0 - General Purpose Register 0 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA0 - General Purpose Register 0 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca0
{
    uint32_t U;
    struct _hw_cau_aesc_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_aesc_ca0_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA0 register
 */
/*@{*/
#define HW_CAU_AESC_CA0_ADDR(x)  ((x) + 0xB08U)

#define HW_CAU_AESC_CA0(x)       (*(__O hw_cau_aesc_ca0_t *) HW_CAU_AESC_CA0_ADDR(x))
#define HW_CAU_AESC_CA0_WR(x, v) (HW_CAU_AESC_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA0 bitfields
 */

/*!
 * @name Register CAU_AESC_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA0_CA0  (0U)          /*!< Bit position for CAU_AESC_CA0_CA0. */
#define BM_CAU_AESC_CA0_CA0  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA0_CA0. */
#define BS_CAU_AESC_CA0_CA0  (32U)         /*!< Bit field size in bits for CAU_AESC_CA0_CA0. */

/*! @brief Format value for bitfield CAU_AESC_CA0_CA0. */
#define BF_CAU_AESC_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA0_CA0) & BM_CAU_AESC_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA1 - General Purpose Register 1 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA1 - General Purpose Register 1 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca1
{
    uint32_t U;
    struct _hw_cau_aesc_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_aesc_ca1_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA1 register
 */
/*@{*/
#define HW_CAU_AESC_CA1_ADDR(x)  ((x) + 0xB0CU)

#define HW_CAU_AESC_CA1(x)       (*(__O hw_cau_aesc_ca1_t *) HW_CAU_AESC_CA1_ADDR(x))
#define HW_CAU_AESC_CA1_WR(x, v) (HW_CAU_AESC_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA1 bitfields
 */

/*!
 * @name Register CAU_AESC_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA1_CA1  (0U)          /*!< Bit position for CAU_AESC_CA1_CA1. */
#define BM_CAU_AESC_CA1_CA1  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA1_CA1. */
#define BS_CAU_AESC_CA1_CA1  (32U)         /*!< Bit field size in bits for CAU_AESC_CA1_CA1. */

/*! @brief Format value for bitfield CAU_AESC_CA1_CA1. */
#define BF_CAU_AESC_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA1_CA1) & BM_CAU_AESC_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA2 - General Purpose Register 2 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA2 - General Purpose Register 2 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca2
{
    uint32_t U;
    struct _hw_cau_aesc_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_aesc_ca2_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA2 register
 */
/*@{*/
#define HW_CAU_AESC_CA2_ADDR(x)  ((x) + 0xB10U)

#define HW_CAU_AESC_CA2(x)       (*(__O hw_cau_aesc_ca2_t *) HW_CAU_AESC_CA2_ADDR(x))
#define HW_CAU_AESC_CA2_WR(x, v) (HW_CAU_AESC_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA2 bitfields
 */

/*!
 * @name Register CAU_AESC_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA2_CA2  (0U)          /*!< Bit position for CAU_AESC_CA2_CA2. */
#define BM_CAU_AESC_CA2_CA2  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA2_CA2. */
#define BS_CAU_AESC_CA2_CA2  (32U)         /*!< Bit field size in bits for CAU_AESC_CA2_CA2. */

/*! @brief Format value for bitfield CAU_AESC_CA2_CA2. */
#define BF_CAU_AESC_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA2_CA2) & BM_CAU_AESC_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA3 - General Purpose Register 3 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA3 - General Purpose Register 3 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca3
{
    uint32_t U;
    struct _hw_cau_aesc_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_aesc_ca3_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA3 register
 */
/*@{*/
#define HW_CAU_AESC_CA3_ADDR(x)  ((x) + 0xB14U)

#define HW_CAU_AESC_CA3(x)       (*(__O hw_cau_aesc_ca3_t *) HW_CAU_AESC_CA3_ADDR(x))
#define HW_CAU_AESC_CA3_WR(x, v) (HW_CAU_AESC_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA3 bitfields
 */

/*!
 * @name Register CAU_AESC_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA3_CA3  (0U)          /*!< Bit position for CAU_AESC_CA3_CA3. */
#define BM_CAU_AESC_CA3_CA3  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA3_CA3. */
#define BS_CAU_AESC_CA3_CA3  (32U)         /*!< Bit field size in bits for CAU_AESC_CA3_CA3. */

/*! @brief Format value for bitfield CAU_AESC_CA3_CA3. */
#define BF_CAU_AESC_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA3_CA3) & BM_CAU_AESC_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA4 - General Purpose Register 4 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA4 - General Purpose Register 4 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca4
{
    uint32_t U;
    struct _hw_cau_aesc_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_aesc_ca4_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA4 register
 */
/*@{*/
#define HW_CAU_AESC_CA4_ADDR(x)  ((x) + 0xB18U)

#define HW_CAU_AESC_CA4(x)       (*(__O hw_cau_aesc_ca4_t *) HW_CAU_AESC_CA4_ADDR(x))
#define HW_CAU_AESC_CA4_WR(x, v) (HW_CAU_AESC_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA4 bitfields
 */

/*!
 * @name Register CAU_AESC_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA4_CA4  (0U)          /*!< Bit position for CAU_AESC_CA4_CA4. */
#define BM_CAU_AESC_CA4_CA4  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA4_CA4. */
#define BS_CAU_AESC_CA4_CA4  (32U)         /*!< Bit field size in bits for CAU_AESC_CA4_CA4. */

/*! @brief Format value for bitfield CAU_AESC_CA4_CA4. */
#define BF_CAU_AESC_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA4_CA4) & BM_CAU_AESC_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA5 - General Purpose Register 5 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA5 - General Purpose Register 5 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca5
{
    uint32_t U;
    struct _hw_cau_aesc_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_aesc_ca5_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA5 register
 */
/*@{*/
#define HW_CAU_AESC_CA5_ADDR(x)  ((x) + 0xB1CU)

#define HW_CAU_AESC_CA5(x)       (*(__O hw_cau_aesc_ca5_t *) HW_CAU_AESC_CA5_ADDR(x))
#define HW_CAU_AESC_CA5_WR(x, v) (HW_CAU_AESC_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA5 bitfields
 */

/*!
 * @name Register CAU_AESC_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA5_CA5  (0U)          /*!< Bit position for CAU_AESC_CA5_CA5. */
#define BM_CAU_AESC_CA5_CA5  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA5_CA5. */
#define BS_CAU_AESC_CA5_CA5  (32U)         /*!< Bit field size in bits for CAU_AESC_CA5_CA5. */

/*! @brief Format value for bitfield CAU_AESC_CA5_CA5. */
#define BF_CAU_AESC_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA5_CA5) & BM_CAU_AESC_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA6 - General Purpose Register 6 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA6 - General Purpose Register 6 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca6
{
    uint32_t U;
    struct _hw_cau_aesc_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_aesc_ca6_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA6 register
 */
/*@{*/
#define HW_CAU_AESC_CA6_ADDR(x)  ((x) + 0xB20U)

#define HW_CAU_AESC_CA6(x)       (*(__O hw_cau_aesc_ca6_t *) HW_CAU_AESC_CA6_ADDR(x))
#define HW_CAU_AESC_CA6_WR(x, v) (HW_CAU_AESC_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA6 bitfields
 */

/*!
 * @name Register CAU_AESC_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA6_CA6  (0U)          /*!< Bit position for CAU_AESC_CA6_CA6. */
#define BM_CAU_AESC_CA6_CA6  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA6_CA6. */
#define BS_CAU_AESC_CA6_CA6  (32U)         /*!< Bit field size in bits for CAU_AESC_CA6_CA6. */

/*! @brief Format value for bitfield CAU_AESC_CA6_CA6. */
#define BF_CAU_AESC_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA6_CA6) & BM_CAU_AESC_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA7 - General Purpose Register 7 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA7 - General Purpose Register 7 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca7
{
    uint32_t U;
    struct _hw_cau_aesc_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_aesc_ca7_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA7 register
 */
/*@{*/
#define HW_CAU_AESC_CA7_ADDR(x)  ((x) + 0xB24U)

#define HW_CAU_AESC_CA7(x)       (*(__O hw_cau_aesc_ca7_t *) HW_CAU_AESC_CA7_ADDR(x))
#define HW_CAU_AESC_CA7_WR(x, v) (HW_CAU_AESC_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA7 bitfields
 */

/*!
 * @name Register CAU_AESC_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA7_CA7  (0U)          /*!< Bit position for CAU_AESC_CA7_CA7. */
#define BM_CAU_AESC_CA7_CA7  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA7_CA7. */
#define BS_CAU_AESC_CA7_CA7  (32U)         /*!< Bit field size in bits for CAU_AESC_CA7_CA7. */

/*! @brief Format value for bitfield CAU_AESC_CA7_CA7. */
#define BF_CAU_AESC_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA7_CA7) & BM_CAU_AESC_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESC_CA8 - General Purpose Register 8 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESC_CA8 - General Purpose Register 8 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca8
{
    uint32_t U;
    struct _hw_cau_aesc_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_aesc_ca8_t;

/*!
 * @name Constants and macros for entire CAU_AESC_CA8 register
 */
/*@{*/
#define HW_CAU_AESC_CA8_ADDR(x)  ((x) + 0xB28U)

#define HW_CAU_AESC_CA8(x)       (*(__O hw_cau_aesc_ca8_t *) HW_CAU_AESC_CA8_ADDR(x))
#define HW_CAU_AESC_CA8_WR(x, v) (HW_CAU_AESC_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CA8 bitfields
 */

/*!
 * @name Register CAU_AESC_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESC_CA8_CA8  (0U)          /*!< Bit position for CAU_AESC_CA8_CA8. */
#define BM_CAU_AESC_CA8_CA8  (0xFFFFFFFFU) /*!< Bit mask for CAU_AESC_CA8_CA8. */
#define BS_CAU_AESC_CA8_CA8  (32U)         /*!< Bit field size in bits for CAU_AESC_CA8_CA8. */

/*! @brief Format value for bitfield CAU_AESC_CA8_CA8. */
#define BF_CAU_AESC_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESC_CA8_CA8) & BM_CAU_AESC_CA8_CA8)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CASR - Status register  - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CASR - Status register  - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_aesic_casr
{
    uint32_t U;
    struct _hw_cau_aesic_casr_bitfields
    {
        uint32_t IC : 1;               /*!< [0]  */
        uint32_t DPE : 1;              /*!< [1]  */
        uint32_t RESERVED0 : 26;       /*!< [27:2]  */
        uint32_t VER : 4;              /*!< [31:28] CAU version */
    } B;
} hw_cau_aesic_casr_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CASR register
 */
/*@{*/
#define HW_CAU_AESIC_CASR_ADDR(x) ((x) + 0xB40U)

#define HW_CAU_AESIC_CASR(x)     (*(__O hw_cau_aesic_casr_t *) HW_CAU_AESIC_CASR_ADDR(x))
#define HW_CAU_AESIC_CASR_WR(x, v) (HW_CAU_AESIC_CASR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CASR bitfields
 */

/*!
 * @name Register CAU_AESIC_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
/*@{*/
#define BP_CAU_AESIC_CASR_IC (0U)          /*!< Bit position for CAU_AESIC_CASR_IC. */
#define BM_CAU_AESIC_CASR_IC (0x00000001U) /*!< Bit mask for CAU_AESIC_CASR_IC. */
#define BS_CAU_AESIC_CASR_IC (1U)          /*!< Bit field size in bits for CAU_AESIC_CASR_IC. */

/*! @brief Format value for bitfield CAU_AESIC_CASR_IC. */
#define BF_CAU_AESIC_CASR_IC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CASR_IC) & BM_CAU_AESIC_CASR_IC)
/*@}*/

/*!
 * @name Register CAU_AESIC_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
/*@{*/
#define BP_CAU_AESIC_CASR_DPE (1U)         /*!< Bit position for CAU_AESIC_CASR_DPE. */
#define BM_CAU_AESIC_CASR_DPE (0x00000002U) /*!< Bit mask for CAU_AESIC_CASR_DPE. */
#define BS_CAU_AESIC_CASR_DPE (1U)         /*!< Bit field size in bits for CAU_AESIC_CASR_DPE. */

/*! @brief Format value for bitfield CAU_AESIC_CASR_DPE. */
#define BF_CAU_AESIC_CASR_DPE(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CASR_DPE) & BM_CAU_AESIC_CASR_DPE)
/*@}*/

/*!
 * @name Register CAU_AESIC_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
#define BP_CAU_AESIC_CASR_VER (28U)        /*!< Bit position for CAU_AESIC_CASR_VER. */
#define BM_CAU_AESIC_CASR_VER (0xF0000000U) /*!< Bit mask for CAU_AESIC_CASR_VER. */
#define BS_CAU_AESIC_CASR_VER (4U)         /*!< Bit field size in bits for CAU_AESIC_CASR_VER. */

/*! @brief Format value for bitfield CAU_AESIC_CASR_VER. */
#define BF_CAU_AESIC_CASR_VER(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CASR_VER) & BM_CAU_AESIC_CASR_VER)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_caa
{
    uint32_t U;
    struct _hw_cau_aesic_caa_bitfields
    {
        uint32_t ACC : 32;             /*!< [31:0] ACC */
    } B;
} hw_cau_aesic_caa_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CAA register
 */
/*@{*/
#define HW_CAU_AESIC_CAA_ADDR(x) ((x) + 0xB44U)

#define HW_CAU_AESIC_CAA(x)      (*(__O hw_cau_aesic_caa_t *) HW_CAU_AESIC_CAA_ADDR(x))
#define HW_CAU_AESIC_CAA_WR(x, v) (HW_CAU_AESIC_CAA(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CAA bitfields
 */

/*!
 * @name Register CAU_AESIC_CAA, field ACC[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CAA_ACC (0U)          /*!< Bit position for CAU_AESIC_CAA_ACC. */
#define BM_CAU_AESIC_CAA_ACC (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CAA_ACC. */
#define BS_CAU_AESIC_CAA_ACC (32U)         /*!< Bit field size in bits for CAU_AESIC_CAA_ACC. */

/*! @brief Format value for bitfield CAU_AESIC_CAA_ACC. */
#define BF_CAU_AESIC_CAA_ACC(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CAA_ACC) & BM_CAU_AESIC_CAA_ACC)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA0 - General Purpose Register 0 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA0 - General Purpose Register 0 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca0
{
    uint32_t U;
    struct _hw_cau_aesic_ca0_bitfields
    {
        uint32_t CA0 : 32;             /*!< [31:0] CA0 */
    } B;
} hw_cau_aesic_ca0_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA0 register
 */
/*@{*/
#define HW_CAU_AESIC_CA0_ADDR(x) ((x) + 0xB48U)

#define HW_CAU_AESIC_CA0(x)      (*(__O hw_cau_aesic_ca0_t *) HW_CAU_AESIC_CA0_ADDR(x))
#define HW_CAU_AESIC_CA0_WR(x, v) (HW_CAU_AESIC_CA0(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA0 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA0, field CA0[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA0_CA0 (0U)          /*!< Bit position for CAU_AESIC_CA0_CA0. */
#define BM_CAU_AESIC_CA0_CA0 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA0_CA0. */
#define BS_CAU_AESIC_CA0_CA0 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA0_CA0. */

/*! @brief Format value for bitfield CAU_AESIC_CA0_CA0. */
#define BF_CAU_AESIC_CA0_CA0(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA0_CA0) & BM_CAU_AESIC_CA0_CA0)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA1 - General Purpose Register 1 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA1 - General Purpose Register 1 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca1
{
    uint32_t U;
    struct _hw_cau_aesic_ca1_bitfields
    {
        uint32_t CA1 : 32;             /*!< [31:0] CA1 */
    } B;
} hw_cau_aesic_ca1_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA1 register
 */
/*@{*/
#define HW_CAU_AESIC_CA1_ADDR(x) ((x) + 0xB4CU)

#define HW_CAU_AESIC_CA1(x)      (*(__O hw_cau_aesic_ca1_t *) HW_CAU_AESIC_CA1_ADDR(x))
#define HW_CAU_AESIC_CA1_WR(x, v) (HW_CAU_AESIC_CA1(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA1 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA1, field CA1[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA1_CA1 (0U)          /*!< Bit position for CAU_AESIC_CA1_CA1. */
#define BM_CAU_AESIC_CA1_CA1 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA1_CA1. */
#define BS_CAU_AESIC_CA1_CA1 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA1_CA1. */

/*! @brief Format value for bitfield CAU_AESIC_CA1_CA1. */
#define BF_CAU_AESIC_CA1_CA1(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA1_CA1) & BM_CAU_AESIC_CA1_CA1)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA2 - General Purpose Register 2 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA2 - General Purpose Register 2 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca2
{
    uint32_t U;
    struct _hw_cau_aesic_ca2_bitfields
    {
        uint32_t CA2 : 32;             /*!< [31:0] CA2 */
    } B;
} hw_cau_aesic_ca2_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA2 register
 */
/*@{*/
#define HW_CAU_AESIC_CA2_ADDR(x) ((x) + 0xB50U)

#define HW_CAU_AESIC_CA2(x)      (*(__O hw_cau_aesic_ca2_t *) HW_CAU_AESIC_CA2_ADDR(x))
#define HW_CAU_AESIC_CA2_WR(x, v) (HW_CAU_AESIC_CA2(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA2 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA2, field CA2[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA2_CA2 (0U)          /*!< Bit position for CAU_AESIC_CA2_CA2. */
#define BM_CAU_AESIC_CA2_CA2 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA2_CA2. */
#define BS_CAU_AESIC_CA2_CA2 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA2_CA2. */

/*! @brief Format value for bitfield CAU_AESIC_CA2_CA2. */
#define BF_CAU_AESIC_CA2_CA2(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA2_CA2) & BM_CAU_AESIC_CA2_CA2)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA3 - General Purpose Register 3 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA3 - General Purpose Register 3 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca3
{
    uint32_t U;
    struct _hw_cau_aesic_ca3_bitfields
    {
        uint32_t CA3 : 32;             /*!< [31:0] CA3 */
    } B;
} hw_cau_aesic_ca3_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA3 register
 */
/*@{*/
#define HW_CAU_AESIC_CA3_ADDR(x) ((x) + 0xB54U)

#define HW_CAU_AESIC_CA3(x)      (*(__O hw_cau_aesic_ca3_t *) HW_CAU_AESIC_CA3_ADDR(x))
#define HW_CAU_AESIC_CA3_WR(x, v) (HW_CAU_AESIC_CA3(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA3 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA3, field CA3[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA3_CA3 (0U)          /*!< Bit position for CAU_AESIC_CA3_CA3. */
#define BM_CAU_AESIC_CA3_CA3 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA3_CA3. */
#define BS_CAU_AESIC_CA3_CA3 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA3_CA3. */

/*! @brief Format value for bitfield CAU_AESIC_CA3_CA3. */
#define BF_CAU_AESIC_CA3_CA3(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA3_CA3) & BM_CAU_AESIC_CA3_CA3)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA4 - General Purpose Register 4 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA4 - General Purpose Register 4 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca4
{
    uint32_t U;
    struct _hw_cau_aesic_ca4_bitfields
    {
        uint32_t CA4 : 32;             /*!< [31:0] CA4 */
    } B;
} hw_cau_aesic_ca4_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA4 register
 */
/*@{*/
#define HW_CAU_AESIC_CA4_ADDR(x) ((x) + 0xB58U)

#define HW_CAU_AESIC_CA4(x)      (*(__O hw_cau_aesic_ca4_t *) HW_CAU_AESIC_CA4_ADDR(x))
#define HW_CAU_AESIC_CA4_WR(x, v) (HW_CAU_AESIC_CA4(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA4 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA4, field CA4[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA4_CA4 (0U)          /*!< Bit position for CAU_AESIC_CA4_CA4. */
#define BM_CAU_AESIC_CA4_CA4 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA4_CA4. */
#define BS_CAU_AESIC_CA4_CA4 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA4_CA4. */

/*! @brief Format value for bitfield CAU_AESIC_CA4_CA4. */
#define BF_CAU_AESIC_CA4_CA4(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA4_CA4) & BM_CAU_AESIC_CA4_CA4)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA5 - General Purpose Register 5 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA5 - General Purpose Register 5 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca5
{
    uint32_t U;
    struct _hw_cau_aesic_ca5_bitfields
    {
        uint32_t CA5 : 32;             /*!< [31:0] CA5 */
    } B;
} hw_cau_aesic_ca5_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA5 register
 */
/*@{*/
#define HW_CAU_AESIC_CA5_ADDR(x) ((x) + 0xB5CU)

#define HW_CAU_AESIC_CA5(x)      (*(__O hw_cau_aesic_ca5_t *) HW_CAU_AESIC_CA5_ADDR(x))
#define HW_CAU_AESIC_CA5_WR(x, v) (HW_CAU_AESIC_CA5(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA5 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA5, field CA5[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA5_CA5 (0U)          /*!< Bit position for CAU_AESIC_CA5_CA5. */
#define BM_CAU_AESIC_CA5_CA5 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA5_CA5. */
#define BS_CAU_AESIC_CA5_CA5 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA5_CA5. */

/*! @brief Format value for bitfield CAU_AESIC_CA5_CA5. */
#define BF_CAU_AESIC_CA5_CA5(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA5_CA5) & BM_CAU_AESIC_CA5_CA5)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA6 - General Purpose Register 6 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA6 - General Purpose Register 6 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca6
{
    uint32_t U;
    struct _hw_cau_aesic_ca6_bitfields
    {
        uint32_t CA6 : 32;             /*!< [31:0] CA6 */
    } B;
} hw_cau_aesic_ca6_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA6 register
 */
/*@{*/
#define HW_CAU_AESIC_CA6_ADDR(x) ((x) + 0xB60U)

#define HW_CAU_AESIC_CA6(x)      (*(__O hw_cau_aesic_ca6_t *) HW_CAU_AESIC_CA6_ADDR(x))
#define HW_CAU_AESIC_CA6_WR(x, v) (HW_CAU_AESIC_CA6(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA6 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA6, field CA6[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA6_CA6 (0U)          /*!< Bit position for CAU_AESIC_CA6_CA6. */
#define BM_CAU_AESIC_CA6_CA6 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA6_CA6. */
#define BS_CAU_AESIC_CA6_CA6 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA6_CA6. */

/*! @brief Format value for bitfield CAU_AESIC_CA6_CA6. */
#define BF_CAU_AESIC_CA6_CA6(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA6_CA6) & BM_CAU_AESIC_CA6_CA6)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA7 - General Purpose Register 7 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA7 - General Purpose Register 7 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca7
{
    uint32_t U;
    struct _hw_cau_aesic_ca7_bitfields
    {
        uint32_t CA7 : 32;             /*!< [31:0] CA7 */
    } B;
} hw_cau_aesic_ca7_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA7 register
 */
/*@{*/
#define HW_CAU_AESIC_CA7_ADDR(x) ((x) + 0xB64U)

#define HW_CAU_AESIC_CA7(x)      (*(__O hw_cau_aesic_ca7_t *) HW_CAU_AESIC_CA7_ADDR(x))
#define HW_CAU_AESIC_CA7_WR(x, v) (HW_CAU_AESIC_CA7(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA7 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA7, field CA7[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA7_CA7 (0U)          /*!< Bit position for CAU_AESIC_CA7_CA7. */
#define BM_CAU_AESIC_CA7_CA7 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA7_CA7. */
#define BS_CAU_AESIC_CA7_CA7 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA7_CA7. */

/*! @brief Format value for bitfield CAU_AESIC_CA7_CA7. */
#define BF_CAU_AESIC_CA7_CA7(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA7_CA7) & BM_CAU_AESIC_CA7_CA7)
/*@}*/

/*******************************************************************************
 * HW_CAU_AESIC_CA8 - General Purpose Register 8 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief HW_CAU_AESIC_CA8 - General Purpose Register 8 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca8
{
    uint32_t U;
    struct _hw_cau_aesic_ca8_bitfields
    {
        uint32_t CA8 : 32;             /*!< [31:0] CA8 */
    } B;
} hw_cau_aesic_ca8_t;

/*!
 * @name Constants and macros for entire CAU_AESIC_CA8 register
 */
/*@{*/
#define HW_CAU_AESIC_CA8_ADDR(x) ((x) + 0xB68U)

#define HW_CAU_AESIC_CA8(x)      (*(__O hw_cau_aesic_ca8_t *) HW_CAU_AESIC_CA8_ADDR(x))
#define HW_CAU_AESIC_CA8_WR(x, v) (HW_CAU_AESIC_CA8(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CA8 bitfields
 */

/*!
 * @name Register CAU_AESIC_CA8, field CA8[31:0] (WO)
 */
/*@{*/
#define BP_CAU_AESIC_CA8_CA8 (0U)          /*!< Bit position for CAU_AESIC_CA8_CA8. */
#define BM_CAU_AESIC_CA8_CA8 (0xFFFFFFFFU) /*!< Bit mask for CAU_AESIC_CA8_CA8. */
#define BS_CAU_AESIC_CA8_CA8 (32U)         /*!< Bit field size in bits for CAU_AESIC_CA8_CA8. */

/*! @brief Format value for bitfield CAU_AESIC_CA8_CA8. */
#define BF_CAU_AESIC_CA8_CA8(v) ((uint32_t)((uint32_t)(v) << BP_CAU_AESIC_CA8_CA8) & BM_CAU_AESIC_CA8_CA8)
/*@}*/

/*******************************************************************************
 * hw_cau_t - module struct
 ******************************************************************************/
/*!
 * @brief All CAU module registers.
 */
#pragma pack(1)
typedef struct _hw_cau
{
    __O hw_cau_direct0_t DIRECT0;          /*!< [0x0] Direct access register 0 */
    __O hw_cau_direct1_t DIRECT1;          /*!< [0x4] Direct access register 1 */
    __O hw_cau_direct2_t DIRECT2;          /*!< [0x8] Direct access register 2 */
    __O hw_cau_direct3_t DIRECT3;          /*!< [0xC] Direct access register 3 */
    __O hw_cau_direct4_t DIRECT4;          /*!< [0x10] Direct access register 4 */
    __O hw_cau_direct5_t DIRECT5;          /*!< [0x14] Direct access register 5 */
    __O hw_cau_direct6_t DIRECT6;          /*!< [0x18] Direct access register 6 */
    __O hw_cau_direct7_t DIRECT7;          /*!< [0x1C] Direct access register 7 */
    __O hw_cau_direct8_t DIRECT8;          /*!< [0x20] Direct access register 8 */
    __O hw_cau_direct9_t DIRECT9;          /*!< [0x24] Direct access register 9 */
    __O hw_cau_direct10_t DIRECT10;        /*!< [0x28] Direct access register 10 */
    __O hw_cau_direct11_t DIRECT11;        /*!< [0x2C] Direct access register 11 */
    __O hw_cau_direct12_t DIRECT12;        /*!< [0x30] Direct access register 12 */
    __O hw_cau_direct13_t DIRECT13;        /*!< [0x34] Direct access register 13 */
    __O hw_cau_direct14_t DIRECT14;        /*!< [0x38] Direct access register 14 */
    __O hw_cau_direct15_t DIRECT15;        /*!< [0x3C] Direct access register 15 */
    uint8_t _reserved0[2048];
    __O hw_cau_ldr_casr_t LDR_CASR;        /*!< [0x840] Status register  - Load Register command */
    __O hw_cau_ldr_caa_t LDR_CAA;          /*!< [0x844] Accumulator register - Load Register command */
    __O hw_cau_ldr_ca0_t LDR_CA0;          /*!< [0x848] General Purpose Register 0 - Load Register command */
    __O hw_cau_ldr_ca1_t LDR_CA1;          /*!< [0x84C] General Purpose Register 1 - Load Register command */
    __O hw_cau_ldr_ca2_t LDR_CA2;          /*!< [0x850] General Purpose Register 2 - Load Register command */
    __O hw_cau_ldr_ca3_t LDR_CA3;          /*!< [0x854] General Purpose Register 3 - Load Register command */
    __O hw_cau_ldr_ca4_t LDR_CA4;          /*!< [0x858] General Purpose Register 4 - Load Register command */
    __O hw_cau_ldr_ca5_t LDR_CA5;          /*!< [0x85C] General Purpose Register 5 - Load Register command */
    __O hw_cau_ldr_ca6_t LDR_CA6;          /*!< [0x860] General Purpose Register 6 - Load Register command */
    __O hw_cau_ldr_ca7_t LDR_CA7;          /*!< [0x864] General Purpose Register 7 - Load Register command */
    __O hw_cau_ldr_ca8_t LDR_CA8;          /*!< [0x868] General Purpose Register 8 - Load Register command */
    uint8_t _reserved1[20];
    __I hw_cau_str_casr_t STR_CASR;        /*!< [0x880] Status register  - Store Register command */
    __I hw_cau_str_caa_t STR_CAA;          /*!< [0x884] Accumulator register - Store Register command */
    __I hw_cau_str_ca0_t STR_CA0;          /*!< [0x888] General Purpose Register 0 - Store Register command */
    __I hw_cau_str_ca1_t STR_CA1;          /*!< [0x88C] General Purpose Register 1 - Store Register command */
    __I hw_cau_str_ca2_t STR_CA2;          /*!< [0x890] General Purpose Register 2 - Store Register command */
    __I hw_cau_str_ca3_t STR_CA3;          /*!< [0x894] General Purpose Register 3 - Store Register command */
    __I hw_cau_str_ca4_t STR_CA4;          /*!< [0x898] General Purpose Register 4 - Store Register command */
    __I hw_cau_str_ca5_t STR_CA5;          /*!< [0x89C] General Purpose Register 5 - Store Register command */
    __I hw_cau_str_ca6_t STR_CA6;          /*!< [0x8A0] General Purpose Register 6 - Store Register command */
    __I hw_cau_str_ca7_t STR_CA7;          /*!< [0x8A4] General Purpose Register 7 - Store Register command */
    __I hw_cau_str_ca8_t STR_CA8;          /*!< [0x8A8] General Purpose Register 8 - Store Register command */
    uint8_t _reserved2[20];
    __O hw_cau_adr_casr_t ADR_CASR;        /*!< [0x8C0] Status register  - Add Register command */
    __O hw_cau_adr_caa_t ADR_CAA;          /*!< [0x8C4] Accumulator register - Add to register command */
    __O hw_cau_adr_ca0_t ADR_CA0;          /*!< [0x8C8] General Purpose Register 0 - Add to register command */
    __O hw_cau_adr_ca1_t ADR_CA1;          /*!< [0x8CC] General Purpose Register 1 - Add to register command */
    __O hw_cau_adr_ca2_t ADR_CA2;          /*!< [0x8D0] General Purpose Register 2 - Add to register command */
    __O hw_cau_adr_ca3_t ADR_CA3;          /*!< [0x8D4] General Purpose Register 3 - Add to register command */
    __O hw_cau_adr_ca4_t ADR_CA4;          /*!< [0x8D8] General Purpose Register 4 - Add to register command */
    __O hw_cau_adr_ca5_t ADR_CA5;          /*!< [0x8DC] General Purpose Register 5 - Add to register command */
    __O hw_cau_adr_ca6_t ADR_CA6;          /*!< [0x8E0] General Purpose Register 6 - Add to register command */
    __O hw_cau_adr_ca7_t ADR_CA7;          /*!< [0x8E4] General Purpose Register 7 - Add to register command */
    __O hw_cau_adr_ca8_t ADR_CA8;          /*!< [0x8E8] General Purpose Register 8 - Add to register command */
    uint8_t _reserved3[20];
    __O hw_cau_radr_casr_t RADR_CASR;      /*!< [0x900] Status register  - Reverse and Add to Register command */
    __O hw_cau_radr_caa_t RADR_CAA;        /*!< [0x904] Accumulator register - Reverse and Add to Register command */
    __O hw_cau_radr_ca0_t RADR_CA0;        /*!< [0x908] General Purpose Register 0 - Reverse and Add to Register command */
    __O hw_cau_radr_ca1_t RADR_CA1;        /*!< [0x90C] General Purpose Register 1 - Reverse and Add to Register command */
    __O hw_cau_radr_ca2_t RADR_CA2;        /*!< [0x910] General Purpose Register 2 - Reverse and Add to Register command */
    __O hw_cau_radr_ca3_t RADR_CA3;        /*!< [0x914] General Purpose Register 3 - Reverse and Add to Register command */
    __O hw_cau_radr_ca4_t RADR_CA4;        /*!< [0x918] General Purpose Register 4 - Reverse and Add to Register command */
    __O hw_cau_radr_ca5_t RADR_CA5;        /*!< [0x91C] General Purpose Register 5 - Reverse and Add to Register command */
    __O hw_cau_radr_ca6_t RADR_CA6;        /*!< [0x920] General Purpose Register 6 - Reverse and Add to Register command */
    __O hw_cau_radr_ca7_t RADR_CA7;        /*!< [0x924] General Purpose Register 7 - Reverse and Add to Register command */
    __O hw_cau_radr_ca8_t RADR_CA8;        /*!< [0x928] General Purpose Register 8 - Reverse and Add to Register command */
    uint8_t _reserved4[84];
    __O hw_cau_xor_casr_t XOR_CASR;        /*!< [0x980] Status register  - Exclusive Or command */
    __O hw_cau_xor_caa_t XOR_CAA;          /*!< [0x984] Accumulator register - Exclusive Or command */
    __O hw_cau_xor_ca0_t XOR_CA0;          /*!< [0x988] General Purpose Register 0 - Exclusive Or command */
    __O hw_cau_xor_ca1_t XOR_CA1;          /*!< [0x98C] General Purpose Register 1 - Exclusive Or command */
    __O hw_cau_xor_ca2_t XOR_CA2;          /*!< [0x990] General Purpose Register 2 - Exclusive Or command */
    __O hw_cau_xor_ca3_t XOR_CA3;          /*!< [0x994] General Purpose Register 3 - Exclusive Or command */
    __O hw_cau_xor_ca4_t XOR_CA4;          /*!< [0x998] General Purpose Register 4 - Exclusive Or command */
    __O hw_cau_xor_ca5_t XOR_CA5;          /*!< [0x99C] General Purpose Register 5 - Exclusive Or command */
    __O hw_cau_xor_ca6_t XOR_CA6;          /*!< [0x9A0] General Purpose Register 6 - Exclusive Or command */
    __O hw_cau_xor_ca7_t XOR_CA7;          /*!< [0x9A4] General Purpose Register 7 - Exclusive Or command */
    __O hw_cau_xor_ca8_t XOR_CA8;          /*!< [0x9A8] General Purpose Register 8 - Exclusive Or command */
    uint8_t _reserved5[20];
    __O hw_cau_rotl_casr_t ROTL_CASR;      /*!< [0x9C0] Status register  - Rotate Left command */
    __O hw_cau_rotl_caa_t ROTL_CAA;        /*!< [0x9C4] Accumulator register - Rotate Left command */
    __O hw_cau_rotl_ca0_t ROTL_CA0;        /*!< [0x9C8] General Purpose Register 0 - Rotate Left command */
    __O hw_cau_rotl_ca1_t ROTL_CA1;        /*!< [0x9CC] General Purpose Register 1 - Rotate Left command */
    __O hw_cau_rotl_ca2_t ROTL_CA2;        /*!< [0x9D0] General Purpose Register 2 - Rotate Left command */
    __O hw_cau_rotl_ca3_t ROTL_CA3;        /*!< [0x9D4] General Purpose Register 3 - Rotate Left command */
    __O hw_cau_rotl_ca4_t ROTL_CA4;        /*!< [0x9D8] General Purpose Register 4 - Rotate Left command */
    __O hw_cau_rotl_ca5_t ROTL_CA5;        /*!< [0x9DC] General Purpose Register 5 - Rotate Left command */
    __O hw_cau_rotl_ca6_t ROTL_CA6;        /*!< [0x9E0] General Purpose Register 6 - Rotate Left command */
    __O hw_cau_rotl_ca7_t ROTL_CA7;        /*!< [0x9E4] General Purpose Register 7 - Rotate Left command */
    __O hw_cau_rotl_ca8_t ROTL_CA8;        /*!< [0x9E8] General Purpose Register 8 - Rotate Left command */
    uint8_t _reserved6[276];
    __O hw_cau_aesc_casr_t AESC_CASR;      /*!< [0xB00] Status register  - AES Column Operation command */
    __O hw_cau_aesc_caa_t AESC_CAA;        /*!< [0xB04] Accumulator register - AES Column Operation command */
    __O hw_cau_aesc_ca0_t AESC_CA0;        /*!< [0xB08] General Purpose Register 0 - AES Column Operation command */
    __O hw_cau_aesc_ca1_t AESC_CA1;        /*!< [0xB0C] General Purpose Register 1 - AES Column Operation command */
    __O hw_cau_aesc_ca2_t AESC_CA2;        /*!< [0xB10] General Purpose Register 2 - AES Column Operation command */
    __O hw_cau_aesc_ca3_t AESC_CA3;        /*!< [0xB14] General Purpose Register 3 - AES Column Operation command */
    __O hw_cau_aesc_ca4_t AESC_CA4;        /*!< [0xB18] General Purpose Register 4 - AES Column Operation command */
    __O hw_cau_aesc_ca5_t AESC_CA5;        /*!< [0xB1C] General Purpose Register 5 - AES Column Operation command */
    __O hw_cau_aesc_ca6_t AESC_CA6;        /*!< [0xB20] General Purpose Register 6 - AES Column Operation command */
    __O hw_cau_aesc_ca7_t AESC_CA7;        /*!< [0xB24] General Purpose Register 7 - AES Column Operation command */
    __O hw_cau_aesc_ca8_t AESC_CA8;        /*!< [0xB28] General Purpose Register 8 - AES Column Operation command */
    uint8_t _reserved7[20];
    __O hw_cau_aesic_casr_t AESIC_CASR;    /*!< [0xB40] Status register  - AES Inverse Column Operation command */
    __O hw_cau_aesic_caa_t AESIC_CAA;      /*!< [0xB44] Accumulator register - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca0_t AESIC_CA0;      /*!< [0xB48] General Purpose Register 0 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca1_t AESIC_CA1;      /*!< [0xB4C] General Purpose Register 1 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca2_t AESIC_CA2;      /*!< [0xB50] General Purpose Register 2 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca3_t AESIC_CA3;      /*!< [0xB54] General Purpose Register 3 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca4_t AESIC_CA4;      /*!< [0xB58] General Purpose Register 4 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca5_t AESIC_CA5;      /*!< [0xB5C] General Purpose Register 5 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca6_t AESIC_CA6;      /*!< [0xB60] General Purpose Register 6 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca7_t AESIC_CA7;      /*!< [0xB64] General Purpose Register 7 - AES Inverse Column Operation command */
    __O hw_cau_aesic_ca8_t AESIC_CA8;      /*!< [0xB68] General Purpose Register 8 - AES Inverse Column Operation command */
} hw_cau_t;
#pragma pack()

/*! @brief Macro to access all CAU registers. */
/*! @param x CAU module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CAU(CAU_BASE)</code>. */
#define HW_CAU(x)      (*(hw_cau_t *)(x))

#endif /* __HW_CAU_REGISTERS_H__ */
/* EOF */
