/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_FTM_REGISTERS_H__
#define __HW_FTM_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 FTM
 *
 * FlexTimer Module
 *
 * Registers defined in this header file:
 * - HW_FTM_SC - Status And Control
 * - HW_FTM_CNT - Counter
 * - HW_FTM_MOD - Modulo
 * - HW_FTM_CnSC - Channel (n) Status And Control
 * - HW_FTM_CnV - Channel (n) Value
 * - HW_FTM_CNTIN - Counter Initial Value
 * - HW_FTM_STATUS - Capture And Compare Status
 * - HW_FTM_MODE - Features Mode Selection
 * - HW_FTM_SYNC - Synchronization
 * - HW_FTM_OUTINIT - Initial State For Channels Output
 * - HW_FTM_OUTMASK - Output Mask
 * - HW_FTM_COMBINE - Function For Linked Channels
 * - HW_FTM_DEADTIME - Deadtime Insertion Control
 * - HW_FTM_EXTTRIG - FTM External Trigger
 * - HW_FTM_POL - Channels Polarity
 * - HW_FTM_FMS - Fault Mode Status
 * - HW_FTM_FILTER - Input Capture Filter Control
 * - HW_FTM_FLTCTRL - Fault Control
 * - HW_FTM_QDCTRL - Quadrature Decoder Control And Status
 * - HW_FTM_CONF - Configuration
 * - HW_FTM_FLTPOL - FTM Fault Input Polarity
 * - HW_FTM_SYNCONF - Synchronization Configuration
 * - HW_FTM_INVCTRL - FTM Inverting Control
 * - HW_FTM_SWOCTRL - FTM Software Output Control
 * - HW_FTM_PWMLOAD - FTM PWM Load
 *
 * - hw_ftm_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_FTM_BASE
#define HW_FTM_INSTANCE_COUNT (4U) //!< Number of instances of the FTM module.
#define HW_FTM0 (0U) //!< Instance number for FTM0.
#define HW_FTM1 (1U) //!< Instance number for FTM1.
#define HW_FTM2 (2U) //!< Instance number for FTM2.
#define HW_FTM3 (3U) //!< Instance number for FTM3.
#define REGS_FTM0_BASE (0x40038000U) //!< Base address for FTM0.
#define REGS_FTM1_BASE (0x40039000U) //!< Base address for FTM1.
#define REGS_FTM2_BASE (0x4003A000U) //!< Base address for FTM2.
#define REGS_FTM3_BASE (0x400B9000U) //!< Base address for FTM3.

//! @brief Table of base addresses for FTM instances.
static const uint32_t __g_regs_FTM_base_addresses[] = {
        REGS_FTM0_BASE,
        REGS_FTM1_BASE,
        REGS_FTM2_BASE,
        REGS_FTM3_BASE,
    };

//! @brief Get the base address of FTM by instance number.
//! @param x FTM instance number, from 0 through 3.
#define REGS_FTM_BASE(x) (__g_regs_FTM_base_addresses[(x)])

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of FTM.
#define REGS_FTM_INSTANCE(b) ((b) == REGS_FTM0_BASE ? HW_FTM0 : (b) == REGS_FTM1_BASE ? HW_FTM1 : (b) == REGS_FTM2_BASE ? HW_FTM2 : (b) == REGS_FTM3_BASE ? HW_FTM3 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_SC - Status And Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_SC - Status And Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * SC contains the overflow status flag and control bits used to configure the
 * interrupt enable, FTM configuration, clock source, and prescaler factor. These
 * controls relate to all channels within this module.
 */
typedef union _hw_ftm_sc
{
    uint32_t U;
    struct _hw_ftm_sc_bitfields
    {
        uint32_t PS : 3;               //!< [2:0] Prescale Factor Selection
        uint32_t CLKS : 2;             //!< [4:3] Clock Source Selection
        uint32_t CPWMS : 1;            //!< [5] Center-Aligned PWM Select
        uint32_t TOIE : 1;             //!< [6] Timer Overflow Interrupt Enable
        uint32_t TOF : 1;              //!< [7] Timer Overflow Flag
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_sc_t;
#endif

/*!
 * @name Constants and macros for entire FTM_SC register
 */
//@{
#define HW_FTM_SC_ADDR(x)        (REGS_FTM_BASE(x) + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_SC(x)             (*(__IO hw_ftm_sc_t *) HW_FTM_SC_ADDR(x))
#define HW_FTM_SC_RD(x)          (HW_FTM_SC(x).U)
#define HW_FTM_SC_WR(x, v)       (HW_FTM_SC(x).U = (v))
#define HW_FTM_SC_SET(x, v)      (HW_FTM_SC_WR(x, HW_FTM_SC_RD(x) |  (v)))
#define HW_FTM_SC_CLR(x, v)      (HW_FTM_SC_WR(x, HW_FTM_SC_RD(x) & ~(v)))
#define HW_FTM_SC_TOG(x, v)      (HW_FTM_SC_WR(x, HW_FTM_SC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_SC bitfields
 */

/*!
 * @name Register FTM_SC, field PS[2:0] (RW)
 *
 * Selects one of 8 division factors for the clock source selected by CLKS. The
 * new prescaler factor affects the clock source on the next system clock cycle
 * after the new value is updated into the register bits. This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 000 - Divide by 1
 * - 001 - Divide by 2
 * - 010 - Divide by 4
 * - 011 - Divide by 8
 * - 100 - Divide by 16
 * - 101 - Divide by 32
 * - 110 - Divide by 64
 * - 111 - Divide by 128
 */
//@{
#define BP_FTM_SC_PS         (0U)          //!< Bit position for FTM_SC_PS.
#define BM_FTM_SC_PS         (0x00000007U) //!< Bit mask for FTM_SC_PS.
#define BS_FTM_SC_PS         (3U)          //!< Bit field size in bits for FTM_SC_PS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SC_PS field.
#define BR_FTM_SC_PS(x)      (HW_FTM_SC(x).B.PS)
#endif

//! @brief Format value for bitfield FTM_SC_PS.
#define BF_FTM_SC_PS(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SC_PS), uint32_t) & BM_FTM_SC_PS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PS field to a new value.
#define BW_FTM_SC_PS(x, v)   (HW_FTM_SC_WR(x, (HW_FTM_SC_RD(x) & ~BM_FTM_SC_PS) | BF_FTM_SC_PS(v)))
#endif
//@}

/*!
 * @name Register FTM_SC, field CLKS[4:3] (RW)
 *
 * Selects one of the three FTM counter clock sources. This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 00 - No clock selected. This in effect disables the FTM counter.
 * - 01 - System clock
 * - 10 - Fixed frequency clock
 * - 11 - External clock
 */
//@{
#define BP_FTM_SC_CLKS       (3U)          //!< Bit position for FTM_SC_CLKS.
#define BM_FTM_SC_CLKS       (0x00000018U) //!< Bit mask for FTM_SC_CLKS.
#define BS_FTM_SC_CLKS       (2U)          //!< Bit field size in bits for FTM_SC_CLKS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SC_CLKS field.
#define BR_FTM_SC_CLKS(x)    (HW_FTM_SC(x).B.CLKS)
#endif

//! @brief Format value for bitfield FTM_SC_CLKS.
#define BF_FTM_SC_CLKS(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SC_CLKS), uint32_t) & BM_FTM_SC_CLKS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLKS field to a new value.
#define BW_FTM_SC_CLKS(x, v) (HW_FTM_SC_WR(x, (HW_FTM_SC_RD(x) & ~BM_FTM_SC_CLKS) | BF_FTM_SC_CLKS(v)))
#endif
//@}

/*!
 * @name Register FTM_SC, field CPWMS[5] (RW)
 *
 * Selects CPWM mode. This mode configures the FTM to operate in Up-Down
 * Counting mode. This field is write protected. It can be written only when MODE[WPDIS]
 * = 1.
 *
 * Values:
 * - 0 - FTM counter operates in Up Counting mode.
 * - 1 - FTM counter operates in Up-Down Counting mode.
 */
//@{
#define BP_FTM_SC_CPWMS      (5U)          //!< Bit position for FTM_SC_CPWMS.
#define BM_FTM_SC_CPWMS      (0x00000020U) //!< Bit mask for FTM_SC_CPWMS.
#define BS_FTM_SC_CPWMS      (1U)          //!< Bit field size in bits for FTM_SC_CPWMS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SC_CPWMS field.
#define BR_FTM_SC_CPWMS(x)   (BITBAND_ACCESS32(HW_FTM_SC_ADDR(x), BP_FTM_SC_CPWMS))
#endif

//! @brief Format value for bitfield FTM_SC_CPWMS.
#define BF_FTM_SC_CPWMS(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SC_CPWMS), uint32_t) & BM_FTM_SC_CPWMS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CPWMS field to a new value.
#define BW_FTM_SC_CPWMS(x, v) (BITBAND_ACCESS32(HW_FTM_SC_ADDR(x), BP_FTM_SC_CPWMS) = (v))
#endif
//@}

/*!
 * @name Register FTM_SC, field TOIE[6] (RW)
 *
 * Enables FTM overflow interrupts.
 *
 * Values:
 * - 0 - Disable TOF interrupts. Use software polling.
 * - 1 - Enable TOF interrupts. An interrupt is generated when TOF equals one.
 */
//@{
#define BP_FTM_SC_TOIE       (6U)          //!< Bit position for FTM_SC_TOIE.
#define BM_FTM_SC_TOIE       (0x00000040U) //!< Bit mask for FTM_SC_TOIE.
#define BS_FTM_SC_TOIE       (1U)          //!< Bit field size in bits for FTM_SC_TOIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SC_TOIE field.
#define BR_FTM_SC_TOIE(x)    (BITBAND_ACCESS32(HW_FTM_SC_ADDR(x), BP_FTM_SC_TOIE))
#endif

//! @brief Format value for bitfield FTM_SC_TOIE.
#define BF_FTM_SC_TOIE(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SC_TOIE), uint32_t) & BM_FTM_SC_TOIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOIE field to a new value.
#define BW_FTM_SC_TOIE(x, v) (BITBAND_ACCESS32(HW_FTM_SC_ADDR(x), BP_FTM_SC_TOIE) = (v))
#endif
//@}

/*!
 * @name Register FTM_SC, field TOF[7] (ROWZ)
 *
 * Set by hardware when the FTM counter passes the value in the MOD register.
 * The TOF bit is cleared by reading the SC register while TOF is set and then
 * writing a 0 to TOF bit. Writing a 1 to TOF has no effect. If another FTM overflow
 * occurs between the read and write operations, the write operation has no
 * effect; therefore, TOF remains set indicating an overflow has occurred. In this
 * case, a TOF interrupt request is not lost due to the clearing sequence for a
 * previous TOF.
 *
 * Values:
 * - 0 - FTM counter has not overflowed.
 * - 1 - FTM counter has overflowed.
 */
//@{
#define BP_FTM_SC_TOF        (7U)          //!< Bit position for FTM_SC_TOF.
#define BM_FTM_SC_TOF        (0x00000080U) //!< Bit mask for FTM_SC_TOF.
#define BS_FTM_SC_TOF        (1U)          //!< Bit field size in bits for FTM_SC_TOF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SC_TOF field.
#define BR_FTM_SC_TOF(x)     (BITBAND_ACCESS32(HW_FTM_SC_ADDR(x), BP_FTM_SC_TOF))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_CNT - Counter
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_CNT - Counter (RW)
 *
 * Reset value: 0x00000000U
 *
 * The CNT register contains the FTM counter value. Reset clears the CNT
 * register. Writing any value to COUNT updates the counter with its initial value,
 * CNTIN. When BDM is active, the FTM counter is frozen. This is the value that you
 * may read.
 */
typedef union _hw_ftm_cnt
{
    uint32_t U;
    struct _hw_ftm_cnt_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Counter Value
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_ftm_cnt_t;
#endif

/*!
 * @name Constants and macros for entire FTM_CNT register
 */
//@{
#define HW_FTM_CNT_ADDR(x)       (REGS_FTM_BASE(x) + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_CNT(x)            (*(__IO hw_ftm_cnt_t *) HW_FTM_CNT_ADDR(x))
#define HW_FTM_CNT_RD(x)         (HW_FTM_CNT(x).U)
#define HW_FTM_CNT_WR(x, v)      (HW_FTM_CNT(x).U = (v))
#define HW_FTM_CNT_SET(x, v)     (HW_FTM_CNT_WR(x, HW_FTM_CNT_RD(x) |  (v)))
#define HW_FTM_CNT_CLR(x, v)     (HW_FTM_CNT_WR(x, HW_FTM_CNT_RD(x) & ~(v)))
#define HW_FTM_CNT_TOG(x, v)     (HW_FTM_CNT_WR(x, HW_FTM_CNT_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_CNT bitfields
 */

/*!
 * @name Register FTM_CNT, field COUNT[15:0] (RW)
 */
//@{
#define BP_FTM_CNT_COUNT     (0U)          //!< Bit position for FTM_CNT_COUNT.
#define BM_FTM_CNT_COUNT     (0x0000FFFFU) //!< Bit mask for FTM_CNT_COUNT.
#define BS_FTM_CNT_COUNT     (16U)         //!< Bit field size in bits for FTM_CNT_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CNT_COUNT field.
#define BR_FTM_CNT_COUNT(x)  (HW_FTM_CNT(x).B.COUNT)
#endif

//! @brief Format value for bitfield FTM_CNT_COUNT.
#define BF_FTM_CNT_COUNT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CNT_COUNT), uint32_t) & BM_FTM_CNT_COUNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COUNT field to a new value.
#define BW_FTM_CNT_COUNT(x, v) (HW_FTM_CNT_WR(x, (HW_FTM_CNT_RD(x) & ~BM_FTM_CNT_COUNT) | BF_FTM_CNT_COUNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_MOD - Modulo
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_MOD - Modulo (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Modulo register contains the modulo value for the FTM counter. After the
 * FTM counter reaches the modulo value, the overflow flag (TOF) becomes set at
 * the next clock, and the next value of FTM counter depends on the selected
 * counting method; see Counter. Writing to the MOD register latches the value into a
 * buffer. The MOD register is updated with the value of its write buffer
 * according to Registers updated from write buffers. If FTMEN = 0, this write coherency
 * mechanism may be manually reset by writing to the SC register whether BDM is
 * active or not. Initialize the FTM counter, by writing to CNT, before writing
 * to the MOD register to avoid confusion about when the first counter overflow
 * will occur.
 */
typedef union _hw_ftm_mod
{
    uint32_t U;
    struct _hw_ftm_mod_bitfields
    {
        uint32_t MOD : 16;             //!< [15:0]
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_ftm_mod_t;
#endif

/*!
 * @name Constants and macros for entire FTM_MOD register
 */
//@{
#define HW_FTM_MOD_ADDR(x)       (REGS_FTM_BASE(x) + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_MOD(x)            (*(__IO hw_ftm_mod_t *) HW_FTM_MOD_ADDR(x))
#define HW_FTM_MOD_RD(x)         (HW_FTM_MOD(x).U)
#define HW_FTM_MOD_WR(x, v)      (HW_FTM_MOD(x).U = (v))
#define HW_FTM_MOD_SET(x, v)     (HW_FTM_MOD_WR(x, HW_FTM_MOD_RD(x) |  (v)))
#define HW_FTM_MOD_CLR(x, v)     (HW_FTM_MOD_WR(x, HW_FTM_MOD_RD(x) & ~(v)))
#define HW_FTM_MOD_TOG(x, v)     (HW_FTM_MOD_WR(x, HW_FTM_MOD_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_MOD bitfields
 */

/*!
 * @name Register FTM_MOD, field MOD[15:0] (RW)
 *
 * Modulo Value
 */
//@{
#define BP_FTM_MOD_MOD       (0U)          //!< Bit position for FTM_MOD_MOD.
#define BM_FTM_MOD_MOD       (0x0000FFFFU) //!< Bit mask for FTM_MOD_MOD.
#define BS_FTM_MOD_MOD       (16U)         //!< Bit field size in bits for FTM_MOD_MOD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MOD_MOD field.
#define BR_FTM_MOD_MOD(x)    (HW_FTM_MOD(x).B.MOD)
#endif

//! @brief Format value for bitfield FTM_MOD_MOD.
#define BF_FTM_MOD_MOD(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MOD_MOD), uint32_t) & BM_FTM_MOD_MOD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MOD field to a new value.
#define BW_FTM_MOD_MOD(x, v) (HW_FTM_MOD_WR(x, (HW_FTM_MOD_RD(x) & ~BM_FTM_MOD_MOD) | BF_FTM_MOD_MOD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_CnSC - Channel (n) Status And Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_CnSC - Channel (n) Status And Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * CnSC contains the channel-interrupt-status flag and control bits used to
 * configure the interrupt enable, channel configuration, and pin function. Mode,
 * edge, and level selection DECAPEN COMBINE CPWMS MSnB:MSnA ELSnB:ELSnA Mode
 * Configuration X X X XX 0 Pin not used for FTM-revert the channel pin to general
 * purpose I/O or other peripheral control 0 0 0 0 1 Input Capture Capture on Rising
 * Edge Only 10 Capture on Falling Edge Only 11 Capture on Rising or Falling Edge
 * 1 1 Output Compare Toggle Output on match 10 Clear Output on match 11 Set
 * Output on match 1X 10 Edge-Aligned PWM High-true pulses (clear Output on match)
 * X1 Low-true pulses (set Output on match) 1 XX 10 Center-Aligned PWM High-true
 * pulses (clear Output on match-up) X1 Low-true pulses (set Output on match-up) 1
 * 0 XX 10 Combine PWM High-true pulses (set on channel (n) match, and clear on
 * channel (n+1) match) X1 Low-true pulses (clear on channel (n) match, and set
 * on channel (n+1) match) 1 0 0 X0 See the following table (#ModeSel2Table). Dual
 * Edge Capture One-Shot Capture mode X1 Continuous Capture mode Dual Edge
 * Capture mode - edge polarity selection ELSnB ELSnA Channel Port Enable Detected
 * Edges 0 0 Disabled No edge 0 1 Enabled Rising edge 1 0 Enabled Falling edge 1 1
 * Enabled Rising and falling edges
 */
typedef union _hw_ftm_cnsc
{
    uint32_t U;
    struct _hw_ftm_cnsc_bitfields
    {
        uint32_t DMAb : 1;             //!< [0] DMA Enable
        uint32_t RESERVED0 : 1;        //!< [1]
        uint32_t ELSA : 1;             //!< [2] Edge or Level Select
        uint32_t ELSB : 1;             //!< [3] Edge or Level Select
        uint32_t MSA : 1;              //!< [4] Channel Mode Select
        uint32_t MSB : 1;              //!< [5] Channel Mode Select
        uint32_t CHIE : 1;             //!< [6] Channel Interrupt Enable
        uint32_t CHF : 1;              //!< [7] Channel Flag
        uint32_t RESERVED1 : 24;       //!< [31:8]
    } B;
} hw_ftm_cnsc_t;
#endif

/*!
 * @name Constants and macros for entire FTM_CnSC register
 */
//@{
#define HW_FTM_CnSC_COUNT (8U)

#define HW_FTM_CnSC_ADDR(x, n)   (REGS_FTM_BASE(x) + 0xCU + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FTM_CnSC(x, n)        (*(__IO hw_ftm_cnsc_t *) HW_FTM_CnSC_ADDR(x, n))
#define HW_FTM_CnSC_RD(x, n)     (HW_FTM_CnSC(x, n).U)
#define HW_FTM_CnSC_WR(x, n, v)  (HW_FTM_CnSC(x, n).U = (v))
#define HW_FTM_CnSC_SET(x, n, v) (HW_FTM_CnSC_WR(x, n, HW_FTM_CnSC_RD(x, n) |  (v)))
#define HW_FTM_CnSC_CLR(x, n, v) (HW_FTM_CnSC_WR(x, n, HW_FTM_CnSC_RD(x, n) & ~(v)))
#define HW_FTM_CnSC_TOG(x, n, v) (HW_FTM_CnSC_WR(x, n, HW_FTM_CnSC_RD(x, n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_CnSC bitfields
 */

/*!
 * @name Register FTM_CnSC, field DMA[0] (RW)
 *
 * Enables DMA transfers for the channel.
 *
 * Values:
 * - 0 - Disable DMA transfers.
 * - 1 - Enable DMA transfers.
 */
//@{
#define BP_FTM_CnSC_DMA      (0U)          //!< Bit position for FTM_CnSC_DMA.
#define BM_FTM_CnSC_DMA      (0x00000001U) //!< Bit mask for FTM_CnSC_DMA.
#define BS_FTM_CnSC_DMA      (1U)          //!< Bit field size in bits for FTM_CnSC_DMA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_DMA field.
#define BR_FTM_CnSC_DMA(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_DMA))
#endif

//! @brief Format value for bitfield FTM_CnSC_DMA.
#define BF_FTM_CnSC_DMA(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnSC_DMA), uint32_t) & BM_FTM_CnSC_DMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA field to a new value.
#define BW_FTM_CnSC_DMA(x, n, v) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_DMA) = (v))
#endif
//@}

/*!
 * @name Register FTM_CnSC, field ELSA[2] (RW)
 *
 * The functionality of ELSB and ELSA depends on the channel mode. See
 * #ModeSel1Table. This field is write protected. It can be written only when MODE[WPDIS]
 * = 1.
 */
//@{
#define BP_FTM_CnSC_ELSA     (2U)          //!< Bit position for FTM_CnSC_ELSA.
#define BM_FTM_CnSC_ELSA     (0x00000004U) //!< Bit mask for FTM_CnSC_ELSA.
#define BS_FTM_CnSC_ELSA     (1U)          //!< Bit field size in bits for FTM_CnSC_ELSA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_ELSA field.
#define BR_FTM_CnSC_ELSA(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_ELSA))
#endif

//! @brief Format value for bitfield FTM_CnSC_ELSA.
#define BF_FTM_CnSC_ELSA(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnSC_ELSA), uint32_t) & BM_FTM_CnSC_ELSA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ELSA field to a new value.
#define BW_FTM_CnSC_ELSA(x, n, v) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_ELSA) = (v))
#endif
//@}

/*!
 * @name Register FTM_CnSC, field ELSB[3] (RW)
 *
 * The functionality of ELSB and ELSA depends on the channel mode. See
 * #ModeSel1Table. This field is write protected. It can be written only when MODE[WPDIS]
 * = 1.
 */
//@{
#define BP_FTM_CnSC_ELSB     (3U)          //!< Bit position for FTM_CnSC_ELSB.
#define BM_FTM_CnSC_ELSB     (0x00000008U) //!< Bit mask for FTM_CnSC_ELSB.
#define BS_FTM_CnSC_ELSB     (1U)          //!< Bit field size in bits for FTM_CnSC_ELSB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_ELSB field.
#define BR_FTM_CnSC_ELSB(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_ELSB))
#endif

//! @brief Format value for bitfield FTM_CnSC_ELSB.
#define BF_FTM_CnSC_ELSB(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnSC_ELSB), uint32_t) & BM_FTM_CnSC_ELSB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ELSB field to a new value.
#define BW_FTM_CnSC_ELSB(x, n, v) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_ELSB) = (v))
#endif
//@}

/*!
 * @name Register FTM_CnSC, field MSA[4] (RW)
 *
 * Used for further selections in the channel logic. Its functionality is
 * dependent on the channel mode. See #ModeSel1Table. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 */
//@{
#define BP_FTM_CnSC_MSA      (4U)          //!< Bit position for FTM_CnSC_MSA.
#define BM_FTM_CnSC_MSA      (0x00000010U) //!< Bit mask for FTM_CnSC_MSA.
#define BS_FTM_CnSC_MSA      (1U)          //!< Bit field size in bits for FTM_CnSC_MSA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_MSA field.
#define BR_FTM_CnSC_MSA(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_MSA))
#endif

//! @brief Format value for bitfield FTM_CnSC_MSA.
#define BF_FTM_CnSC_MSA(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnSC_MSA), uint32_t) & BM_FTM_CnSC_MSA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSA field to a new value.
#define BW_FTM_CnSC_MSA(x, n, v) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_MSA) = (v))
#endif
//@}

/*!
 * @name Register FTM_CnSC, field MSB[5] (RW)
 *
 * Used for further selections in the channel logic. Its functionality is
 * dependent on the channel mode. See #ModeSel1Table. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 */
//@{
#define BP_FTM_CnSC_MSB      (5U)          //!< Bit position for FTM_CnSC_MSB.
#define BM_FTM_CnSC_MSB      (0x00000020U) //!< Bit mask for FTM_CnSC_MSB.
#define BS_FTM_CnSC_MSB      (1U)          //!< Bit field size in bits for FTM_CnSC_MSB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_MSB field.
#define BR_FTM_CnSC_MSB(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_MSB))
#endif

//! @brief Format value for bitfield FTM_CnSC_MSB.
#define BF_FTM_CnSC_MSB(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnSC_MSB), uint32_t) & BM_FTM_CnSC_MSB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSB field to a new value.
#define BW_FTM_CnSC_MSB(x, n, v) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_MSB) = (v))
#endif
//@}

/*!
 * @name Register FTM_CnSC, field CHIE[6] (RW)
 *
 * Enables channel interrupts.
 *
 * Values:
 * - 0 - Disable channel interrupts. Use software polling.
 * - 1 - Enable channel interrupts.
 */
//@{
#define BP_FTM_CnSC_CHIE     (6U)          //!< Bit position for FTM_CnSC_CHIE.
#define BM_FTM_CnSC_CHIE     (0x00000040U) //!< Bit mask for FTM_CnSC_CHIE.
#define BS_FTM_CnSC_CHIE     (1U)          //!< Bit field size in bits for FTM_CnSC_CHIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_CHIE field.
#define BR_FTM_CnSC_CHIE(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_CHIE))
#endif

//! @brief Format value for bitfield FTM_CnSC_CHIE.
#define BF_FTM_CnSC_CHIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnSC_CHIE), uint32_t) & BM_FTM_CnSC_CHIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHIE field to a new value.
#define BW_FTM_CnSC_CHIE(x, n, v) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_CHIE) = (v))
#endif
//@}

/*!
 * @name Register FTM_CnSC, field CHF[7] (ROWZ)
 *
 * Set by hardware when an event occurs on the channel. CHF is cleared by
 * reading the CSC register while CHnF is set and then writing a 0 to the CHF bit.
 * Writing a 1 to CHF has no effect. If another event occurs between the read and
 * write operations, the write operation has no effect; therefore, CHF remains set
 * indicating an event has occurred. In this case a CHF interrupt request is not
 * lost due to the clearing sequence for a previous CHF.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_CnSC_CHF      (7U)          //!< Bit position for FTM_CnSC_CHF.
#define BM_FTM_CnSC_CHF      (0x00000080U) //!< Bit mask for FTM_CnSC_CHF.
#define BS_FTM_CnSC_CHF      (1U)          //!< Bit field size in bits for FTM_CnSC_CHF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnSC_CHF field.
#define BR_FTM_CnSC_CHF(x, n) (BITBAND_ACCESS32(HW_FTM_CnSC_ADDR(x, n), BP_FTM_CnSC_CHF))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_FTM_CnV - Channel (n) Value
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_CnV - Channel (n) Value (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers contain the captured FTM counter value for the input modes or
 * the match value for the output modes. In Input Capture, Capture Test, and
 * Dual Edge Capture modes, any write to a CnV register is ignored. In output modes,
 * writing to a CnV register latches the value into a buffer. A CnV register is
 * updated with the value of its write buffer according to Registers updated from
 * write buffers. If FTMEN = 0, this write coherency mechanism may be manually
 * reset by writing to the CnSC register whether BDM mode is active or not.
 */
typedef union _hw_ftm_cnv
{
    uint32_t U;
    struct _hw_ftm_cnv_bitfields
    {
        uint32_t VAL : 16;             //!< [15:0] Channel Value
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_ftm_cnv_t;
#endif

/*!
 * @name Constants and macros for entire FTM_CnV register
 */
//@{
#define HW_FTM_CnV_COUNT (8U)

#define HW_FTM_CnV_ADDR(x, n)    (REGS_FTM_BASE(x) + 0x10U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FTM_CnV(x, n)         (*(__IO hw_ftm_cnv_t *) HW_FTM_CnV_ADDR(x, n))
#define HW_FTM_CnV_RD(x, n)      (HW_FTM_CnV(x, n).U)
#define HW_FTM_CnV_WR(x, n, v)   (HW_FTM_CnV(x, n).U = (v))
#define HW_FTM_CnV_SET(x, n, v)  (HW_FTM_CnV_WR(x, n, HW_FTM_CnV_RD(x, n) |  (v)))
#define HW_FTM_CnV_CLR(x, n, v)  (HW_FTM_CnV_WR(x, n, HW_FTM_CnV_RD(x, n) & ~(v)))
#define HW_FTM_CnV_TOG(x, n, v)  (HW_FTM_CnV_WR(x, n, HW_FTM_CnV_RD(x, n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_CnV bitfields
 */

/*!
 * @name Register FTM_CnV, field VAL[15:0] (RW)
 *
 * Captured FTM counter value of the input modes or the match value for the
 * output modes
 */
//@{
#define BP_FTM_CnV_VAL       (0U)          //!< Bit position for FTM_CnV_VAL.
#define BM_FTM_CnV_VAL       (0x0000FFFFU) //!< Bit mask for FTM_CnV_VAL.
#define BS_FTM_CnV_VAL       (16U)         //!< Bit field size in bits for FTM_CnV_VAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CnV_VAL field.
#define BR_FTM_CnV_VAL(x, n) (HW_FTM_CnV(x, n).B.VAL)
#endif

//! @brief Format value for bitfield FTM_CnV_VAL.
#define BF_FTM_CnV_VAL(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CnV_VAL), uint32_t) & BM_FTM_CnV_VAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VAL field to a new value.
#define BW_FTM_CnV_VAL(x, n, v) (HW_FTM_CnV_WR(x, n, (HW_FTM_CnV_RD(x, n) & ~BM_FTM_CnV_VAL) | BF_FTM_CnV_VAL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_CNTIN - Counter Initial Value
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_CNTIN - Counter Initial Value (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Counter Initial Value register contains the initial value for the FTM
 * counter. Writing to the CNTIN register latches the value into a buffer. The CNTIN
 * register is updated with the value of its write buffer according to Registers
 * updated from write buffers. When the FTM clock is initially selected, by
 * writing a non-zero value to the CLKS bits, the FTM counter starts with the value
 * 0x0000. To avoid this behavior, before the first write to select the FTM clock,
 * write the new value to the the CNTIN register and then initialize the FTM
 * counter by writing any value to the CNT register.
 */
typedef union _hw_ftm_cntin
{
    uint32_t U;
    struct _hw_ftm_cntin_bitfields
    {
        uint32_t INIT : 16;            //!< [15:0]
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_ftm_cntin_t;
#endif

/*!
 * @name Constants and macros for entire FTM_CNTIN register
 */
//@{
#define HW_FTM_CNTIN_ADDR(x)     (REGS_FTM_BASE(x) + 0x4CU)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_CNTIN(x)          (*(__IO hw_ftm_cntin_t *) HW_FTM_CNTIN_ADDR(x))
#define HW_FTM_CNTIN_RD(x)       (HW_FTM_CNTIN(x).U)
#define HW_FTM_CNTIN_WR(x, v)    (HW_FTM_CNTIN(x).U = (v))
#define HW_FTM_CNTIN_SET(x, v)   (HW_FTM_CNTIN_WR(x, HW_FTM_CNTIN_RD(x) |  (v)))
#define HW_FTM_CNTIN_CLR(x, v)   (HW_FTM_CNTIN_WR(x, HW_FTM_CNTIN_RD(x) & ~(v)))
#define HW_FTM_CNTIN_TOG(x, v)   (HW_FTM_CNTIN_WR(x, HW_FTM_CNTIN_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_CNTIN bitfields
 */

/*!
 * @name Register FTM_CNTIN, field INIT[15:0] (RW)
 *
 * Initial Value Of The FTM Counter
 */
//@{
#define BP_FTM_CNTIN_INIT    (0U)          //!< Bit position for FTM_CNTIN_INIT.
#define BM_FTM_CNTIN_INIT    (0x0000FFFFU) //!< Bit mask for FTM_CNTIN_INIT.
#define BS_FTM_CNTIN_INIT    (16U)         //!< Bit field size in bits for FTM_CNTIN_INIT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CNTIN_INIT field.
#define BR_FTM_CNTIN_INIT(x) (HW_FTM_CNTIN(x).B.INIT)
#endif

//! @brief Format value for bitfield FTM_CNTIN_INIT.
#define BF_FTM_CNTIN_INIT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CNTIN_INIT), uint32_t) & BM_FTM_CNTIN_INIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INIT field to a new value.
#define BW_FTM_CNTIN_INIT(x, v) (HW_FTM_CNTIN_WR(x, (HW_FTM_CNTIN_RD(x) & ~BM_FTM_CNTIN_INIT) | BF_FTM_CNTIN_INIT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_STATUS - Capture And Compare Status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_STATUS - Capture And Compare Status (RW)
 *
 * Reset value: 0x00000000U
 *
 * The STATUS register contains a copy of the status flag CHnF bit in CnSC for
 * each FTM channel for software convenience. Each CHnF bit in STATUS is a mirror
 * of CHnF bit in CnSC. All CHnF bits can be checked using only one read of
 * STATUS. All CHnF bits can be cleared by reading STATUS followed by writing 0x00 to
 * STATUS. Hardware sets the individual channel flags when an event occurs on the
 * channel. CHnF is cleared by reading STATUS while CHnF is set and then writing
 * a 0 to the CHnF bit. Writing a 1 to CHnF has no effect. If another event
 * occurs between the read and write operations, the write operation has no effect;
 * therefore, CHnF remains set indicating an event has occurred. In this case, a
 * CHnF interrupt request is not lost due to the clearing sequence for a previous
 * CHnF. The STATUS register should be used only in Combine mode.
 */
typedef union _hw_ftm_status
{
    uint32_t U;
    struct _hw_ftm_status_bitfields
    {
        uint32_t CH0F : 1;             //!< [0] Channel 0 Flag
        uint32_t CH1F : 1;             //!< [1] Channel 1 Flag
        uint32_t CH2F : 1;             //!< [2] Channel 2 Flag
        uint32_t CH3F : 1;             //!< [3] Channel 3 Flag
        uint32_t CH4F : 1;             //!< [4] Channel 4 Flag
        uint32_t CH5F : 1;             //!< [5] Channel 5 Flag
        uint32_t CH6F : 1;             //!< [6] Channel 6 Flag
        uint32_t CH7F : 1;             //!< [7] Channel 7 Flag
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_status_t;
#endif

/*!
 * @name Constants and macros for entire FTM_STATUS register
 */
//@{
#define HW_FTM_STATUS_ADDR(x)    (REGS_FTM_BASE(x) + 0x50U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_STATUS(x)         (*(__IO hw_ftm_status_t *) HW_FTM_STATUS_ADDR(x))
#define HW_FTM_STATUS_RD(x)      (HW_FTM_STATUS(x).U)
#define HW_FTM_STATUS_WR(x, v)   (HW_FTM_STATUS(x).U = (v))
#define HW_FTM_STATUS_SET(x, v)  (HW_FTM_STATUS_WR(x, HW_FTM_STATUS_RD(x) |  (v)))
#define HW_FTM_STATUS_CLR(x, v)  (HW_FTM_STATUS_WR(x, HW_FTM_STATUS_RD(x) & ~(v)))
#define HW_FTM_STATUS_TOG(x, v)  (HW_FTM_STATUS_WR(x, HW_FTM_STATUS_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_STATUS bitfields
 */

/*!
 * @name Register FTM_STATUS, field CH0F[0] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH0F   (0U)          //!< Bit position for FTM_STATUS_CH0F.
#define BM_FTM_STATUS_CH0F   (0x00000001U) //!< Bit mask for FTM_STATUS_CH0F.
#define BS_FTM_STATUS_CH0F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH0F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH0F field.
#define BR_FTM_STATUS_CH0F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH0F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH0F.
#define BF_FTM_STATUS_CH0F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH0F), uint32_t) & BM_FTM_STATUS_CH0F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0F field to a new value.
#define BW_FTM_STATUS_CH0F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH0F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH1F[1] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH1F   (1U)          //!< Bit position for FTM_STATUS_CH1F.
#define BM_FTM_STATUS_CH1F   (0x00000002U) //!< Bit mask for FTM_STATUS_CH1F.
#define BS_FTM_STATUS_CH1F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH1F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH1F field.
#define BR_FTM_STATUS_CH1F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH1F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH1F.
#define BF_FTM_STATUS_CH1F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH1F), uint32_t) & BM_FTM_STATUS_CH1F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1F field to a new value.
#define BW_FTM_STATUS_CH1F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH1F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH2F[2] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH2F   (2U)          //!< Bit position for FTM_STATUS_CH2F.
#define BM_FTM_STATUS_CH2F   (0x00000004U) //!< Bit mask for FTM_STATUS_CH2F.
#define BS_FTM_STATUS_CH2F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH2F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH2F field.
#define BR_FTM_STATUS_CH2F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH2F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH2F.
#define BF_FTM_STATUS_CH2F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH2F), uint32_t) & BM_FTM_STATUS_CH2F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2F field to a new value.
#define BW_FTM_STATUS_CH2F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH2F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH3F[3] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH3F   (3U)          //!< Bit position for FTM_STATUS_CH3F.
#define BM_FTM_STATUS_CH3F   (0x00000008U) //!< Bit mask for FTM_STATUS_CH3F.
#define BS_FTM_STATUS_CH3F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH3F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH3F field.
#define BR_FTM_STATUS_CH3F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH3F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH3F.
#define BF_FTM_STATUS_CH3F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH3F), uint32_t) & BM_FTM_STATUS_CH3F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3F field to a new value.
#define BW_FTM_STATUS_CH3F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH3F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH4F[4] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH4F   (4U)          //!< Bit position for FTM_STATUS_CH4F.
#define BM_FTM_STATUS_CH4F   (0x00000010U) //!< Bit mask for FTM_STATUS_CH4F.
#define BS_FTM_STATUS_CH4F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH4F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH4F field.
#define BR_FTM_STATUS_CH4F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH4F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH4F.
#define BF_FTM_STATUS_CH4F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH4F), uint32_t) & BM_FTM_STATUS_CH4F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4F field to a new value.
#define BW_FTM_STATUS_CH4F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH4F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH5F[5] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH5F   (5U)          //!< Bit position for FTM_STATUS_CH5F.
#define BM_FTM_STATUS_CH5F   (0x00000020U) //!< Bit mask for FTM_STATUS_CH5F.
#define BS_FTM_STATUS_CH5F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH5F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH5F field.
#define BR_FTM_STATUS_CH5F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH5F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH5F.
#define BF_FTM_STATUS_CH5F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH5F), uint32_t) & BM_FTM_STATUS_CH5F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5F field to a new value.
#define BW_FTM_STATUS_CH5F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH5F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH6F[6] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH6F   (6U)          //!< Bit position for FTM_STATUS_CH6F.
#define BM_FTM_STATUS_CH6F   (0x00000040U) //!< Bit mask for FTM_STATUS_CH6F.
#define BS_FTM_STATUS_CH6F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH6F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH6F field.
#define BR_FTM_STATUS_CH6F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH6F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH6F.
#define BF_FTM_STATUS_CH6F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH6F), uint32_t) & BM_FTM_STATUS_CH6F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6F field to a new value.
#define BW_FTM_STATUS_CH6F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH6F) = (v))
#endif
//@}

/*!
 * @name Register FTM_STATUS, field CH7F[7] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
//@{
#define BP_FTM_STATUS_CH7F   (7U)          //!< Bit position for FTM_STATUS_CH7F.
#define BM_FTM_STATUS_CH7F   (0x00000080U) //!< Bit mask for FTM_STATUS_CH7F.
#define BS_FTM_STATUS_CH7F   (1U)          //!< Bit field size in bits for FTM_STATUS_CH7F.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_STATUS_CH7F field.
#define BR_FTM_STATUS_CH7F(x) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH7F))
#endif

//! @brief Format value for bitfield FTM_STATUS_CH7F.
#define BF_FTM_STATUS_CH7F(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_STATUS_CH7F), uint32_t) & BM_FTM_STATUS_CH7F)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7F field to a new value.
#define BW_FTM_STATUS_CH7F(x, v) (BITBAND_ACCESS32(HW_FTM_STATUS_ADDR(x), BP_FTM_STATUS_CH7F) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_MODE - Features Mode Selection
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_MODE - Features Mode Selection (RW)
 *
 * Reset value: 0x00000004U
 *
 * This register contains the global enable bit for FTM-specific features and
 * the control bits used to configure: Fault control mode and interrupt Capture
 * Test mode PWM synchronization Write protection Channel output initialization
 * These controls relate to all channels within this module.
 */
typedef union _hw_ftm_mode
{
    uint32_t U;
    struct _hw_ftm_mode_bitfields
    {
        uint32_t FTMEN : 1;            //!< [0] FTM Enable
        uint32_t INIT : 1;             //!< [1] Initialize The Channels Output
        uint32_t WPDIS : 1;            //!< [2] Write Protection Disable
        uint32_t PWMSYNC : 1;          //!< [3] PWM Synchronization Mode
        uint32_t CAPTEST : 1;          //!< [4] Capture Test Mode Enable
        uint32_t FAULTM : 2;           //!< [6:5] Fault Control Mode
        uint32_t FAULTIE : 1;          //!< [7] Fault Interrupt Enable
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_mode_t;
#endif

/*!
 * @name Constants and macros for entire FTM_MODE register
 */
//@{
#define HW_FTM_MODE_ADDR(x)      (REGS_FTM_BASE(x) + 0x54U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_MODE(x)           (*(__IO hw_ftm_mode_t *) HW_FTM_MODE_ADDR(x))
#define HW_FTM_MODE_RD(x)        (HW_FTM_MODE(x).U)
#define HW_FTM_MODE_WR(x, v)     (HW_FTM_MODE(x).U = (v))
#define HW_FTM_MODE_SET(x, v)    (HW_FTM_MODE_WR(x, HW_FTM_MODE_RD(x) |  (v)))
#define HW_FTM_MODE_CLR(x, v)    (HW_FTM_MODE_WR(x, HW_FTM_MODE_RD(x) & ~(v)))
#define HW_FTM_MODE_TOG(x, v)    (HW_FTM_MODE_WR(x, HW_FTM_MODE_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_MODE bitfields
 */

/*!
 * @name Register FTM_MODE, field FTMEN[0] (RW)
 *
 * This field is write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Only the TPM-compatible registers (first set of registers) can be used
 *     without any restriction. Do not use the FTM-specific registers.
 * - 1 - All registers including the FTM-specific registers (second set of
 *     registers) are available for use with no restrictions.
 */
//@{
#define BP_FTM_MODE_FTMEN    (0U)          //!< Bit position for FTM_MODE_FTMEN.
#define BM_FTM_MODE_FTMEN    (0x00000001U) //!< Bit mask for FTM_MODE_FTMEN.
#define BS_FTM_MODE_FTMEN    (1U)          //!< Bit field size in bits for FTM_MODE_FTMEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_FTMEN field.
#define BR_FTM_MODE_FTMEN(x) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_FTMEN))
#endif

//! @brief Format value for bitfield FTM_MODE_FTMEN.
#define BF_FTM_MODE_FTMEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_FTMEN), uint32_t) & BM_FTM_MODE_FTMEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTMEN field to a new value.
#define BW_FTM_MODE_FTMEN(x, v) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_FTMEN) = (v))
#endif
//@}

/*!
 * @name Register FTM_MODE, field INIT[1] (RW)
 *
 * When a 1 is written to INIT bit the channels output is initialized according
 * to the state of their corresponding bit in the OUTINIT register. Writing a 0
 * to INIT bit has no effect. The INIT bit is always read as 0.
 */
//@{
#define BP_FTM_MODE_INIT     (1U)          //!< Bit position for FTM_MODE_INIT.
#define BM_FTM_MODE_INIT     (0x00000002U) //!< Bit mask for FTM_MODE_INIT.
#define BS_FTM_MODE_INIT     (1U)          //!< Bit field size in bits for FTM_MODE_INIT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_INIT field.
#define BR_FTM_MODE_INIT(x)  (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_INIT))
#endif

//! @brief Format value for bitfield FTM_MODE_INIT.
#define BF_FTM_MODE_INIT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_INIT), uint32_t) & BM_FTM_MODE_INIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INIT field to a new value.
#define BW_FTM_MODE_INIT(x, v) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_INIT) = (v))
#endif
//@}

/*!
 * @name Register FTM_MODE, field WPDIS[2] (RW)
 *
 * When write protection is enabled (WPDIS = 0), write protected bits cannot be
 * written. When write protection is disabled (WPDIS = 1), write protected bits
 * can be written. The WPDIS bit is the negation of the WPEN bit. WPDIS is cleared
 * when 1 is written to WPEN. WPDIS is set when WPEN bit is read as a 1 and then
 * 1 is written to WPDIS. Writing 0 to WPDIS has no effect.
 *
 * Values:
 * - 0 - Write protection is enabled.
 * - 1 - Write protection is disabled.
 */
//@{
#define BP_FTM_MODE_WPDIS    (2U)          //!< Bit position for FTM_MODE_WPDIS.
#define BM_FTM_MODE_WPDIS    (0x00000004U) //!< Bit mask for FTM_MODE_WPDIS.
#define BS_FTM_MODE_WPDIS    (1U)          //!< Bit field size in bits for FTM_MODE_WPDIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_WPDIS field.
#define BR_FTM_MODE_WPDIS(x) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_WPDIS))
#endif

//! @brief Format value for bitfield FTM_MODE_WPDIS.
#define BF_FTM_MODE_WPDIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_WPDIS), uint32_t) & BM_FTM_MODE_WPDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WPDIS field to a new value.
#define BW_FTM_MODE_WPDIS(x, v) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_WPDIS) = (v))
#endif
//@}

/*!
 * @name Register FTM_MODE, field PWMSYNC[3] (RW)
 *
 * Selects which triggers can be used by MOD, CnV, OUTMASK, and FTM counter
 * synchronization. See PWM synchronization. The PWMSYNC bit configures the
 * synchronization when SYNCMODE is 0.
 *
 * Values:
 * - 0 - No restrictions. Software and hardware triggers can be used by MOD,
 *     CnV, OUTMASK, and FTM counter synchronization.
 * - 1 - Software trigger can only be used by MOD and CnV synchronization, and
 *     hardware triggers can only be used by OUTMASK and FTM counter
 *     synchronization.
 */
//@{
#define BP_FTM_MODE_PWMSYNC  (3U)          //!< Bit position for FTM_MODE_PWMSYNC.
#define BM_FTM_MODE_PWMSYNC  (0x00000008U) //!< Bit mask for FTM_MODE_PWMSYNC.
#define BS_FTM_MODE_PWMSYNC  (1U)          //!< Bit field size in bits for FTM_MODE_PWMSYNC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_PWMSYNC field.
#define BR_FTM_MODE_PWMSYNC(x) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_PWMSYNC))
#endif

//! @brief Format value for bitfield FTM_MODE_PWMSYNC.
#define BF_FTM_MODE_PWMSYNC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_PWMSYNC), uint32_t) & BM_FTM_MODE_PWMSYNC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PWMSYNC field to a new value.
#define BW_FTM_MODE_PWMSYNC(x, v) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_PWMSYNC) = (v))
#endif
//@}

/*!
 * @name Register FTM_MODE, field CAPTEST[4] (RW)
 *
 * Enables the capture test mode. This field is write protected. It can be
 * written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Capture test mode is disabled.
 * - 1 - Capture test mode is enabled.
 */
//@{
#define BP_FTM_MODE_CAPTEST  (4U)          //!< Bit position for FTM_MODE_CAPTEST.
#define BM_FTM_MODE_CAPTEST  (0x00000010U) //!< Bit mask for FTM_MODE_CAPTEST.
#define BS_FTM_MODE_CAPTEST  (1U)          //!< Bit field size in bits for FTM_MODE_CAPTEST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_CAPTEST field.
#define BR_FTM_MODE_CAPTEST(x) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_CAPTEST))
#endif

//! @brief Format value for bitfield FTM_MODE_CAPTEST.
#define BF_FTM_MODE_CAPTEST(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_CAPTEST), uint32_t) & BM_FTM_MODE_CAPTEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CAPTEST field to a new value.
#define BW_FTM_MODE_CAPTEST(x, v) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_CAPTEST) = (v))
#endif
//@}

/*!
 * @name Register FTM_MODE, field FAULTM[6:5] (RW)
 *
 * Defines the FTM fault control mode. This field is write protected. It can be
 * written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 00 - Fault control is disabled for all channels.
 * - 01 - Fault control is enabled for even channels only (channels 0, 2, 4, and
 *     6), and the selected mode is the manual fault clearing.
 * - 10 - Fault control is enabled for all channels, and the selected mode is
 *     the manual fault clearing.
 * - 11 - Fault control is enabled for all channels, and the selected mode is
 *     the automatic fault clearing.
 */
//@{
#define BP_FTM_MODE_FAULTM   (5U)          //!< Bit position for FTM_MODE_FAULTM.
#define BM_FTM_MODE_FAULTM   (0x00000060U) //!< Bit mask for FTM_MODE_FAULTM.
#define BS_FTM_MODE_FAULTM   (2U)          //!< Bit field size in bits for FTM_MODE_FAULTM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_FAULTM field.
#define BR_FTM_MODE_FAULTM(x) (HW_FTM_MODE(x).B.FAULTM)
#endif

//! @brief Format value for bitfield FTM_MODE_FAULTM.
#define BF_FTM_MODE_FAULTM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_FAULTM), uint32_t) & BM_FTM_MODE_FAULTM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULTM field to a new value.
#define BW_FTM_MODE_FAULTM(x, v) (HW_FTM_MODE_WR(x, (HW_FTM_MODE_RD(x) & ~BM_FTM_MODE_FAULTM) | BF_FTM_MODE_FAULTM(v)))
#endif
//@}

/*!
 * @name Register FTM_MODE, field FAULTIE[7] (RW)
 *
 * Enables the generation of an interrupt when a fault is detected by FTM and
 * the FTM fault control is enabled.
 *
 * Values:
 * - 0 - Fault control interrupt is disabled.
 * - 1 - Fault control interrupt is enabled.
 */
//@{
#define BP_FTM_MODE_FAULTIE  (7U)          //!< Bit position for FTM_MODE_FAULTIE.
#define BM_FTM_MODE_FAULTIE  (0x00000080U) //!< Bit mask for FTM_MODE_FAULTIE.
#define BS_FTM_MODE_FAULTIE  (1U)          //!< Bit field size in bits for FTM_MODE_FAULTIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_MODE_FAULTIE field.
#define BR_FTM_MODE_FAULTIE(x) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_FAULTIE))
#endif

//! @brief Format value for bitfield FTM_MODE_FAULTIE.
#define BF_FTM_MODE_FAULTIE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_MODE_FAULTIE), uint32_t) & BM_FTM_MODE_FAULTIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULTIE field to a new value.
#define BW_FTM_MODE_FAULTIE(x, v) (BITBAND_ACCESS32(HW_FTM_MODE_ADDR(x), BP_FTM_MODE_FAULTIE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_SYNC - Synchronization
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_SYNC - Synchronization (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register configures the PWM synchronization. A synchronization event can
 * perform the synchronized update of MOD, CV, and OUTMASK registers with the
 * value of their write buffer and the FTM counter initialization. The software
 * trigger, SWSYNC bit, and hardware triggers TRIG0, TRIG1, and TRIG2 bits have a
 * potential conflict if used together when SYNCMODE = 0. Use only hardware or
 * software triggers but not both at the same time, otherwise unpredictable behavior
 * is likely to happen. The selection of the loading point, CNTMAX and CNTMIN
 * bits, is intended to provide the update of MOD, CNTIN, and CnV registers across
 * all enabled channels simultaneously. The use of the loading point selection
 * together with SYNCMODE = 0 and hardware trigger selection, TRIG0, TRIG1, or TRIG2
 * bits, is likely to result in unpredictable behavior. The synchronization
 * event selection also depends on the PWMSYNC (MODE register) and SYNCMODE (SYNCONF
 * register) bits. See PWM synchronization.
 */
typedef union _hw_ftm_sync
{
    uint32_t U;
    struct _hw_ftm_sync_bitfields
    {
        uint32_t CNTMIN : 1;           //!< [0] Minimum Loading Point Enable
        uint32_t CNTMAX : 1;           //!< [1] Maximum Loading Point Enable
        uint32_t REINIT : 1;           //!< [2] FTM Counter Reinitialization By
                                       //! Synchronization (FTM counter synchronization)
        uint32_t SYNCHOM : 1;          //!< [3] Output Mask Synchronization
        uint32_t TRIG0 : 1;            //!< [4] PWM Synchronization Hardware Trigger 0
        uint32_t TRIG1 : 1;            //!< [5] PWM Synchronization Hardware Trigger 1
        uint32_t TRIG2 : 1;            //!< [6] PWM Synchronization Hardware Trigger 2
        uint32_t SWSYNC : 1;           //!< [7] PWM Synchronization Software Trigger
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_sync_t;
#endif

/*!
 * @name Constants and macros for entire FTM_SYNC register
 */
//@{
#define HW_FTM_SYNC_ADDR(x)      (REGS_FTM_BASE(x) + 0x58U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_SYNC(x)           (*(__IO hw_ftm_sync_t *) HW_FTM_SYNC_ADDR(x))
#define HW_FTM_SYNC_RD(x)        (HW_FTM_SYNC(x).U)
#define HW_FTM_SYNC_WR(x, v)     (HW_FTM_SYNC(x).U = (v))
#define HW_FTM_SYNC_SET(x, v)    (HW_FTM_SYNC_WR(x, HW_FTM_SYNC_RD(x) |  (v)))
#define HW_FTM_SYNC_CLR(x, v)    (HW_FTM_SYNC_WR(x, HW_FTM_SYNC_RD(x) & ~(v)))
#define HW_FTM_SYNC_TOG(x, v)    (HW_FTM_SYNC_WR(x, HW_FTM_SYNC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_SYNC bitfields
 */

/*!
 * @name Register FTM_SYNC, field CNTMIN[0] (RW)
 *
 * Selects the minimum loading point to PWM synchronization. See Boundary cycle
 * and loading points. If CNTMIN is one, the selected loading point is when the
 * FTM counter reaches its minimum value (CNTIN register).
 *
 * Values:
 * - 0 - The minimum loading point is disabled.
 * - 1 - The minimum loading point is enabled.
 */
//@{
#define BP_FTM_SYNC_CNTMIN   (0U)          //!< Bit position for FTM_SYNC_CNTMIN.
#define BM_FTM_SYNC_CNTMIN   (0x00000001U) //!< Bit mask for FTM_SYNC_CNTMIN.
#define BS_FTM_SYNC_CNTMIN   (1U)          //!< Bit field size in bits for FTM_SYNC_CNTMIN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_CNTMIN field.
#define BR_FTM_SYNC_CNTMIN(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_CNTMIN))
#endif

//! @brief Format value for bitfield FTM_SYNC_CNTMIN.
#define BF_FTM_SYNC_CNTMIN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_CNTMIN), uint32_t) & BM_FTM_SYNC_CNTMIN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNTMIN field to a new value.
#define BW_FTM_SYNC_CNTMIN(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_CNTMIN) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field CNTMAX[1] (RW)
 *
 * Selects the maximum loading point to PWM synchronization. See Boundary cycle
 * and loading points. If CNTMAX is 1, the selected loading point is when the FTM
 * counter reaches its maximum value (MOD register).
 *
 * Values:
 * - 0 - The maximum loading point is disabled.
 * - 1 - The maximum loading point is enabled.
 */
//@{
#define BP_FTM_SYNC_CNTMAX   (1U)          //!< Bit position for FTM_SYNC_CNTMAX.
#define BM_FTM_SYNC_CNTMAX   (0x00000002U) //!< Bit mask for FTM_SYNC_CNTMAX.
#define BS_FTM_SYNC_CNTMAX   (1U)          //!< Bit field size in bits for FTM_SYNC_CNTMAX.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_CNTMAX field.
#define BR_FTM_SYNC_CNTMAX(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_CNTMAX))
#endif

//! @brief Format value for bitfield FTM_SYNC_CNTMAX.
#define BF_FTM_SYNC_CNTMAX(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_CNTMAX), uint32_t) & BM_FTM_SYNC_CNTMAX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNTMAX field to a new value.
#define BW_FTM_SYNC_CNTMAX(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_CNTMAX) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field REINIT[2] (RW)
 *
 * Determines if the FTM counter is reinitialized when the selected trigger for
 * the synchronization is detected. The REINIT bit configures the synchronization
 * when SYNCMODE is zero.
 *
 * Values:
 * - 0 - FTM counter continues to count normally.
 * - 1 - FTM counter is updated with its initial value when the selected trigger
 *     is detected.
 */
//@{
#define BP_FTM_SYNC_REINIT   (2U)          //!< Bit position for FTM_SYNC_REINIT.
#define BM_FTM_SYNC_REINIT   (0x00000004U) //!< Bit mask for FTM_SYNC_REINIT.
#define BS_FTM_SYNC_REINIT   (1U)          //!< Bit field size in bits for FTM_SYNC_REINIT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_REINIT field.
#define BR_FTM_SYNC_REINIT(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_REINIT))
#endif

//! @brief Format value for bitfield FTM_SYNC_REINIT.
#define BF_FTM_SYNC_REINIT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_REINIT), uint32_t) & BM_FTM_SYNC_REINIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REINIT field to a new value.
#define BW_FTM_SYNC_REINIT(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_REINIT) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field SYNCHOM[3] (RW)
 *
 * Selects when the OUTMASK register is updated with the value of its buffer.
 *
 * Values:
 * - 0 - OUTMASK register is updated with the value of its buffer in all rising
 *     edges of the system clock.
 * - 1 - OUTMASK register is updated with the value of its buffer only by the
 *     PWM synchronization.
 */
//@{
#define BP_FTM_SYNC_SYNCHOM  (3U)          //!< Bit position for FTM_SYNC_SYNCHOM.
#define BM_FTM_SYNC_SYNCHOM  (0x00000008U) //!< Bit mask for FTM_SYNC_SYNCHOM.
#define BS_FTM_SYNC_SYNCHOM  (1U)          //!< Bit field size in bits for FTM_SYNC_SYNCHOM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_SYNCHOM field.
#define BR_FTM_SYNC_SYNCHOM(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_SYNCHOM))
#endif

//! @brief Format value for bitfield FTM_SYNC_SYNCHOM.
#define BF_FTM_SYNC_SYNCHOM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_SYNCHOM), uint32_t) & BM_FTM_SYNC_SYNCHOM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNCHOM field to a new value.
#define BW_FTM_SYNC_SYNCHOM(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_SYNCHOM) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field TRIG0[4] (RW)
 *
 * Enables hardware trigger 0 to the PWM synchronization. Hardware trigger 0
 * occurs when a rising edge is detected at the trigger 0 input signal.
 *
 * Values:
 * - 0 - Trigger is disabled.
 * - 1 - Trigger is enabled.
 */
//@{
#define BP_FTM_SYNC_TRIG0    (4U)          //!< Bit position for FTM_SYNC_TRIG0.
#define BM_FTM_SYNC_TRIG0    (0x00000010U) //!< Bit mask for FTM_SYNC_TRIG0.
#define BS_FTM_SYNC_TRIG0    (1U)          //!< Bit field size in bits for FTM_SYNC_TRIG0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_TRIG0 field.
#define BR_FTM_SYNC_TRIG0(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_TRIG0))
#endif

//! @brief Format value for bitfield FTM_SYNC_TRIG0.
#define BF_FTM_SYNC_TRIG0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_TRIG0), uint32_t) & BM_FTM_SYNC_TRIG0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRIG0 field to a new value.
#define BW_FTM_SYNC_TRIG0(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_TRIG0) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field TRIG1[5] (RW)
 *
 * Enables hardware trigger 1 to the PWM synchronization. Hardware trigger 1
 * happens when a rising edge is detected at the trigger 1 input signal.
 *
 * Values:
 * - 0 - Trigger is disabled.
 * - 1 - Trigger is enabled.
 */
//@{
#define BP_FTM_SYNC_TRIG1    (5U)          //!< Bit position for FTM_SYNC_TRIG1.
#define BM_FTM_SYNC_TRIG1    (0x00000020U) //!< Bit mask for FTM_SYNC_TRIG1.
#define BS_FTM_SYNC_TRIG1    (1U)          //!< Bit field size in bits for FTM_SYNC_TRIG1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_TRIG1 field.
#define BR_FTM_SYNC_TRIG1(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_TRIG1))
#endif

//! @brief Format value for bitfield FTM_SYNC_TRIG1.
#define BF_FTM_SYNC_TRIG1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_TRIG1), uint32_t) & BM_FTM_SYNC_TRIG1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRIG1 field to a new value.
#define BW_FTM_SYNC_TRIG1(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_TRIG1) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field TRIG2[6] (RW)
 *
 * Enables hardware trigger 2 to the PWM synchronization. Hardware trigger 2
 * happens when a rising edge is detected at the trigger 2 input signal.
 *
 * Values:
 * - 0 - Trigger is disabled.
 * - 1 - Trigger is enabled.
 */
//@{
#define BP_FTM_SYNC_TRIG2    (6U)          //!< Bit position for FTM_SYNC_TRIG2.
#define BM_FTM_SYNC_TRIG2    (0x00000040U) //!< Bit mask for FTM_SYNC_TRIG2.
#define BS_FTM_SYNC_TRIG2    (1U)          //!< Bit field size in bits for FTM_SYNC_TRIG2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_TRIG2 field.
#define BR_FTM_SYNC_TRIG2(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_TRIG2))
#endif

//! @brief Format value for bitfield FTM_SYNC_TRIG2.
#define BF_FTM_SYNC_TRIG2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_TRIG2), uint32_t) & BM_FTM_SYNC_TRIG2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRIG2 field to a new value.
#define BW_FTM_SYNC_TRIG2(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_TRIG2) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNC, field SWSYNC[7] (RW)
 *
 * Selects the software trigger as the PWM synchronization trigger. The software
 * trigger happens when a 1 is written to SWSYNC bit.
 *
 * Values:
 * - 0 - Software trigger is not selected.
 * - 1 - Software trigger is selected.
 */
//@{
#define BP_FTM_SYNC_SWSYNC   (7U)          //!< Bit position for FTM_SYNC_SWSYNC.
#define BM_FTM_SYNC_SWSYNC   (0x00000080U) //!< Bit mask for FTM_SYNC_SWSYNC.
#define BS_FTM_SYNC_SWSYNC   (1U)          //!< Bit field size in bits for FTM_SYNC_SWSYNC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNC_SWSYNC field.
#define BR_FTM_SYNC_SWSYNC(x) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_SWSYNC))
#endif

//! @brief Format value for bitfield FTM_SYNC_SWSYNC.
#define BF_FTM_SYNC_SWSYNC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNC_SWSYNC), uint32_t) & BM_FTM_SYNC_SWSYNC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWSYNC field to a new value.
#define BW_FTM_SYNC_SWSYNC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNC_ADDR(x), BP_FTM_SYNC_SWSYNC) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_OUTINIT - Initial State For Channels Output
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_OUTINIT - Initial State For Channels Output (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_ftm_outinit
{
    uint32_t U;
    struct _hw_ftm_outinit_bitfields
    {
        uint32_t CH0OI : 1;            //!< [0] Channel 0 Output Initialization Value
        uint32_t CH1OI : 1;            //!< [1] Channel 1 Output Initialization Value
        uint32_t CH2OI : 1;            //!< [2] Channel 2 Output Initialization Value
        uint32_t CH3OI : 1;            //!< [3] Channel 3 Output Initialization Value
        uint32_t CH4OI : 1;            //!< [4] Channel 4 Output Initialization Value
        uint32_t CH5OI : 1;            //!< [5] Channel 5 Output Initialization Value
        uint32_t CH6OI : 1;            //!< [6] Channel 6 Output Initialization Value
        uint32_t CH7OI : 1;            //!< [7] Channel 7 Output Initialization Value
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_outinit_t;
#endif

/*!
 * @name Constants and macros for entire FTM_OUTINIT register
 */
//@{
#define HW_FTM_OUTINIT_ADDR(x)   (REGS_FTM_BASE(x) + 0x5CU)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_OUTINIT(x)        (*(__IO hw_ftm_outinit_t *) HW_FTM_OUTINIT_ADDR(x))
#define HW_FTM_OUTINIT_RD(x)     (HW_FTM_OUTINIT(x).U)
#define HW_FTM_OUTINIT_WR(x, v)  (HW_FTM_OUTINIT(x).U = (v))
#define HW_FTM_OUTINIT_SET(x, v) (HW_FTM_OUTINIT_WR(x, HW_FTM_OUTINIT_RD(x) |  (v)))
#define HW_FTM_OUTINIT_CLR(x, v) (HW_FTM_OUTINIT_WR(x, HW_FTM_OUTINIT_RD(x) & ~(v)))
#define HW_FTM_OUTINIT_TOG(x, v) (HW_FTM_OUTINIT_WR(x, HW_FTM_OUTINIT_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_OUTINIT bitfields
 */

/*!
 * @name Register FTM_OUTINIT, field CH0OI[0] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH0OI (0U)          //!< Bit position for FTM_OUTINIT_CH0OI.
#define BM_FTM_OUTINIT_CH0OI (0x00000001U) //!< Bit mask for FTM_OUTINIT_CH0OI.
#define BS_FTM_OUTINIT_CH0OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH0OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH0OI field.
#define BR_FTM_OUTINIT_CH0OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH0OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH0OI.
#define BF_FTM_OUTINIT_CH0OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH0OI), uint32_t) & BM_FTM_OUTINIT_CH0OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0OI field to a new value.
#define BW_FTM_OUTINIT_CH0OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH0OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH1OI[1] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH1OI (1U)          //!< Bit position for FTM_OUTINIT_CH1OI.
#define BM_FTM_OUTINIT_CH1OI (0x00000002U) //!< Bit mask for FTM_OUTINIT_CH1OI.
#define BS_FTM_OUTINIT_CH1OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH1OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH1OI field.
#define BR_FTM_OUTINIT_CH1OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH1OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH1OI.
#define BF_FTM_OUTINIT_CH1OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH1OI), uint32_t) & BM_FTM_OUTINIT_CH1OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1OI field to a new value.
#define BW_FTM_OUTINIT_CH1OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH1OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH2OI[2] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH2OI (2U)          //!< Bit position for FTM_OUTINIT_CH2OI.
#define BM_FTM_OUTINIT_CH2OI (0x00000004U) //!< Bit mask for FTM_OUTINIT_CH2OI.
#define BS_FTM_OUTINIT_CH2OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH2OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH2OI field.
#define BR_FTM_OUTINIT_CH2OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH2OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH2OI.
#define BF_FTM_OUTINIT_CH2OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH2OI), uint32_t) & BM_FTM_OUTINIT_CH2OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2OI field to a new value.
#define BW_FTM_OUTINIT_CH2OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH2OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH3OI[3] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH3OI (3U)          //!< Bit position for FTM_OUTINIT_CH3OI.
#define BM_FTM_OUTINIT_CH3OI (0x00000008U) //!< Bit mask for FTM_OUTINIT_CH3OI.
#define BS_FTM_OUTINIT_CH3OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH3OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH3OI field.
#define BR_FTM_OUTINIT_CH3OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH3OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH3OI.
#define BF_FTM_OUTINIT_CH3OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH3OI), uint32_t) & BM_FTM_OUTINIT_CH3OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3OI field to a new value.
#define BW_FTM_OUTINIT_CH3OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH3OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH4OI[4] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH4OI (4U)          //!< Bit position for FTM_OUTINIT_CH4OI.
#define BM_FTM_OUTINIT_CH4OI (0x00000010U) //!< Bit mask for FTM_OUTINIT_CH4OI.
#define BS_FTM_OUTINIT_CH4OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH4OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH4OI field.
#define BR_FTM_OUTINIT_CH4OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH4OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH4OI.
#define BF_FTM_OUTINIT_CH4OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH4OI), uint32_t) & BM_FTM_OUTINIT_CH4OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4OI field to a new value.
#define BW_FTM_OUTINIT_CH4OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH4OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH5OI[5] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH5OI (5U)          //!< Bit position for FTM_OUTINIT_CH5OI.
#define BM_FTM_OUTINIT_CH5OI (0x00000020U) //!< Bit mask for FTM_OUTINIT_CH5OI.
#define BS_FTM_OUTINIT_CH5OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH5OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH5OI field.
#define BR_FTM_OUTINIT_CH5OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH5OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH5OI.
#define BF_FTM_OUTINIT_CH5OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH5OI), uint32_t) & BM_FTM_OUTINIT_CH5OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5OI field to a new value.
#define BW_FTM_OUTINIT_CH5OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH5OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH6OI[6] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH6OI (6U)          //!< Bit position for FTM_OUTINIT_CH6OI.
#define BM_FTM_OUTINIT_CH6OI (0x00000040U) //!< Bit mask for FTM_OUTINIT_CH6OI.
#define BS_FTM_OUTINIT_CH6OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH6OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH6OI field.
#define BR_FTM_OUTINIT_CH6OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH6OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH6OI.
#define BF_FTM_OUTINIT_CH6OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH6OI), uint32_t) & BM_FTM_OUTINIT_CH6OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6OI field to a new value.
#define BW_FTM_OUTINIT_CH6OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH6OI) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTINIT, field CH7OI[7] (RW)
 *
 * Selects the value that is forced into the channel output when the
 * initialization occurs.
 *
 * Values:
 * - 0 - The initialization value is 0.
 * - 1 - The initialization value is 1.
 */
//@{
#define BP_FTM_OUTINIT_CH7OI (7U)          //!< Bit position for FTM_OUTINIT_CH7OI.
#define BM_FTM_OUTINIT_CH7OI (0x00000080U) //!< Bit mask for FTM_OUTINIT_CH7OI.
#define BS_FTM_OUTINIT_CH7OI (1U)          //!< Bit field size in bits for FTM_OUTINIT_CH7OI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTINIT_CH7OI field.
#define BR_FTM_OUTINIT_CH7OI(x) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH7OI))
#endif

//! @brief Format value for bitfield FTM_OUTINIT_CH7OI.
#define BF_FTM_OUTINIT_CH7OI(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTINIT_CH7OI), uint32_t) & BM_FTM_OUTINIT_CH7OI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7OI field to a new value.
#define BW_FTM_OUTINIT_CH7OI(x, v) (BITBAND_ACCESS32(HW_FTM_OUTINIT_ADDR(x), BP_FTM_OUTINIT_CH7OI) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_OUTMASK - Output Mask
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_OUTMASK - Output Mask (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides a mask for each FTM channel. The mask of a channel
 * determines if its output responds, that is, it is masked or not, when a match
 * occurs. This feature is used for BLDC control where the PWM signal is presented
 * to an electric motor at specific times to provide electronic commutation. Any
 * write to the OUTMASK register, stores the value in its write buffer. The
 * register is updated with the value of its write buffer according to PWM
 * synchronization.
 */
typedef union _hw_ftm_outmask
{
    uint32_t U;
    struct _hw_ftm_outmask_bitfields
    {
        uint32_t CH0OM : 1;            //!< [0] Channel 0 Output Mask
        uint32_t CH1OM : 1;            //!< [1] Channel 1 Output Mask
        uint32_t CH2OM : 1;            //!< [2] Channel 2 Output Mask
        uint32_t CH3OM : 1;            //!< [3] Channel 3 Output Mask
        uint32_t CH4OM : 1;            //!< [4] Channel 4 Output Mask
        uint32_t CH5OM : 1;            //!< [5] Channel 5 Output Mask
        uint32_t CH6OM : 1;            //!< [6] Channel 6 Output Mask
        uint32_t CH7OM : 1;            //!< [7] Channel 7 Output Mask
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_outmask_t;
#endif

/*!
 * @name Constants and macros for entire FTM_OUTMASK register
 */
//@{
#define HW_FTM_OUTMASK_ADDR(x)   (REGS_FTM_BASE(x) + 0x60U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_OUTMASK(x)        (*(__IO hw_ftm_outmask_t *) HW_FTM_OUTMASK_ADDR(x))
#define HW_FTM_OUTMASK_RD(x)     (HW_FTM_OUTMASK(x).U)
#define HW_FTM_OUTMASK_WR(x, v)  (HW_FTM_OUTMASK(x).U = (v))
#define HW_FTM_OUTMASK_SET(x, v) (HW_FTM_OUTMASK_WR(x, HW_FTM_OUTMASK_RD(x) |  (v)))
#define HW_FTM_OUTMASK_CLR(x, v) (HW_FTM_OUTMASK_WR(x, HW_FTM_OUTMASK_RD(x) & ~(v)))
#define HW_FTM_OUTMASK_TOG(x, v) (HW_FTM_OUTMASK_WR(x, HW_FTM_OUTMASK_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_OUTMASK bitfields
 */

/*!
 * @name Register FTM_OUTMASK, field CH0OM[0] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH0OM (0U)          //!< Bit position for FTM_OUTMASK_CH0OM.
#define BM_FTM_OUTMASK_CH0OM (0x00000001U) //!< Bit mask for FTM_OUTMASK_CH0OM.
#define BS_FTM_OUTMASK_CH0OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH0OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH0OM field.
#define BR_FTM_OUTMASK_CH0OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH0OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH0OM.
#define BF_FTM_OUTMASK_CH0OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH0OM), uint32_t) & BM_FTM_OUTMASK_CH0OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0OM field to a new value.
#define BW_FTM_OUTMASK_CH0OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH0OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH1OM[1] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH1OM (1U)          //!< Bit position for FTM_OUTMASK_CH1OM.
#define BM_FTM_OUTMASK_CH1OM (0x00000002U) //!< Bit mask for FTM_OUTMASK_CH1OM.
#define BS_FTM_OUTMASK_CH1OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH1OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH1OM field.
#define BR_FTM_OUTMASK_CH1OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH1OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH1OM.
#define BF_FTM_OUTMASK_CH1OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH1OM), uint32_t) & BM_FTM_OUTMASK_CH1OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1OM field to a new value.
#define BW_FTM_OUTMASK_CH1OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH1OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH2OM[2] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH2OM (2U)          //!< Bit position for FTM_OUTMASK_CH2OM.
#define BM_FTM_OUTMASK_CH2OM (0x00000004U) //!< Bit mask for FTM_OUTMASK_CH2OM.
#define BS_FTM_OUTMASK_CH2OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH2OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH2OM field.
#define BR_FTM_OUTMASK_CH2OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH2OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH2OM.
#define BF_FTM_OUTMASK_CH2OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH2OM), uint32_t) & BM_FTM_OUTMASK_CH2OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2OM field to a new value.
#define BW_FTM_OUTMASK_CH2OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH2OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH3OM[3] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH3OM (3U)          //!< Bit position for FTM_OUTMASK_CH3OM.
#define BM_FTM_OUTMASK_CH3OM (0x00000008U) //!< Bit mask for FTM_OUTMASK_CH3OM.
#define BS_FTM_OUTMASK_CH3OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH3OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH3OM field.
#define BR_FTM_OUTMASK_CH3OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH3OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH3OM.
#define BF_FTM_OUTMASK_CH3OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH3OM), uint32_t) & BM_FTM_OUTMASK_CH3OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3OM field to a new value.
#define BW_FTM_OUTMASK_CH3OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH3OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH4OM[4] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH4OM (4U)          //!< Bit position for FTM_OUTMASK_CH4OM.
#define BM_FTM_OUTMASK_CH4OM (0x00000010U) //!< Bit mask for FTM_OUTMASK_CH4OM.
#define BS_FTM_OUTMASK_CH4OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH4OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH4OM field.
#define BR_FTM_OUTMASK_CH4OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH4OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH4OM.
#define BF_FTM_OUTMASK_CH4OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH4OM), uint32_t) & BM_FTM_OUTMASK_CH4OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4OM field to a new value.
#define BW_FTM_OUTMASK_CH4OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH4OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH5OM[5] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH5OM (5U)          //!< Bit position for FTM_OUTMASK_CH5OM.
#define BM_FTM_OUTMASK_CH5OM (0x00000020U) //!< Bit mask for FTM_OUTMASK_CH5OM.
#define BS_FTM_OUTMASK_CH5OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH5OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH5OM field.
#define BR_FTM_OUTMASK_CH5OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH5OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH5OM.
#define BF_FTM_OUTMASK_CH5OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH5OM), uint32_t) & BM_FTM_OUTMASK_CH5OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5OM field to a new value.
#define BW_FTM_OUTMASK_CH5OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH5OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH6OM[6] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH6OM (6U)          //!< Bit position for FTM_OUTMASK_CH6OM.
#define BM_FTM_OUTMASK_CH6OM (0x00000040U) //!< Bit mask for FTM_OUTMASK_CH6OM.
#define BS_FTM_OUTMASK_CH6OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH6OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH6OM field.
#define BR_FTM_OUTMASK_CH6OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH6OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH6OM.
#define BF_FTM_OUTMASK_CH6OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH6OM), uint32_t) & BM_FTM_OUTMASK_CH6OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6OM field to a new value.
#define BW_FTM_OUTMASK_CH6OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH6OM) = (v))
#endif
//@}

/*!
 * @name Register FTM_OUTMASK, field CH7OM[7] (RW)
 *
 * Defines if the channel output is masked or unmasked.
 *
 * Values:
 * - 0 - Channel output is not masked. It continues to operate normally.
 * - 1 - Channel output is masked. It is forced to its inactive state.
 */
//@{
#define BP_FTM_OUTMASK_CH7OM (7U)          //!< Bit position for FTM_OUTMASK_CH7OM.
#define BM_FTM_OUTMASK_CH7OM (0x00000080U) //!< Bit mask for FTM_OUTMASK_CH7OM.
#define BS_FTM_OUTMASK_CH7OM (1U)          //!< Bit field size in bits for FTM_OUTMASK_CH7OM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_OUTMASK_CH7OM field.
#define BR_FTM_OUTMASK_CH7OM(x) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH7OM))
#endif

//! @brief Format value for bitfield FTM_OUTMASK_CH7OM.
#define BF_FTM_OUTMASK_CH7OM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_OUTMASK_CH7OM), uint32_t) & BM_FTM_OUTMASK_CH7OM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7OM field to a new value.
#define BW_FTM_OUTMASK_CH7OM(x, v) (BITBAND_ACCESS32(HW_FTM_OUTMASK_ADDR(x), BP_FTM_OUTMASK_CH7OM) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_COMBINE - Function For Linked Channels
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_COMBINE - Function For Linked Channels (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains the control bits used to configure the fault control,
 * synchronization, deadtime insertion, Dual Edge Capture mode, Complementary,
 * and Combine mode for each pair of channels (n) and (n+1), where n equals 0, 2,
 * 4, and 6.
 */
typedef union _hw_ftm_combine
{
    uint32_t U;
    struct _hw_ftm_combine_bitfields
    {
        uint32_t COMBINE0 : 1;         //!< [0] Combine Channels For n = 0
        uint32_t COMP0 : 1;            //!< [1] Complement Of Channel (n) For n = 0
        uint32_t DECAPEN0 : 1;         //!< [2] Dual Edge Capture Mode Enable For n =
                                       //! 0
        uint32_t DECAP0 : 1;           //!< [3] Dual Edge Capture Mode Captures For n =
                                       //! 0
        uint32_t DTEN0 : 1;            //!< [4] Deadtime Enable For n = 0
        uint32_t SYNCEN0 : 1;          //!< [5] Synchronization Enable For n = 0
        uint32_t FAULTEN0 : 1;         //!< [6] Fault Control Enable For n = 0
        uint32_t RESERVED0 : 1;        //!< [7]
        uint32_t COMBINE1 : 1;         //!< [8] Combine Channels For n = 2
        uint32_t COMP1 : 1;            //!< [9] Complement Of Channel (n) For n = 2
        uint32_t DECAPEN1 : 1;         //!< [10] Dual Edge Capture Mode Enable For n
                                       //! = 2
        uint32_t DECAP1 : 1;           //!< [11] Dual Edge Capture Mode Captures For n
                                       //! = 2
        uint32_t DTEN1 : 1;            //!< [12] Deadtime Enable For n = 2
        uint32_t SYNCEN1 : 1;          //!< [13] Synchronization Enable For n = 2
        uint32_t FAULTEN1 : 1;         //!< [14] Fault Control Enable For n = 2
        uint32_t RESERVED1 : 1;        //!< [15]
        uint32_t COMBINE2 : 1;         //!< [16] Combine Channels For n = 4
        uint32_t COMP2 : 1;            //!< [17] Complement Of Channel (n) For n = 4
        uint32_t DECAPEN2 : 1;         //!< [18] Dual Edge Capture Mode Enable For n
                                       //! = 4
        uint32_t DECAP2 : 1;           //!< [19] Dual Edge Capture Mode Captures For n
                                       //! = 4
        uint32_t DTEN2 : 1;            //!< [20] Deadtime Enable For n = 4
        uint32_t SYNCEN2 : 1;          //!< [21] Synchronization Enable For n = 4
        uint32_t FAULTEN2 : 1;         //!< [22] Fault Control Enable For n = 4
        uint32_t RESERVED2 : 1;        //!< [23]
        uint32_t COMBINE3 : 1;         //!< [24] Combine Channels For n = 6
        uint32_t COMP3 : 1;            //!< [25] Complement Of Channel (n) for n = 6
        uint32_t DECAPEN3 : 1;         //!< [26] Dual Edge Capture Mode Enable For n
                                       //! = 6
        uint32_t DECAP3 : 1;           //!< [27] Dual Edge Capture Mode Captures For n
                                       //! = 6
        uint32_t DTEN3 : 1;            //!< [28] Deadtime Enable For n = 6
        uint32_t SYNCEN3 : 1;          //!< [29] Synchronization Enable For n = 6
        uint32_t FAULTEN3 : 1;         //!< [30] Fault Control Enable For n = 6
        uint32_t RESERVED3 : 1;        //!< [31]
    } B;
} hw_ftm_combine_t;
#endif

/*!
 * @name Constants and macros for entire FTM_COMBINE register
 */
//@{
#define HW_FTM_COMBINE_ADDR(x)   (REGS_FTM_BASE(x) + 0x64U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_COMBINE(x)        (*(__IO hw_ftm_combine_t *) HW_FTM_COMBINE_ADDR(x))
#define HW_FTM_COMBINE_RD(x)     (HW_FTM_COMBINE(x).U)
#define HW_FTM_COMBINE_WR(x, v)  (HW_FTM_COMBINE(x).U = (v))
#define HW_FTM_COMBINE_SET(x, v) (HW_FTM_COMBINE_WR(x, HW_FTM_COMBINE_RD(x) |  (v)))
#define HW_FTM_COMBINE_CLR(x, v) (HW_FTM_COMBINE_WR(x, HW_FTM_COMBINE_RD(x) & ~(v)))
#define HW_FTM_COMBINE_TOG(x, v) (HW_FTM_COMBINE_WR(x, HW_FTM_COMBINE_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_COMBINE bitfields
 */

/*!
 * @name Register FTM_COMBINE, field COMBINE0[0] (RW)
 *
 * Enables the combine feature for channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Channels (n) and (n+1) are independent.
 * - 1 - Channels (n) and (n+1) are combined.
 */
//@{
#define BP_FTM_COMBINE_COMBINE0 (0U)       //!< Bit position for FTM_COMBINE_COMBINE0.
#define BM_FTM_COMBINE_COMBINE0 (0x00000001U) //!< Bit mask for FTM_COMBINE_COMBINE0.
#define BS_FTM_COMBINE_COMBINE0 (1U)       //!< Bit field size in bits for FTM_COMBINE_COMBINE0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMBINE0 field.
#define BR_FTM_COMBINE_COMBINE0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMBINE0.
#define BF_FTM_COMBINE_COMBINE0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMBINE0), uint32_t) & BM_FTM_COMBINE_COMBINE0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMBINE0 field to a new value.
#define BW_FTM_COMBINE_COMBINE0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMP0[1] (RW)
 *
 * Enables Complementary mode for the combined channels. In Complementary mode
 * the channel (n+1) output is the inverse of the channel (n) output. This field
 * is write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel (n+1) output is the same as the channel (n) output.
 * - 1 - The channel (n+1) output is the complement of the channel (n) output.
 */
//@{
#define BP_FTM_COMBINE_COMP0 (1U)          //!< Bit position for FTM_COMBINE_COMP0.
#define BM_FTM_COMBINE_COMP0 (0x00000002U) //!< Bit mask for FTM_COMBINE_COMP0.
#define BS_FTM_COMBINE_COMP0 (1U)          //!< Bit field size in bits for FTM_COMBINE_COMP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMP0 field.
#define BR_FTM_COMBINE_COMP0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMP0.
#define BF_FTM_COMBINE_COMP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMP0), uint32_t) & BM_FTM_COMBINE_COMP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMP0 field to a new value.
#define BW_FTM_COMBINE_COMP0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAPEN0[2] (RW)
 *
 * Enables the Dual Edge Capture mode in the channels (n) and (n+1). This bit
 * reconfigures the function of MSnA, ELSnB:ELSnA and ELS(n+1)B:ELS(n+1)A bits in
 * Dual Edge Capture mode according to #ModeSel1Table. This field applies only
 * when FTMEN = 1. This field is write protected. It can be written only when
 * MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The Dual Edge Capture mode in this pair of channels is disabled.
 * - 1 - The Dual Edge Capture mode in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DECAPEN0 (2U)       //!< Bit position for FTM_COMBINE_DECAPEN0.
#define BM_FTM_COMBINE_DECAPEN0 (0x00000004U) //!< Bit mask for FTM_COMBINE_DECAPEN0.
#define BS_FTM_COMBINE_DECAPEN0 (1U)       //!< Bit field size in bits for FTM_COMBINE_DECAPEN0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAPEN0 field.
#define BR_FTM_COMBINE_DECAPEN0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAPEN0.
#define BF_FTM_COMBINE_DECAPEN0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAPEN0), uint32_t) & BM_FTM_COMBINE_DECAPEN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAPEN0 field to a new value.
#define BW_FTM_COMBINE_DECAPEN0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAP0[3] (RW)
 *
 * Enables the capture of the FTM counter value according to the channel (n)
 * input event and the configuration of the dual edge capture bits. This field
 * applies only when FTMEN = 1 and DECAPEN = 1. DECAP bit is cleared automatically by
 * hardware if dual edge capture - one-shot mode is selected and when the capture
 * of channel (n+1) event is made.
 *
 * Values:
 * - 0 - The dual edge captures are inactive.
 * - 1 - The dual edge captures are active.
 */
//@{
#define BP_FTM_COMBINE_DECAP0 (3U)         //!< Bit position for FTM_COMBINE_DECAP0.
#define BM_FTM_COMBINE_DECAP0 (0x00000008U) //!< Bit mask for FTM_COMBINE_DECAP0.
#define BS_FTM_COMBINE_DECAP0 (1U)         //!< Bit field size in bits for FTM_COMBINE_DECAP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAP0 field.
#define BR_FTM_COMBINE_DECAP0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAP0.
#define BF_FTM_COMBINE_DECAP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAP0), uint32_t) & BM_FTM_COMBINE_DECAP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAP0 field to a new value.
#define BW_FTM_COMBINE_DECAP0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DTEN0[4] (RW)
 *
 * Enables the deadtime insertion in the channels (n) and (n+1). This field is
 * write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The deadtime insertion in this pair of channels is disabled.
 * - 1 - The deadtime insertion in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DTEN0 (4U)          //!< Bit position for FTM_COMBINE_DTEN0.
#define BM_FTM_COMBINE_DTEN0 (0x00000010U) //!< Bit mask for FTM_COMBINE_DTEN0.
#define BS_FTM_COMBINE_DTEN0 (1U)          //!< Bit field size in bits for FTM_COMBINE_DTEN0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DTEN0 field.
#define BR_FTM_COMBINE_DTEN0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DTEN0.
#define BF_FTM_COMBINE_DTEN0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DTEN0), uint32_t) & BM_FTM_COMBINE_DTEN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTEN0 field to a new value.
#define BW_FTM_COMBINE_DTEN0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field SYNCEN0[5] (RW)
 *
 * Enables PWM synchronization of registers C(n)V and C(n+1)V.
 *
 * Values:
 * - 0 - The PWM synchronization in this pair of channels is disabled.
 * - 1 - The PWM synchronization in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_SYNCEN0 (5U)        //!< Bit position for FTM_COMBINE_SYNCEN0.
#define BM_FTM_COMBINE_SYNCEN0 (0x00000020U) //!< Bit mask for FTM_COMBINE_SYNCEN0.
#define BS_FTM_COMBINE_SYNCEN0 (1U)        //!< Bit field size in bits for FTM_COMBINE_SYNCEN0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_SYNCEN0 field.
#define BR_FTM_COMBINE_SYNCEN0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_SYNCEN0.
#define BF_FTM_COMBINE_SYNCEN0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_SYNCEN0), uint32_t) & BM_FTM_COMBINE_SYNCEN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNCEN0 field to a new value.
#define BW_FTM_COMBINE_SYNCEN0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field FAULTEN0[6] (RW)
 *
 * Enables the fault control in channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault control in this pair of channels is disabled.
 * - 1 - The fault control in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_FAULTEN0 (6U)       //!< Bit position for FTM_COMBINE_FAULTEN0.
#define BM_FTM_COMBINE_FAULTEN0 (0x00000040U) //!< Bit mask for FTM_COMBINE_FAULTEN0.
#define BS_FTM_COMBINE_FAULTEN0 (1U)       //!< Bit field size in bits for FTM_COMBINE_FAULTEN0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_FAULTEN0 field.
#define BR_FTM_COMBINE_FAULTEN0(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN0))
#endif

//! @brief Format value for bitfield FTM_COMBINE_FAULTEN0.
#define BF_FTM_COMBINE_FAULTEN0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_FAULTEN0), uint32_t) & BM_FTM_COMBINE_FAULTEN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULTEN0 field to a new value.
#define BW_FTM_COMBINE_FAULTEN0(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN0) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMBINE1[8] (RW)
 *
 * Enables the combine feature for channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Channels (n) and (n+1) are independent.
 * - 1 - Channels (n) and (n+1) are combined.
 */
//@{
#define BP_FTM_COMBINE_COMBINE1 (8U)       //!< Bit position for FTM_COMBINE_COMBINE1.
#define BM_FTM_COMBINE_COMBINE1 (0x00000100U) //!< Bit mask for FTM_COMBINE_COMBINE1.
#define BS_FTM_COMBINE_COMBINE1 (1U)       //!< Bit field size in bits for FTM_COMBINE_COMBINE1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMBINE1 field.
#define BR_FTM_COMBINE_COMBINE1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMBINE1.
#define BF_FTM_COMBINE_COMBINE1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMBINE1), uint32_t) & BM_FTM_COMBINE_COMBINE1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMBINE1 field to a new value.
#define BW_FTM_COMBINE_COMBINE1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMP1[9] (RW)
 *
 * Enables Complementary mode for the combined channels. In Complementary mode
 * the channel (n+1) output is the inverse of the channel (n) output. This field
 * is write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel (n+1) output is the same as the channel (n) output.
 * - 1 - The channel (n+1) output is the complement of the channel (n) output.
 */
//@{
#define BP_FTM_COMBINE_COMP1 (9U)          //!< Bit position for FTM_COMBINE_COMP1.
#define BM_FTM_COMBINE_COMP1 (0x00000200U) //!< Bit mask for FTM_COMBINE_COMP1.
#define BS_FTM_COMBINE_COMP1 (1U)          //!< Bit field size in bits for FTM_COMBINE_COMP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMP1 field.
#define BR_FTM_COMBINE_COMP1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMP1.
#define BF_FTM_COMBINE_COMP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMP1), uint32_t) & BM_FTM_COMBINE_COMP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMP1 field to a new value.
#define BW_FTM_COMBINE_COMP1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAPEN1[10] (RW)
 *
 * Enables the Dual Edge Capture mode in the channels (n) and (n+1). This bit
 * reconfigures the function of MSnA, ELSnB:ELSnA and ELS(n+1)B:ELS(n+1)A bits in
 * Dual Edge Capture mode according to #ModeSel1Table. This field applies only
 * when FTMEN = 1. This field is write protected. It can be written only when
 * MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The Dual Edge Capture mode in this pair of channels is disabled.
 * - 1 - The Dual Edge Capture mode in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DECAPEN1 (10U)      //!< Bit position for FTM_COMBINE_DECAPEN1.
#define BM_FTM_COMBINE_DECAPEN1 (0x00000400U) //!< Bit mask for FTM_COMBINE_DECAPEN1.
#define BS_FTM_COMBINE_DECAPEN1 (1U)       //!< Bit field size in bits for FTM_COMBINE_DECAPEN1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAPEN1 field.
#define BR_FTM_COMBINE_DECAPEN1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAPEN1.
#define BF_FTM_COMBINE_DECAPEN1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAPEN1), uint32_t) & BM_FTM_COMBINE_DECAPEN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAPEN1 field to a new value.
#define BW_FTM_COMBINE_DECAPEN1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAP1[11] (RW)
 *
 * Enables the capture of the FTM counter value according to the channel (n)
 * input event and the configuration of the dual edge capture bits. This field
 * applies only when FTMEN = 1 and DECAPEN = 1. DECAP bit is cleared automatically by
 * hardware if Dual Edge Capture - One-Shot mode is selected and when the capture
 * of channel (n+1) event is made.
 *
 * Values:
 * - 0 - The dual edge captures are inactive.
 * - 1 - The dual edge captures are active.
 */
//@{
#define BP_FTM_COMBINE_DECAP1 (11U)        //!< Bit position for FTM_COMBINE_DECAP1.
#define BM_FTM_COMBINE_DECAP1 (0x00000800U) //!< Bit mask for FTM_COMBINE_DECAP1.
#define BS_FTM_COMBINE_DECAP1 (1U)         //!< Bit field size in bits for FTM_COMBINE_DECAP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAP1 field.
#define BR_FTM_COMBINE_DECAP1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAP1.
#define BF_FTM_COMBINE_DECAP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAP1), uint32_t) & BM_FTM_COMBINE_DECAP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAP1 field to a new value.
#define BW_FTM_COMBINE_DECAP1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DTEN1[12] (RW)
 *
 * Enables the deadtime insertion in the channels (n) and (n+1). This field is
 * write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The deadtime insertion in this pair of channels is disabled.
 * - 1 - The deadtime insertion in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DTEN1 (12U)         //!< Bit position for FTM_COMBINE_DTEN1.
#define BM_FTM_COMBINE_DTEN1 (0x00001000U) //!< Bit mask for FTM_COMBINE_DTEN1.
#define BS_FTM_COMBINE_DTEN1 (1U)          //!< Bit field size in bits for FTM_COMBINE_DTEN1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DTEN1 field.
#define BR_FTM_COMBINE_DTEN1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DTEN1.
#define BF_FTM_COMBINE_DTEN1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DTEN1), uint32_t) & BM_FTM_COMBINE_DTEN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTEN1 field to a new value.
#define BW_FTM_COMBINE_DTEN1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field SYNCEN1[13] (RW)
 *
 * Enables PWM synchronization of registers C(n)V and C(n+1)V.
 *
 * Values:
 * - 0 - The PWM synchronization in this pair of channels is disabled.
 * - 1 - The PWM synchronization in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_SYNCEN1 (13U)       //!< Bit position for FTM_COMBINE_SYNCEN1.
#define BM_FTM_COMBINE_SYNCEN1 (0x00002000U) //!< Bit mask for FTM_COMBINE_SYNCEN1.
#define BS_FTM_COMBINE_SYNCEN1 (1U)        //!< Bit field size in bits for FTM_COMBINE_SYNCEN1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_SYNCEN1 field.
#define BR_FTM_COMBINE_SYNCEN1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_SYNCEN1.
#define BF_FTM_COMBINE_SYNCEN1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_SYNCEN1), uint32_t) & BM_FTM_COMBINE_SYNCEN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNCEN1 field to a new value.
#define BW_FTM_COMBINE_SYNCEN1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field FAULTEN1[14] (RW)
 *
 * Enables the fault control in channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault control in this pair of channels is disabled.
 * - 1 - The fault control in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_FAULTEN1 (14U)      //!< Bit position for FTM_COMBINE_FAULTEN1.
#define BM_FTM_COMBINE_FAULTEN1 (0x00004000U) //!< Bit mask for FTM_COMBINE_FAULTEN1.
#define BS_FTM_COMBINE_FAULTEN1 (1U)       //!< Bit field size in bits for FTM_COMBINE_FAULTEN1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_FAULTEN1 field.
#define BR_FTM_COMBINE_FAULTEN1(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN1))
#endif

//! @brief Format value for bitfield FTM_COMBINE_FAULTEN1.
#define BF_FTM_COMBINE_FAULTEN1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_FAULTEN1), uint32_t) & BM_FTM_COMBINE_FAULTEN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULTEN1 field to a new value.
#define BW_FTM_COMBINE_FAULTEN1(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN1) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMBINE2[16] (RW)
 *
 * Enables the combine feature for channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Channels (n) and (n+1) are independent.
 * - 1 - Channels (n) and (n+1) are combined.
 */
//@{
#define BP_FTM_COMBINE_COMBINE2 (16U)      //!< Bit position for FTM_COMBINE_COMBINE2.
#define BM_FTM_COMBINE_COMBINE2 (0x00010000U) //!< Bit mask for FTM_COMBINE_COMBINE2.
#define BS_FTM_COMBINE_COMBINE2 (1U)       //!< Bit field size in bits for FTM_COMBINE_COMBINE2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMBINE2 field.
#define BR_FTM_COMBINE_COMBINE2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMBINE2.
#define BF_FTM_COMBINE_COMBINE2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMBINE2), uint32_t) & BM_FTM_COMBINE_COMBINE2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMBINE2 field to a new value.
#define BW_FTM_COMBINE_COMBINE2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMP2[17] (RW)
 *
 * Enables Complementary mode for the combined channels. In Complementary mode
 * the channel (n+1) output is the inverse of the channel (n) output. This field
 * is write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel (n+1) output is the same as the channel (n) output.
 * - 1 - The channel (n+1) output is the complement of the channel (n) output.
 */
//@{
#define BP_FTM_COMBINE_COMP2 (17U)         //!< Bit position for FTM_COMBINE_COMP2.
#define BM_FTM_COMBINE_COMP2 (0x00020000U) //!< Bit mask for FTM_COMBINE_COMP2.
#define BS_FTM_COMBINE_COMP2 (1U)          //!< Bit field size in bits for FTM_COMBINE_COMP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMP2 field.
#define BR_FTM_COMBINE_COMP2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMP2.
#define BF_FTM_COMBINE_COMP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMP2), uint32_t) & BM_FTM_COMBINE_COMP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMP2 field to a new value.
#define BW_FTM_COMBINE_COMP2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAPEN2[18] (RW)
 *
 * Enables the Dual Edge Capture mode in the channels (n) and (n+1). This bit
 * reconfigures the function of MSnA, ELSnB:ELSnA and ELS(n+1)B:ELS(n+1)A bits in
 * Dual Edge Capture mode according to #ModeSel1Table. This field applies only
 * when FTMEN = 1. This field is write protected. It can be written only when
 * MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The Dual Edge Capture mode in this pair of channels is disabled.
 * - 1 - The Dual Edge Capture mode in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DECAPEN2 (18U)      //!< Bit position for FTM_COMBINE_DECAPEN2.
#define BM_FTM_COMBINE_DECAPEN2 (0x00040000U) //!< Bit mask for FTM_COMBINE_DECAPEN2.
#define BS_FTM_COMBINE_DECAPEN2 (1U)       //!< Bit field size in bits for FTM_COMBINE_DECAPEN2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAPEN2 field.
#define BR_FTM_COMBINE_DECAPEN2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAPEN2.
#define BF_FTM_COMBINE_DECAPEN2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAPEN2), uint32_t) & BM_FTM_COMBINE_DECAPEN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAPEN2 field to a new value.
#define BW_FTM_COMBINE_DECAPEN2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAP2[19] (RW)
 *
 * Enables the capture of the FTM counter value according to the channel (n)
 * input event and the configuration of the dual edge capture bits. This field
 * applies only when FTMEN = 1 and DECAPEN = 1. DECAP bit is cleared automatically by
 * hardware if dual edge capture - one-shot mode is selected and when the capture
 * of channel (n+1) event is made.
 *
 * Values:
 * - 0 - The dual edge captures are inactive.
 * - 1 - The dual edge captures are active.
 */
//@{
#define BP_FTM_COMBINE_DECAP2 (19U)        //!< Bit position for FTM_COMBINE_DECAP2.
#define BM_FTM_COMBINE_DECAP2 (0x00080000U) //!< Bit mask for FTM_COMBINE_DECAP2.
#define BS_FTM_COMBINE_DECAP2 (1U)         //!< Bit field size in bits for FTM_COMBINE_DECAP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAP2 field.
#define BR_FTM_COMBINE_DECAP2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAP2.
#define BF_FTM_COMBINE_DECAP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAP2), uint32_t) & BM_FTM_COMBINE_DECAP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAP2 field to a new value.
#define BW_FTM_COMBINE_DECAP2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DTEN2[20] (RW)
 *
 * Enables the deadtime insertion in the channels (n) and (n+1). This field is
 * write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The deadtime insertion in this pair of channels is disabled.
 * - 1 - The deadtime insertion in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DTEN2 (20U)         //!< Bit position for FTM_COMBINE_DTEN2.
#define BM_FTM_COMBINE_DTEN2 (0x00100000U) //!< Bit mask for FTM_COMBINE_DTEN2.
#define BS_FTM_COMBINE_DTEN2 (1U)          //!< Bit field size in bits for FTM_COMBINE_DTEN2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DTEN2 field.
#define BR_FTM_COMBINE_DTEN2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DTEN2.
#define BF_FTM_COMBINE_DTEN2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DTEN2), uint32_t) & BM_FTM_COMBINE_DTEN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTEN2 field to a new value.
#define BW_FTM_COMBINE_DTEN2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field SYNCEN2[21] (RW)
 *
 * Enables PWM synchronization of registers C(n)V and C(n+1)V.
 *
 * Values:
 * - 0 - The PWM synchronization in this pair of channels is disabled.
 * - 1 - The PWM synchronization in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_SYNCEN2 (21U)       //!< Bit position for FTM_COMBINE_SYNCEN2.
#define BM_FTM_COMBINE_SYNCEN2 (0x00200000U) //!< Bit mask for FTM_COMBINE_SYNCEN2.
#define BS_FTM_COMBINE_SYNCEN2 (1U)        //!< Bit field size in bits for FTM_COMBINE_SYNCEN2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_SYNCEN2 field.
#define BR_FTM_COMBINE_SYNCEN2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_SYNCEN2.
#define BF_FTM_COMBINE_SYNCEN2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_SYNCEN2), uint32_t) & BM_FTM_COMBINE_SYNCEN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNCEN2 field to a new value.
#define BW_FTM_COMBINE_SYNCEN2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field FAULTEN2[22] (RW)
 *
 * Enables the fault control in channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault control in this pair of channels is disabled.
 * - 1 - The fault control in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_FAULTEN2 (22U)      //!< Bit position for FTM_COMBINE_FAULTEN2.
#define BM_FTM_COMBINE_FAULTEN2 (0x00400000U) //!< Bit mask for FTM_COMBINE_FAULTEN2.
#define BS_FTM_COMBINE_FAULTEN2 (1U)       //!< Bit field size in bits for FTM_COMBINE_FAULTEN2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_FAULTEN2 field.
#define BR_FTM_COMBINE_FAULTEN2(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN2))
#endif

//! @brief Format value for bitfield FTM_COMBINE_FAULTEN2.
#define BF_FTM_COMBINE_FAULTEN2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_FAULTEN2), uint32_t) & BM_FTM_COMBINE_FAULTEN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULTEN2 field to a new value.
#define BW_FTM_COMBINE_FAULTEN2(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN2) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMBINE3[24] (RW)
 *
 * Enables the combine feature for channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Channels (n) and (n+1) are independent.
 * - 1 - Channels (n) and (n+1) are combined.
 */
//@{
#define BP_FTM_COMBINE_COMBINE3 (24U)      //!< Bit position for FTM_COMBINE_COMBINE3.
#define BM_FTM_COMBINE_COMBINE3 (0x01000000U) //!< Bit mask for FTM_COMBINE_COMBINE3.
#define BS_FTM_COMBINE_COMBINE3 (1U)       //!< Bit field size in bits for FTM_COMBINE_COMBINE3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMBINE3 field.
#define BR_FTM_COMBINE_COMBINE3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMBINE3.
#define BF_FTM_COMBINE_COMBINE3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMBINE3), uint32_t) & BM_FTM_COMBINE_COMBINE3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMBINE3 field to a new value.
#define BW_FTM_COMBINE_COMBINE3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMBINE3) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field COMP3[25] (RW)
 *
 * Enables Complementary mode for the combined channels. In Complementary mode
 * the channel (n+1) output is the inverse of the channel (n) output. This field
 * is write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel (n+1) output is the same as the channel (n) output.
 * - 1 - The channel (n+1) output is the complement of the channel (n) output.
 */
//@{
#define BP_FTM_COMBINE_COMP3 (25U)         //!< Bit position for FTM_COMBINE_COMP3.
#define BM_FTM_COMBINE_COMP3 (0x02000000U) //!< Bit mask for FTM_COMBINE_COMP3.
#define BS_FTM_COMBINE_COMP3 (1U)          //!< Bit field size in bits for FTM_COMBINE_COMP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_COMP3 field.
#define BR_FTM_COMBINE_COMP3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_COMP3.
#define BF_FTM_COMBINE_COMP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_COMP3), uint32_t) & BM_FTM_COMBINE_COMP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMP3 field to a new value.
#define BW_FTM_COMBINE_COMP3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_COMP3) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAPEN3[26] (RW)
 *
 * Enables the Dual Edge Capture mode in the channels (n) and (n+1). This bit
 * reconfigures the function of MSnA, ELSnB:ELSnA and ELS(n+1)B:ELS(n+1)A bits in
 * Dual Edge Capture mode according to #ModeSel1Table. This field applies only
 * when FTMEN = 1. This field is write protected. It can be written only when
 * MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The Dual Edge Capture mode in this pair of channels is disabled.
 * - 1 - The Dual Edge Capture mode in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DECAPEN3 (26U)      //!< Bit position for FTM_COMBINE_DECAPEN3.
#define BM_FTM_COMBINE_DECAPEN3 (0x04000000U) //!< Bit mask for FTM_COMBINE_DECAPEN3.
#define BS_FTM_COMBINE_DECAPEN3 (1U)       //!< Bit field size in bits for FTM_COMBINE_DECAPEN3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAPEN3 field.
#define BR_FTM_COMBINE_DECAPEN3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAPEN3.
#define BF_FTM_COMBINE_DECAPEN3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAPEN3), uint32_t) & BM_FTM_COMBINE_DECAPEN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAPEN3 field to a new value.
#define BW_FTM_COMBINE_DECAPEN3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAPEN3) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DECAP3[27] (RW)
 *
 * Enables the capture of the FTM counter value according to the channel (n)
 * input event and the configuration of the dual edge capture bits. This field
 * applies only when FTMEN = 1 and DECAPEN = 1. DECAP bit is cleared automatically by
 * hardware if dual edge capture - one-shot mode is selected and when the capture
 * of channel (n+1) event is made.
 *
 * Values:
 * - 0 - The dual edge captures are inactive.
 * - 1 - The dual edge captures are active.
 */
//@{
#define BP_FTM_COMBINE_DECAP3 (27U)        //!< Bit position for FTM_COMBINE_DECAP3.
#define BM_FTM_COMBINE_DECAP3 (0x08000000U) //!< Bit mask for FTM_COMBINE_DECAP3.
#define BS_FTM_COMBINE_DECAP3 (1U)         //!< Bit field size in bits for FTM_COMBINE_DECAP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DECAP3 field.
#define BR_FTM_COMBINE_DECAP3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DECAP3.
#define BF_FTM_COMBINE_DECAP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DECAP3), uint32_t) & BM_FTM_COMBINE_DECAP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECAP3 field to a new value.
#define BW_FTM_COMBINE_DECAP3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DECAP3) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field DTEN3[28] (RW)
 *
 * Enables the deadtime insertion in the channels (n) and (n+1). This field is
 * write protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The deadtime insertion in this pair of channels is disabled.
 * - 1 - The deadtime insertion in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_DTEN3 (28U)         //!< Bit position for FTM_COMBINE_DTEN3.
#define BM_FTM_COMBINE_DTEN3 (0x10000000U) //!< Bit mask for FTM_COMBINE_DTEN3.
#define BS_FTM_COMBINE_DTEN3 (1U)          //!< Bit field size in bits for FTM_COMBINE_DTEN3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_DTEN3 field.
#define BR_FTM_COMBINE_DTEN3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_DTEN3.
#define BF_FTM_COMBINE_DTEN3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_DTEN3), uint32_t) & BM_FTM_COMBINE_DTEN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTEN3 field to a new value.
#define BW_FTM_COMBINE_DTEN3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_DTEN3) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field SYNCEN3[29] (RW)
 *
 * Enables PWM synchronization of registers C(n)V and C(n+1)V.
 *
 * Values:
 * - 0 - The PWM synchronization in this pair of channels is disabled.
 * - 1 - The PWM synchronization in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_SYNCEN3 (29U)       //!< Bit position for FTM_COMBINE_SYNCEN3.
#define BM_FTM_COMBINE_SYNCEN3 (0x20000000U) //!< Bit mask for FTM_COMBINE_SYNCEN3.
#define BS_FTM_COMBINE_SYNCEN3 (1U)        //!< Bit field size in bits for FTM_COMBINE_SYNCEN3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_SYNCEN3 field.
#define BR_FTM_COMBINE_SYNCEN3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_SYNCEN3.
#define BF_FTM_COMBINE_SYNCEN3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_SYNCEN3), uint32_t) & BM_FTM_COMBINE_SYNCEN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNCEN3 field to a new value.
#define BW_FTM_COMBINE_SYNCEN3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_SYNCEN3) = (v))
#endif
//@}

/*!
 * @name Register FTM_COMBINE, field FAULTEN3[30] (RW)
 *
 * Enables the fault control in channels (n) and (n+1). This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault control in this pair of channels is disabled.
 * - 1 - The fault control in this pair of channels is enabled.
 */
//@{
#define BP_FTM_COMBINE_FAULTEN3 (30U)      //!< Bit position for FTM_COMBINE_FAULTEN3.
#define BM_FTM_COMBINE_FAULTEN3 (0x40000000U) //!< Bit mask for FTM_COMBINE_FAULTEN3.
#define BS_FTM_COMBINE_FAULTEN3 (1U)       //!< Bit field size in bits for FTM_COMBINE_FAULTEN3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_COMBINE_FAULTEN3 field.
#define BR_FTM_COMBINE_FAULTEN3(x) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN3))
#endif

//! @brief Format value for bitfield FTM_COMBINE_FAULTEN3.
#define BF_FTM_COMBINE_FAULTEN3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_COMBINE_FAULTEN3), uint32_t) & BM_FTM_COMBINE_FAULTEN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULTEN3 field to a new value.
#define BW_FTM_COMBINE_FAULTEN3(x, v) (BITBAND_ACCESS32(HW_FTM_COMBINE_ADDR(x), BP_FTM_COMBINE_FAULTEN3) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_DEADTIME - Deadtime Insertion Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_DEADTIME - Deadtime Insertion Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register selects the deadtime prescaler factor and deadtime value. All
 * FTM channels use this clock prescaler and this deadtime value for the deadtime
 * insertion.
 */
typedef union _hw_ftm_deadtime
{
    uint32_t U;
    struct _hw_ftm_deadtime_bitfields
    {
        uint32_t DTVAL : 6;            //!< [5:0] Deadtime Value
        uint32_t DTPS : 2;             //!< [7:6] Deadtime Prescaler Value
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_deadtime_t;
#endif

/*!
 * @name Constants and macros for entire FTM_DEADTIME register
 */
//@{
#define HW_FTM_DEADTIME_ADDR(x)  (REGS_FTM_BASE(x) + 0x68U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_DEADTIME(x)       (*(__IO hw_ftm_deadtime_t *) HW_FTM_DEADTIME_ADDR(x))
#define HW_FTM_DEADTIME_RD(x)    (HW_FTM_DEADTIME(x).U)
#define HW_FTM_DEADTIME_WR(x, v) (HW_FTM_DEADTIME(x).U = (v))
#define HW_FTM_DEADTIME_SET(x, v) (HW_FTM_DEADTIME_WR(x, HW_FTM_DEADTIME_RD(x) |  (v)))
#define HW_FTM_DEADTIME_CLR(x, v) (HW_FTM_DEADTIME_WR(x, HW_FTM_DEADTIME_RD(x) & ~(v)))
#define HW_FTM_DEADTIME_TOG(x, v) (HW_FTM_DEADTIME_WR(x, HW_FTM_DEADTIME_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_DEADTIME bitfields
 */

/*!
 * @name Register FTM_DEADTIME, field DTVAL[5:0] (RW)
 *
 * Selects the deadtime insertion value for the deadtime counter. The deadtime
 * counter is clocked by a scaled version of the system clock. See the description
 * of DTPS. Deadtime insert value = (DTPS * DTVAL). DTVAL selects the number of
 * deadtime counts inserted as follows: When DTVAL is 0, no counts are inserted.
 * When DTVAL is 1, 1 count is inserted. When DTVAL is 2, 2 counts are inserted.
 * This pattern continues up to a possible 63 counts. This field is write
 * protected. It can be written only when MODE[WPDIS] = 1.
 */
//@{
#define BP_FTM_DEADTIME_DTVAL (0U)         //!< Bit position for FTM_DEADTIME_DTVAL.
#define BM_FTM_DEADTIME_DTVAL (0x0000003FU) //!< Bit mask for FTM_DEADTIME_DTVAL.
#define BS_FTM_DEADTIME_DTVAL (6U)         //!< Bit field size in bits for FTM_DEADTIME_DTVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_DEADTIME_DTVAL field.
#define BR_FTM_DEADTIME_DTVAL(x) (HW_FTM_DEADTIME(x).B.DTVAL)
#endif

//! @brief Format value for bitfield FTM_DEADTIME_DTVAL.
#define BF_FTM_DEADTIME_DTVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_DEADTIME_DTVAL), uint32_t) & BM_FTM_DEADTIME_DTVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTVAL field to a new value.
#define BW_FTM_DEADTIME_DTVAL(x, v) (HW_FTM_DEADTIME_WR(x, (HW_FTM_DEADTIME_RD(x) & ~BM_FTM_DEADTIME_DTVAL) | BF_FTM_DEADTIME_DTVAL(v)))
#endif
//@}

/*!
 * @name Register FTM_DEADTIME, field DTPS[7:6] (RW)
 *
 * Selects the division factor of the system clock. This prescaled clock is used
 * by the deadtime counter. This field is write protected. It can be written
 * only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0x - Divide the system clock by 1.
 * - 10 - Divide the system clock by 4.
 * - 11 - Divide the system clock by 16.
 */
//@{
#define BP_FTM_DEADTIME_DTPS (6U)          //!< Bit position for FTM_DEADTIME_DTPS.
#define BM_FTM_DEADTIME_DTPS (0x000000C0U) //!< Bit mask for FTM_DEADTIME_DTPS.
#define BS_FTM_DEADTIME_DTPS (2U)          //!< Bit field size in bits for FTM_DEADTIME_DTPS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_DEADTIME_DTPS field.
#define BR_FTM_DEADTIME_DTPS(x) (HW_FTM_DEADTIME(x).B.DTPS)
#endif

//! @brief Format value for bitfield FTM_DEADTIME_DTPS.
#define BF_FTM_DEADTIME_DTPS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_DEADTIME_DTPS), uint32_t) & BM_FTM_DEADTIME_DTPS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTPS field to a new value.
#define BW_FTM_DEADTIME_DTPS(x, v) (HW_FTM_DEADTIME_WR(x, (HW_FTM_DEADTIME_RD(x) & ~BM_FTM_DEADTIME_DTPS) | BF_FTM_DEADTIME_DTPS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_EXTTRIG - FTM External Trigger
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_EXTTRIG - FTM External Trigger (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register: Indicates when a channel trigger was generated Enables the
 * generation of a trigger when the FTM counter is equal to its initial value
 * Selects which channels are used in the generation of the channel triggers Several
 * channels can be selected to generate multiple triggers in one PWM period.
 * Channels 6 and 7 are not used to generate channel triggers.
 */
typedef union _hw_ftm_exttrig
{
    uint32_t U;
    struct _hw_ftm_exttrig_bitfields
    {
        uint32_t CH2TRIG : 1;          //!< [0] Channel 2 Trigger Enable
        uint32_t CH3TRIG : 1;          //!< [1] Channel 3 Trigger Enable
        uint32_t CH4TRIG : 1;          //!< [2] Channel 4 Trigger Enable
        uint32_t CH5TRIG : 1;          //!< [3] Channel 5 Trigger Enable
        uint32_t CH0TRIG : 1;          //!< [4] Channel 0 Trigger Enable
        uint32_t CH1TRIG : 1;          //!< [5] Channel 1 Trigger Enable
        uint32_t INITTRIGEN : 1;       //!< [6] Initialization Trigger Enable
        uint32_t TRIGF : 1;            //!< [7] Channel Trigger Flag
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_exttrig_t;
#endif

/*!
 * @name Constants and macros for entire FTM_EXTTRIG register
 */
//@{
#define HW_FTM_EXTTRIG_ADDR(x)   (REGS_FTM_BASE(x) + 0x6CU)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_EXTTRIG(x)        (*(__IO hw_ftm_exttrig_t *) HW_FTM_EXTTRIG_ADDR(x))
#define HW_FTM_EXTTRIG_RD(x)     (HW_FTM_EXTTRIG(x).U)
#define HW_FTM_EXTTRIG_WR(x, v)  (HW_FTM_EXTTRIG(x).U = (v))
#define HW_FTM_EXTTRIG_SET(x, v) (HW_FTM_EXTTRIG_WR(x, HW_FTM_EXTTRIG_RD(x) |  (v)))
#define HW_FTM_EXTTRIG_CLR(x, v) (HW_FTM_EXTTRIG_WR(x, HW_FTM_EXTTRIG_RD(x) & ~(v)))
#define HW_FTM_EXTTRIG_TOG(x, v) (HW_FTM_EXTTRIG_WR(x, HW_FTM_EXTTRIG_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_EXTTRIG bitfields
 */

/*!
 * @name Register FTM_EXTTRIG, field CH2TRIG[0] (RW)
 *
 * Enables the generation of the channel trigger when the FTM counter is equal
 * to the CnV register.
 *
 * Values:
 * - 0 - The generation of the channel trigger is disabled.
 * - 1 - The generation of the channel trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_CH2TRIG (0U)        //!< Bit position for FTM_EXTTRIG_CH2TRIG.
#define BM_FTM_EXTTRIG_CH2TRIG (0x00000001U) //!< Bit mask for FTM_EXTTRIG_CH2TRIG.
#define BS_FTM_EXTTRIG_CH2TRIG (1U)        //!< Bit field size in bits for FTM_EXTTRIG_CH2TRIG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_CH2TRIG field.
#define BR_FTM_EXTTRIG_CH2TRIG(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH2TRIG))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_CH2TRIG.
#define BF_FTM_EXTTRIG_CH2TRIG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_CH2TRIG), uint32_t) & BM_FTM_EXTTRIG_CH2TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2TRIG field to a new value.
#define BW_FTM_EXTTRIG_CH2TRIG(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH2TRIG) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field CH3TRIG[1] (RW)
 *
 * Enables the generation of the channel trigger when the FTM counter is equal
 * to the CnV register.
 *
 * Values:
 * - 0 - The generation of the channel trigger is disabled.
 * - 1 - The generation of the channel trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_CH3TRIG (1U)        //!< Bit position for FTM_EXTTRIG_CH3TRIG.
#define BM_FTM_EXTTRIG_CH3TRIG (0x00000002U) //!< Bit mask for FTM_EXTTRIG_CH3TRIG.
#define BS_FTM_EXTTRIG_CH3TRIG (1U)        //!< Bit field size in bits for FTM_EXTTRIG_CH3TRIG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_CH3TRIG field.
#define BR_FTM_EXTTRIG_CH3TRIG(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH3TRIG))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_CH3TRIG.
#define BF_FTM_EXTTRIG_CH3TRIG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_CH3TRIG), uint32_t) & BM_FTM_EXTTRIG_CH3TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3TRIG field to a new value.
#define BW_FTM_EXTTRIG_CH3TRIG(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH3TRIG) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field CH4TRIG[2] (RW)
 *
 * Enables the generation of the channel trigger when the FTM counter is equal
 * to the CnV register.
 *
 * Values:
 * - 0 - The generation of the channel trigger is disabled.
 * - 1 - The generation of the channel trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_CH4TRIG (2U)        //!< Bit position for FTM_EXTTRIG_CH4TRIG.
#define BM_FTM_EXTTRIG_CH4TRIG (0x00000004U) //!< Bit mask for FTM_EXTTRIG_CH4TRIG.
#define BS_FTM_EXTTRIG_CH4TRIG (1U)        //!< Bit field size in bits for FTM_EXTTRIG_CH4TRIG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_CH4TRIG field.
#define BR_FTM_EXTTRIG_CH4TRIG(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH4TRIG))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_CH4TRIG.
#define BF_FTM_EXTTRIG_CH4TRIG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_CH4TRIG), uint32_t) & BM_FTM_EXTTRIG_CH4TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4TRIG field to a new value.
#define BW_FTM_EXTTRIG_CH4TRIG(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH4TRIG) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field CH5TRIG[3] (RW)
 *
 * Enables the generation of the channel trigger when the FTM counter is equal
 * to the CnV register.
 *
 * Values:
 * - 0 - The generation of the channel trigger is disabled.
 * - 1 - The generation of the channel trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_CH5TRIG (3U)        //!< Bit position for FTM_EXTTRIG_CH5TRIG.
#define BM_FTM_EXTTRIG_CH5TRIG (0x00000008U) //!< Bit mask for FTM_EXTTRIG_CH5TRIG.
#define BS_FTM_EXTTRIG_CH5TRIG (1U)        //!< Bit field size in bits for FTM_EXTTRIG_CH5TRIG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_CH5TRIG field.
#define BR_FTM_EXTTRIG_CH5TRIG(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH5TRIG))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_CH5TRIG.
#define BF_FTM_EXTTRIG_CH5TRIG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_CH5TRIG), uint32_t) & BM_FTM_EXTTRIG_CH5TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5TRIG field to a new value.
#define BW_FTM_EXTTRIG_CH5TRIG(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH5TRIG) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field CH0TRIG[4] (RW)
 *
 * Enables the generation of the channel trigger when the FTM counter is equal
 * to the CnV register.
 *
 * Values:
 * - 0 - The generation of the channel trigger is disabled.
 * - 1 - The generation of the channel trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_CH0TRIG (4U)        //!< Bit position for FTM_EXTTRIG_CH0TRIG.
#define BM_FTM_EXTTRIG_CH0TRIG (0x00000010U) //!< Bit mask for FTM_EXTTRIG_CH0TRIG.
#define BS_FTM_EXTTRIG_CH0TRIG (1U)        //!< Bit field size in bits for FTM_EXTTRIG_CH0TRIG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_CH0TRIG field.
#define BR_FTM_EXTTRIG_CH0TRIG(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH0TRIG))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_CH0TRIG.
#define BF_FTM_EXTTRIG_CH0TRIG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_CH0TRIG), uint32_t) & BM_FTM_EXTTRIG_CH0TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0TRIG field to a new value.
#define BW_FTM_EXTTRIG_CH0TRIG(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH0TRIG) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field CH1TRIG[5] (RW)
 *
 * Enables the generation of the channel trigger when the FTM counter is equal
 * to the CnV register.
 *
 * Values:
 * - 0 - The generation of the channel trigger is disabled.
 * - 1 - The generation of the channel trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_CH1TRIG (5U)        //!< Bit position for FTM_EXTTRIG_CH1TRIG.
#define BM_FTM_EXTTRIG_CH1TRIG (0x00000020U) //!< Bit mask for FTM_EXTTRIG_CH1TRIG.
#define BS_FTM_EXTTRIG_CH1TRIG (1U)        //!< Bit field size in bits for FTM_EXTTRIG_CH1TRIG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_CH1TRIG field.
#define BR_FTM_EXTTRIG_CH1TRIG(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH1TRIG))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_CH1TRIG.
#define BF_FTM_EXTTRIG_CH1TRIG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_CH1TRIG), uint32_t) & BM_FTM_EXTTRIG_CH1TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1TRIG field to a new value.
#define BW_FTM_EXTTRIG_CH1TRIG(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_CH1TRIG) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field INITTRIGEN[6] (RW)
 *
 * Enables the generation of the trigger when the FTM counter is equal to the
 * CNTIN register.
 *
 * Values:
 * - 0 - The generation of initialization trigger is disabled.
 * - 1 - The generation of initialization trigger is enabled.
 */
//@{
#define BP_FTM_EXTTRIG_INITTRIGEN (6U)     //!< Bit position for FTM_EXTTRIG_INITTRIGEN.
#define BM_FTM_EXTTRIG_INITTRIGEN (0x00000040U) //!< Bit mask for FTM_EXTTRIG_INITTRIGEN.
#define BS_FTM_EXTTRIG_INITTRIGEN (1U)     //!< Bit field size in bits for FTM_EXTTRIG_INITTRIGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_INITTRIGEN field.
#define BR_FTM_EXTTRIG_INITTRIGEN(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_INITTRIGEN))
#endif

//! @brief Format value for bitfield FTM_EXTTRIG_INITTRIGEN.
#define BF_FTM_EXTTRIG_INITTRIGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_EXTTRIG_INITTRIGEN), uint32_t) & BM_FTM_EXTTRIG_INITTRIGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INITTRIGEN field to a new value.
#define BW_FTM_EXTTRIG_INITTRIGEN(x, v) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_INITTRIGEN) = (v))
#endif
//@}

/*!
 * @name Register FTM_EXTTRIG, field TRIGF[7] (ROWZ)
 *
 * Set by hardware when a channel trigger is generated. Clear TRIGF by reading
 * EXTTRIG while TRIGF is set and then writing a 0 to TRIGF. Writing a 1 to TRIGF
 * has no effect. If another channel trigger is generated before the clearing
 * sequence is completed, the sequence is reset so TRIGF remains set after the clear
 * sequence is completed for the earlier TRIGF.
 *
 * Values:
 * - 0 - No channel trigger was generated.
 * - 1 - A channel trigger was generated.
 */
//@{
#define BP_FTM_EXTTRIG_TRIGF (7U)          //!< Bit position for FTM_EXTTRIG_TRIGF.
#define BM_FTM_EXTTRIG_TRIGF (0x00000080U) //!< Bit mask for FTM_EXTTRIG_TRIGF.
#define BS_FTM_EXTTRIG_TRIGF (1U)          //!< Bit field size in bits for FTM_EXTTRIG_TRIGF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_EXTTRIG_TRIGF field.
#define BR_FTM_EXTTRIG_TRIGF(x) (BITBAND_ACCESS32(HW_FTM_EXTTRIG_ADDR(x), BP_FTM_EXTTRIG_TRIGF))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_POL - Channels Polarity
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_POL - Channels Polarity (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the output polarity of the FTM channels. The safe value
 * that is driven in a channel output when the fault control is enabled and a
 * fault condition is detected is the inactive state of the channel. That is, the
 * safe value of a channel is the value of its POL bit.
 */
typedef union _hw_ftm_pol
{
    uint32_t U;
    struct _hw_ftm_pol_bitfields
    {
        uint32_t POL0 : 1;             //!< [0] Channel 0 Polarity
        uint32_t POL1 : 1;             //!< [1] Channel 1 Polarity
        uint32_t POL2 : 1;             //!< [2] Channel 2 Polarity
        uint32_t POL3 : 1;             //!< [3] Channel 3 Polarity
        uint32_t POL4 : 1;             //!< [4] Channel 4 Polarity
        uint32_t POL5 : 1;             //!< [5] Channel 5 Polarity
        uint32_t POL6 : 1;             //!< [6] Channel 6 Polarity
        uint32_t POL7 : 1;             //!< [7] Channel 7 Polarity
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_pol_t;
#endif

/*!
 * @name Constants and macros for entire FTM_POL register
 */
//@{
#define HW_FTM_POL_ADDR(x)       (REGS_FTM_BASE(x) + 0x70U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_POL(x)            (*(__IO hw_ftm_pol_t *) HW_FTM_POL_ADDR(x))
#define HW_FTM_POL_RD(x)         (HW_FTM_POL(x).U)
#define HW_FTM_POL_WR(x, v)      (HW_FTM_POL(x).U = (v))
#define HW_FTM_POL_SET(x, v)     (HW_FTM_POL_WR(x, HW_FTM_POL_RD(x) |  (v)))
#define HW_FTM_POL_CLR(x, v)     (HW_FTM_POL_WR(x, HW_FTM_POL_RD(x) & ~(v)))
#define HW_FTM_POL_TOG(x, v)     (HW_FTM_POL_WR(x, HW_FTM_POL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_POL bitfields
 */

/*!
 * @name Register FTM_POL, field POL0[0] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL0      (0U)          //!< Bit position for FTM_POL_POL0.
#define BM_FTM_POL_POL0      (0x00000001U) //!< Bit mask for FTM_POL_POL0.
#define BS_FTM_POL_POL0      (1U)          //!< Bit field size in bits for FTM_POL_POL0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL0 field.
#define BR_FTM_POL_POL0(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL0))
#endif

//! @brief Format value for bitfield FTM_POL_POL0.
#define BF_FTM_POL_POL0(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL0), uint32_t) & BM_FTM_POL_POL0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL0 field to a new value.
#define BW_FTM_POL_POL0(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL0) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL1[1] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL1      (1U)          //!< Bit position for FTM_POL_POL1.
#define BM_FTM_POL_POL1      (0x00000002U) //!< Bit mask for FTM_POL_POL1.
#define BS_FTM_POL_POL1      (1U)          //!< Bit field size in bits for FTM_POL_POL1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL1 field.
#define BR_FTM_POL_POL1(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL1))
#endif

//! @brief Format value for bitfield FTM_POL_POL1.
#define BF_FTM_POL_POL1(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL1), uint32_t) & BM_FTM_POL_POL1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL1 field to a new value.
#define BW_FTM_POL_POL1(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL1) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL2[2] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL2      (2U)          //!< Bit position for FTM_POL_POL2.
#define BM_FTM_POL_POL2      (0x00000004U) //!< Bit mask for FTM_POL_POL2.
#define BS_FTM_POL_POL2      (1U)          //!< Bit field size in bits for FTM_POL_POL2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL2 field.
#define BR_FTM_POL_POL2(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL2))
#endif

//! @brief Format value for bitfield FTM_POL_POL2.
#define BF_FTM_POL_POL2(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL2), uint32_t) & BM_FTM_POL_POL2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL2 field to a new value.
#define BW_FTM_POL_POL2(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL2) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL3[3] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL3      (3U)          //!< Bit position for FTM_POL_POL3.
#define BM_FTM_POL_POL3      (0x00000008U) //!< Bit mask for FTM_POL_POL3.
#define BS_FTM_POL_POL3      (1U)          //!< Bit field size in bits for FTM_POL_POL3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL3 field.
#define BR_FTM_POL_POL3(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL3))
#endif

//! @brief Format value for bitfield FTM_POL_POL3.
#define BF_FTM_POL_POL3(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL3), uint32_t) & BM_FTM_POL_POL3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL3 field to a new value.
#define BW_FTM_POL_POL3(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL3) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL4[4] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL4      (4U)          //!< Bit position for FTM_POL_POL4.
#define BM_FTM_POL_POL4      (0x00000010U) //!< Bit mask for FTM_POL_POL4.
#define BS_FTM_POL_POL4      (1U)          //!< Bit field size in bits for FTM_POL_POL4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL4 field.
#define BR_FTM_POL_POL4(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL4))
#endif

//! @brief Format value for bitfield FTM_POL_POL4.
#define BF_FTM_POL_POL4(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL4), uint32_t) & BM_FTM_POL_POL4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL4 field to a new value.
#define BW_FTM_POL_POL4(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL4) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL5[5] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL5      (5U)          //!< Bit position for FTM_POL_POL5.
#define BM_FTM_POL_POL5      (0x00000020U) //!< Bit mask for FTM_POL_POL5.
#define BS_FTM_POL_POL5      (1U)          //!< Bit field size in bits for FTM_POL_POL5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL5 field.
#define BR_FTM_POL_POL5(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL5))
#endif

//! @brief Format value for bitfield FTM_POL_POL5.
#define BF_FTM_POL_POL5(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL5), uint32_t) & BM_FTM_POL_POL5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL5 field to a new value.
#define BW_FTM_POL_POL5(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL5) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL6[6] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL6      (6U)          //!< Bit position for FTM_POL_POL6.
#define BM_FTM_POL_POL6      (0x00000040U) //!< Bit mask for FTM_POL_POL6.
#define BS_FTM_POL_POL6      (1U)          //!< Bit field size in bits for FTM_POL_POL6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL6 field.
#define BR_FTM_POL_POL6(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL6))
#endif

//! @brief Format value for bitfield FTM_POL_POL6.
#define BF_FTM_POL_POL6(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL6), uint32_t) & BM_FTM_POL_POL6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL6 field to a new value.
#define BW_FTM_POL_POL6(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL6) = (v))
#endif
//@}

/*!
 * @name Register FTM_POL, field POL7[7] (RW)
 *
 * Defines the polarity of the channel output. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
//@{
#define BP_FTM_POL_POL7      (7U)          //!< Bit position for FTM_POL_POL7.
#define BM_FTM_POL_POL7      (0x00000080U) //!< Bit mask for FTM_POL_POL7.
#define BS_FTM_POL_POL7      (1U)          //!< Bit field size in bits for FTM_POL_POL7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_POL_POL7 field.
#define BR_FTM_POL_POL7(x)   (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL7))
#endif

//! @brief Format value for bitfield FTM_POL_POL7.
#define BF_FTM_POL_POL7(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_POL_POL7), uint32_t) & BM_FTM_POL_POL7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POL7 field to a new value.
#define BW_FTM_POL_POL7(x, v) (BITBAND_ACCESS32(HW_FTM_POL_ADDR(x), BP_FTM_POL_POL7) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_FMS - Fault Mode Status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_FMS - Fault Mode Status (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains the fault detection flags, write protection enable
 * bit, and the logic OR of the enabled fault inputs.
 */
typedef union _hw_ftm_fms
{
    uint32_t U;
    struct _hw_ftm_fms_bitfields
    {
        uint32_t FAULTF0 : 1;          //!< [0] Fault Detection Flag 0
        uint32_t FAULTF1 : 1;          //!< [1] Fault Detection Flag 1
        uint32_t FAULTF2 : 1;          //!< [2] Fault Detection Flag 2
        uint32_t FAULTF3 : 1;          //!< [3] Fault Detection Flag 3
        uint32_t RESERVED0 : 1;        //!< [4]
        uint32_t FAULTIN : 1;          //!< [5] Fault Inputs
        uint32_t WPEN : 1;             //!< [6] Write Protection Enable
        uint32_t FAULTF : 1;           //!< [7] Fault Detection Flag
        uint32_t RESERVED1 : 24;       //!< [31:8]
    } B;
} hw_ftm_fms_t;
#endif

/*!
 * @name Constants and macros for entire FTM_FMS register
 */
//@{
#define HW_FTM_FMS_ADDR(x)       (REGS_FTM_BASE(x) + 0x74U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_FMS(x)            (*(__IO hw_ftm_fms_t *) HW_FTM_FMS_ADDR(x))
#define HW_FTM_FMS_RD(x)         (HW_FTM_FMS(x).U)
#define HW_FTM_FMS_WR(x, v)      (HW_FTM_FMS(x).U = (v))
#define HW_FTM_FMS_SET(x, v)     (HW_FTM_FMS_WR(x, HW_FTM_FMS_RD(x) |  (v)))
#define HW_FTM_FMS_CLR(x, v)     (HW_FTM_FMS_WR(x, HW_FTM_FMS_RD(x) & ~(v)))
#define HW_FTM_FMS_TOG(x, v)     (HW_FTM_FMS_WR(x, HW_FTM_FMS_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_FMS bitfields
 */

/*!
 * @name Register FTM_FMS, field FAULTF0[0] (ROWZ)
 *
 * Set by hardware when fault control is enabled, the corresponding fault input
 * is enabled and a fault condition is detected at the fault input. Clear FAULTF0
 * by reading the FMS register while FAULTF0 is set and then writing a 0 to
 * FAULTF0 while there is no existing fault condition at the corresponding fault
 * input. Writing a 1 to FAULTF0 has no effect. FAULTF0 bit is also cleared when
 * FAULTF bit is cleared. If another fault condition is detected at the corresponding
 * fault input before the clearing sequence is completed, the sequence is reset
 * so FAULTF0 remains set after the clearing sequence is completed for the
 * earlier fault condition.
 *
 * Values:
 * - 0 - No fault condition was detected at the fault input.
 * - 1 - A fault condition was detected at the fault input.
 */
//@{
#define BP_FTM_FMS_FAULTF0   (0U)          //!< Bit position for FTM_FMS_FAULTF0.
#define BM_FTM_FMS_FAULTF0   (0x00000001U) //!< Bit mask for FTM_FMS_FAULTF0.
#define BS_FTM_FMS_FAULTF0   (1U)          //!< Bit field size in bits for FTM_FMS_FAULTF0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_FAULTF0 field.
#define BR_FTM_FMS_FAULTF0(x) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_FAULTF0))
#endif
//@}

/*!
 * @name Register FTM_FMS, field FAULTF1[1] (ROWZ)
 *
 * Set by hardware when fault control is enabled, the corresponding fault input
 * is enabled and a fault condition is detected at the fault input. Clear FAULTF1
 * by reading the FMS register while FAULTF1 is set and then writing a 0 to
 * FAULTF1 while there is no existing fault condition at the corresponding fault
 * input. Writing a 1 to FAULTF1 has no effect. FAULTF1 bit is also cleared when
 * FAULTF bit is cleared. If another fault condition is detected at the corresponding
 * fault input before the clearing sequence is completed, the sequence is reset
 * so FAULTF1 remains set after the clearing sequence is completed for the
 * earlier fault condition.
 *
 * Values:
 * - 0 - No fault condition was detected at the fault input.
 * - 1 - A fault condition was detected at the fault input.
 */
//@{
#define BP_FTM_FMS_FAULTF1   (1U)          //!< Bit position for FTM_FMS_FAULTF1.
#define BM_FTM_FMS_FAULTF1   (0x00000002U) //!< Bit mask for FTM_FMS_FAULTF1.
#define BS_FTM_FMS_FAULTF1   (1U)          //!< Bit field size in bits for FTM_FMS_FAULTF1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_FAULTF1 field.
#define BR_FTM_FMS_FAULTF1(x) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_FAULTF1))
#endif
//@}

/*!
 * @name Register FTM_FMS, field FAULTF2[2] (ROWZ)
 *
 * Set by hardware when fault control is enabled, the corresponding fault input
 * is enabled and a fault condition is detected at the fault input. Clear FAULTF2
 * by reading the FMS register while FAULTF2 is set and then writing a 0 to
 * FAULTF2 while there is no existing fault condition at the corresponding fault
 * input. Writing a 1 to FAULTF2 has no effect. FAULTF2 bit is also cleared when
 * FAULTF bit is cleared. If another fault condition is detected at the corresponding
 * fault input before the clearing sequence is completed, the sequence is reset
 * so FAULTF2 remains set after the clearing sequence is completed for the
 * earlier fault condition.
 *
 * Values:
 * - 0 - No fault condition was detected at the fault input.
 * - 1 - A fault condition was detected at the fault input.
 */
//@{
#define BP_FTM_FMS_FAULTF2   (2U)          //!< Bit position for FTM_FMS_FAULTF2.
#define BM_FTM_FMS_FAULTF2   (0x00000004U) //!< Bit mask for FTM_FMS_FAULTF2.
#define BS_FTM_FMS_FAULTF2   (1U)          //!< Bit field size in bits for FTM_FMS_FAULTF2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_FAULTF2 field.
#define BR_FTM_FMS_FAULTF2(x) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_FAULTF2))
#endif
//@}

/*!
 * @name Register FTM_FMS, field FAULTF3[3] (ROWZ)
 *
 * Set by hardware when fault control is enabled, the corresponding fault input
 * is enabled and a fault condition is detected at the fault input. Clear FAULTF3
 * by reading the FMS register while FAULTF3 is set and then writing a 0 to
 * FAULTF3 while there is no existing fault condition at the corresponding fault
 * input. Writing a 1 to FAULTF3 has no effect. FAULTF3 bit is also cleared when
 * FAULTF bit is cleared. If another fault condition is detected at the corresponding
 * fault input before the clearing sequence is completed, the sequence is reset
 * so FAULTF3 remains set after the clearing sequence is completed for the
 * earlier fault condition.
 *
 * Values:
 * - 0 - No fault condition was detected at the fault input.
 * - 1 - A fault condition was detected at the fault input.
 */
//@{
#define BP_FTM_FMS_FAULTF3   (3U)          //!< Bit position for FTM_FMS_FAULTF3.
#define BM_FTM_FMS_FAULTF3   (0x00000008U) //!< Bit mask for FTM_FMS_FAULTF3.
#define BS_FTM_FMS_FAULTF3   (1U)          //!< Bit field size in bits for FTM_FMS_FAULTF3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_FAULTF3 field.
#define BR_FTM_FMS_FAULTF3(x) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_FAULTF3))
#endif
//@}

/*!
 * @name Register FTM_FMS, field FAULTIN[5] (RO)
 *
 * Represents the logic OR of the enabled fault inputs after their filter (if
 * their filter is enabled) when fault control is enabled.
 *
 * Values:
 * - 0 - The logic OR of the enabled fault inputs is 0.
 * - 1 - The logic OR of the enabled fault inputs is 1.
 */
//@{
#define BP_FTM_FMS_FAULTIN   (5U)          //!< Bit position for FTM_FMS_FAULTIN.
#define BM_FTM_FMS_FAULTIN   (0x00000020U) //!< Bit mask for FTM_FMS_FAULTIN.
#define BS_FTM_FMS_FAULTIN   (1U)          //!< Bit field size in bits for FTM_FMS_FAULTIN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_FAULTIN field.
#define BR_FTM_FMS_FAULTIN(x) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_FAULTIN))
#endif
//@}

/*!
 * @name Register FTM_FMS, field WPEN[6] (RW)
 *
 * The WPEN bit is the negation of the WPDIS bit. WPEN is set when 1 is written
 * to it. WPEN is cleared when WPEN bit is read as a 1 and then 1 is written to
 * WPDIS. Writing 0 to WPEN has no effect.
 *
 * Values:
 * - 0 - Write protection is disabled. Write protected bits can be written.
 * - 1 - Write protection is enabled. Write protected bits cannot be written.
 */
//@{
#define BP_FTM_FMS_WPEN      (6U)          //!< Bit position for FTM_FMS_WPEN.
#define BM_FTM_FMS_WPEN      (0x00000040U) //!< Bit mask for FTM_FMS_WPEN.
#define BS_FTM_FMS_WPEN      (1U)          //!< Bit field size in bits for FTM_FMS_WPEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_WPEN field.
#define BR_FTM_FMS_WPEN(x)   (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_WPEN))
#endif

//! @brief Format value for bitfield FTM_FMS_WPEN.
#define BF_FTM_FMS_WPEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FMS_WPEN), uint32_t) & BM_FTM_FMS_WPEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WPEN field to a new value.
#define BW_FTM_FMS_WPEN(x, v) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_WPEN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FMS, field FAULTF[7] (ROWZ)
 *
 * Represents the logic OR of the individual FAULTFj bits where j = 3, 2, 1, 0.
 * Clear FAULTF by reading the FMS register while FAULTF is set and then writing
 * a 0 to FAULTF while there is no existing fault condition at the enabled fault
 * inputs. Writing a 1 to FAULTF has no effect. If another fault condition is
 * detected in an enabled fault input before the clearing sequence is completed, the
 * sequence is reset so FAULTF remains set after the clearing sequence is
 * completed for the earlier fault condition. FAULTF is also cleared when FAULTFj bits
 * are cleared individually.
 *
 * Values:
 * - 0 - No fault condition was detected.
 * - 1 - A fault condition was detected.
 */
//@{
#define BP_FTM_FMS_FAULTF    (7U)          //!< Bit position for FTM_FMS_FAULTF.
#define BM_FTM_FMS_FAULTF    (0x00000080U) //!< Bit mask for FTM_FMS_FAULTF.
#define BS_FTM_FMS_FAULTF    (1U)          //!< Bit field size in bits for FTM_FMS_FAULTF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FMS_FAULTF field.
#define BR_FTM_FMS_FAULTF(x) (BITBAND_ACCESS32(HW_FTM_FMS_ADDR(x), BP_FTM_FMS_FAULTF))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_FILTER - Input Capture Filter Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_FILTER - Input Capture Filter Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register selects the filter value for the inputs of channels. Channels
 * 4, 5, 6 and 7 do not have an input filter. Writing to the FILTER register has
 * immediate effect and must be done only when the channels 0, 1, 2, and 3 are not
 * in input modes. Failure to do this could result in a missing valid signal.
 */
typedef union _hw_ftm_filter
{
    uint32_t U;
    struct _hw_ftm_filter_bitfields
    {
        uint32_t CH0FVAL : 4;          //!< [3:0] Channel 0 Input Filter
        uint32_t CH1FVAL : 4;          //!< [7:4] Channel 1 Input Filter
        uint32_t CH2FVAL : 4;          //!< [11:8] Channel 2 Input Filter
        uint32_t CH3FVAL : 4;          //!< [15:12] Channel 3 Input Filter
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_ftm_filter_t;
#endif

/*!
 * @name Constants and macros for entire FTM_FILTER register
 */
//@{
#define HW_FTM_FILTER_ADDR(x)    (REGS_FTM_BASE(x) + 0x78U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_FILTER(x)         (*(__IO hw_ftm_filter_t *) HW_FTM_FILTER_ADDR(x))
#define HW_FTM_FILTER_RD(x)      (HW_FTM_FILTER(x).U)
#define HW_FTM_FILTER_WR(x, v)   (HW_FTM_FILTER(x).U = (v))
#define HW_FTM_FILTER_SET(x, v)  (HW_FTM_FILTER_WR(x, HW_FTM_FILTER_RD(x) |  (v)))
#define HW_FTM_FILTER_CLR(x, v)  (HW_FTM_FILTER_WR(x, HW_FTM_FILTER_RD(x) & ~(v)))
#define HW_FTM_FILTER_TOG(x, v)  (HW_FTM_FILTER_WR(x, HW_FTM_FILTER_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_FILTER bitfields
 */

/*!
 * @name Register FTM_FILTER, field CH0FVAL[3:0] (RW)
 *
 * Selects the filter value for the channel input. The filter is disabled when
 * the value is zero.
 */
//@{
#define BP_FTM_FILTER_CH0FVAL (0U)         //!< Bit position for FTM_FILTER_CH0FVAL.
#define BM_FTM_FILTER_CH0FVAL (0x0000000FU) //!< Bit mask for FTM_FILTER_CH0FVAL.
#define BS_FTM_FILTER_CH0FVAL (4U)         //!< Bit field size in bits for FTM_FILTER_CH0FVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FILTER_CH0FVAL field.
#define BR_FTM_FILTER_CH0FVAL(x) (HW_FTM_FILTER(x).B.CH0FVAL)
#endif

//! @brief Format value for bitfield FTM_FILTER_CH0FVAL.
#define BF_FTM_FILTER_CH0FVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FILTER_CH0FVAL), uint32_t) & BM_FTM_FILTER_CH0FVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0FVAL field to a new value.
#define BW_FTM_FILTER_CH0FVAL(x, v) (HW_FTM_FILTER_WR(x, (HW_FTM_FILTER_RD(x) & ~BM_FTM_FILTER_CH0FVAL) | BF_FTM_FILTER_CH0FVAL(v)))
#endif
//@}

/*!
 * @name Register FTM_FILTER, field CH1FVAL[7:4] (RW)
 *
 * Selects the filter value for the channel input. The filter is disabled when
 * the value is zero.
 */
//@{
#define BP_FTM_FILTER_CH1FVAL (4U)         //!< Bit position for FTM_FILTER_CH1FVAL.
#define BM_FTM_FILTER_CH1FVAL (0x000000F0U) //!< Bit mask for FTM_FILTER_CH1FVAL.
#define BS_FTM_FILTER_CH1FVAL (4U)         //!< Bit field size in bits for FTM_FILTER_CH1FVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FILTER_CH1FVAL field.
#define BR_FTM_FILTER_CH1FVAL(x) (HW_FTM_FILTER(x).B.CH1FVAL)
#endif

//! @brief Format value for bitfield FTM_FILTER_CH1FVAL.
#define BF_FTM_FILTER_CH1FVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FILTER_CH1FVAL), uint32_t) & BM_FTM_FILTER_CH1FVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1FVAL field to a new value.
#define BW_FTM_FILTER_CH1FVAL(x, v) (HW_FTM_FILTER_WR(x, (HW_FTM_FILTER_RD(x) & ~BM_FTM_FILTER_CH1FVAL) | BF_FTM_FILTER_CH1FVAL(v)))
#endif
//@}

/*!
 * @name Register FTM_FILTER, field CH2FVAL[11:8] (RW)
 *
 * Selects the filter value for the channel input. The filter is disabled when
 * the value is zero.
 */
//@{
#define BP_FTM_FILTER_CH2FVAL (8U)         //!< Bit position for FTM_FILTER_CH2FVAL.
#define BM_FTM_FILTER_CH2FVAL (0x00000F00U) //!< Bit mask for FTM_FILTER_CH2FVAL.
#define BS_FTM_FILTER_CH2FVAL (4U)         //!< Bit field size in bits for FTM_FILTER_CH2FVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FILTER_CH2FVAL field.
#define BR_FTM_FILTER_CH2FVAL(x) (HW_FTM_FILTER(x).B.CH2FVAL)
#endif

//! @brief Format value for bitfield FTM_FILTER_CH2FVAL.
#define BF_FTM_FILTER_CH2FVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FILTER_CH2FVAL), uint32_t) & BM_FTM_FILTER_CH2FVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2FVAL field to a new value.
#define BW_FTM_FILTER_CH2FVAL(x, v) (HW_FTM_FILTER_WR(x, (HW_FTM_FILTER_RD(x) & ~BM_FTM_FILTER_CH2FVAL) | BF_FTM_FILTER_CH2FVAL(v)))
#endif
//@}

/*!
 * @name Register FTM_FILTER, field CH3FVAL[15:12] (RW)
 *
 * Selects the filter value for the channel input. The filter is disabled when
 * the value is zero.
 */
//@{
#define BP_FTM_FILTER_CH3FVAL (12U)        //!< Bit position for FTM_FILTER_CH3FVAL.
#define BM_FTM_FILTER_CH3FVAL (0x0000F000U) //!< Bit mask for FTM_FILTER_CH3FVAL.
#define BS_FTM_FILTER_CH3FVAL (4U)         //!< Bit field size in bits for FTM_FILTER_CH3FVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FILTER_CH3FVAL field.
#define BR_FTM_FILTER_CH3FVAL(x) (HW_FTM_FILTER(x).B.CH3FVAL)
#endif

//! @brief Format value for bitfield FTM_FILTER_CH3FVAL.
#define BF_FTM_FILTER_CH3FVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FILTER_CH3FVAL), uint32_t) & BM_FTM_FILTER_CH3FVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3FVAL field to a new value.
#define BW_FTM_FILTER_CH3FVAL(x, v) (HW_FTM_FILTER_WR(x, (HW_FTM_FILTER_RD(x) & ~BM_FTM_FILTER_CH3FVAL) | BF_FTM_FILTER_CH3FVAL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_FLTCTRL - Fault Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_FLTCTRL - Fault Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register selects the filter value for the fault inputs, enables the
 * fault inputs and the fault inputs filter.
 */
typedef union _hw_ftm_fltctrl
{
    uint32_t U;
    struct _hw_ftm_fltctrl_bitfields
    {
        uint32_t FAULT0EN : 1;         //!< [0] Fault Input 0 Enable
        uint32_t FAULT1EN : 1;         //!< [1] Fault Input 1 Enable
        uint32_t FAULT2EN : 1;         //!< [2] Fault Input 2 Enable
        uint32_t FAULT3EN : 1;         //!< [3] Fault Input 3 Enable
        uint32_t FFLTR0EN : 1;         //!< [4] Fault Input 0 Filter Enable
        uint32_t FFLTR1EN : 1;         //!< [5] Fault Input 1 Filter Enable
        uint32_t FFLTR2EN : 1;         //!< [6] Fault Input 2 Filter Enable
        uint32_t FFLTR3EN : 1;         //!< [7] Fault Input 3 Filter Enable
        uint32_t FFVAL : 4;            //!< [11:8] Fault Input Filter
        uint32_t RESERVED0 : 20;       //!< [31:12]
    } B;
} hw_ftm_fltctrl_t;
#endif

/*!
 * @name Constants and macros for entire FTM_FLTCTRL register
 */
//@{
#define HW_FTM_FLTCTRL_ADDR(x)   (REGS_FTM_BASE(x) + 0x7CU)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_FLTCTRL(x)        (*(__IO hw_ftm_fltctrl_t *) HW_FTM_FLTCTRL_ADDR(x))
#define HW_FTM_FLTCTRL_RD(x)     (HW_FTM_FLTCTRL(x).U)
#define HW_FTM_FLTCTRL_WR(x, v)  (HW_FTM_FLTCTRL(x).U = (v))
#define HW_FTM_FLTCTRL_SET(x, v) (HW_FTM_FLTCTRL_WR(x, HW_FTM_FLTCTRL_RD(x) |  (v)))
#define HW_FTM_FLTCTRL_CLR(x, v) (HW_FTM_FLTCTRL_WR(x, HW_FTM_FLTCTRL_RD(x) & ~(v)))
#define HW_FTM_FLTCTRL_TOG(x, v) (HW_FTM_FLTCTRL_WR(x, HW_FTM_FLTCTRL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_FLTCTRL bitfields
 */

/*!
 * @name Register FTM_FLTCTRL, field FAULT0EN[0] (RW)
 *
 * Enables the fault input. This field is write protected. It can be written
 * only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input is disabled.
 * - 1 - Fault input is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FAULT0EN (0U)       //!< Bit position for FTM_FLTCTRL_FAULT0EN.
#define BM_FTM_FLTCTRL_FAULT0EN (0x00000001U) //!< Bit mask for FTM_FLTCTRL_FAULT0EN.
#define BS_FTM_FLTCTRL_FAULT0EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FAULT0EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FAULT0EN field.
#define BR_FTM_FLTCTRL_FAULT0EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT0EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FAULT0EN.
#define BF_FTM_FLTCTRL_FAULT0EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FAULT0EN), uint32_t) & BM_FTM_FLTCTRL_FAULT0EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULT0EN field to a new value.
#define BW_FTM_FLTCTRL_FAULT0EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT0EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FAULT1EN[1] (RW)
 *
 * Enables the fault input. This field is write protected. It can be written
 * only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input is disabled.
 * - 1 - Fault input is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FAULT1EN (1U)       //!< Bit position for FTM_FLTCTRL_FAULT1EN.
#define BM_FTM_FLTCTRL_FAULT1EN (0x00000002U) //!< Bit mask for FTM_FLTCTRL_FAULT1EN.
#define BS_FTM_FLTCTRL_FAULT1EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FAULT1EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FAULT1EN field.
#define BR_FTM_FLTCTRL_FAULT1EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT1EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FAULT1EN.
#define BF_FTM_FLTCTRL_FAULT1EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FAULT1EN), uint32_t) & BM_FTM_FLTCTRL_FAULT1EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULT1EN field to a new value.
#define BW_FTM_FLTCTRL_FAULT1EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT1EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FAULT2EN[2] (RW)
 *
 * Enables the fault input. This field is write protected. It can be written
 * only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input is disabled.
 * - 1 - Fault input is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FAULT2EN (2U)       //!< Bit position for FTM_FLTCTRL_FAULT2EN.
#define BM_FTM_FLTCTRL_FAULT2EN (0x00000004U) //!< Bit mask for FTM_FLTCTRL_FAULT2EN.
#define BS_FTM_FLTCTRL_FAULT2EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FAULT2EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FAULT2EN field.
#define BR_FTM_FLTCTRL_FAULT2EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT2EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FAULT2EN.
#define BF_FTM_FLTCTRL_FAULT2EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FAULT2EN), uint32_t) & BM_FTM_FLTCTRL_FAULT2EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULT2EN field to a new value.
#define BW_FTM_FLTCTRL_FAULT2EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT2EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FAULT3EN[3] (RW)
 *
 * Enables the fault input. This field is write protected. It can be written
 * only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input is disabled.
 * - 1 - Fault input is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FAULT3EN (3U)       //!< Bit position for FTM_FLTCTRL_FAULT3EN.
#define BM_FTM_FLTCTRL_FAULT3EN (0x00000008U) //!< Bit mask for FTM_FLTCTRL_FAULT3EN.
#define BS_FTM_FLTCTRL_FAULT3EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FAULT3EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FAULT3EN field.
#define BR_FTM_FLTCTRL_FAULT3EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT3EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FAULT3EN.
#define BF_FTM_FLTCTRL_FAULT3EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FAULT3EN), uint32_t) & BM_FTM_FLTCTRL_FAULT3EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAULT3EN field to a new value.
#define BW_FTM_FLTCTRL_FAULT3EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FAULT3EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FFLTR0EN[4] (RW)
 *
 * Enables the filter for the fault input. This field is write protected. It can
 * be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input filter is disabled.
 * - 1 - Fault input filter is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FFLTR0EN (4U)       //!< Bit position for FTM_FLTCTRL_FFLTR0EN.
#define BM_FTM_FLTCTRL_FFLTR0EN (0x00000010U) //!< Bit mask for FTM_FLTCTRL_FFLTR0EN.
#define BS_FTM_FLTCTRL_FFLTR0EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FFLTR0EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FFLTR0EN field.
#define BR_FTM_FLTCTRL_FFLTR0EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR0EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FFLTR0EN.
#define BF_FTM_FLTCTRL_FFLTR0EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FFLTR0EN), uint32_t) & BM_FTM_FLTCTRL_FFLTR0EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FFLTR0EN field to a new value.
#define BW_FTM_FLTCTRL_FFLTR0EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR0EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FFLTR1EN[5] (RW)
 *
 * Enables the filter for the fault input. This field is write protected. It can
 * be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input filter is disabled.
 * - 1 - Fault input filter is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FFLTR1EN (5U)       //!< Bit position for FTM_FLTCTRL_FFLTR1EN.
#define BM_FTM_FLTCTRL_FFLTR1EN (0x00000020U) //!< Bit mask for FTM_FLTCTRL_FFLTR1EN.
#define BS_FTM_FLTCTRL_FFLTR1EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FFLTR1EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FFLTR1EN field.
#define BR_FTM_FLTCTRL_FFLTR1EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR1EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FFLTR1EN.
#define BF_FTM_FLTCTRL_FFLTR1EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FFLTR1EN), uint32_t) & BM_FTM_FLTCTRL_FFLTR1EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FFLTR1EN field to a new value.
#define BW_FTM_FLTCTRL_FFLTR1EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR1EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FFLTR2EN[6] (RW)
 *
 * Enables the filter for the fault input. This field is write protected. It can
 * be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input filter is disabled.
 * - 1 - Fault input filter is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FFLTR2EN (6U)       //!< Bit position for FTM_FLTCTRL_FFLTR2EN.
#define BM_FTM_FLTCTRL_FFLTR2EN (0x00000040U) //!< Bit mask for FTM_FLTCTRL_FFLTR2EN.
#define BS_FTM_FLTCTRL_FFLTR2EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FFLTR2EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FFLTR2EN field.
#define BR_FTM_FLTCTRL_FFLTR2EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR2EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FFLTR2EN.
#define BF_FTM_FLTCTRL_FFLTR2EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FFLTR2EN), uint32_t) & BM_FTM_FLTCTRL_FFLTR2EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FFLTR2EN field to a new value.
#define BW_FTM_FLTCTRL_FFLTR2EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR2EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FFLTR3EN[7] (RW)
 *
 * Enables the filter for the fault input. This field is write protected. It can
 * be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Fault input filter is disabled.
 * - 1 - Fault input filter is enabled.
 */
//@{
#define BP_FTM_FLTCTRL_FFLTR3EN (7U)       //!< Bit position for FTM_FLTCTRL_FFLTR3EN.
#define BM_FTM_FLTCTRL_FFLTR3EN (0x00000080U) //!< Bit mask for FTM_FLTCTRL_FFLTR3EN.
#define BS_FTM_FLTCTRL_FFLTR3EN (1U)       //!< Bit field size in bits for FTM_FLTCTRL_FFLTR3EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FFLTR3EN field.
#define BR_FTM_FLTCTRL_FFLTR3EN(x) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR3EN))
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FFLTR3EN.
#define BF_FTM_FLTCTRL_FFLTR3EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FFLTR3EN), uint32_t) & BM_FTM_FLTCTRL_FFLTR3EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FFLTR3EN field to a new value.
#define BW_FTM_FLTCTRL_FFLTR3EN(x, v) (BITBAND_ACCESS32(HW_FTM_FLTCTRL_ADDR(x), BP_FTM_FLTCTRL_FFLTR3EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTCTRL, field FFVAL[11:8] (RW)
 *
 * Selects the filter value for the fault inputs. The fault filter is disabled
 * when the value is zero. Writing to this field has immediate effect and must be
 * done only when the fault control or all fault inputs are disabled. Failure to
 * do this could result in a missing fault detection.
 */
//@{
#define BP_FTM_FLTCTRL_FFVAL (8U)          //!< Bit position for FTM_FLTCTRL_FFVAL.
#define BM_FTM_FLTCTRL_FFVAL (0x00000F00U) //!< Bit mask for FTM_FLTCTRL_FFVAL.
#define BS_FTM_FLTCTRL_FFVAL (4U)          //!< Bit field size in bits for FTM_FLTCTRL_FFVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTCTRL_FFVAL field.
#define BR_FTM_FLTCTRL_FFVAL(x) (HW_FTM_FLTCTRL(x).B.FFVAL)
#endif

//! @brief Format value for bitfield FTM_FLTCTRL_FFVAL.
#define BF_FTM_FLTCTRL_FFVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTCTRL_FFVAL), uint32_t) & BM_FTM_FLTCTRL_FFVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FFVAL field to a new value.
#define BW_FTM_FLTCTRL_FFVAL(x, v) (HW_FTM_FLTCTRL_WR(x, (HW_FTM_FLTCTRL_RD(x) & ~BM_FTM_FLTCTRL_FFVAL) | BF_FTM_FLTCTRL_FFVAL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_QDCTRL - Quadrature Decoder Control And Status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_QDCTRL - Quadrature Decoder Control And Status (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register has the control and status bits for the Quadrature Decoder mode.
 */
typedef union _hw_ftm_qdctrl
{
    uint32_t U;
    struct _hw_ftm_qdctrl_bitfields
    {
        uint32_t QUADEN : 1;           //!< [0] Quadrature Decoder Mode Enable
        uint32_t TOFDIR : 1;           //!< [1] Timer Overflow Direction In Quadrature
                                       //! Decoder Mode
        uint32_t QUADIR : 1;           //!< [2] FTM Counter Direction In Quadrature
                                       //! Decoder Mode
        uint32_t QUADMODE : 1;         //!< [3] Quadrature Decoder Mode
        uint32_t PHBPOL : 1;           //!< [4] Phase B Input Polarity
        uint32_t PHAPOL : 1;           //!< [5] Phase A Input Polarity
        uint32_t PHBFLTREN : 1;        //!< [6] Phase B Input Filter Enable
        uint32_t PHAFLTREN : 1;        //!< [7] Phase A Input Filter Enable
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_ftm_qdctrl_t;
#endif

/*!
 * @name Constants and macros for entire FTM_QDCTRL register
 */
//@{
#define HW_FTM_QDCTRL_ADDR(x)    (REGS_FTM_BASE(x) + 0x80U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_QDCTRL(x)         (*(__IO hw_ftm_qdctrl_t *) HW_FTM_QDCTRL_ADDR(x))
#define HW_FTM_QDCTRL_RD(x)      (HW_FTM_QDCTRL(x).U)
#define HW_FTM_QDCTRL_WR(x, v)   (HW_FTM_QDCTRL(x).U = (v))
#define HW_FTM_QDCTRL_SET(x, v)  (HW_FTM_QDCTRL_WR(x, HW_FTM_QDCTRL_RD(x) |  (v)))
#define HW_FTM_QDCTRL_CLR(x, v)  (HW_FTM_QDCTRL_WR(x, HW_FTM_QDCTRL_RD(x) & ~(v)))
#define HW_FTM_QDCTRL_TOG(x, v)  (HW_FTM_QDCTRL_WR(x, HW_FTM_QDCTRL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_QDCTRL bitfields
 */

/*!
 * @name Register FTM_QDCTRL, field QUADEN[0] (RW)
 *
 * Enables the Quadrature Decoder mode. In this mode, the phase A and B input
 * signals control the FTM counter direction. The Quadrature Decoder mode has
 * precedence over the other modes. See #ModeSel1Table. This field is write protected.
 * It can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - Quadrature Decoder mode is disabled.
 * - 1 - Quadrature Decoder mode is enabled.
 */
//@{
#define BP_FTM_QDCTRL_QUADEN (0U)          //!< Bit position for FTM_QDCTRL_QUADEN.
#define BM_FTM_QDCTRL_QUADEN (0x00000001U) //!< Bit mask for FTM_QDCTRL_QUADEN.
#define BS_FTM_QDCTRL_QUADEN (1U)          //!< Bit field size in bits for FTM_QDCTRL_QUADEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_QUADEN field.
#define BR_FTM_QDCTRL_QUADEN(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_QUADEN))
#endif

//! @brief Format value for bitfield FTM_QDCTRL_QUADEN.
#define BF_FTM_QDCTRL_QUADEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_QDCTRL_QUADEN), uint32_t) & BM_FTM_QDCTRL_QUADEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the QUADEN field to a new value.
#define BW_FTM_QDCTRL_QUADEN(x, v) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_QUADEN) = (v))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field TOFDIR[1] (RO)
 *
 * Indicates if the TOF bit was set on the top or the bottom of counting.
 *
 * Values:
 * - 0 - TOF bit was set on the bottom of counting. There was an FTM counter
 *     decrement and FTM counter changes from its minimum value (CNTIN register) to
 *     its maximum value (MOD register).
 * - 1 - TOF bit was set on the top of counting. There was an FTM counter
 *     increment and FTM counter changes from its maximum value (MOD register) to its
 *     minimum value (CNTIN register).
 */
//@{
#define BP_FTM_QDCTRL_TOFDIR (1U)          //!< Bit position for FTM_QDCTRL_TOFDIR.
#define BM_FTM_QDCTRL_TOFDIR (0x00000002U) //!< Bit mask for FTM_QDCTRL_TOFDIR.
#define BS_FTM_QDCTRL_TOFDIR (1U)          //!< Bit field size in bits for FTM_QDCTRL_TOFDIR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_TOFDIR field.
#define BR_FTM_QDCTRL_TOFDIR(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_TOFDIR))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field QUADIR[2] (RO)
 *
 * Indicates the counting direction.
 *
 * Values:
 * - 0 - Counting direction is decreasing (FTM counter decrement).
 * - 1 - Counting direction is increasing (FTM counter increment).
 */
//@{
#define BP_FTM_QDCTRL_QUADIR (2U)          //!< Bit position for FTM_QDCTRL_QUADIR.
#define BM_FTM_QDCTRL_QUADIR (0x00000004U) //!< Bit mask for FTM_QDCTRL_QUADIR.
#define BS_FTM_QDCTRL_QUADIR (1U)          //!< Bit field size in bits for FTM_QDCTRL_QUADIR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_QUADIR field.
#define BR_FTM_QDCTRL_QUADIR(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_QUADIR))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field QUADMODE[3] (RW)
 *
 * Selects the encoding mode used in the Quadrature Decoder mode.
 *
 * Values:
 * - 0 - Phase A and phase B encoding mode.
 * - 1 - Count and direction encoding mode.
 */
//@{
#define BP_FTM_QDCTRL_QUADMODE (3U)        //!< Bit position for FTM_QDCTRL_QUADMODE.
#define BM_FTM_QDCTRL_QUADMODE (0x00000008U) //!< Bit mask for FTM_QDCTRL_QUADMODE.
#define BS_FTM_QDCTRL_QUADMODE (1U)        //!< Bit field size in bits for FTM_QDCTRL_QUADMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_QUADMODE field.
#define BR_FTM_QDCTRL_QUADMODE(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_QUADMODE))
#endif

//! @brief Format value for bitfield FTM_QDCTRL_QUADMODE.
#define BF_FTM_QDCTRL_QUADMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_QDCTRL_QUADMODE), uint32_t) & BM_FTM_QDCTRL_QUADMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the QUADMODE field to a new value.
#define BW_FTM_QDCTRL_QUADMODE(x, v) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_QUADMODE) = (v))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field PHBPOL[4] (RW)
 *
 * Selects the polarity for the quadrature decoder phase B input.
 *
 * Values:
 * - 0 - Normal polarity. Phase B input signal is not inverted before
 *     identifying the rising and falling edges of this signal.
 * - 1 - Inverted polarity. Phase B input signal is inverted before identifying
 *     the rising and falling edges of this signal.
 */
//@{
#define BP_FTM_QDCTRL_PHBPOL (4U)          //!< Bit position for FTM_QDCTRL_PHBPOL.
#define BM_FTM_QDCTRL_PHBPOL (0x00000010U) //!< Bit mask for FTM_QDCTRL_PHBPOL.
#define BS_FTM_QDCTRL_PHBPOL (1U)          //!< Bit field size in bits for FTM_QDCTRL_PHBPOL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_PHBPOL field.
#define BR_FTM_QDCTRL_PHBPOL(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHBPOL))
#endif

//! @brief Format value for bitfield FTM_QDCTRL_PHBPOL.
#define BF_FTM_QDCTRL_PHBPOL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_QDCTRL_PHBPOL), uint32_t) & BM_FTM_QDCTRL_PHBPOL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PHBPOL field to a new value.
#define BW_FTM_QDCTRL_PHBPOL(x, v) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHBPOL) = (v))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field PHAPOL[5] (RW)
 *
 * Selects the polarity for the quadrature decoder phase A input.
 *
 * Values:
 * - 0 - Normal polarity. Phase A input signal is not inverted before
 *     identifying the rising and falling edges of this signal.
 * - 1 - Inverted polarity. Phase A input signal is inverted before identifying
 *     the rising and falling edges of this signal.
 */
//@{
#define BP_FTM_QDCTRL_PHAPOL (5U)          //!< Bit position for FTM_QDCTRL_PHAPOL.
#define BM_FTM_QDCTRL_PHAPOL (0x00000020U) //!< Bit mask for FTM_QDCTRL_PHAPOL.
#define BS_FTM_QDCTRL_PHAPOL (1U)          //!< Bit field size in bits for FTM_QDCTRL_PHAPOL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_PHAPOL field.
#define BR_FTM_QDCTRL_PHAPOL(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHAPOL))
#endif

//! @brief Format value for bitfield FTM_QDCTRL_PHAPOL.
#define BF_FTM_QDCTRL_PHAPOL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_QDCTRL_PHAPOL), uint32_t) & BM_FTM_QDCTRL_PHAPOL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PHAPOL field to a new value.
#define BW_FTM_QDCTRL_PHAPOL(x, v) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHAPOL) = (v))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field PHBFLTREN[6] (RW)
 *
 * Enables the filter for the quadrature decoder phase B input. The filter value
 * for the phase B input is defined by the CH1FVAL field of FILTER. The phase B
 * filter is also disabled when CH1FVAL is zero.
 *
 * Values:
 * - 0 - Phase B input filter is disabled.
 * - 1 - Phase B input filter is enabled.
 */
//@{
#define BP_FTM_QDCTRL_PHBFLTREN (6U)       //!< Bit position for FTM_QDCTRL_PHBFLTREN.
#define BM_FTM_QDCTRL_PHBFLTREN (0x00000040U) //!< Bit mask for FTM_QDCTRL_PHBFLTREN.
#define BS_FTM_QDCTRL_PHBFLTREN (1U)       //!< Bit field size in bits for FTM_QDCTRL_PHBFLTREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_PHBFLTREN field.
#define BR_FTM_QDCTRL_PHBFLTREN(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHBFLTREN))
#endif

//! @brief Format value for bitfield FTM_QDCTRL_PHBFLTREN.
#define BF_FTM_QDCTRL_PHBFLTREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_QDCTRL_PHBFLTREN), uint32_t) & BM_FTM_QDCTRL_PHBFLTREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PHBFLTREN field to a new value.
#define BW_FTM_QDCTRL_PHBFLTREN(x, v) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHBFLTREN) = (v))
#endif
//@}

/*!
 * @name Register FTM_QDCTRL, field PHAFLTREN[7] (RW)
 *
 * Enables the filter for the quadrature decoder phase A input. The filter value
 * for the phase A input is defined by the CH0FVAL field of FILTER. The phase A
 * filter is also disabled when CH0FVAL is zero.
 *
 * Values:
 * - 0 - Phase A input filter is disabled.
 * - 1 - Phase A input filter is enabled.
 */
//@{
#define BP_FTM_QDCTRL_PHAFLTREN (7U)       //!< Bit position for FTM_QDCTRL_PHAFLTREN.
#define BM_FTM_QDCTRL_PHAFLTREN (0x00000080U) //!< Bit mask for FTM_QDCTRL_PHAFLTREN.
#define BS_FTM_QDCTRL_PHAFLTREN (1U)       //!< Bit field size in bits for FTM_QDCTRL_PHAFLTREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_QDCTRL_PHAFLTREN field.
#define BR_FTM_QDCTRL_PHAFLTREN(x) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHAFLTREN))
#endif

//! @brief Format value for bitfield FTM_QDCTRL_PHAFLTREN.
#define BF_FTM_QDCTRL_PHAFLTREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_QDCTRL_PHAFLTREN), uint32_t) & BM_FTM_QDCTRL_PHAFLTREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PHAFLTREN field to a new value.
#define BW_FTM_QDCTRL_PHAFLTREN(x, v) (BITBAND_ACCESS32(HW_FTM_QDCTRL_ADDR(x), BP_FTM_QDCTRL_PHAFLTREN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_CONF - Configuration
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_CONF - Configuration (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register selects the number of times that the FTM counter overflow
 * should occur before the TOF bit to be set, the FTM behavior in BDM modes, the use
 * of an external global time base, and the global time base signal generation.
 */
typedef union _hw_ftm_conf
{
    uint32_t U;
    struct _hw_ftm_conf_bitfields
    {
        uint32_t NUMTOF : 5;           //!< [4:0] TOF Frequency
        uint32_t RESERVED0 : 1;        //!< [5]
        uint32_t BDMMODE : 2;          //!< [7:6] BDM Mode
        uint32_t RESERVED1 : 1;        //!< [8]
        uint32_t GTBEEN : 1;           //!< [9] Global Time Base Enable
        uint32_t GTBEOUT : 1;          //!< [10] Global Time Base Output
        uint32_t RESERVED2 : 21;       //!< [31:11]
    } B;
} hw_ftm_conf_t;
#endif

/*!
 * @name Constants and macros for entire FTM_CONF register
 */
//@{
#define HW_FTM_CONF_ADDR(x)      (REGS_FTM_BASE(x) + 0x84U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_CONF(x)           (*(__IO hw_ftm_conf_t *) HW_FTM_CONF_ADDR(x))
#define HW_FTM_CONF_RD(x)        (HW_FTM_CONF(x).U)
#define HW_FTM_CONF_WR(x, v)     (HW_FTM_CONF(x).U = (v))
#define HW_FTM_CONF_SET(x, v)    (HW_FTM_CONF_WR(x, HW_FTM_CONF_RD(x) |  (v)))
#define HW_FTM_CONF_CLR(x, v)    (HW_FTM_CONF_WR(x, HW_FTM_CONF_RD(x) & ~(v)))
#define HW_FTM_CONF_TOG(x, v)    (HW_FTM_CONF_WR(x, HW_FTM_CONF_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_CONF bitfields
 */

/*!
 * @name Register FTM_CONF, field NUMTOF[4:0] (RW)
 *
 * Selects the ratio between the number of counter overflows to the number of
 * times the TOF bit is set. NUMTOF = 0: The TOF bit is set for each counter
 * overflow. NUMTOF = 1: The TOF bit is set for the first counter overflow but not for
 * the next overflow. NUMTOF = 2: The TOF bit is set for the first counter
 * overflow but not for the next 2 overflows. NUMTOF = 3: The TOF bit is set for the
 * first counter overflow but not for the next 3 overflows. This pattern continues
 * up to a maximum of 31.
 */
//@{
#define BP_FTM_CONF_NUMTOF   (0U)          //!< Bit position for FTM_CONF_NUMTOF.
#define BM_FTM_CONF_NUMTOF   (0x0000001FU) //!< Bit mask for FTM_CONF_NUMTOF.
#define BS_FTM_CONF_NUMTOF   (5U)          //!< Bit field size in bits for FTM_CONF_NUMTOF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CONF_NUMTOF field.
#define BR_FTM_CONF_NUMTOF(x) (HW_FTM_CONF(x).B.NUMTOF)
#endif

//! @brief Format value for bitfield FTM_CONF_NUMTOF.
#define BF_FTM_CONF_NUMTOF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CONF_NUMTOF), uint32_t) & BM_FTM_CONF_NUMTOF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUMTOF field to a new value.
#define BW_FTM_CONF_NUMTOF(x, v) (HW_FTM_CONF_WR(x, (HW_FTM_CONF_RD(x) & ~BM_FTM_CONF_NUMTOF) | BF_FTM_CONF_NUMTOF(v)))
#endif
//@}

/*!
 * @name Register FTM_CONF, field BDMMODE[7:6] (RW)
 *
 * Selects the FTM behavior in BDM mode. See BDM mode.
 */
//@{
#define BP_FTM_CONF_BDMMODE  (6U)          //!< Bit position for FTM_CONF_BDMMODE.
#define BM_FTM_CONF_BDMMODE  (0x000000C0U) //!< Bit mask for FTM_CONF_BDMMODE.
#define BS_FTM_CONF_BDMMODE  (2U)          //!< Bit field size in bits for FTM_CONF_BDMMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CONF_BDMMODE field.
#define BR_FTM_CONF_BDMMODE(x) (HW_FTM_CONF(x).B.BDMMODE)
#endif

//! @brief Format value for bitfield FTM_CONF_BDMMODE.
#define BF_FTM_CONF_BDMMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CONF_BDMMODE), uint32_t) & BM_FTM_CONF_BDMMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BDMMODE field to a new value.
#define BW_FTM_CONF_BDMMODE(x, v) (HW_FTM_CONF_WR(x, (HW_FTM_CONF_RD(x) & ~BM_FTM_CONF_BDMMODE) | BF_FTM_CONF_BDMMODE(v)))
#endif
//@}

/*!
 * @name Register FTM_CONF, field GTBEEN[9] (RW)
 *
 * Configures the FTM to use an external global time base signal that is
 * generated by another FTM.
 *
 * Values:
 * - 0 - Use of an external global time base is disabled.
 * - 1 - Use of an external global time base is enabled.
 */
//@{
#define BP_FTM_CONF_GTBEEN   (9U)          //!< Bit position for FTM_CONF_GTBEEN.
#define BM_FTM_CONF_GTBEEN   (0x00000200U) //!< Bit mask for FTM_CONF_GTBEEN.
#define BS_FTM_CONF_GTBEEN   (1U)          //!< Bit field size in bits for FTM_CONF_GTBEEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CONF_GTBEEN field.
#define BR_FTM_CONF_GTBEEN(x) (BITBAND_ACCESS32(HW_FTM_CONF_ADDR(x), BP_FTM_CONF_GTBEEN))
#endif

//! @brief Format value for bitfield FTM_CONF_GTBEEN.
#define BF_FTM_CONF_GTBEEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CONF_GTBEEN), uint32_t) & BM_FTM_CONF_GTBEEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GTBEEN field to a new value.
#define BW_FTM_CONF_GTBEEN(x, v) (BITBAND_ACCESS32(HW_FTM_CONF_ADDR(x), BP_FTM_CONF_GTBEEN) = (v))
#endif
//@}

/*!
 * @name Register FTM_CONF, field GTBEOUT[10] (RW)
 *
 * Enables the global time base signal generation to other FTMs.
 *
 * Values:
 * - 0 - A global time base signal generation is disabled.
 * - 1 - A global time base signal generation is enabled.
 */
//@{
#define BP_FTM_CONF_GTBEOUT  (10U)         //!< Bit position for FTM_CONF_GTBEOUT.
#define BM_FTM_CONF_GTBEOUT  (0x00000400U) //!< Bit mask for FTM_CONF_GTBEOUT.
#define BS_FTM_CONF_GTBEOUT  (1U)          //!< Bit field size in bits for FTM_CONF_GTBEOUT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_CONF_GTBEOUT field.
#define BR_FTM_CONF_GTBEOUT(x) (BITBAND_ACCESS32(HW_FTM_CONF_ADDR(x), BP_FTM_CONF_GTBEOUT))
#endif

//! @brief Format value for bitfield FTM_CONF_GTBEOUT.
#define BF_FTM_CONF_GTBEOUT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_CONF_GTBEOUT), uint32_t) & BM_FTM_CONF_GTBEOUT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GTBEOUT field to a new value.
#define BW_FTM_CONF_GTBEOUT(x, v) (BITBAND_ACCESS32(HW_FTM_CONF_ADDR(x), BP_FTM_CONF_GTBEOUT) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_FLTPOL - FTM Fault Input Polarity
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_FLTPOL - FTM Fault Input Polarity (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the fault inputs polarity.
 */
typedef union _hw_ftm_fltpol
{
    uint32_t U;
    struct _hw_ftm_fltpol_bitfields
    {
        uint32_t FLT0POL : 1;          //!< [0] Fault Input 0 Polarity
        uint32_t FLT1POL : 1;          //!< [1] Fault Input 1 Polarity
        uint32_t FLT2POL : 1;          //!< [2] Fault Input 2 Polarity
        uint32_t FLT3POL : 1;          //!< [3] Fault Input 3 Polarity
        uint32_t RESERVED0 : 28;       //!< [31:4]
    } B;
} hw_ftm_fltpol_t;
#endif

/*!
 * @name Constants and macros for entire FTM_FLTPOL register
 */
//@{
#define HW_FTM_FLTPOL_ADDR(x)    (REGS_FTM_BASE(x) + 0x88U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_FLTPOL(x)         (*(__IO hw_ftm_fltpol_t *) HW_FTM_FLTPOL_ADDR(x))
#define HW_FTM_FLTPOL_RD(x)      (HW_FTM_FLTPOL(x).U)
#define HW_FTM_FLTPOL_WR(x, v)   (HW_FTM_FLTPOL(x).U = (v))
#define HW_FTM_FLTPOL_SET(x, v)  (HW_FTM_FLTPOL_WR(x, HW_FTM_FLTPOL_RD(x) |  (v)))
#define HW_FTM_FLTPOL_CLR(x, v)  (HW_FTM_FLTPOL_WR(x, HW_FTM_FLTPOL_RD(x) & ~(v)))
#define HW_FTM_FLTPOL_TOG(x, v)  (HW_FTM_FLTPOL_WR(x, HW_FTM_FLTPOL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_FLTPOL bitfields
 */

/*!
 * @name Register FTM_FLTPOL, field FLT0POL[0] (RW)
 *
 * Defines the polarity of the fault input. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault input polarity is active high. A 1 at the fault input
 *     indicates a fault.
 * - 1 - The fault input polarity is active low. A 0 at the fault input
 *     indicates a fault.
 */
//@{
#define BP_FTM_FLTPOL_FLT0POL (0U)         //!< Bit position for FTM_FLTPOL_FLT0POL.
#define BM_FTM_FLTPOL_FLT0POL (0x00000001U) //!< Bit mask for FTM_FLTPOL_FLT0POL.
#define BS_FTM_FLTPOL_FLT0POL (1U)         //!< Bit field size in bits for FTM_FLTPOL_FLT0POL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTPOL_FLT0POL field.
#define BR_FTM_FLTPOL_FLT0POL(x) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT0POL))
#endif

//! @brief Format value for bitfield FTM_FLTPOL_FLT0POL.
#define BF_FTM_FLTPOL_FLT0POL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTPOL_FLT0POL), uint32_t) & BM_FTM_FLTPOL_FLT0POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLT0POL field to a new value.
#define BW_FTM_FLTPOL_FLT0POL(x, v) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT0POL) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTPOL, field FLT1POL[1] (RW)
 *
 * Defines the polarity of the fault input. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault input polarity is active high. A 1 at the fault input
 *     indicates a fault.
 * - 1 - The fault input polarity is active low. A 0 at the fault input
 *     indicates a fault.
 */
//@{
#define BP_FTM_FLTPOL_FLT1POL (1U)         //!< Bit position for FTM_FLTPOL_FLT1POL.
#define BM_FTM_FLTPOL_FLT1POL (0x00000002U) //!< Bit mask for FTM_FLTPOL_FLT1POL.
#define BS_FTM_FLTPOL_FLT1POL (1U)         //!< Bit field size in bits for FTM_FLTPOL_FLT1POL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTPOL_FLT1POL field.
#define BR_FTM_FLTPOL_FLT1POL(x) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT1POL))
#endif

//! @brief Format value for bitfield FTM_FLTPOL_FLT1POL.
#define BF_FTM_FLTPOL_FLT1POL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTPOL_FLT1POL), uint32_t) & BM_FTM_FLTPOL_FLT1POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLT1POL field to a new value.
#define BW_FTM_FLTPOL_FLT1POL(x, v) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT1POL) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTPOL, field FLT2POL[2] (RW)
 *
 * Defines the polarity of the fault input. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault input polarity is active high. A 1 at the fault input
 *     indicates a fault.
 * - 1 - The fault input polarity is active low. A 0 at the fault input
 *     indicates a fault.
 */
//@{
#define BP_FTM_FLTPOL_FLT2POL (2U)         //!< Bit position for FTM_FLTPOL_FLT2POL.
#define BM_FTM_FLTPOL_FLT2POL (0x00000004U) //!< Bit mask for FTM_FLTPOL_FLT2POL.
#define BS_FTM_FLTPOL_FLT2POL (1U)         //!< Bit field size in bits for FTM_FLTPOL_FLT2POL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTPOL_FLT2POL field.
#define BR_FTM_FLTPOL_FLT2POL(x) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT2POL))
#endif

//! @brief Format value for bitfield FTM_FLTPOL_FLT2POL.
#define BF_FTM_FLTPOL_FLT2POL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTPOL_FLT2POL), uint32_t) & BM_FTM_FLTPOL_FLT2POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLT2POL field to a new value.
#define BW_FTM_FLTPOL_FLT2POL(x, v) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT2POL) = (v))
#endif
//@}

/*!
 * @name Register FTM_FLTPOL, field FLT3POL[3] (RW)
 *
 * Defines the polarity of the fault input. This field is write protected. It
 * can be written only when MODE[WPDIS] = 1.
 *
 * Values:
 * - 0 - The fault input polarity is active high. A 1 at the fault input
 *     indicates a fault.
 * - 1 - The fault input polarity is active low. A 0 at the fault input
 *     indicates a fault.
 */
//@{
#define BP_FTM_FLTPOL_FLT3POL (3U)         //!< Bit position for FTM_FLTPOL_FLT3POL.
#define BM_FTM_FLTPOL_FLT3POL (0x00000008U) //!< Bit mask for FTM_FLTPOL_FLT3POL.
#define BS_FTM_FLTPOL_FLT3POL (1U)         //!< Bit field size in bits for FTM_FLTPOL_FLT3POL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_FLTPOL_FLT3POL field.
#define BR_FTM_FLTPOL_FLT3POL(x) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT3POL))
#endif

//! @brief Format value for bitfield FTM_FLTPOL_FLT3POL.
#define BF_FTM_FLTPOL_FLT3POL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_FLTPOL_FLT3POL), uint32_t) & BM_FTM_FLTPOL_FLT3POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLT3POL field to a new value.
#define BW_FTM_FLTPOL_FLT3POL(x, v) (BITBAND_ACCESS32(HW_FTM_FLTPOL_ADDR(x), BP_FTM_FLTPOL_FLT3POL) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_SYNCONF - Synchronization Configuration
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_SYNCONF - Synchronization Configuration (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register selects the PWM synchronization configuration, SWOCTRL, INVCTRL
 * and CNTIN registers synchronization, if FTM clears the TRIGj bit, where j =
 * 0, 1, 2, when the hardware trigger j is detected.
 */
typedef union _hw_ftm_synconf
{
    uint32_t U;
    struct _hw_ftm_synconf_bitfields
    {
        uint32_t HWTRIGMODE : 1;       //!< [0] Hardware Trigger Mode
        uint32_t RESERVED0 : 1;        //!< [1]
        uint32_t CNTINC : 1;           //!< [2] CNTIN Register Synchronization
        uint32_t RESERVED1 : 1;        //!< [3]
        uint32_t INVC : 1;             //!< [4] INVCTRL Register Synchronization
        uint32_t SWOC : 1;             //!< [5] SWOCTRL Register Synchronization
        uint32_t RESERVED2 : 1;        //!< [6]
        uint32_t SYNCMODE : 1;         //!< [7] Synchronization Mode
        uint32_t SWRSTCNT : 1;         //!< [8]
        uint32_t SWWRBUF : 1;          //!< [9]
        uint32_t SWOM : 1;             //!< [10]
        uint32_t SWINVC : 1;           //!< [11]
        uint32_t SWSOC : 1;            //!< [12]
        uint32_t RESERVED3 : 3;        //!< [15:13]
        uint32_t HWRSTCNT : 1;         //!< [16]
        uint32_t HWWRBUF : 1;          //!< [17]
        uint32_t HWOM : 1;             //!< [18]
        uint32_t HWINVC : 1;           //!< [19]
        uint32_t HWSOC : 1;            //!< [20]
        uint32_t RESERVED4 : 11;       //!< [31:21]
    } B;
} hw_ftm_synconf_t;
#endif

/*!
 * @name Constants and macros for entire FTM_SYNCONF register
 */
//@{
#define HW_FTM_SYNCONF_ADDR(x)   (REGS_FTM_BASE(x) + 0x8CU)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_SYNCONF(x)        (*(__IO hw_ftm_synconf_t *) HW_FTM_SYNCONF_ADDR(x))
#define HW_FTM_SYNCONF_RD(x)     (HW_FTM_SYNCONF(x).U)
#define HW_FTM_SYNCONF_WR(x, v)  (HW_FTM_SYNCONF(x).U = (v))
#define HW_FTM_SYNCONF_SET(x, v) (HW_FTM_SYNCONF_WR(x, HW_FTM_SYNCONF_RD(x) |  (v)))
#define HW_FTM_SYNCONF_CLR(x, v) (HW_FTM_SYNCONF_WR(x, HW_FTM_SYNCONF_RD(x) & ~(v)))
#define HW_FTM_SYNCONF_TOG(x, v) (HW_FTM_SYNCONF_WR(x, HW_FTM_SYNCONF_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_SYNCONF bitfields
 */

/*!
 * @name Register FTM_SYNCONF, field HWTRIGMODE[0] (RW)
 *
 * Values:
 * - 0 - FTM clears the TRIGj bit when the hardware trigger j is detected, where
 *     j = 0, 1,2.
 * - 1 - FTM does not clear the TRIGj bit when the hardware trigger j is
 *     detected, where j = 0, 1,2.
 */
//@{
#define BP_FTM_SYNCONF_HWTRIGMODE (0U)     //!< Bit position for FTM_SYNCONF_HWTRIGMODE.
#define BM_FTM_SYNCONF_HWTRIGMODE (0x00000001U) //!< Bit mask for FTM_SYNCONF_HWTRIGMODE.
#define BS_FTM_SYNCONF_HWTRIGMODE (1U)     //!< Bit field size in bits for FTM_SYNCONF_HWTRIGMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_HWTRIGMODE field.
#define BR_FTM_SYNCONF_HWTRIGMODE(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWTRIGMODE))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_HWTRIGMODE.
#define BF_FTM_SYNCONF_HWTRIGMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_HWTRIGMODE), uint32_t) & BM_FTM_SYNCONF_HWTRIGMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HWTRIGMODE field to a new value.
#define BW_FTM_SYNCONF_HWTRIGMODE(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWTRIGMODE) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field CNTINC[2] (RW)
 *
 * Values:
 * - 0 - CNTIN register is updated with its buffer value at all rising edges of
 *     system clock.
 * - 1 - CNTIN register is updated with its buffer value by the PWM
 *     synchronization.
 */
//@{
#define BP_FTM_SYNCONF_CNTINC (2U)         //!< Bit position for FTM_SYNCONF_CNTINC.
#define BM_FTM_SYNCONF_CNTINC (0x00000004U) //!< Bit mask for FTM_SYNCONF_CNTINC.
#define BS_FTM_SYNCONF_CNTINC (1U)         //!< Bit field size in bits for FTM_SYNCONF_CNTINC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_CNTINC field.
#define BR_FTM_SYNCONF_CNTINC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_CNTINC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_CNTINC.
#define BF_FTM_SYNCONF_CNTINC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_CNTINC), uint32_t) & BM_FTM_SYNCONF_CNTINC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNTINC field to a new value.
#define BW_FTM_SYNCONF_CNTINC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_CNTINC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field INVC[4] (RW)
 *
 * Values:
 * - 0 - INVCTRL register is updated with its buffer value at all rising edges
 *     of system clock.
 * - 1 - INVCTRL register is updated with its buffer value by the PWM
 *     synchronization.
 */
//@{
#define BP_FTM_SYNCONF_INVC  (4U)          //!< Bit position for FTM_SYNCONF_INVC.
#define BM_FTM_SYNCONF_INVC  (0x00000010U) //!< Bit mask for FTM_SYNCONF_INVC.
#define BS_FTM_SYNCONF_INVC  (1U)          //!< Bit field size in bits for FTM_SYNCONF_INVC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_INVC field.
#define BR_FTM_SYNCONF_INVC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_INVC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_INVC.
#define BF_FTM_SYNCONF_INVC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_INVC), uint32_t) & BM_FTM_SYNCONF_INVC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INVC field to a new value.
#define BW_FTM_SYNCONF_INVC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_INVC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SWOC[5] (RW)
 *
 * Values:
 * - 0 - SWOCTRL register is updated with its buffer value at all rising edges
 *     of system clock.
 * - 1 - SWOCTRL register is updated with its buffer value by the PWM
 *     synchronization.
 */
//@{
#define BP_FTM_SYNCONF_SWOC  (5U)          //!< Bit position for FTM_SYNCONF_SWOC.
#define BM_FTM_SYNCONF_SWOC  (0x00000020U) //!< Bit mask for FTM_SYNCONF_SWOC.
#define BS_FTM_SYNCONF_SWOC  (1U)          //!< Bit field size in bits for FTM_SYNCONF_SWOC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SWOC field.
#define BR_FTM_SYNCONF_SWOC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWOC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SWOC.
#define BF_FTM_SYNCONF_SWOC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SWOC), uint32_t) & BM_FTM_SYNCONF_SWOC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWOC field to a new value.
#define BW_FTM_SYNCONF_SWOC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWOC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SYNCMODE[7] (RW)
 *
 * Selects the PWM Synchronization mode.
 *
 * Values:
 * - 0 - Legacy PWM synchronization is selected.
 * - 1 - Enhanced PWM synchronization is selected.
 */
//@{
#define BP_FTM_SYNCONF_SYNCMODE (7U)       //!< Bit position for FTM_SYNCONF_SYNCMODE.
#define BM_FTM_SYNCONF_SYNCMODE (0x00000080U) //!< Bit mask for FTM_SYNCONF_SYNCMODE.
#define BS_FTM_SYNCONF_SYNCMODE (1U)       //!< Bit field size in bits for FTM_SYNCONF_SYNCMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SYNCMODE field.
#define BR_FTM_SYNCONF_SYNCMODE(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SYNCMODE))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SYNCMODE.
#define BF_FTM_SYNCONF_SYNCMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SYNCMODE), uint32_t) & BM_FTM_SYNCONF_SYNCMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNCMODE field to a new value.
#define BW_FTM_SYNCONF_SYNCMODE(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SYNCMODE) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SWRSTCNT[8] (RW)
 *
 * FTM counter synchronization is activated by the software trigger.
 *
 * Values:
 * - 0 - The software trigger does not activate the FTM counter synchronization.
 * - 1 - The software trigger activates the FTM counter synchronization.
 */
//@{
#define BP_FTM_SYNCONF_SWRSTCNT (8U)       //!< Bit position for FTM_SYNCONF_SWRSTCNT.
#define BM_FTM_SYNCONF_SWRSTCNT (0x00000100U) //!< Bit mask for FTM_SYNCONF_SWRSTCNT.
#define BS_FTM_SYNCONF_SWRSTCNT (1U)       //!< Bit field size in bits for FTM_SYNCONF_SWRSTCNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SWRSTCNT field.
#define BR_FTM_SYNCONF_SWRSTCNT(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWRSTCNT))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SWRSTCNT.
#define BF_FTM_SYNCONF_SWRSTCNT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SWRSTCNT), uint32_t) & BM_FTM_SYNCONF_SWRSTCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWRSTCNT field to a new value.
#define BW_FTM_SYNCONF_SWRSTCNT(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWRSTCNT) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SWWRBUF[9] (RW)
 *
 * MOD, CNTIN, and CV registers synchronization is activated by the software
 * trigger.
 *
 * Values:
 * - 0 - The software trigger does not activate MOD, CNTIN, and CV registers
 *     synchronization.
 * - 1 - The software trigger activates MOD, CNTIN, and CV registers
 *     synchronization.
 */
//@{
#define BP_FTM_SYNCONF_SWWRBUF (9U)        //!< Bit position for FTM_SYNCONF_SWWRBUF.
#define BM_FTM_SYNCONF_SWWRBUF (0x00000200U) //!< Bit mask for FTM_SYNCONF_SWWRBUF.
#define BS_FTM_SYNCONF_SWWRBUF (1U)        //!< Bit field size in bits for FTM_SYNCONF_SWWRBUF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SWWRBUF field.
#define BR_FTM_SYNCONF_SWWRBUF(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWWRBUF))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SWWRBUF.
#define BF_FTM_SYNCONF_SWWRBUF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SWWRBUF), uint32_t) & BM_FTM_SYNCONF_SWWRBUF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWWRBUF field to a new value.
#define BW_FTM_SYNCONF_SWWRBUF(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWWRBUF) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SWOM[10] (RW)
 *
 * Output mask synchronization is activated by the software trigger.
 *
 * Values:
 * - 0 - The software trigger does not activate the OUTMASK register
 *     synchronization.
 * - 1 - The software trigger activates the OUTMASK register synchronization.
 */
//@{
#define BP_FTM_SYNCONF_SWOM  (10U)         //!< Bit position for FTM_SYNCONF_SWOM.
#define BM_FTM_SYNCONF_SWOM  (0x00000400U) //!< Bit mask for FTM_SYNCONF_SWOM.
#define BS_FTM_SYNCONF_SWOM  (1U)          //!< Bit field size in bits for FTM_SYNCONF_SWOM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SWOM field.
#define BR_FTM_SYNCONF_SWOM(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWOM))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SWOM.
#define BF_FTM_SYNCONF_SWOM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SWOM), uint32_t) & BM_FTM_SYNCONF_SWOM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWOM field to a new value.
#define BW_FTM_SYNCONF_SWOM(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWOM) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SWINVC[11] (RW)
 *
 * Inverting control synchronization is activated by the software trigger.
 *
 * Values:
 * - 0 - The software trigger does not activate the INVCTRL register
 *     synchronization.
 * - 1 - The software trigger activates the INVCTRL register synchronization.
 */
//@{
#define BP_FTM_SYNCONF_SWINVC (11U)        //!< Bit position for FTM_SYNCONF_SWINVC.
#define BM_FTM_SYNCONF_SWINVC (0x00000800U) //!< Bit mask for FTM_SYNCONF_SWINVC.
#define BS_FTM_SYNCONF_SWINVC (1U)         //!< Bit field size in bits for FTM_SYNCONF_SWINVC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SWINVC field.
#define BR_FTM_SYNCONF_SWINVC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWINVC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SWINVC.
#define BF_FTM_SYNCONF_SWINVC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SWINVC), uint32_t) & BM_FTM_SYNCONF_SWINVC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWINVC field to a new value.
#define BW_FTM_SYNCONF_SWINVC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWINVC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field SWSOC[12] (RW)
 *
 * Software output control synchronization is activated by the software trigger.
 *
 * Values:
 * - 0 - The software trigger does not activate the SWOCTRL register
 *     synchronization.
 * - 1 - The software trigger activates the SWOCTRL register synchronization.
 */
//@{
#define BP_FTM_SYNCONF_SWSOC (12U)         //!< Bit position for FTM_SYNCONF_SWSOC.
#define BM_FTM_SYNCONF_SWSOC (0x00001000U) //!< Bit mask for FTM_SYNCONF_SWSOC.
#define BS_FTM_SYNCONF_SWSOC (1U)          //!< Bit field size in bits for FTM_SYNCONF_SWSOC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_SWSOC field.
#define BR_FTM_SYNCONF_SWSOC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWSOC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_SWSOC.
#define BF_FTM_SYNCONF_SWSOC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_SWSOC), uint32_t) & BM_FTM_SYNCONF_SWSOC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWSOC field to a new value.
#define BW_FTM_SYNCONF_SWSOC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_SWSOC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field HWRSTCNT[16] (RW)
 *
 * FTM counter synchronization is activated by a hardware trigger.
 *
 * Values:
 * - 0 - A hardware trigger does not activate the FTM counter synchronization.
 * - 1 - A hardware trigger activates the FTM counter synchronization.
 */
//@{
#define BP_FTM_SYNCONF_HWRSTCNT (16U)      //!< Bit position for FTM_SYNCONF_HWRSTCNT.
#define BM_FTM_SYNCONF_HWRSTCNT (0x00010000U) //!< Bit mask for FTM_SYNCONF_HWRSTCNT.
#define BS_FTM_SYNCONF_HWRSTCNT (1U)       //!< Bit field size in bits for FTM_SYNCONF_HWRSTCNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_HWRSTCNT field.
#define BR_FTM_SYNCONF_HWRSTCNT(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWRSTCNT))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_HWRSTCNT.
#define BF_FTM_SYNCONF_HWRSTCNT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_HWRSTCNT), uint32_t) & BM_FTM_SYNCONF_HWRSTCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HWRSTCNT field to a new value.
#define BW_FTM_SYNCONF_HWRSTCNT(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWRSTCNT) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field HWWRBUF[17] (RW)
 *
 * MOD, CNTIN, and CV registers synchronization is activated by a hardware
 * trigger.
 *
 * Values:
 * - 0 - A hardware trigger does not activate MOD, CNTIN, and CV registers
 *     synchronization.
 * - 1 - A hardware trigger activates MOD, CNTIN, and CV registers
 *     synchronization.
 */
//@{
#define BP_FTM_SYNCONF_HWWRBUF (17U)       //!< Bit position for FTM_SYNCONF_HWWRBUF.
#define BM_FTM_SYNCONF_HWWRBUF (0x00020000U) //!< Bit mask for FTM_SYNCONF_HWWRBUF.
#define BS_FTM_SYNCONF_HWWRBUF (1U)        //!< Bit field size in bits for FTM_SYNCONF_HWWRBUF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_HWWRBUF field.
#define BR_FTM_SYNCONF_HWWRBUF(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWWRBUF))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_HWWRBUF.
#define BF_FTM_SYNCONF_HWWRBUF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_HWWRBUF), uint32_t) & BM_FTM_SYNCONF_HWWRBUF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HWWRBUF field to a new value.
#define BW_FTM_SYNCONF_HWWRBUF(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWWRBUF) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field HWOM[18] (RW)
 *
 * Output mask synchronization is activated by a hardware trigger.
 *
 * Values:
 * - 0 - A hardware trigger does not activate the OUTMASK register
 *     synchronization.
 * - 1 - A hardware trigger activates the OUTMASK register synchronization.
 */
//@{
#define BP_FTM_SYNCONF_HWOM  (18U)         //!< Bit position for FTM_SYNCONF_HWOM.
#define BM_FTM_SYNCONF_HWOM  (0x00040000U) //!< Bit mask for FTM_SYNCONF_HWOM.
#define BS_FTM_SYNCONF_HWOM  (1U)          //!< Bit field size in bits for FTM_SYNCONF_HWOM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_HWOM field.
#define BR_FTM_SYNCONF_HWOM(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWOM))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_HWOM.
#define BF_FTM_SYNCONF_HWOM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_HWOM), uint32_t) & BM_FTM_SYNCONF_HWOM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HWOM field to a new value.
#define BW_FTM_SYNCONF_HWOM(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWOM) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field HWINVC[19] (RW)
 *
 * Inverting control synchronization is activated by a hardware trigger.
 *
 * Values:
 * - 0 - A hardware trigger does not activate the INVCTRL register
 *     synchronization.
 * - 1 - A hardware trigger activates the INVCTRL register synchronization.
 */
//@{
#define BP_FTM_SYNCONF_HWINVC (19U)        //!< Bit position for FTM_SYNCONF_HWINVC.
#define BM_FTM_SYNCONF_HWINVC (0x00080000U) //!< Bit mask for FTM_SYNCONF_HWINVC.
#define BS_FTM_SYNCONF_HWINVC (1U)         //!< Bit field size in bits for FTM_SYNCONF_HWINVC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_HWINVC field.
#define BR_FTM_SYNCONF_HWINVC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWINVC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_HWINVC.
#define BF_FTM_SYNCONF_HWINVC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_HWINVC), uint32_t) & BM_FTM_SYNCONF_HWINVC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HWINVC field to a new value.
#define BW_FTM_SYNCONF_HWINVC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWINVC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SYNCONF, field HWSOC[20] (RW)
 *
 * Software output control synchronization is activated by a hardware trigger.
 *
 * Values:
 * - 0 - A hardware trigger does not activate the SWOCTRL register
 *     synchronization.
 * - 1 - A hardware trigger activates the SWOCTRL register synchronization.
 */
//@{
#define BP_FTM_SYNCONF_HWSOC (20U)         //!< Bit position for FTM_SYNCONF_HWSOC.
#define BM_FTM_SYNCONF_HWSOC (0x00100000U) //!< Bit mask for FTM_SYNCONF_HWSOC.
#define BS_FTM_SYNCONF_HWSOC (1U)          //!< Bit field size in bits for FTM_SYNCONF_HWSOC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SYNCONF_HWSOC field.
#define BR_FTM_SYNCONF_HWSOC(x) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWSOC))
#endif

//! @brief Format value for bitfield FTM_SYNCONF_HWSOC.
#define BF_FTM_SYNCONF_HWSOC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SYNCONF_HWSOC), uint32_t) & BM_FTM_SYNCONF_HWSOC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HWSOC field to a new value.
#define BW_FTM_SYNCONF_HWSOC(x, v) (BITBAND_ACCESS32(HW_FTM_SYNCONF_ADDR(x), BP_FTM_SYNCONF_HWSOC) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_INVCTRL - FTM Inverting Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_INVCTRL - FTM Inverting Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register controls when the channel (n) output becomes the channel (n+1)
 * output, and channel (n+1) output becomes the channel (n) output. Each INVmEN
 * bit enables the inverting operation for the corresponding pair channels m. This
 * register has a write buffer. The INVmEN bit is updated by the INVCTRL
 * register synchronization.
 */
typedef union _hw_ftm_invctrl
{
    uint32_t U;
    struct _hw_ftm_invctrl_bitfields
    {
        uint32_t INV0EN : 1;           //!< [0] Pair Channels 0 Inverting Enable
        uint32_t INV1EN : 1;           //!< [1] Pair Channels 1 Inverting Enable
        uint32_t INV2EN : 1;           //!< [2] Pair Channels 2 Inverting Enable
        uint32_t INV3EN : 1;           //!< [3] Pair Channels 3 Inverting Enable
        uint32_t RESERVED0 : 28;       //!< [31:4]
    } B;
} hw_ftm_invctrl_t;
#endif

/*!
 * @name Constants and macros for entire FTM_INVCTRL register
 */
//@{
#define HW_FTM_INVCTRL_ADDR(x)   (REGS_FTM_BASE(x) + 0x90U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_INVCTRL(x)        (*(__IO hw_ftm_invctrl_t *) HW_FTM_INVCTRL_ADDR(x))
#define HW_FTM_INVCTRL_RD(x)     (HW_FTM_INVCTRL(x).U)
#define HW_FTM_INVCTRL_WR(x, v)  (HW_FTM_INVCTRL(x).U = (v))
#define HW_FTM_INVCTRL_SET(x, v) (HW_FTM_INVCTRL_WR(x, HW_FTM_INVCTRL_RD(x) |  (v)))
#define HW_FTM_INVCTRL_CLR(x, v) (HW_FTM_INVCTRL_WR(x, HW_FTM_INVCTRL_RD(x) & ~(v)))
#define HW_FTM_INVCTRL_TOG(x, v) (HW_FTM_INVCTRL_WR(x, HW_FTM_INVCTRL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_INVCTRL bitfields
 */

/*!
 * @name Register FTM_INVCTRL, field INV0EN[0] (RW)
 *
 * Values:
 * - 0 - Inverting is disabled.
 * - 1 - Inverting is enabled.
 */
//@{
#define BP_FTM_INVCTRL_INV0EN (0U)         //!< Bit position for FTM_INVCTRL_INV0EN.
#define BM_FTM_INVCTRL_INV0EN (0x00000001U) //!< Bit mask for FTM_INVCTRL_INV0EN.
#define BS_FTM_INVCTRL_INV0EN (1U)         //!< Bit field size in bits for FTM_INVCTRL_INV0EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_INVCTRL_INV0EN field.
#define BR_FTM_INVCTRL_INV0EN(x) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV0EN))
#endif

//! @brief Format value for bitfield FTM_INVCTRL_INV0EN.
#define BF_FTM_INVCTRL_INV0EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_INVCTRL_INV0EN), uint32_t) & BM_FTM_INVCTRL_INV0EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INV0EN field to a new value.
#define BW_FTM_INVCTRL_INV0EN(x, v) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV0EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_INVCTRL, field INV1EN[1] (RW)
 *
 * Values:
 * - 0 - Inverting is disabled.
 * - 1 - Inverting is enabled.
 */
//@{
#define BP_FTM_INVCTRL_INV1EN (1U)         //!< Bit position for FTM_INVCTRL_INV1EN.
#define BM_FTM_INVCTRL_INV1EN (0x00000002U) //!< Bit mask for FTM_INVCTRL_INV1EN.
#define BS_FTM_INVCTRL_INV1EN (1U)         //!< Bit field size in bits for FTM_INVCTRL_INV1EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_INVCTRL_INV1EN field.
#define BR_FTM_INVCTRL_INV1EN(x) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV1EN))
#endif

//! @brief Format value for bitfield FTM_INVCTRL_INV1EN.
#define BF_FTM_INVCTRL_INV1EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_INVCTRL_INV1EN), uint32_t) & BM_FTM_INVCTRL_INV1EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INV1EN field to a new value.
#define BW_FTM_INVCTRL_INV1EN(x, v) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV1EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_INVCTRL, field INV2EN[2] (RW)
 *
 * Values:
 * - 0 - Inverting is disabled.
 * - 1 - Inverting is enabled.
 */
//@{
#define BP_FTM_INVCTRL_INV2EN (2U)         //!< Bit position for FTM_INVCTRL_INV2EN.
#define BM_FTM_INVCTRL_INV2EN (0x00000004U) //!< Bit mask for FTM_INVCTRL_INV2EN.
#define BS_FTM_INVCTRL_INV2EN (1U)         //!< Bit field size in bits for FTM_INVCTRL_INV2EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_INVCTRL_INV2EN field.
#define BR_FTM_INVCTRL_INV2EN(x) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV2EN))
#endif

//! @brief Format value for bitfield FTM_INVCTRL_INV2EN.
#define BF_FTM_INVCTRL_INV2EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_INVCTRL_INV2EN), uint32_t) & BM_FTM_INVCTRL_INV2EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INV2EN field to a new value.
#define BW_FTM_INVCTRL_INV2EN(x, v) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV2EN) = (v))
#endif
//@}

/*!
 * @name Register FTM_INVCTRL, field INV3EN[3] (RW)
 *
 * Values:
 * - 0 - Inverting is disabled.
 * - 1 - Inverting is enabled.
 */
//@{
#define BP_FTM_INVCTRL_INV3EN (3U)         //!< Bit position for FTM_INVCTRL_INV3EN.
#define BM_FTM_INVCTRL_INV3EN (0x00000008U) //!< Bit mask for FTM_INVCTRL_INV3EN.
#define BS_FTM_INVCTRL_INV3EN (1U)         //!< Bit field size in bits for FTM_INVCTRL_INV3EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_INVCTRL_INV3EN field.
#define BR_FTM_INVCTRL_INV3EN(x) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV3EN))
#endif

//! @brief Format value for bitfield FTM_INVCTRL_INV3EN.
#define BF_FTM_INVCTRL_INV3EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_INVCTRL_INV3EN), uint32_t) & BM_FTM_INVCTRL_INV3EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INV3EN field to a new value.
#define BW_FTM_INVCTRL_INV3EN(x, v) (BITBAND_ACCESS32(HW_FTM_INVCTRL_ADDR(x), BP_FTM_INVCTRL_INV3EN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_SWOCTRL - FTM Software Output Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_SWOCTRL - FTM Software Output Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register enables software control of channel (n) output and defines the
 * value forced to the channel (n) output: The CHnOC bits enable the control of
 * the corresponding channel (n) output by software. The CHnOCV bits select the
 * value that is forced at the corresponding channel (n) output. This register has
 * a write buffer. The fields are updated by the SWOCTRL register synchronization.
 */
typedef union _hw_ftm_swoctrl
{
    uint32_t U;
    struct _hw_ftm_swoctrl_bitfields
    {
        uint32_t CH0OC : 1;            //!< [0] Channel 0 Software Output Control Enable
        uint32_t CH1OC : 1;            //!< [1] Channel 1 Software Output Control Enable
        uint32_t CH2OC : 1;            //!< [2] Channel 2 Software Output Control Enable
        uint32_t CH3OC : 1;            //!< [3] Channel 3 Software Output Control Enable
        uint32_t CH4OC : 1;            //!< [4] Channel 4 Software Output Control Enable
        uint32_t CH5OC : 1;            //!< [5] Channel 5 Software Output Control Enable
        uint32_t CH6OC : 1;            //!< [6] Channel 6 Software Output Control Enable
        uint32_t CH7OC : 1;            //!< [7] Channel 7 Software Output Control Enable
        uint32_t CH0OCV : 1;           //!< [8] Channel 0 Software Output Control Value
        uint32_t CH1OCV : 1;           //!< [9] Channel 1 Software Output Control Value
        uint32_t CH2OCV : 1;           //!< [10] Channel 2 Software Output Control Value
        uint32_t CH3OCV : 1;           //!< [11] Channel 3 Software Output Control Value
        uint32_t CH4OCV : 1;           //!< [12] Channel 4 Software Output Control Value
        uint32_t CH5OCV : 1;           //!< [13] Channel 5 Software Output Control Value
        uint32_t CH6OCV : 1;           //!< [14] Channel 6 Software Output Control Value
        uint32_t CH7OCV : 1;           //!< [15] Channel 7 Software Output Control Value
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_ftm_swoctrl_t;
#endif

/*!
 * @name Constants and macros for entire FTM_SWOCTRL register
 */
//@{
#define HW_FTM_SWOCTRL_ADDR(x)   (REGS_FTM_BASE(x) + 0x94U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_SWOCTRL(x)        (*(__IO hw_ftm_swoctrl_t *) HW_FTM_SWOCTRL_ADDR(x))
#define HW_FTM_SWOCTRL_RD(x)     (HW_FTM_SWOCTRL(x).U)
#define HW_FTM_SWOCTRL_WR(x, v)  (HW_FTM_SWOCTRL(x).U = (v))
#define HW_FTM_SWOCTRL_SET(x, v) (HW_FTM_SWOCTRL_WR(x, HW_FTM_SWOCTRL_RD(x) |  (v)))
#define HW_FTM_SWOCTRL_CLR(x, v) (HW_FTM_SWOCTRL_WR(x, HW_FTM_SWOCTRL_RD(x) & ~(v)))
#define HW_FTM_SWOCTRL_TOG(x, v) (HW_FTM_SWOCTRL_WR(x, HW_FTM_SWOCTRL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_SWOCTRL bitfields
 */

/*!
 * @name Register FTM_SWOCTRL, field CH0OC[0] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH0OC (0U)          //!< Bit position for FTM_SWOCTRL_CH0OC.
#define BM_FTM_SWOCTRL_CH0OC (0x00000001U) //!< Bit mask for FTM_SWOCTRL_CH0OC.
#define BS_FTM_SWOCTRL_CH0OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH0OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH0OC field.
#define BR_FTM_SWOCTRL_CH0OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH0OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH0OC.
#define BF_FTM_SWOCTRL_CH0OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH0OC), uint32_t) & BM_FTM_SWOCTRL_CH0OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0OC field to a new value.
#define BW_FTM_SWOCTRL_CH0OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH0OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH1OC[1] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH1OC (1U)          //!< Bit position for FTM_SWOCTRL_CH1OC.
#define BM_FTM_SWOCTRL_CH1OC (0x00000002U) //!< Bit mask for FTM_SWOCTRL_CH1OC.
#define BS_FTM_SWOCTRL_CH1OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH1OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH1OC field.
#define BR_FTM_SWOCTRL_CH1OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH1OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH1OC.
#define BF_FTM_SWOCTRL_CH1OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH1OC), uint32_t) & BM_FTM_SWOCTRL_CH1OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1OC field to a new value.
#define BW_FTM_SWOCTRL_CH1OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH1OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH2OC[2] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH2OC (2U)          //!< Bit position for FTM_SWOCTRL_CH2OC.
#define BM_FTM_SWOCTRL_CH2OC (0x00000004U) //!< Bit mask for FTM_SWOCTRL_CH2OC.
#define BS_FTM_SWOCTRL_CH2OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH2OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH2OC field.
#define BR_FTM_SWOCTRL_CH2OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH2OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH2OC.
#define BF_FTM_SWOCTRL_CH2OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH2OC), uint32_t) & BM_FTM_SWOCTRL_CH2OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2OC field to a new value.
#define BW_FTM_SWOCTRL_CH2OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH2OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH3OC[3] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH3OC (3U)          //!< Bit position for FTM_SWOCTRL_CH3OC.
#define BM_FTM_SWOCTRL_CH3OC (0x00000008U) //!< Bit mask for FTM_SWOCTRL_CH3OC.
#define BS_FTM_SWOCTRL_CH3OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH3OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH3OC field.
#define BR_FTM_SWOCTRL_CH3OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH3OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH3OC.
#define BF_FTM_SWOCTRL_CH3OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH3OC), uint32_t) & BM_FTM_SWOCTRL_CH3OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3OC field to a new value.
#define BW_FTM_SWOCTRL_CH3OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH3OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH4OC[4] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH4OC (4U)          //!< Bit position for FTM_SWOCTRL_CH4OC.
#define BM_FTM_SWOCTRL_CH4OC (0x00000010U) //!< Bit mask for FTM_SWOCTRL_CH4OC.
#define BS_FTM_SWOCTRL_CH4OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH4OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH4OC field.
#define BR_FTM_SWOCTRL_CH4OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH4OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH4OC.
#define BF_FTM_SWOCTRL_CH4OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH4OC), uint32_t) & BM_FTM_SWOCTRL_CH4OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4OC field to a new value.
#define BW_FTM_SWOCTRL_CH4OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH4OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH5OC[5] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH5OC (5U)          //!< Bit position for FTM_SWOCTRL_CH5OC.
#define BM_FTM_SWOCTRL_CH5OC (0x00000020U) //!< Bit mask for FTM_SWOCTRL_CH5OC.
#define BS_FTM_SWOCTRL_CH5OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH5OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH5OC field.
#define BR_FTM_SWOCTRL_CH5OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH5OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH5OC.
#define BF_FTM_SWOCTRL_CH5OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH5OC), uint32_t) & BM_FTM_SWOCTRL_CH5OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5OC field to a new value.
#define BW_FTM_SWOCTRL_CH5OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH5OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH6OC[6] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH6OC (6U)          //!< Bit position for FTM_SWOCTRL_CH6OC.
#define BM_FTM_SWOCTRL_CH6OC (0x00000040U) //!< Bit mask for FTM_SWOCTRL_CH6OC.
#define BS_FTM_SWOCTRL_CH6OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH6OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH6OC field.
#define BR_FTM_SWOCTRL_CH6OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH6OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH6OC.
#define BF_FTM_SWOCTRL_CH6OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH6OC), uint32_t) & BM_FTM_SWOCTRL_CH6OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6OC field to a new value.
#define BW_FTM_SWOCTRL_CH6OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH6OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH7OC[7] (RW)
 *
 * Values:
 * - 0 - The channel output is not affected by software output control.
 * - 1 - The channel output is affected by software output control.
 */
//@{
#define BP_FTM_SWOCTRL_CH7OC (7U)          //!< Bit position for FTM_SWOCTRL_CH7OC.
#define BM_FTM_SWOCTRL_CH7OC (0x00000080U) //!< Bit mask for FTM_SWOCTRL_CH7OC.
#define BS_FTM_SWOCTRL_CH7OC (1U)          //!< Bit field size in bits for FTM_SWOCTRL_CH7OC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH7OC field.
#define BR_FTM_SWOCTRL_CH7OC(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH7OC))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH7OC.
#define BF_FTM_SWOCTRL_CH7OC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH7OC), uint32_t) & BM_FTM_SWOCTRL_CH7OC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7OC field to a new value.
#define BW_FTM_SWOCTRL_CH7OC(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH7OC) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH0OCV[8] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH0OCV (8U)         //!< Bit position for FTM_SWOCTRL_CH0OCV.
#define BM_FTM_SWOCTRL_CH0OCV (0x00000100U) //!< Bit mask for FTM_SWOCTRL_CH0OCV.
#define BS_FTM_SWOCTRL_CH0OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH0OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH0OCV field.
#define BR_FTM_SWOCTRL_CH0OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH0OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH0OCV.
#define BF_FTM_SWOCTRL_CH0OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH0OCV), uint32_t) & BM_FTM_SWOCTRL_CH0OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0OCV field to a new value.
#define BW_FTM_SWOCTRL_CH0OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH0OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH1OCV[9] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH1OCV (9U)         //!< Bit position for FTM_SWOCTRL_CH1OCV.
#define BM_FTM_SWOCTRL_CH1OCV (0x00000200U) //!< Bit mask for FTM_SWOCTRL_CH1OCV.
#define BS_FTM_SWOCTRL_CH1OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH1OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH1OCV field.
#define BR_FTM_SWOCTRL_CH1OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH1OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH1OCV.
#define BF_FTM_SWOCTRL_CH1OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH1OCV), uint32_t) & BM_FTM_SWOCTRL_CH1OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1OCV field to a new value.
#define BW_FTM_SWOCTRL_CH1OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH1OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH2OCV[10] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH2OCV (10U)        //!< Bit position for FTM_SWOCTRL_CH2OCV.
#define BM_FTM_SWOCTRL_CH2OCV (0x00000400U) //!< Bit mask for FTM_SWOCTRL_CH2OCV.
#define BS_FTM_SWOCTRL_CH2OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH2OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH2OCV field.
#define BR_FTM_SWOCTRL_CH2OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH2OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH2OCV.
#define BF_FTM_SWOCTRL_CH2OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH2OCV), uint32_t) & BM_FTM_SWOCTRL_CH2OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2OCV field to a new value.
#define BW_FTM_SWOCTRL_CH2OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH2OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH3OCV[11] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH3OCV (11U)        //!< Bit position for FTM_SWOCTRL_CH3OCV.
#define BM_FTM_SWOCTRL_CH3OCV (0x00000800U) //!< Bit mask for FTM_SWOCTRL_CH3OCV.
#define BS_FTM_SWOCTRL_CH3OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH3OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH3OCV field.
#define BR_FTM_SWOCTRL_CH3OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH3OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH3OCV.
#define BF_FTM_SWOCTRL_CH3OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH3OCV), uint32_t) & BM_FTM_SWOCTRL_CH3OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3OCV field to a new value.
#define BW_FTM_SWOCTRL_CH3OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH3OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH4OCV[12] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH4OCV (12U)        //!< Bit position for FTM_SWOCTRL_CH4OCV.
#define BM_FTM_SWOCTRL_CH4OCV (0x00001000U) //!< Bit mask for FTM_SWOCTRL_CH4OCV.
#define BS_FTM_SWOCTRL_CH4OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH4OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH4OCV field.
#define BR_FTM_SWOCTRL_CH4OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH4OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH4OCV.
#define BF_FTM_SWOCTRL_CH4OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH4OCV), uint32_t) & BM_FTM_SWOCTRL_CH4OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4OCV field to a new value.
#define BW_FTM_SWOCTRL_CH4OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH4OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH5OCV[13] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH5OCV (13U)        //!< Bit position for FTM_SWOCTRL_CH5OCV.
#define BM_FTM_SWOCTRL_CH5OCV (0x00002000U) //!< Bit mask for FTM_SWOCTRL_CH5OCV.
#define BS_FTM_SWOCTRL_CH5OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH5OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH5OCV field.
#define BR_FTM_SWOCTRL_CH5OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH5OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH5OCV.
#define BF_FTM_SWOCTRL_CH5OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH5OCV), uint32_t) & BM_FTM_SWOCTRL_CH5OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5OCV field to a new value.
#define BW_FTM_SWOCTRL_CH5OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH5OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH6OCV[14] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH6OCV (14U)        //!< Bit position for FTM_SWOCTRL_CH6OCV.
#define BM_FTM_SWOCTRL_CH6OCV (0x00004000U) //!< Bit mask for FTM_SWOCTRL_CH6OCV.
#define BS_FTM_SWOCTRL_CH6OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH6OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH6OCV field.
#define BR_FTM_SWOCTRL_CH6OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH6OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH6OCV.
#define BF_FTM_SWOCTRL_CH6OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH6OCV), uint32_t) & BM_FTM_SWOCTRL_CH6OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6OCV field to a new value.
#define BW_FTM_SWOCTRL_CH6OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH6OCV) = (v))
#endif
//@}

/*!
 * @name Register FTM_SWOCTRL, field CH7OCV[15] (RW)
 *
 * Values:
 * - 0 - The software output control forces 0 to the channel output.
 * - 1 - The software output control forces 1 to the channel output.
 */
//@{
#define BP_FTM_SWOCTRL_CH7OCV (15U)        //!< Bit position for FTM_SWOCTRL_CH7OCV.
#define BM_FTM_SWOCTRL_CH7OCV (0x00008000U) //!< Bit mask for FTM_SWOCTRL_CH7OCV.
#define BS_FTM_SWOCTRL_CH7OCV (1U)         //!< Bit field size in bits for FTM_SWOCTRL_CH7OCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_SWOCTRL_CH7OCV field.
#define BR_FTM_SWOCTRL_CH7OCV(x) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH7OCV))
#endif

//! @brief Format value for bitfield FTM_SWOCTRL_CH7OCV.
#define BF_FTM_SWOCTRL_CH7OCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_SWOCTRL_CH7OCV), uint32_t) & BM_FTM_SWOCTRL_CH7OCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7OCV field to a new value.
#define BW_FTM_SWOCTRL_CH7OCV(x, v) (BITBAND_ACCESS32(HW_FTM_SWOCTRL_ADDR(x), BP_FTM_SWOCTRL_CH7OCV) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FTM_PWMLOAD - FTM PWM Load
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FTM_PWMLOAD - FTM PWM Load (RW)
 *
 * Reset value: 0x00000000U
 *
 * Enables the loading of the MOD, CNTIN, C(n)V, and C(n+1)V registers with the
 * values of their write buffers when the FTM counter changes from the MOD
 * register value to its next value or when a channel (j) match occurs. A match occurs
 * for the channel (j) when FTM counter = C(j)V.
 */
typedef union _hw_ftm_pwmload
{
    uint32_t U;
    struct _hw_ftm_pwmload_bitfields
    {
        uint32_t CH0SEL : 1;           //!< [0] Channel 0 Select
        uint32_t CH1SEL : 1;           //!< [1] Channel 1 Select
        uint32_t CH2SEL : 1;           //!< [2] Channel 2 Select
        uint32_t CH3SEL : 1;           //!< [3] Channel 3 Select
        uint32_t CH4SEL : 1;           //!< [4] Channel 4 Select
        uint32_t CH5SEL : 1;           //!< [5] Channel 5 Select
        uint32_t CH6SEL : 1;           //!< [6] Channel 6 Select
        uint32_t CH7SEL : 1;           //!< [7] Channel 7 Select
        uint32_t RESERVED0 : 1;        //!< [8]
        uint32_t LDOK : 1;             //!< [9] Load Enable
        uint32_t RESERVED1 : 22;       //!< [31:10]
    } B;
} hw_ftm_pwmload_t;
#endif

/*!
 * @name Constants and macros for entire FTM_PWMLOAD register
 */
//@{
#define HW_FTM_PWMLOAD_ADDR(x)   (REGS_FTM_BASE(x) + 0x98U)

#ifndef __LANGUAGE_ASM__
#define HW_FTM_PWMLOAD(x)        (*(__IO hw_ftm_pwmload_t *) HW_FTM_PWMLOAD_ADDR(x))
#define HW_FTM_PWMLOAD_RD(x)     (HW_FTM_PWMLOAD(x).U)
#define HW_FTM_PWMLOAD_WR(x, v)  (HW_FTM_PWMLOAD(x).U = (v))
#define HW_FTM_PWMLOAD_SET(x, v) (HW_FTM_PWMLOAD_WR(x, HW_FTM_PWMLOAD_RD(x) |  (v)))
#define HW_FTM_PWMLOAD_CLR(x, v) (HW_FTM_PWMLOAD_WR(x, HW_FTM_PWMLOAD_RD(x) & ~(v)))
#define HW_FTM_PWMLOAD_TOG(x, v) (HW_FTM_PWMLOAD_WR(x, HW_FTM_PWMLOAD_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FTM_PWMLOAD bitfields
 */

/*!
 * @name Register FTM_PWMLOAD, field CH0SEL[0] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH0SEL (0U)         //!< Bit position for FTM_PWMLOAD_CH0SEL.
#define BM_FTM_PWMLOAD_CH0SEL (0x00000001U) //!< Bit mask for FTM_PWMLOAD_CH0SEL.
#define BS_FTM_PWMLOAD_CH0SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH0SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH0SEL field.
#define BR_FTM_PWMLOAD_CH0SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH0SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH0SEL.
#define BF_FTM_PWMLOAD_CH0SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH0SEL), uint32_t) & BM_FTM_PWMLOAD_CH0SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0SEL field to a new value.
#define BW_FTM_PWMLOAD_CH0SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH0SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH1SEL[1] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH1SEL (1U)         //!< Bit position for FTM_PWMLOAD_CH1SEL.
#define BM_FTM_PWMLOAD_CH1SEL (0x00000002U) //!< Bit mask for FTM_PWMLOAD_CH1SEL.
#define BS_FTM_PWMLOAD_CH1SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH1SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH1SEL field.
#define BR_FTM_PWMLOAD_CH1SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH1SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH1SEL.
#define BF_FTM_PWMLOAD_CH1SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH1SEL), uint32_t) & BM_FTM_PWMLOAD_CH1SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1SEL field to a new value.
#define BW_FTM_PWMLOAD_CH1SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH1SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH2SEL[2] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH2SEL (2U)         //!< Bit position for FTM_PWMLOAD_CH2SEL.
#define BM_FTM_PWMLOAD_CH2SEL (0x00000004U) //!< Bit mask for FTM_PWMLOAD_CH2SEL.
#define BS_FTM_PWMLOAD_CH2SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH2SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH2SEL field.
#define BR_FTM_PWMLOAD_CH2SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH2SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH2SEL.
#define BF_FTM_PWMLOAD_CH2SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH2SEL), uint32_t) & BM_FTM_PWMLOAD_CH2SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2SEL field to a new value.
#define BW_FTM_PWMLOAD_CH2SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH2SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH3SEL[3] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH3SEL (3U)         //!< Bit position for FTM_PWMLOAD_CH3SEL.
#define BM_FTM_PWMLOAD_CH3SEL (0x00000008U) //!< Bit mask for FTM_PWMLOAD_CH3SEL.
#define BS_FTM_PWMLOAD_CH3SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH3SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH3SEL field.
#define BR_FTM_PWMLOAD_CH3SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH3SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH3SEL.
#define BF_FTM_PWMLOAD_CH3SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH3SEL), uint32_t) & BM_FTM_PWMLOAD_CH3SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3SEL field to a new value.
#define BW_FTM_PWMLOAD_CH3SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH3SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH4SEL[4] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH4SEL (4U)         //!< Bit position for FTM_PWMLOAD_CH4SEL.
#define BM_FTM_PWMLOAD_CH4SEL (0x00000010U) //!< Bit mask for FTM_PWMLOAD_CH4SEL.
#define BS_FTM_PWMLOAD_CH4SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH4SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH4SEL field.
#define BR_FTM_PWMLOAD_CH4SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH4SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH4SEL.
#define BF_FTM_PWMLOAD_CH4SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH4SEL), uint32_t) & BM_FTM_PWMLOAD_CH4SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4SEL field to a new value.
#define BW_FTM_PWMLOAD_CH4SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH4SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH5SEL[5] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH5SEL (5U)         //!< Bit position for FTM_PWMLOAD_CH5SEL.
#define BM_FTM_PWMLOAD_CH5SEL (0x00000020U) //!< Bit mask for FTM_PWMLOAD_CH5SEL.
#define BS_FTM_PWMLOAD_CH5SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH5SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH5SEL field.
#define BR_FTM_PWMLOAD_CH5SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH5SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH5SEL.
#define BF_FTM_PWMLOAD_CH5SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH5SEL), uint32_t) & BM_FTM_PWMLOAD_CH5SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5SEL field to a new value.
#define BW_FTM_PWMLOAD_CH5SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH5SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH6SEL[6] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH6SEL (6U)         //!< Bit position for FTM_PWMLOAD_CH6SEL.
#define BM_FTM_PWMLOAD_CH6SEL (0x00000040U) //!< Bit mask for FTM_PWMLOAD_CH6SEL.
#define BS_FTM_PWMLOAD_CH6SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH6SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH6SEL field.
#define BR_FTM_PWMLOAD_CH6SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH6SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH6SEL.
#define BF_FTM_PWMLOAD_CH6SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH6SEL), uint32_t) & BM_FTM_PWMLOAD_CH6SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6SEL field to a new value.
#define BW_FTM_PWMLOAD_CH6SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH6SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field CH7SEL[7] (RW)
 *
 * Values:
 * - 0 - Do not include the channel in the matching process.
 * - 1 - Include the channel in the matching process.
 */
//@{
#define BP_FTM_PWMLOAD_CH7SEL (7U)         //!< Bit position for FTM_PWMLOAD_CH7SEL.
#define BM_FTM_PWMLOAD_CH7SEL (0x00000080U) //!< Bit mask for FTM_PWMLOAD_CH7SEL.
#define BS_FTM_PWMLOAD_CH7SEL (1U)         //!< Bit field size in bits for FTM_PWMLOAD_CH7SEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_CH7SEL field.
#define BR_FTM_PWMLOAD_CH7SEL(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH7SEL))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_CH7SEL.
#define BF_FTM_PWMLOAD_CH7SEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_CH7SEL), uint32_t) & BM_FTM_PWMLOAD_CH7SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7SEL field to a new value.
#define BW_FTM_PWMLOAD_CH7SEL(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_CH7SEL) = (v))
#endif
//@}

/*!
 * @name Register FTM_PWMLOAD, field LDOK[9] (RW)
 *
 * Enables the loading of the MOD, CNTIN, and CV registers with the values of
 * their write buffers.
 *
 * Values:
 * - 0 - Loading updated values is disabled.
 * - 1 - Loading updated values is enabled.
 */
//@{
#define BP_FTM_PWMLOAD_LDOK  (9U)          //!< Bit position for FTM_PWMLOAD_LDOK.
#define BM_FTM_PWMLOAD_LDOK  (0x00000200U) //!< Bit mask for FTM_PWMLOAD_LDOK.
#define BS_FTM_PWMLOAD_LDOK  (1U)          //!< Bit field size in bits for FTM_PWMLOAD_LDOK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FTM_PWMLOAD_LDOK field.
#define BR_FTM_PWMLOAD_LDOK(x) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_LDOK))
#endif

//! @brief Format value for bitfield FTM_PWMLOAD_LDOK.
#define BF_FTM_PWMLOAD_LDOK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FTM_PWMLOAD_LDOK), uint32_t) & BM_FTM_PWMLOAD_LDOK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LDOK field to a new value.
#define BW_FTM_PWMLOAD_LDOK(x, v) (BITBAND_ACCESS32(HW_FTM_PWMLOAD_ADDR(x), BP_FTM_PWMLOAD_LDOK) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_ftm_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All FTM module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_ftm
{
    __IO hw_ftm_sc_t SC;                   //!< [0x0] Status And Control
    __IO hw_ftm_cnt_t CNT;                 //!< [0x4] Counter
    __IO hw_ftm_mod_t MOD;                 //!< [0x8] Modulo
    struct {
        __IO hw_ftm_cnsc_t CnSC;           //!< [0xC] Channel (n) Status And Control
        __IO hw_ftm_cnv_t CnV;             //!< [0x10] Channel (n) Value
    } CONTROLS[8];
    __IO hw_ftm_cntin_t CNTIN;             //!< [0x4C] Counter Initial Value
    __IO hw_ftm_status_t STATUS;           //!< [0x50] Capture And Compare Status
    __IO hw_ftm_mode_t MODE;               //!< [0x54] Features Mode Selection
    __IO hw_ftm_sync_t SYNC;               //!< [0x58] Synchronization
    __IO hw_ftm_outinit_t OUTINIT;         //!< [0x5C] Initial State For Channels Output
    __IO hw_ftm_outmask_t OUTMASK;         //!< [0x60] Output Mask
    __IO hw_ftm_combine_t COMBINE;         //!< [0x64] Function For Linked Channels
    __IO hw_ftm_deadtime_t DEADTIME;       //!< [0x68] Deadtime Insertion Control
    __IO hw_ftm_exttrig_t EXTTRIG;         //!< [0x6C] FTM External Trigger
    __IO hw_ftm_pol_t POL;                 //!< [0x70] Channels Polarity
    __IO hw_ftm_fms_t FMS;                 //!< [0x74] Fault Mode Status
    __IO hw_ftm_filter_t FILTER;           //!< [0x78] Input Capture Filter Control
    __IO hw_ftm_fltctrl_t FLTCTRL;         //!< [0x7C] Fault Control
    __IO hw_ftm_qdctrl_t QDCTRL;           //!< [0x80] Quadrature Decoder Control And Status
    __IO hw_ftm_conf_t CONF;               //!< [0x84] Configuration
    __IO hw_ftm_fltpol_t FLTPOL;           //!< [0x88] FTM Fault Input Polarity
    __IO hw_ftm_synconf_t SYNCONF;         //!< [0x8C] Synchronization Configuration
    __IO hw_ftm_invctrl_t INVCTRL;         //!< [0x90] FTM Inverting Control
    __IO hw_ftm_swoctrl_t SWOCTRL;         //!< [0x94] FTM Software Output Control
    __IO hw_ftm_pwmload_t PWMLOAD;         //!< [0x98] FTM PWM Load
} hw_ftm_t;
#pragma pack()

//! @brief Macro to access all FTM registers.
//! @param x FTM instance number.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_FTM(0)</code>.
#define HW_FTM(x)      (*(hw_ftm_t *) REGS_FTM_BASE(x))
#endif

#endif // __HW_FTM_REGISTERS_H__
// v22/130726/0.9
// EOF
