/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "Timer.h"
#include "us_ticker_api.h"

namespace mbed {

Timer::Timer() {
    reset();
}

void Timer::start() {
    _start = us_ticker_read();
    _running = 1;
}

void Timer::stop() {
    _time += slicetime();
    _running = 0;
}

int Timer::read_us() {
    return _time + slicetime();
}
    
float Timer::read() {
    return (float)read_us() / 1000000.0;
}

int Timer::read_ms() {
    return read_us() / 1000;
}

int Timer::slicetime() {
    if (_running) {
        return us_ticker_read() - _start;
    } else {
        return 0;
    }
}

void Timer::reset() {
    _start = us_ticker_read();
    _time = 0;
}

#ifdef MBED_OPERATORS
Timer::operator float() {
    return read();
}
#endif

} // namespace mbed
