/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "SPISlave.h"

#if DEVICE_SPISLAVE

namespace mbed {

SPISlave::SPISlave(PinName mosi, PinName miso, PinName sclk, PinName ssel) {
    spi_init(&_spi, mosi, miso, sclk, ssel);
    _bits = 8;
    _mode = 0;
    _hz = 1000000;
    spi_format(&_spi, _bits, _mode, 1);
    spi_frequency(&_spi, _hz);
}

void SPISlave::format(int bits, int mode) {
    _bits = bits;
    _mode = mode;
    spi_format(&_spi, _bits, _mode, 1);
}

void SPISlave::frequency(int hz) {
    _hz = hz;
    spi_frequency(&_spi, _hz);
}

int SPISlave::receive(void) {
    return(spi_slave_receive(&_spi));
}

int SPISlave::read(void) {
    return(spi_slave_read(&_spi));
}

void SPISlave::reply(int value) {
    spi_slave_write(&_spi, value);
}

} // namespace mbed

#endif
