/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "InterruptIn.h"

#if DEVICE_INTERRUPTIN

#include "error.h"

namespace mbed {

InterruptIn::InterruptIn(PinName pin) {
    if (gpio_irq_init(&gpio_irq, pin, (&InterruptIn::_irq_handler), (uint32_t)this) != 0)
        error("[ERROR] InterruptIn init\n");
    gpio_init(&gpio, pin, PIN_INPUT);
}

InterruptIn::~InterruptIn() {
    gpio_irq_free(&gpio_irq);
}

int InterruptIn::read() { 
    return gpio_read(&gpio);
}

void InterruptIn::mode(PinMode pull) {
    gpio_mode(&gpio, pull);
}

void InterruptIn::rise(void (*fptr)(void)) {
    if (fptr) {
        _rise.attach(fptr);
        gpio_irq_set(&gpio_irq, IRQ_RISE, 1);
    } else {
        gpio_irq_set(&gpio_irq, IRQ_RISE, 0);
    }
}

void InterruptIn::fall(void (*fptr)(void)) {
    if (fptr) {
        _fall.attach(fptr);
        gpio_irq_set(&gpio_irq, IRQ_FALL, 1);
    } else {
        gpio_irq_set(&gpio_irq, IRQ_FALL, 0);
    }
}

void InterruptIn::_irq_handler(uint32_t id, gpio_irq_event event) {
    InterruptIn *handler = (InterruptIn*)id;
    switch (event) {
        case IRQ_RISE: handler->_rise.call(); break;
        case IRQ_FALL: handler->_fall.call(); break;
        case IRQ_NONE: break;
    }
}

#ifdef MBED_OPERATORS
InterruptIn::operator int() {
    return read();
}
#endif

} // namespace mbed

#endif
