/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "rtc_api.h"

#include <time.h>
#include "rtc_time.h"
#include "us_ticker_api.h"

time_t time(time_t *timer) {
#if DEVICE_RTC
    if (!(rtc_isenabled())) {
        set_time(0);
    }
    time_t t = rtc_read();
    
#else
    time_t t = 0;
#endif
    
    if (timer != NULL) {
        *timer = t;
    }
    return t;
}

void set_time(time_t t) {
#if DEVICE_RTC
    rtc_init();
    rtc_write(t);
#endif
}

clock_t clock() {
    clock_t t = us_ticker_read();
    t /= 1000000 / CLOCKS_PER_SEC; // convert to processor time
    return t;
}
