/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include <stdio.h>
#include "mbed_interface.h"

#include "gpio_api.h"
#include "wait_api.h"
#include "semihost_api.h"
#include "error.h"

// return true if a debugger is attached, indicating mbed interface is connected
int mbed_interface_connected(void) {
    return semihost_connected();
}

int mbed_interface_reset(void) {
    if (mbed_interface_connected()) {
        semihost_reset(); 
        return 0;
    } else {
        return -1;
    }
}

int mbed_interface_uid(char *uid) __attribute__((weak));
int mbed_interface_uid(char *uid) {
    if (mbed_interface_connected()) {
        return semihost_uid(uid); // Returns 0 if successful, -1 on failure
    } else {
        uid[0] = 0;
        return -1;
    }
}

int mbed_interface_disconnect(void) {
    if (mbed_interface_connected()) {
        return semihost_disabledebug();
    } else {
        return -1;
    }
}

int mbed_interface_powerdown(void) {
    mbed_interface_disconnect();
    if (mbed_interface_connected()) {
        return semihost_powerdown();
    } else {
        return -1;
    }
}

void mbed_mac_address(char *mac) __attribute__((weak));
void mbed_mac_address(char *mac) {
    char uid[33];
    int i;
    
    // if we have a UID, extract the MAC
    if (mbed_interface_uid(uid) == 0) {
        char *p = uid + 20;
        for (i=0; i<6; i++) {
            int byte;
            sscanf(p, "%2x", &byte);
            mac[i] = byte;
            p += 2;
        }
    } else {  // else return a default MAC
        mac[0] = 0x00;
        mac[1] = 0x02;
        mac[2] = 0xF7;
        mac[3] = 0xF0;
        mac[4] = 0x00;
        mac[5] = 0x00;
    }
}

// for backward compatibility
void mbed_reset(void) {
    mbed_interface_reset();
}

int mbed_uid(char *uid) __attribute__((weak));
int mbed_uid(char *uid) {
    return mbed_interface_uid(uid);
}
