#include "mbed.h"

/*
RawSerial  pc(USBTX, USBRX);
RawSerial  dev(D1, D0);
*/
RawSerial pc(USBTX, USBRX); // tx, rx
RawSerial dev(PTD3, PTD2); // tx, rx for FRDM-KL25Z

DigitalOut led1(LED1);
DigitalOut led4(LED4);

void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}

void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}

int main()
{
    pc.baud(115200);
    dev.baud(115200);

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
    
    for (int i=0; i<10; i++)
    {        
        led1 = !led1;
        led4 = !led4;
        wait(0.1);
    }

    while(1) {
        sleep();
    }
}
