#include "mbed.h"
#include "CBuffer.h"
#include <stdarg.h>

DigitalOut led1(LED1);
DigitalOut led4(LED4);

RawSerial pc(USBTX, USBRX); // tx, rx

////////////////////////////////////////////////////////////////////////////////////////////////
// mbed Async Debug Print
Timeout timer_async_print;
CircBuffer<char> buffer_async_print(1024);
static char debug_line[64];

void timerfunction_async_print()
{
    char c=0;

    while ( buffer_async_print.available() ) {
        buffer_async_print.dequeue(&c);
        pc.putc(c);
    }
    timer_async_print.attach(&timerfunction_async_print, 0.1);
}

void async_print(const char *format, ...)
{
    va_list args;
    
    va_start(args, format);
    
    vsnprintf(debug_line, sizeof(debug_line), format, args);
    int length = strlen(debug_line);
    
    for (int i=0; i<length; i++)
        buffer_async_print.queue(debug_line[i]);
    
    va_end(args);
}

extern void (*p_async_print)(const char *format, ...);
////////////////////////////////////////////////////////////////////////////////////////////////


extern int rx_irq_counter;
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        pc.printf("RECV [%c]\r\n", pc.getc());
    }
}

int main()
{
    for (int i=0; i<20; i++)
    {        
        led1 = !led1;
        led4 = !led4;
        wait(0.05);
    }

    // Initialize AsyncPrint
    timer_async_print.attach(&timerfunction_async_print, 0.1);
    p_async_print = &async_print;
    
    pc.baud(115200);    
    pc.printf("AsyncPrint Test. \r\n");
    
    pc.attach(&pc_recv, Serial::RxIrq);
    
    while(1) {
        wait(1);
    }
}

