#include "map.h"
#include "hash_table.h"
#include "globals.h"
#include "graphics.h"

/**
 * The Map structure. This holds a HashTable for all the MapItems, along with
 * values for the width and height of the Map.
 */
struct Map {
    HashTable* items;
    int w, h;
};

/**
 * Storage area for the maps.
 * This is a global variable, but can only be access from this file because it
 * is static.
 */
static Map map[2];
//Map 2 is cyberspace
static int active_map;

/**
 * The first step in HashTable access for the map is turning the two-dimensional
 * key information (x, y) into a one-dimensional unsigned integer.
 * This function should uniquely map (x,y) onto the space of unsigned integers.
 */
static unsigned XY_KEY(int X, int Y) {
    unsigned key = X*50+Y;//0.5*(X+Y)*(X+Y+1)+Y;
    return key;
}

/**
 * This is the hash function actually passed into createHashTable. It takes an
 * unsigned key (the output of XY_KEY) and turns it into a hash value (some
 * small non-negative integer).
 */
unsigned map_hash(unsigned key)
{
    unsigned hsh = key%8;
    return hsh;
}

void maps_init()
{
    // TODO: Implement!    
    // Initialize hash table
    map[0].items = createHashTable(map_hash,8);
    map[1].items = createHashTable(map_hash,8);
    // Set width & height
    map[0].w = 50;
    map[0].h = 50;
    map[1].w = 11;
    map[1].h = 11;
}

Map* get_active_map()
{
    // There's only one map
    return &map[active_map];
}

Map* set_active_map(int m)
{
    active_map = m;
    return &map[active_map];
}

void print_map()
{
    // As you add more types, you'll need to add more items to this array.
    char lookup[] = {'W', 'P', 'N', 'T','H'};
    for(int y = 0; y < map_height(); y++)
    {
        for (int x = 0; x < map_width(); x++)
        {
            MapItem* item = get_here(x,y);
            if (item) pc.printf("%c", lookup[item->type]);
            else pc.printf(" ");
        }
        pc.printf("\r\n");
    }
}

int map_width()
{
    return map[active_map].w;
}

int map_height()
{
    return map[active_map].h;
}

int map_area()
{
    return map_width()*map_height();
}

MapItem* get_north(int x, int y)
{
    Map *m1 = get_active_map();
    MapItem* item = (MapItem*)getItem(m1->items,XY_KEY(x,y-1));
    return item;
}

MapItem* get_south(int x, int y)
{
    Map *m1 = get_active_map();
    MapItem* item = (MapItem*)getItem(m1->items,XY_KEY(x,y+1));
    return item;
}

MapItem* get_east(int x, int y)
{
    Map *m1 = get_active_map();
    MapItem* item = (MapItem*)getItem(m1->items,XY_KEY(x+1,y));
    return item;
}

MapItem* get_west(int x, int y)
{
    Map *m1 = get_active_map();
    MapItem* item = (MapItem*)getItem(m1->items,XY_KEY(x-1,y));
    return item;
}

MapItem* get_here(int x, int y)
{
    Map *m1 = get_active_map();
    MapItem* here = (MapItem*)getItem(m1->items,XY_KEY(x,y));
    return here;
}


void map_erase(int x, int y)
{
    free((MapItem*)removeItem(map[active_map].items,XY_KEY(x,y)));
}

void add_wall(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = WALL;
        w1->draw = draw_wall;
        w1->walkable = false;
        w1->data = NULL;
        w1->x = x;
        w1->y = y;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_netPortal(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = NPORTAL;
    w1->draw = draw_netPortal;
    w1->walkable = false;
    w1->data = NULL;
    w1->x = x;
    w1->y = y;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_terminal(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = TERMINAL;
    w1->draw = draw_terminal;
    w1->walkable = false;
    w1->data = NULL;
    w1->x = x;
    w1->y = y;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_hacked_terminal(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = HACKED_TERMINAL;
    w1->draw = draw_hacked_terminal;
    w1->walkable = false;
    w1->data = NULL;
    w1->x = x;
    w1->y = y;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_NPC(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = NPC;
    w1->draw = draw_NPC;
    w1->walkable = false;
    w1->data = NULL;
    w1->x = x;
    w1->y = y;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_plant(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PLANT;
    w1->draw = draw_plant;
    w1->walkable = true;
    w1->data = NULL;
    w1->x = x;
    w1->y = y;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_door(int x, int y,bool walk)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = DOOR;
    w1->draw = draw_door;
    w1->walkable = walk;
    w1->data = NULL;
    w1->x = x;
    w1->y = y;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_boots(int x, int y){
  MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
  w1->type = BOOTS;
  w1->draw = draw_boots;
  w1->walkable = false;
  w1->data = NULL;
  w1->x = x;
  w1->y = y;
  void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
  if (val) free(val); // If something is already there, free it
}
void add_kill(int x, int y){
  MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
  w1->type = KILL;
  w1->draw = draw_gun;
  w1->walkable = false;
  w1->data = NULL;
  w1->x = x;
  w1->y = y;
  void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
  if (val) free(val); // If something is already there, free it
}
void add_orgprint(int x, int y){
  MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
  w1->type = PRINTER;
  w1->draw = draw_printer;
  w1->walkable = false;
  w1->data = NULL;
  w1->x = x;
  w1->y = y;
  void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
  if (val) free(val); // If something is already there, free it
}
void add_teleport(int x, int y){
  MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
  w1->type = TELEPORT;
  w1->draw = draw_teleport;
  w1->walkable = false;
  w1->data = NULL;
  w1->x = x;
  w1->y = y;
  void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
  if (val) free(val); // If something is already there, free it
}