#include "uart1.h"
#include "mbed.h"

#define BUFFERSIZE 128
extern Serial bus;
DigitalOut led_2(LED2);
 
static unsigned char U1buf[BUFFERSIZE];
static unsigned int U1ptr;
static unsigned int U1gptr;
static unsigned int U1cnt;


static void
serial_event()
{
  led_2 = !led_2;
  
  if(bus.readable())
  {
    U1buf[U1ptr++] = (unsigned char) USART1->RDR & 0xFF;//(unsigned char)bus.getc();
    U1ptr &= BUFFERSIZE-1;
    if(U1ptr == U1gptr)
    {
      U1gptr++;
      U1gptr &= BUFFERSIZE-1;
    }
    else
    {
      U1cnt++;
    }
  }
}

 void 
init_uart1(void)
{
  bus.baud(115200); 
  bus.attach(&serial_event,Serial::RxIrq);
  
  U1ptr = U1gptr = U1cnt = 0;
}

int 
uart1_is_char(void)
{
  return U1cnt;
}

int 
uart1_get_char(void)
{
  int result;
  result = 0;
  if(U1cnt)
  {
    result = U1buf[U1gptr++];
    U1gptr &= BUFFERSIZE-1;
    U1cnt--;
  }

  return result; 
}

void 
send_uart1_char(unsigned char c)
{
  bus.putc(c); 
}