//#define TEST
#define DEBUG

#include "mbed.h"
#include "rtos.h"
#include "comms.h"
#include "rs485.h"
#include "uart1.h"
#include "BTpacket.h"

extern const unsigned char DEVADDRESS = 0xF0;
#define NORDIC_ADDRESS     DEVADDRESS
#define BTMODULE_A_ADDRESS 0x20                     //  #CC not sure if this has been defined by CEPD
#define BTMODULE_B_ADDRESS 0x22                     //  #CC not sure if this has been defined by CEPD

enum Commands   {   FX1 = 0x10 , FX1_ACK = 0x90 ,   //  #CC list the commands needed for the NORDIC Module
                    FX2 = 0x12 , FX2_ACK = 0x92
                };

/*===========================================    
*   These functions need to be completed
*
*/
int Bluetooth_ReceivePacket( Packet * );
int Bluetooth_SendChar( unsigned char );
int Bluetooth_SerialHandler( void );
/*==========================================*/

void Fx1( unsigned char * );
void Fx2( unsigned char * );


/*===========================================    
*
*
*/
void receivedSerialData( void ){
  while( uart1_is_char() ){
    SerialHandler( uart1_get_char() );
  }
}

void bus_thread(void const *argument){
    while (true){
        receivedSerialData(); 
        wait_ms( 100 );
    }
}

void Test( void );
void PrintPacket( Packet *_packet );
/*==========================================*/

int main() {  
    
    RegisterCommand( FX1 , &Fx1 );   
    RegisterCommand( FX2 , &Fx2 );            
    
    initComms();
    pc.printf( "\n\rStarted...\n\r" );
    init_uart1();
    
    Thread bus( bus_thread , NULL , osPriorityRealtime , DEFAULT_STACK_SIZE ); 

    while( true ){ };

        #ifdef TEST
            Test();
        #endif // DEBUG


}

//================ Custom Functions =============================================
/*  These functions local functions to the Nordic chip that are exposed to the 
*    system. They must follow this prototype (same return values and parameter)
*     and must be registered with a command using RegisterCommand() from RS485
*     library.
*/
void Fx1( unsigned char *_receivedData ){
    
    pc.printf( "In FX1!\n\r" );
    
    Packet packet;
    packet.sourceID = 0xF0;
    packet.deviceID = 0xFE;
    packet.command = 0x90;
    packet.packetData[0] = 0x22;
    packet.packetLength = 0x01;
    
    SetResponsePacket( &packet );
}

void Fx2( unsigned char *_receivedData ){
    
    pc.printf( "In FX2!\n\r" );
    
    Packet packet;
    packet.sourceID = 0xF0;
    packet.deviceID = 0xFE;
    packet.command = 0x90;
    packet.packetData[0] = 0x22;
    packet.packetLength = 0x01;
    
    SetResponsePacket( &packet );
}
//================ End Custom Functions =========================================

//#CC This needs to handle the uart port and pass received bytes on
/******************************************************************************
 * Bluetooth_SerialHandler
 *
 * The UART port needs to be handled and when a byte is received it is passed on
 *  to SerialHandler() form the rs485 library.
 *
 * PreCondition:    None
 *
 * Input:           '_packet' - packet received from the bus.
 *
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 *****************************************************************************/
int Bluetooth_SerialHandler( void ){
//    if( ByteAvailableOnSerial ){
//        SerialHandler( GetByte() );    
//    }
    return 0;
}

//#CC This needs to be modified as commented below
/******************************************************************************
 * Bluetooth_ReceivePacket
 *
 * This gets automatically called by the bus library when a complete packet is
 *  received. It checks the address the packet is going to and redirects the
 *  message appropriately (ie: if message is for the Nordic chip it calls a
 *  function or it sends it off to a BT device).
 *
 * PreCondition:    None
 *
 * Input:           '_packet' - packet received from the bus.
 *
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 *****************************************************************************/
int Bluetooth_ReceivePacket( Packet *_packet ){

    #ifdef DEBUG
        PrintPacket( _packet );
    #endif // DEBUG   
    
    switch ( _packet->command ){                //  makes decision based off where packet is addressed to go
        
        case NORDIC_ADDRESS:                    //  if the message is for the Nordic chip...              
            if( !CheckFunction( _packet ) ){    //  this will call the appropriate function if one is registered
                //#CC                           //  code goes here if the function is not registered
            }
            break;
            
        case BTMODULE_A_ADDRESS:                //  if message is for Bluetooth Module A
            //#CC
            /*
                Need to bring in packet and modify to send out over BT            
            */                   
            break;
            
        case BTMODULE_B_ADDRESS:
        
            break;
            
        default:
            break;   
        
    }   
    
    return 0;
}

int Bluetooth_SendChar( unsigned char _c ){
    bus.putc( _c );
    return 0;
}

void PrintPacket( Packet *_packet ){
        pc.printf( "Process Packet\n\r" );
                
        pc.printf( "\t%x - Device ID\n\r" , _packet->deviceID );
        pc.printf( "\t%x - Source ID\n\r" , _packet->sourceID );
        pc.printf( "\t%x - Command\n\r" , _packet->command );
        pc.printf( "\t%x - Length\n\r" , _packet->packetLength );
        unsigned char *ptr = (unsigned char *)&_packet->packetData;
        for( int i = 0 ; i < _packet->packetLength ; i++ ){
            pc.printf( "\t%x - Data[%d]\n\r" , *ptr++ , i );   
        }   
}

void Test( void ){
    
            Packet commandPacket;
            commandPacket.sourceID = 0xFE;
            commandPacket.deviceID = 0xF0;
            commandPacket.command = 0x10;
            commandPacket.packetLength = 0x04;
            commandPacket.packetData[0] = 0x8E;
            commandPacket.packetData[1] = 0x7F;
            commandPacket.packetData[2] = 0x8F;
            commandPacket.packetData[3] = 0xB0;
        
            unsigned char buf1[1024];
            unsigned char buf2[1024];
            unsigned char *ptr = buf1;
            
            //  buf for commandPacket
            int size1 = getFormattedPacket( &commandPacket , buf1  );
            int size2;

            // buf for POLL                        
            buf1[0] = 0x8F;
            buf1[1] = 0xF0;
            size1 = 2;          
            
            buf2[0] = 0x8D; 
            size2 = 1; 
            
            pc.printf( "size: %i\t" , size1 );
            
            pc.printf( "buf: " );
            for( int i = 0 ; i < size1 ; i++ ){
                pc.printf( "%x " , *(ptr++) );
            }
            pc.printf( " \n\r" );
            
            while(1) {
                //  poll with no message
                ptr = buf1;
                for( int i = 0 ; i < size1 ; i++ ){
                    SerialHandler( *(ptr++) );
                    wait( 1 );
                }
                
                //  create message
                Bluetooth_SendChar( 0xF0 );
                Bluetooth_SendChar( 0x01 );
                Bluetooth_SendChar( 0x10 );
                
                //  poll with message
                ptr = buf1;
                for( int i = 0 ; i < size1 ; i++ ){
                    SerialHandler( *(ptr++) );
                    wait( 1 );
                }
                
                //  send ACK                
                ptr = buf2;
                for( int i = 0 ; i < size2 ; i++ ){
                    SerialHandler( *(ptr++) );
                    wait( 1 );
                }
            }
}            
