#include "mbed.h"
#include "comms.h"

#define SERIAL1_TX PA_9
#define SERIAL1_RX PA_10

I2C i2c( D4 , D5 );
Serial pc( USBTX , USBRX ); 
Serial bus( SERIAL1_TX  , SERIAL1_RX );


void initComms() {    
    pc.baud( 115200 );
    i2c.frequency( 400000 );
    bus.baud( 115200 );
}

void debugLog( char* fmt, ...) {
    char buf[100];     // this should really be sized appropriately
                       // possibly in response to a call to vsnprintf()
    va_list vl;
    va_start(vl, fmt);

    vsnprintf( buf, sizeof( buf), fmt, vl);

    va_end( vl);

    pc.printf(buf);
}
