#include "CANlibrary.h"


extern CAN can;
Ticker tick; //!!!!!!!!!!!!!!!!!!!!!!!!!!!!! nije hteo da se prevede kao extern

/******************************************
 - - - - - VAZNO! - - - - -
 IDjevi se tumace u decimalnom brojnom sistemu
  - can_flag niz treba namestiti adrese da idu u u intervalu od 0-15 celobrojno
  - tj, mogle bi da se i koriste one od 2000h ali tipa da to se oduzima 
    nekom celobrojom konstantom koja ce davati oseg adresa od 0 do 15
*/


bool can_flag[16];
CANMessage msgs[16];
char data[8];
char idTX;
float msgInterval=0;

void can_initRX(){
    can.attach(can_msg_receive, CAN::RxIrq); 
}
void can_msg_receive(){                     // CAN RX Interrupt Function
    CANMessage tmpMsg;
    if (can.read(tmpMsg)) {                 //Detect message
        can_flag[tmpMsg.id]=true;
        msgs[tmpMsg.id]=tmpMsg;  
    }
};

uint16_t get_data(char id, char indeks){
   return msgs[id].data[indeks<<1] | (msgs[id].data[(indeks << 1) + 1] << 8);
}

bool check_flag(char id){
    bool ret = can_flag[id];
    can_flag[id]=false;
    return ret;
}


//-------------------------------------------------------------------
//-------------------------------------------------------------------
// Funkcije slanja poruka:

void canTX_set_Interval(float inter){ 
    
    //Zadavanje fiksnog intervala slanja CAN poruke
    //Vrednost je realna. Jedinica zadavanja je u sekundama.
    msgInterval=inter;
}

void  can_initTX(char idtx){
    
    //Fukcija koja zadaje fiksnu adresu slanja poruke
    idTX=idtx;
}
void can_msg_send(){
    
    /*
     *  Fukcija koja salje podatke na CAN mrezu po zadatom,setovanom, IDju. 
     *  Duzina poruke podesena je fiksno na 8B.
     */
    can.write(CANMessage((uint16_t)idTX, data, 8));
}
void can_msg_send_tick(){
    
    //Funkcija koja se poziva za slanje poruka u okviru fiksnog intervala
    tick.attach(can_msg_send, msgInterval);
}
//----------------------------------------------------------------------------
/*  Pomocne funkcije za pakovanje podataka prilikom slanja:
 *  Ove funkcije omogućavaju da automatsko pakovanje u razlicite velicine poruke 
 *  u zavisnosti od tipa i pozicije na kojoj treba poslati podatak.
 *
 *  Realizovane su za dva tipa: 
 *      -unit16_t (automatsko pakovanje u dva podatka od po 1B)
 *      -char
 * 
 *  Format: dta = vrednost koju saljemo kao podatak CANom, pos = pozicija u CAN
 *  poruci.
 * 
 *  CAN poruka: (IDslanja, DD7, DD6, DD5, DD4, DD3,DD2, DD1, DD0)
 *  Velicina podataka (DD7...DD0) je od po 1Byte.
 *  Maximalno se mogu poslati 4 podatka od po 2B (pos polje u opsegu od 0 do 3) 
 *  ili 8 od po 1B (pos polje u opsegu od 0 do 7). 
 */

void pack_data(uint16_t dta, char pos){
    
    //Pakuje unit16_t u dva podatka od po 1B, na poziciji pos u CAN poruci
    data[pos<<1] = dta;
    data[(pos<<1)+1] = dta >> 8;
}

void pack_data(char dta, char pos){
     
     //Pakuje char u jedan podatka od 1B, na poziciji pos u CAN poruci
    data[pos<<1] = dta;
}



