#include "mbed.h"
#include "CAN_IDs.h"

//CAN Identificators
#define DTA_1   0x2000
#define DTA_2   0x2001
#define DTA_3   0x2002
#define DTA_4   0x2003
#define DTA_5   0x2004
#define DTA_6   0x2005
// This IDs can be changed as they are our own IDs
#define LVDT_FRONT  0x6
#define LVDT_REAR   0x7
#define BRAKES  0x8
#define DISTANCE_ID 0x9
// If we add some other IDs in the vehicle add them here

CAN can1(PB_8, PB_9);
Serial pc(USBTX, USBRX);
AnalogIn speed_value(A0);
int speed;
char dta1[8];                               //DTA1
uint16_t Rpm,TPS, Water_Temp, Air_Temp;
char dta2[8];                               //DTA2                    
uint16_t MAP, Lambda, Speed, Oil_P;
char dta3[8];                               //DTA3
uint16_t Oil_Temp,Volts;
char dta4[8];                               //DTA4                                   
uint16_t Gear;
char dta6[8];
uint16_t Crank_Error;
char lvdtfront[8];                          //LVDTFront                                             
uint16_t FL_LVDT, FR_LVDT;                                 
char lvdtrear[8];                           //LVDTRear                                             
uint16_t RL_LVDT, RR_LVDT;                                 
char brakes[8];                             //Brakes                                             
uint16_t Brakes;
char distance[8];
uint32_t Distance;                                  

int counter;

void send(uint16_t ID, char dta[8]) {
    if(can1.write(CANMessage((uint16_t)ID,dta, 8))) {
        counter++;
        printf("%x\n",ID);
        printf("Message sent: info1=%x%x, info2=%x%x, info3=%x%x, info4=%x%x, counter=%d\n", dta[1],dta[0],dta[3],dta[2],dta[5],dta[4],dta[7],dta[6],counter);
    }else{
        printf("No message sent!\n");
    } 
};

int main() {
    
   CANMessage msg;
    /*Distance=(uint32_t)2000;
    distance[0]=(uint8_t)(Distance & 0x000000FF);
    distance[1]=(uint8_t)((Distance & 0x0000FF00)>>8);
    distance[2]=(uint8_t)((Distance & 0x00FF0000)>>16);
    distance[3]=(uint8_t)((Distance & 0xFF000000)>>24);
    distance[4]=0;
    distance[5]=0;
    distance[6]=0;
    distance[7]=0;
    //pc.printf("distance=%d\n",Distance);   
    send(DISTANCE_ID,distance);
    */
    while(1){
        counter=0;
        speed=(int)(speed_value.read()*150);
        //speed=123;
        dta2[0]=0;
        dta2[1]=0;
        dta2[2]=0;
        dta2[3]=0;
        dta2[4]=(uint8_t)(speed & 0x00FF);
        dta2[5]=(uint8_t)(speed>>8);
        dta2[6]=0;
        dta2[7]=0;
        pc.printf("speed=%d\n",speed); 
        wait(0.5);  
        send(DTA_2,dta2);
        wait(0.5);
    
         for(int k=0;k<150;k++){
           
           
            //DTA1 CAN simulation
            Rpm=k;
            TPS=k*2;
            Water_Temp=k*4;
            Air_Temp=k*6;
            dta1[0]=(uint8_t)(Rpm & 0x00FF);
            dta1[1]=(uint8_t)(Rpm>>8);
            dta1[2]=(uint8_t)(TPS & 0x00FF);
            dta1[3]=(uint8_t)(TPS>>8);
            dta1[4]=(uint8_t)(Water_Temp & 0x00FF);
            dta1[5]=(uint8_t)(Water_Temp>>8);
            dta1[6]=(uint8_t)(Air_Temp & 0x00FF);
            dta1[7]=(uint8_t)(Air_Temp>>8);
            wait(0.5);
            send(DTA_1,dta1);
            wait(0.5);
            
            
            //DTA2 CAN simulation
            Speed=k;
            MAP=k*2;
            Lambda=k*4;
            Oil_P=k*6;
            dta2[0]=(uint8_t)(MAP & 0x00FF);
            dta2[1]=(uint8_t)(MAP>>8);
            dta2[2]=(uint8_t)(Lambda & 0x00FF);
            dta2[3]=(uint8_t)(Lambda>>8);
            dta2[4]=(uint8_t)(Speed & 0x00FF);
            dta2[5]=(uint8_t)(Speed>>8);
            dta2[6]=(uint8_t)(Oil_P & 0x00FF);
            dta2[7]=(uint8_t)(Oil_P>>8);
            wait(0.5);
            send(DTA_2,dta2);
            wait(0.5);
            
            //DTA3 CAN simulation
            Oil_Temp=k*2;
            Volts=k*4;
            dta3[0]=0;
            dta3[1]=0;
            dta3[2]=(uint8_t)(Oil_Temp & 0x00FF);
            dta3[3]=(uint8_t)(Oil_Temp>>8);
            dta3[4]=(uint8_t)(Volts & 0x00FF);
            dta3[5]=(uint8_t)(Volts>>8);
            dta3[6]=0;
            dta3[7]=0;
            wait(0.5);
            send(DTA_3,dta3);
            wait(0.5);
            
            //DTA4 CAN simulation
            Gear=k/25;
            dta4[0]=Gear;
            wait(0.5);
            send(DTA_4,dta4);
            wait(0.5);
            
            //DTA6 CAN simulation
            if((k/10)%2){
                //only for Crank_Error
                dta6[4]=0xFF;
                dta6[5]=0xFF;
            }else{
                dta6[4]=0;
                dta6[5]=0;
            };
            wait(0.5);
            send(DTA_6,dta6);
            wait(0.5);
            
            //LVDTFront CAN simulation
            FL_LVDT=k;
            FR_LVDT=150-k;
            lvdtfront[0]=(uint8_t)(FL_LVDT & 0x00FF);
            lvdtfront[1]=(uint8_t)(FL_LVDT>>8);
            lvdtfront[2]=(uint8_t)(FR_LVDT & 0x00FF);
            lvdtfront[3]=(uint8_t)(FR_LVDT>>8);
            wait(0.5);
            send(LVDT_FRONT,lvdtfront);
            wait(0.5);
            
            //LVDTRear CAN simulation
            RL_LVDT=k;
            RR_LVDT=150-k;
            lvdtrear[0]=(uint8_t)(RL_LVDT & 0x00FF);
            lvdtrear[1]=(uint8_t)(RL_LVDT>>8);
            lvdtrear[2]=(uint8_t)(RR_LVDT & 0x00FF);
            lvdtrear[3]=(uint8_t)(RR_LVDT>>8);
            wait(0.5);
            send(LVDT_REAR,lvdtrear);
            wait(0.5);
            
            //Brakes CAN simulation
            if((k/10)%2){
                brakes[0]=0xFF;
                brakes[1]=0xFF;
            }else{
                brakes[0]=0;
                brakes[1]=0;
            };
            wait(0.5);
            send(BRAKES,brakes);
            wait(0.5);
            
        };
        
        /*for(int k=150;k>0;k--){
            
            //DTA1 CAN simulation
            Rpm=k;
            TPS=k*2;
            Water_Temp=k*4;
            Air_Temp=k*6;
            dta1[0]=(uint8_t)(Rpm & 0x00FF);
            dta1[1]=(uint8_t)(Rpm>>8);
            dta1[2]=(uint8_t)(TPS & 0x00FF);
            dta1[3]=(uint8_t)(TPS>>8);
            dta1[4]=(uint8_t)(Water_Temp & 0x00FF);
            dta1[5]=(uint8_t)(Water_Temp>>8);
            dta1[6]=(uint8_t)(Air_Temp & 0x00FF);
            dta1[7]=(uint8_t)(Air_Temp>>8);
            send(DTA_1,dta1);
            
            //DTA2 CAN simulation
            Speed=k;
            MAP=k*2;
            Lambda=k*4;
            Oil_P=k*6;
            dta2[0]=(uint8_t)(MAP & 0x00FF);
            dta2[1]=(uint8_t)(MAP>>8);
            dta2[2]=(uint8_t)(Lambda & 0x00FF);
            dta2[3]=(uint8_t)(Lambda>>8);
            dta2[4]=(uint8_t)(Speed & 0x00FF);
            dta2[5]=(uint8_t)(Speed>>8);
            dta2[6]=(uint8_t)(Oil_P & 0x00FF);
            dta2[7]=(uint8_t)(Oil_P>>8);
            send(DTA_2,dta2);
            
            //DTA3 CAN simulation
            Oil_Temp=k*2;
            Volts=k*4;
            dta3[0]=0;
            dta3[1]=0;
            dta3[2]=(uint8_t)(Oil_Temp & 0x00FF);
            dta3[3]=(uint8_t)(Oil_Temp>>8);
            dta3[4]=(uint8_t)(Volts & 0x00FF);
            dta3[5]=(uint8_t)(Volts>>8);
            dta3[6]=0;
            dta3[7]=0;
            send(DTA_3,dta3);
            
            //DTA4 CAN simulation
            Gear=k/25;
            dta4[0]=Gear;
            send(DTA_4,dta4);
            
        };*/
    };
};