#include "mbed.h"
#include "LCD_DISCO_F469NI.h"

// define all CAN IDs in the vehicle
// DTA ID are fixed and cannot be changed
#define DTA_1   0x2000
#define DTA_2   0x2001
#define DTA_3   0x2002
#define DTA_4   0x2003
#define DTA_5   0x2004
#define DTA_6   0x2006
// This IDs can be changed as they are our own IDs
#define LVDT_FRONT  0x1000
#define LVDT_REAR   0x1001
#define BRAKES  0x1002
// If we add some other IDs in the vehicle add them here

// Receive Flag
uint32_t rx_flag=0x00000000;
Serial pc(USBTX, USBRX);

// CAN Message variables, one variable for each ID
// If new IDs are added, add variables for them
CANMessage msgDTA1; // RPM, TPS %, Water temp C, Air temp C
uint8_t msgDTA2[8]; // MAP Kpa, Lambda x1000, KPH x10, Oil P Kpa
uint8_t msgDTA3[8]; // Fuel P Kpa, Oil temp C, Volts x10, Fuel Con. L/Hr x10
uint8_t msgDTA4[8]; // Gear, Advance Deg x10, Injection ms x100, Fuel Con L/100km x10
uint8_t msgDTA5[8]; // Ana1 mV, Ana2 mV, Ana3 mV, Cam Advance x10
uint8_t msgDTA6[8]; // Cam Targ x10, Cam PWM x10, Crank Errors, Cam Errors
uint8_t msgLVDTFront[8]; // Left, Right, Steering Wheel 
uint8_t msgLVDTRear[8]; // Left, Right
uint8_t msgBrakes[8]; // Brake system preassure, Braking On/Off

// CAN Variables
uint16_t rpm,tps,waterTemp, airTemp, map, Lambda, Volts, oilTemp, KPH, oilPress, Gear, lvdtFL, lvdtFR, lvdtRL, lvdtRR, steeringWheel, brakePress, BrakeOn;

// number of different IDs
int noID=9;

// initialize LCD
LCD_DISCO_F469NI lcd;
// initialize internal LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
// initialize CAN object
CAN can1(PB_8, PB_9);

// CAN RX Interrupt Function
void CAN_Msg_Receive(){
    CANMessage tmpMsg;
    if (can1.read(tmpMsg)) { 
    pc.printf("%x\n",tmpMsg.id);      
        switch(tmpMsg.id){
            case(0):
                rx_flag|=(1<<0);
                //for(int k=0;k<8;k++){
                    msgDTA1=tmpMsg;
                //};
                break;
            case(DTA_2):
                rx_flag|=(1<<1);
                for(int k=0;k<8;k++){
                    msgDTA2[k]=tmpMsg.data[k];
                };
                break;
            case(DTA_3):
                rx_flag|=(1<<2);
                for(int k=0;k<8;k++){
                    msgDTA3[k]=tmpMsg.data[k];
                };
                break;
            case(DTA_4):
                rx_flag|=(1<<3);
                for(int k=0;k<8;k++){
                    msgDTA4[k]=tmpMsg.data[k];
                };
                break;
            case(DTA_5):
                rx_flag|=(1<<4);
                for(int k=0;k<8;k++){
                    msgDTA5[k]=tmpMsg.data[k];
                };
                break;
            case(DTA_6):
                rx_flag|=(1<<5);
                for(int k=0;k<8;k++){
                    msgDTA6[k]=tmpMsg.data[k];
                };
                break;
            case(LVDT_FRONT):
                rx_flag|=(1<<6);
                for(int k=0;k<8;k++){
                    msgLVDTFront[k]=tmpMsg.data[k];
                };
                break;
            case(LVDT_REAR):
                rx_flag|=(1<<7);
                for(int k=0;k<8;k++){
                    msgLVDTRear[k]=tmpMsg.data[k];
                };
                break;
            case(BRAKES):
                rx_flag|=(1<<8);
                for(int k=0;k<8;k++){
                    msgBrakes[k]=tmpMsg.data[k];
                };
                break;
        };
        printf("%x\n",rx_flag);
    };
};

void parse_DTA1();
void parse_DTA2();
void parse_DTA3();
void parse_DTA4();
void parse_DTA5();
void parse_DTA6();
void parse_LVDTFRONT();
void parse_LVDTREAR();
void parse_BRAKES();

int main(){
    // attach interrupt function to CAN RX
    can1.attach(&CAN_Msg_Receive,CAN::RxIrq);
    lcd.DisplayStringAt(0,50,(uint8_t*)"Initialised",LEFT_MODE);
    while(1){
        // the code which checks the CAN RX Flags, and call appropriate data handler function
        for (int i=0;i<noID;i++){
            uint8_t flagBit;
            flagBit = rx_flag & (1<<i);
            //printf("i=%d\n",i);
            if (flagBit==1) {
                
                switch(i){
                    case(0):
                        parse_DTA1();
                        rx_flag = rx_flag ^ (1<<0);
                        break;
                    case(1):
                        parse_DTA2();
                        rx_flag = rx_flag ^ (1<<1);
                        break;
                    case(2):
                        parse_DTA3();
                        rx_flag = rx_flag ^ (1<<2);
                        break;
                    case(3):
                        parse_DTA4();
                        rx_flag = rx_flag ^ (1<<3);
                        break;
                    case(4):
                        parse_DTA5();
                        rx_flag = rx_flag ^ (1<<4);
                        break;
                    case(5):
                        parse_DTA6();
                        rx_flag = rx_flag ^ (1<<5);
                        break;
                    case(6):
                        parse_LVDTFRONT();
                        rx_flag = rx_flag ^ (1<<6);
                        break;
                    case(7):
                        parse_LVDTREAR();
                        rx_flag = rx_flag ^ (1<<7);
                        break;
                    case(8):
                        parse_BRAKES();
                        rx_flag = rx_flag ^ (1<<8);
                        break;
                    // for each new id add new case statement
                    
                }
            }
        }

    }
};

void parse_DTA1(){
    rpm=(msgDTA1.data[1]<<8) | msgDTA1.data[0];
    tps=(msgDTA1.data[3]<<8) | msgDTA1.data[2];
    waterTemp=(msgDTA1.data[5]<<8) | msgDTA1.data[4];
    airTemp=(msgDTA1.data[7]<<8) | msgDTA1.data[6];
    lcd.DisplayStringAt(0,0,(uint8_t*)"DTA1",LEFT_MODE);
    printf("rpm=%x%x, tps=%x%x, waterTemp=%x%x, airTemp=%x%x\n",msgDTA1.data[1],msgDTA1.data[0],msgDTA1.data[3],msgDTA1.data[2],msgDTA1.data[5],msgDTA1.data[4],msgDTA1.data[7],msgDTA1.data[6]);
};

void parse_DTA2(){
    printf("DTA2\n");
};

void parse_DTA3(){
    oilTemp=(msgDTA3[3]<<8) | msgDTA3[2];
    Volts=(msgDTA3[5]<<8) | msgDTA3[4];
    lcd.DisplayStringAt(0,0,(uint8_t*)"DTA3",LEFT_MODE);
    printf("oilTemp=%d, Volts=%d\n",oilTemp,Volts);
};

void parse_DTA4(){
    printf("DTA4\n");
};

void parse_DTA5(){
    printf("DTA5\n");
};

void parse_DTA6(){
    printf("DTA6\n");
};

void parse_LVDTFRONT(){
    // add function which parses the received data
};

void parse_LVDTREAR(){
    // add function which parses the received data
};

void parse_BRAKES(){
    // add function which parses the received data
};



