// Written by IVA2K
//
// Example of HTTPServer with additional features:
// * Link status indication (LED4)
// * Local file system (create index.htm page on MBED!)
// * RPC-able class (myrpc, allows remote function call that blinks LED1 N times)
//
// Instructions:
// 1  Plug MBED into BoB2 (or other ETH connector breakout)
// 2  Plug ETH connector into your network (needs DHCP to get IP address)
// 3  Power up MBED using USB cable
// 4  Install MBED serial driver (http://mbed.org/handbook/SerialPC)
// 5  Copy compiled .bin to your MBED (make sure target device selected in the compiler is correct)
// 6  Open terminal on the mbed serial port
// 7  Push MBED reset button
// 8  Terminal will display info message with mac address, followed by IP address (if connection succeeds)
// 9  Open browser and enter the following URL, inserting your MBED's IP address:
//    http://10.0.0.321/rpc/myrpc1/blink,10 (instead of 10.0.0.321 use MBED IP address from terminal)
// 10 MBED will blink the LED 10 times
//
// Notes: there are still some bugs in HTTPServer code. 
// To help fight some of them, copy a valid favicon.ico (a 16x16 icon) file to MBED.
//

#include "mbed.h"
#include "HTTPServer.h"
#include "HTTPRPC.h"
#include "HTTPFS.h"
#include "myrpc.h"
#include "main.h"
#include "TextLCD.h"

DigitalIn knop(p14,"p14");
DigitalOut bel(p21, "p21");
DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
LocalFileSystem local("local");
myrpc myrpc1(p21, "myrpc1");

extern Ethernet eth;        // eth is defined elsewhere, avoid compiler error.
Serial pc(USBTX, USBRX);    // serial poort met pc
TextLCD lcd(p5, p6, p7, p8, p9, p10, p11); // rs, rw, e, d0, d1, d2, d3
Ticker eth_timer;           //ethernet timer

void print_tijd()           //haal uur en min uit npt protocol
{
       print_time(cTime->tm_hour, cTime->tm_min);
}

void print_time(int hour, int minute) 
 //timezonecorrectie en tijd op display schrijven
 //en led aan laten gaan op ingestelde tijd of door drukknop
{
    /* Variable tmphr is 24 hour time adjusted for timezone */
 int tmphr = hour + 13 ;
    while (tmphr < 0)
        tmphr += 24;
    tmphr %= 24;
    
 int tmpmin = minute;
    
   //24 uren klok
    int printhr = tmphr % 24;
    if (printhr == 0)
        printhr += 24;
        lcd.locate(0,1);
        lcd.printf("%2d:%02d ", printhr, minute);
 if ((tmpmin == 1 & tmphr == 1)+(knop==1)){ //Hier moete een tijd ingeven om wat uur het alarm aan gaat of als op de druk knop word gedrukt. 
    bel.write(1);
    wait(10); //hoelang het alarm moet afgaan
    bel.write(0);
    }
}    

//#define LED_ETH_LINK(val) do { led4=val; } while (0)
void eth_link_status() {    //internet deffinieren
    static bool first = true;        // eerste keer ip opvragen
    static int eth_link = -1;        // hebben we verbinding met de switch
    int new_link = eth.link();
    if (eth_link != new_link) {
        if (new_link) {
            // From http://mbed.org/forum/post/909/
            NetServer *net = NetServer::get();
            struct ip_addr ip = net->getIPAddr();
//            struct ip_addr gw = net->getGateway();
//            struct ip_addr nm = net->getNetmask();
//            struct ip_addr dns = net->getDNS1();
            lcd.locate(0,0); 
            lcd.printf("%hhu.%hhu.%hhu.%hhu\n", (ip.addr)&0xFF, (ip.addr>>8)&0xFF, (ip.addr>>16)&0xFF, (ip.addr>>24)&0xFF);
            }
        else {
            lcd.locate(0,0);
            lcd.printf("<link down>       \n");
        }
        //LED_ETH_LINK(new_link);
        eth_link = new_link;
    }
}

int main(void) 
{ //Alle led aan maken dat je kan zijn als het ergens vast zit of niet vind.
    led1=1;
    led2=1;
    led3=1;
    led4=1;
    pc.baud(9600);
// om internet server te maken
    char *hostname = "mbed";
    HTTPServer http(hostname);    // Use DHCP
    http.timeout(60);

// dit is nodig om via het internet het rpc protocol uit te voeren
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<myrpc>();
    led1=0;

    http.addHandler(new HTTPRPC());
    led2=0;

    http.addHandler(new HTTPFileSystemHandler("/", "/local/"));
    led3=0;

// FIXME: BUG:: If eth is not plugged, http.bind() hangs for a while!
    http.bind();
    led4 = 0;

    //pc.printf("\r");    // Add linefeed for stupid Hyperterminal
    eth_timer.attach(&eth_link_status, 0.1);
//NTP uitlezen vanuit ntp server
    Host server(IpAddr(), 123, "0;uk.pool.ntp.org");
    ntp.setTime(server);
    pc.printf("\nstart");
    while(1) 
    {
        http.poll();    // Have to call this method at least every 250ms to let the http server run.
        wait(0.100);
   
        /* Temporary variables for control loop */
        time_t rtc_time = time(NULL);
        int minute = -1; 

        /* Update current time */
        rtc_time = time(NULL);

        cTime = localtime(&rtc_time);
      
        /* Only redraw the lcd display if anything changes */
        if (cTime->tm_min != minute) 
        {
            minute = cTime->tm_min;

            print_tijd();
            /* Update time from NTP server if it's midnight UTC */
//changed min to 1
            if ((cTime->tm_min == 1) && (cTime->tm_hour == 0)) 
            {
                Host server(IpAddr(), 123, "0.north-america.pool.ntp.org");

                ntp.setTime(server); 
            }
        }
    } //return 0; 
}
   
//END