// myrpc.cpp
//
// Based on:
// http://mbed.org/projects/cookbook/svn/Servo/trunk/Servo.h
// http://mbed.org/projects/cookbook/svn/Servo/trunk/Servo.cpp
// http://mbed.org/forum/topic/234/

#include "myrpc.h"
#ifdef MBED_RPC
#include "rpc.h"
#endif



namespace mbed {

myrpc::myrpc(PinName pin, const char *name) : Base(name), _pin(pin) {}


void myrpc::ledon(int n) {
     _pin = 1; 
}

void myrpc::ledoff(int n) {
    _pin = 0;   
}


#ifdef MBED_RPC
const rpc_method *myrpc::get_rpc_methods() {
  static const rpc_method rpc_methods[] = {
        { "ledon", rpc_method_caller<myrpc, int, &myrpc::ledon> },
    { "ledoff", rpc_method_caller<myrpc, int, &myrpc::ledoff> },
    RPC_METHOD_SUPER(Base)
  };
  return rpc_methods;
}       
rpc_class *myrpc::get_rpc_class() {
    static const rpc_function funcs[] = {
        "new", rpc_function_caller<const char*, PinName, const char*, &Base::construct<myrpc,PinName,const char*> >,
        RPC_METHOD_END
    };
    static rpc_class c = { "myrpc", funcs, NULL };
    return &c;
}
#endif

}    // namespace mbed
