#include "mbed.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "C12832.h"

DigitalOut myled(LED1);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
InterruptIn JoyDown(p12);
LM75B temp(p28, p27);
MMA7660 MMA(p28,p27);
C12832 lcd(p5,p7,p6,p8,p11);
Serial xbee(p9,p10);
Serial pc(USBTX, USBRX);
char Buffer[70];
bool isSplitMode = false;
char allDelimiters[] = "{}\":,";
char* strArray[100];

//Split string using preset characters
void delimitJson()
{
    char* pch = strtok(Buffer, allDelimiters);
    int i = 0;
    while (pch != NULL) {
        strArray[i] = pch;
        pch = strtok (NULL, allDelimiters);
        i++;
    }
    pch = NULL;
}

void switchMode()
{
    //Switch between split display and JSON display mode
    isSplitMode = !isSplitMode;
}

void RxData()
{
    //Check if data is received
    if (xbee.readable()) {
        //Put new serial data into Buffer until a '\n' (New Line) character is detected
        xbee.scanf("%67s",Buffer);
    }
    if (isSplitMode)
    {
        //Split the string into a Char Array called strArray
        delimitJson();
        //Draw first two entries in the array (Temp: value)
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("%s:",strArray[0]);
        lcd.locate(25,0);
        lcd.printf(strArray[1]);
        //Draw next two entries in the array (X: value)
        lcd.locate(0,10);
        lcd.printf("%s:",strArray[2]);
        lcd.locate(25,10);
        lcd.printf(strArray[3]);
        //Draw next two entries in the array (Y: value)
        lcd.locate(0,20);
        lcd.printf("%s:",strArray[4]);
        lcd.locate(25,20);
        lcd.printf(strArray[5]);
        //Draw next two entries in the array (Z: value)
        lcd.locate(60,0);
        lcd.printf("%s:",strArray[6]);
        lcd.locate(85,0);
        lcd.printf(strArray[7]);
        //Draw next two entries in the array (Pot1: value)
        lcd.locate(60,10);
        lcd.printf("%s:",strArray[8]);
        lcd.locate(85,10);
        lcd.printf(strArray[9]);
        //Draw last two entries in the array (Pot2: value)
        lcd.locate(60,20);
        lcd.printf("%s:",strArray[10]);
        lcd.locate(85,20);
        lcd.printf(strArray[11]);
    } else {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf(Buffer);
    }
}

int main()
{
    //Attach receive interrupt to xbee serial pins
    xbee.attach(&RxData, Serial::RxIrq);
    //Attach button interrupt to the switchMode method
    JoyDown.rise(&switchMode);
    //Initialise LM75B temperature sensor
    if (temp.open()) {
        pc.printf("\r\nLM75B Operational\r\n");
    }

    while(1) {
        //Flash LED so we know program is running
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        //Send current data from sensors to Xbee
        xbee.printf("{Temp:%.3f,X:%.4f,Y:%.4f,Z:%.4f,Pot1:%.3f,Pot2:%.3f}\n", temp.temp(), MMA.x(), MMA.y(), MMA.z(), pot1.read(), pot2.read());
    }
}
