#include "mbed.h"
#include "rtos.h"

#include "MCP23017.h"
#include "WattBob_TextLCD.h"

#define BACK_LIGHT_ON(INTERFACE) INTERFACE->write_bit(1,BL_BIT)
#define BACK_LIGHT_OFF(INTERFACE) INTERFACE->write_bit(0,BL_BIT)

MCP23017 *par_port;             // pointer to 16-bit parallel I/O object
WattBob_TextLCD *lcd;           // pointer to 2*16 chacater LCD object

AnalogIn accel(p15);            // Analog in
AnalogIn brake(p16);

float speed;                    // IO values 
float kmph;
float aveSpeed;
float acc;
float br;
float distance = 0;

DigitalOut sideLights(LED1);    // mbed out
DigitalOut lIndicator(LED2);
DigitalOut rIndicator(LED3);
DigitalOut engLight(LED4);

DigitalOut brakeLights(p6);     // redbox out
DigitalOut fluxCapacitor(p7);

DigitalIn  engine(p5);          // switches in
DigitalIn  lightSwitch(p8);
DigitalIn  lIndicate(p11);
DigitalIn  rIndicate(p12);

int l, r, lr;                   // indicator values

Serial pc(USBTX, USBRX);        // serial tx, rx

Thread sp;                      // threads. Speed
Thread task1;
Thread task246;
Thread task3;
Thread task59;
Thread task7;
Thread task8;
Thread task10;
Thread indi;                    // indicators

typedef struct {                //  mail
    float m_speed;
    float m_acc;
    float m_br;
} mail_t;

Mail<mail_t, 100> mail_box;

void acceleration()                                 //  1.  read brake and accelerator          10
{
    while (1) {
        acc = accel.read()*3.3;
        br = brake.read()*3.3;
        
        Thread::wait(100);
    }
}
void getSpeed()                                     // calculation for speed & distance thread  20
{
    while (1) {
        speed = (acc - br)*16.835;                      // speed in m/s. Max = 55
        if (speed < 0) {
            speed = 0;
        }
        kmph = speed*3.6;                               // convert speed to km/ph. Change to *2.24 for ~mph
        distance = distance + (speed*0.05)/1000;        // distance = speed*time /1000 for m to km (/1609.34 for miles)
        
        Thread::wait(50);
    }
}
void ignition()                                     //  2.   Read engine on/off show LED  subroutine    2
{
    if (engine.read() > 0) {
        engLight = 1;
    } else {
        engLight = 0;
        aveSpeed = 0;
        acc = 0;
        br = 0;
    }
}
void speedo()                                       //  3.   Average last n speed readings  thread      5
{
    while (1) {
        for (int i = 0; i<3; i++) {
            aveSpeed = kmph + aveSpeed;                 // in km/h
        }
        aveSpeed = aveSpeed/4;

        Thread::wait(200);
    }
}
void braking()                                      //  4.   Brake indicated by LED   subroutine        2
{
    if ( br > 0) {
        brakeLights = 1;
    } else {
        brakeLights = 0;
    }
}
void greatScott()                                   //  5.   if speed > 88 LED on  subroutine           1
{
    if (kmph > 141.6) {                                 // 141.6 km = 88 miles
        fluxCapacitor = 1;
    } else {
        fluxCapacitor = 0;
    }
}
void LCD()                                          //  6.   display odometer and speed  subroutine     2
{
    lcd->locate(0,0);
    lcd->printf("KM:%0.1f",distance);
    lcd->locate(1,0);
    lcd->printf("KM/H:%.1f",aveSpeed);
}
void send_thread (void)                             //  7.  speed, acc, brake MAILq thread              0.2
{
    while (true) {
        mail_t *mail = mail_box.alloc();
        mail->m_speed = aveSpeed;
        mail->m_acc = acc;
        mail->m_br = br;
        mail_box.put(mail);

        Thread::wait(5000);
    }
}
void toSerial()                                     //  8.   MAILq to serial PC    thread               0.05
{
    while (1) {
        osEvent evt = mail_box.get();
        mail_t *mail = (mail_t*)evt.value.p;
        pc.printf("\nSpeed: %.2f \n\r", mail->m_speed);
        pc.printf("Acceleration: %.2f \n\r", mail->m_acc);
        pc.printf("Braking: %.2f \n\r", mail->m_br);
        
        Thread::wait(20000);
    }
}
void lights()                                       //  9.   set side lights  subroutine                1
{
        if (lightSwitch.read() == 1) {                  // If light switch on
            sideLights = 1;                             // turn on side lights
        } else {
            sideLights = 0;
        }
}
void indicators()                                   //  10.  check indicators  thread                   0.5
{
    while (1) {

        if ((lIndicate == 1) && (rIndicate == 1)) {         //  If both switch on
            lr = 1;                                         //      both LED at 2Hz
        } else if ((lIndicate == 1) && (rIndicate == 0)) {  //  if left switch on
            l = 1;                                          //      left LED at 1Hz
            r = 0;
            lr = 0;
        } else if ((lIndicate == 0) && (rIndicate == 1)) {  //  if right switch on
            r = 1;                                          //      right LED at 1Hz
            l = 0;
            lr = 0;
        } else if ((lIndicate == 0) && (rIndicate == 0)) {  // both off
            r = 0;
            l = 0;
            lr = 0;
        }

        Thread::wait(2000);
    }
}

void indicate()                                     // flash indicators
{
    while (1) {
        int x = 1000;
        if (lr == 1) {                  //  If both switch on
            lIndicator = !lIndicator;     //      both LED at 2Hz
            rIndicator = !rIndicator;
            x = 500;
        } else if (l == 1) {            //  if left switch on
            lIndicator = !lIndicator;     //      left LED at 1Hz
            rIndicator = 0;
            x = 1000;
        } else if (r == 1) {           //  if right switch on
            rIndicator = !rIndicator;     //      right LED at 1Hz
            lIndicator = 0;
            x = 1000;
        }

        Thread::wait(x);
    }
}
void t59()                                   //  thread for 5 & 9           1Hz
{
    while (1) {
        greatScott();
        lights();

        Thread::wait(1000);
    }
}
void t246()                                     //  thread for 2, 4, & 6     2Hz
{
    while (1) {
        ignition();
        LCD();
        braking();

        Thread::wait(500);
    }
}

int main()
{
    par_port = new MCP23017(p9, p10, 0x40);             // initialise 16-bit I/O chip
    lcd = new WattBob_TextLCD(par_port);                // initialise 2*26 char display
    par_port->write_bit(1,BL_BIT);                      // turn LCD backlight ON
                                        //Hz
    sp.start(getSpeed);                 //20
    task1.start(acceleration);          //10
    task246.start(t246);                //2
    task3.start(speedo);                //5
    task59.start(t59);                  //1
    task7.start(callback(send_thread)); //0.2
    task8.start(toSerial);              //0.05
    task10.start(indicators);           //0.5
    indi.start(indicate);               // 1-2

}