#include "mbed.h"
#include "max31855.h"

DigitalOut myled(LED1);

//----------------------------------------------------------
//SPI Interfaces
SPI testSPI(p11,p12,p13);
//----------------------------------------------------------

//----------------------------------------------------------
//Thermocouples
max31855 max1(testSPI,p21);
//----------------------------------------------------------

int main() {
    //Initialise chip (starts internal timer)
    max1.initialise();
    
    //Float value to hold temperature returned
    float fvalue = 0;
    
    while(1) {
        //Check if the chip is ready for a reading to be taken
        if (max1.ready()==1){
            //Get the reading
            fvalue = max1.read_temp();
            
            if (fvalue > 2000){
                if(fvalue==2001){
                    printf("No TC");
                }else if(fvalue==2002){
                    printf("Short to Ground");
                }else if(fvalue==2004){
                    printf("Short to VCC");
                }
            }else{
                printf("Temperature is: %f\n\r", fvalue);
            }
     }
        
        //Heartbeat signal (not necessary)
        myled = !myled;
        
        //Delay is not required, here simply for test program
        wait(0.25);
    }
}
