#ifndef METEO_CAN_H
#define METEO_CAN_H
 
#include "mbed.h"

class meteoCAN
{
    public:
        //Notre Constructeur, prend en argument les pins utiliser pour communiquer en CAN
        meteoCAN(PinName rd, PinName td); //CAN (PinName rd, PinName td)
        //Créer et envoie la trame météo*, avec l’ID donnée en argument.
        bool send(uint16_t canID, float temperature, float humidite, float irradiance, float vitesse_vent, char direction_vent);
        //Renvoie vrai si l’ID du message CAN reçu correspond à l’ID donnée en argument. Renvoie faux sinon
        bool filtreID(CANMessage &msg, uint16_t IDtoFilter);
        //Décrypte la trame météo renvoie en float la température.
        float getTemperature(CANMessage &msg);
        //Décrypte la trame météo renvoie en float l’humidite.
        float getHumidite(CANMessage &msg);
        //Décrypte la trame météo renvoie uint16_t l’irradiance.
        uint16_t getIrradiance(CANMessage &msg);
        //Décrypte la trame météo renvoie en float la vitesse du vent.
        float getVitesseVent(CANMessage &msg);
        //Décrypte la trame météo renvoie en uint8_t la direction du vent.
        uint8_t getDirectionVent(CANMessage &msg);
      
    private:
        CAN can1;
};

#endif