#include "meteoCAN.h"
#include "mbed.h"

//Notre Constructeur, prend en argument les pins utiliser pour communiquer en CAN
meteoCAN::meteoCAN(PinName rd, PinName td):can1(rd, td){}

//Créer et envoie la trame météo*, avec l’ID donnée en argument.
bool meteoCAN::send(uint16_t canID, float temperature, float humidite, float irradiance, float vitesse_vent, char direction_vent){
    uint16_t temp, humi, irra, vite;
    char trame[50];
        
    temp = uint16_t(temperature*100);
    trame[0] = temp & 255; //temperature octet faible
    trame[1] = temp >> 8;   //temperature octet fort
    
    humi = uint16_t(humidite*10);
    trame[2] = humi & 255; //humidite octet faible
    trame[3] = humi >> 8;   //humidite octet fort
    
    irra = uint16_t(irradiance);
    trame[4] = irra & 255; //irradiance octet faible
    trame[5] = irra >> 8;   //irradiance octet fort
    
    vite = uint16_t(vitesse_vent*100);
    trame[6] = vite & 255; //vitesse_vent octet faible
    trame[7] = vite >> 8;   //vitesse_vent octet fort
    
    trame[3] = (direction_vent<<4 & 0xF0) + (trame[3] & 0x0F);
  
    // send value to CAN bus and monitor return value to check if CAN
    // message was sent successfully. If so display, increment and toggle
    if (can1.write(CANMessage(canID, trame, 8))) {
    }
    else{
      can1.reset();                                           // Reset CANbus if there is a problem
    }
    wait(1.0);                                                  // wait a second  
    
    return true;
}

//Renvoie vrai si l’ID du message CAN reçu correspond à l’ID donnée en argument. Renvoie faux sinon
bool meteoCAN::filtreID(CANMessage &msg, uint16_t IDtoFilter){
    if(IDtoFilter == msg.id) return true;
    else return false;
}

//Décrypte la trame météo renvoie en float la température.
float meteoCAN::getTemperature(CANMessage &msg){
        return float(float(( msg.data[0] & 0xFF) + ( msg.data[1]<<8 & 0xFF00))/100);
}

//Décrypte la trame météo renvoie en float l’humidite.
float meteoCAN::getHumidite(CANMessage &msg){
        return float(float((msg.data[2] & 0xFF) + (msg.data[3]<<8 & 0x0F00))/10);
}

//Décrypte la trame météo renvoie uint16_t l’irradiance.
uint16_t meteoCAN::getIrradiance(CANMessage &msg){
        return uint16_t((msg.data[4] & 0xFF) + (msg.data[5]<<8 & 0xFF00));
}

//Décrypte la trame météo renvoie en float la vitesse du vent.
float meteoCAN::getVitesseVent(CANMessage &msg){
        return float(float((msg.data[6] & 0xFF) + (msg.data[7]<<8 & 0xFF00))/100);
}

//Décrypte la trame météo renvoie en uint8_t la direction du vent.
uint8_t meteoCAN::getDirectionVent(CANMessage &msg){
        return uint8_t((msg.data[3] & 0xF0)>>4);
}

