#include "mbed.h"
#include "meteoCAN.h"

#define can_len 8

Serial pc(USBTX, USBRX, 115200);          // tx, rx for Tera Term output

DigitalOut myled(LED1);            // LED1 displays messsage sent Status
CAN can1(PA_11, PA_12);            // CAN interface
meteoCAN meteo(PA_11, PA_12);
CANMessage msg; // create empty CAN message


int main() {
    
    uint16_t i, octet;
    char trame[8];
    bool readCAN=false;
    
    while(1){
        
        readCAN=false;
        pc.printf("**********Envoi de la Requete meteo par bus CAN**********\n\n");
        
        //Tant que readCAN est faux,autrement dit tant qu'il n'y as pas de trame à lire sur le Bus CAN
        while(readCAN == false){
            //Envoi d'un requête météo avec l'ID 21 
            if (can1.write(CANMessage(21, trame, 0))) {  
                pc.printf("Message envoye !\n");
                myled = !myled;
            }
            else{
                pc.printf("Echec de l'envoi\n");
                can1.reset();                                           // Reset le bus CAN en cas de problème
            }
            wait(1.0);                                                  // Paus de 1s
            //readCAN reste faux si aucune trame n'est reçu, sinon devient vrai
            readCAN = can1.read(msg);
        }
        
        //Affiche la trame meteo reçue
        pc.printf("\nRecepetion en cours...");
        pc.printf("\n");
        pc.printf("|******TRAME RECU**********|\n");
        printf("ID de la trame CAN   : %d\n", msg.id);
        printf("Nombre d'octets recus: %d\n", msg.len);   // display message data
        for(i=0;i<msg.len;i++) printf("  -> data[%d] = %d\n", i, msg.data[i]);
        
        //Décode la trame météo et affiche la valeurs des donnees reçues
        //Affiche la température
        pc.printf(" ->Temperature = %2.2f degres celsius\n", meteo.getTemperature(msg));
        //Affiche l'humidité
        pc.printf(" ->Humidite = %2.2f %%RH\n", meteo.getHumidite(msg));
        //Affiche l'irradiance
        pc.printf(" ->Irradiance = %hu W/m2\n", meteo.getIrradiance(msg));
        //Affiche la vitesse du vent
        pc.printf(" ->Vitesse du vent = %f m/s\n", meteo.getVitesseVent(msg));
        //Affiche la direction du vent
        pc.printf(" ->Direction du vent = %u\n", meteo.getDirectionVent(msg));
        
        myled = !myled;//inverse l'état de la led
        wait(5.0);//Attente de 5s avant de renvoyer uen requête météo
    }
}