#ifndef MBED_GirouetteWD1080_H
#define MBED_GirouetteWD1080_H
 
#include "mbed.h"
#include "string"

// => /!\ Les pôles de réfèrence sont sculptés sur le pied de la girouette /!\

class GirouetteWD1080
{
    public:
        //Notre constructeur
        GirouetteWD1080(PinName analog_pin);
        /*Permet de lire la girouette et d'attribuer le résultat en int  à la variable direction_int :
            ------------------------------------------------------------------------------------------------------------
            |    Retour | 0    | 1         | 2   | 3       | 4   | 5        | 6    | 7          | 8                    |
            | Direction |Ouest | Sud-Ouest | Sud | Sud-Est | Est | Nord-Est | Nord | Nord-Ouest | Erreur d'acquisition |
            ------------------------------------------------------------------------------------------------------------
        */
        bool read_string();
        /*Permet de lire la girouette et d'attribuer le résultat en string à la variable direction_string :
            ---------------------------------------------------------------------------------------------------------------------------
            | Retour |"Ouest" | "Sud-Ouest" | "Sud" | "Sud-Est" | "Est" | "Nord-Est" | "Nord" | "Nord-Ouest" | "Err" |
            ---------------------------------------------------------------------------------------------------------------------------
        */
        bool read_int();
       
        //Varibale public, récupère le résultat en string
        string direction_string;
        //Varibale public, récupère le résultat en int
        int direction_int;    
        
    private:
        //Appel du constructeur AnalogIn pour lire le port de la girouette WS1080
        AnalogIn girouette;
};

#endif