#include "GirouetteWD1080.h"
#include "mbed.h"

// => /!\ Les pôles de réfèrence sont sculptés sur le pied de la girouette /!\

//Notre constructeur
GirouetteWD1080::GirouetteWD1080(PinName analog_pin):girouette(analog_pin)
{
}



/*Permet de lire la girouette et d'attribuer le résultat en string à la variable direction_string :
    ---------------------------------------------------------------------------------------------------------------------------
    | Retour |"Ouest" | "Sud-Ouest" | "Sud" | "Sud-Est" | "Est" | "Nord-Est" | "Nord" | "Nord-Ouest" | "Err" |
    ---------------------------------------------------------------------------------------------------------------------------
*/
bool GirouetteWD1080::read_string( )
{   
        uint16_t positions[8] = {770, 200, 53, 30, 13, 105, 350, 550}, girou, i=0;
        string directions[9]={"O","S-O","S","S-E","E","N-E","N","N-O", "ERR"};
        
        girou = int(girouette.read()*1000.0f);
        
        for(i=0; i<9;i++){
            if( (positions[i]-10)<=girou && (positions[i]+10)>=girou){
                direction_string = directions[i];
                return true;
            }
        }
        
        direction_string = directions[8];
        return false;
}

/*Permet de lire la girouette et d'attribuer le résultat en int  à la variable direction_int :
    ------------------------------------------------------------------------------------------------------------
    |    Retour | 0    | 1         | 2   | 3       | 4   | 5        | 6    | 7          | 8                    |
    | Direction |Ouest | Sud-Ouest | Sud | Sud-Est | Est | Nord-Est | Nord | Nord-Ouest | Erreur d'acquisition |
    ------------------------------------------------------------------------------------------------------------
*/
bool GirouetteWD1080::read_int( )
{   
        uint16_t positions[8] = {770, 200, 53, 30, 13, 105, 350, 550}, girou, i=0;
        
        girou = int(girouette.read()*1000.0f);
        
        for(i=0; i<9;i++){
            if( (positions[i]-10)<=girou && (positions[i]+10)>=girou){
                direction_int = i;
                return true;
            }
        }
        
        direction_int = 255;
        return false;
}


