#ifndef MBED_AnemoWS1080_H
#define MBED_AnemoWS1080_H
 
#include "mbed.h"

#define PI           3.14159265358979323846
#define R_HELICE 0.07//Rayon des hélices en mètre
#define TEMPS_DE_MESURE 5.0

class AnemoWS1080
{
    public:
        //notre constructeur
        AnemoWS1080(PinName digital_pin, float coeff_etalon);
        //Permet de lire l'anemomètre et de stocker la vitesse du vent en m/s
        // dans la variable publique vitesse
        bool read();
        //Variable publique stockant la vitesse vent en m/s au niveau de l'anemomètre
        float vitesse;      
    private:
        //appel du constructeur de la classe timer
        Timer t;
        //Appel du constructeur DigitalIn pour lire le port de la girouette WS1080
        DigitalIn anemo;
        //variable privé pour stocker le coeff etalon
        float coef_etalon;
};

#endif