#include "AnemoWS1080.h"
#include "mbed.h"


//Notre constructeur
AnemoWS1080::AnemoWS1080(PinName digital_pin, float coeff_etalon):anemo(digital_pin)
{
    coef_etalon = coeff_etalon;
}

//Permet de lire l'anemomètre et de stocker la vitesse du vent en m/s
//dans la variable publique vitesse
bool AnemoWS1080::read(){
    
    unsigned int compteur=0;
    float tours_seconde=0;
    t.start();
        
    while(t.read()<float(TEMPS_DE_MESURE)){
        if(anemo){
            compteur++;
            while(anemo && t.read()<float(TEMPS_DE_MESURE));
        }
    }
    
    tours_seconde = (float(compteur)/3.0f)/TEMPS_DE_MESURE;
    vitesse = tours_seconde*2.0f*PI*coef_etalon*R_HELICE;

    t.reset();
    return true;
}
