#include "TurntableControl.h"

TurntableControl::TurntableControl()
    : encoder(PA_13, PullDown), limitSW(PA_15, PullUp), ttdriver(PA_14, PullDown)
{
    encoderMax = 0;
    encoderCurrent = 0;
}

TurntableControl::TurntableControl(PinName en, PinName lSW, PinName ttd)
    : encoder(en, PullDown), limitSW(lSW, PullUp), ttdriver(ttd, PullDown)
{
    encoderMax = 0;
    encoderCurrent = 0;
}

void TurntableControl::initialise()
{
    ttdriver = 1; // Start motor
    while (limitSW.read()) // Continue until limit switch reached
    {}
    while (!limitSW.read()) // Wait for limit switch to reset
    {}
    ttdriver = 0; // Stop motor
}

int TurntableControl::calibrate()
{
    int lastVal = encoder.read(); // Start at a known encoder sample
    ttdriver = 1; // Start motor
    
    while (limitSW.read()) // Continue until limit switch reached
    {
        if (lastVal != encoder.read()) // Check for edge
        {
            encoderMax++; // Increment on edge
        }
        lastVal = encoder.read(); // Update current sample
    }
    while (!limitSW.read()) // Continue until limit switch reached
    {
        if (lastVal != encoder.read()) // Check for edge
        {
            encoderMax++; // Increment on edge
        }
        lastVal = encoder.read(); // Update current sample
    }
    ttdriver = 0; // Stop motor
    return encoderMax;
}

void TurntableControl::incrementTurntable(int edges)
{
    ttdriver = 1;
    int lastVal = encoder.read();
    int target = encoderCurrent + edges;
    while(target >= encoderCurrent) // Cycle through number of edges 
    {
        if(lastVal != encoder.read()) // Check and wait for edge
        {
            encoderCurrent++;
        }
        lastVal = encoder.read();
    }
    ttdriver = 0;
}

void TurntableControl::reset()
{
    encoderMax = 0;
    encoderCurrent = 0;
    initialise();
}

int TurntableControl::getEncoderCurrent()
{
    return encoderCurrent;
}

int TurntableControl::getEncoderMax()
{
    return encoderMax;
}

int TurntableControl::getEncoder()
{
    return encoder.read();
}

void TurntableControl::quarterTurns(int n) // Turn the turntable a quarter rotation, n times
{
    int quaterEdges = getEncoderMax()/4;
    for(int i = 0; i < n; i++)
    {
        incrementTurntable(quaterEdges);
    }
}